"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .braintreedynamicdatafieldsoptions import (
    BraintreeDynamicDataFieldsOptions,
    BraintreeDynamicDataFieldsOptionsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict
from typing_extensions import NotRequired, TypedDict


class BraintreeOptionsTypedDict(TypedDict):
    discount_amount: NotRequired[Nullable[int]]
    r"""Passes a discount amount to be applied to the transaction when using Braintree."""
    custom_fields: NotRequired[Nullable[Dict[str, str]]]
    r"""Passes `customFields` to the Braintree API when creating a new payment. Custom fields allow you to customize your checkout experience by collecting specific information about your customers and their purchases."""
    dynamic_data_fields: NotRequired[
        Nullable[BraintreeDynamicDataFieldsOptionsTypedDict]
    ]
    r"""Additional dynamic fields to pass to the Braintree API"""


class BraintreeOptions(BaseModel):
    discount_amount: OptionalNullable[int] = UNSET
    r"""Passes a discount amount to be applied to the transaction when using Braintree."""

    custom_fields: OptionalNullable[Dict[str, str]] = UNSET
    r"""Passes `customFields` to the Braintree API when creating a new payment. Custom fields allow you to customize your checkout experience by collecting specific information about your customers and their purchases."""

    dynamic_data_fields: OptionalNullable[BraintreeDynamicDataFieldsOptions] = UNSET
    r"""Additional dynamic fields to pass to the Braintree API"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discount_amount", "custom_fields", "dynamic_data_fields"]
        nullable_fields = ["discount_amount", "custom_fields", "dynamic_data_fields"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
