# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['HookVersionArgs', 'HookVersion']

@pulumi.input_type
class HookVersionArgs:
    def __init__(__self__, *,
                 schema_handler_package: pulumi.Input[str],
                 type_name: pulumi.Input[str],
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input['HookVersionLoggingConfigArgs']] = None):
        """
        The set of arguments for constructing a HookVersion resource.
        :param pulumi.Input[str] schema_handler_package: A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.
               
               For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        :param pulumi.Input[str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        :param pulumi.Input[str] execution_role_arn: The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        :param pulumi.Input['HookVersionLoggingConfigArgs'] logging_config: Specifies logging configuration information for a type.
        """
        pulumi.set(__self__, "schema_handler_package", schema_handler_package)
        pulumi.set(__self__, "type_name", type_name)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)

    @property
    @pulumi.getter(name="schemaHandlerPackage")
    def schema_handler_package(self) -> pulumi.Input[str]:
        """
        A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.

        For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        """
        return pulumi.get(self, "schema_handler_package")

    @schema_handler_package.setter
    def schema_handler_package(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_handler_package", value)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Input[str]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_name", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['HookVersionLoggingConfigArgs']]:
        """
        Specifies logging configuration information for a type.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['HookVersionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)


class HookVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['HookVersionLoggingConfigArgs']]] = None,
                 schema_handler_package: Optional[pulumi.Input[str]] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Publishes new or first hook version to AWS CloudFormation Registry.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] execution_role_arn: The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        :param pulumi.Input[pulumi.InputType['HookVersionLoggingConfigArgs']] logging_config: Specifies logging configuration information for a type.
        :param pulumi.Input[str] schema_handler_package: A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.
               
               For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        :param pulumi.Input[str] type_name: The name of the type being registered.
               
               We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HookVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Publishes new or first hook version to AWS CloudFormation Registry.

        :param str resource_name: The name of the resource.
        :param HookVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HookVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 execution_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['HookVersionLoggingConfigArgs']]] = None,
                 schema_handler_package: Optional[pulumi.Input[str]] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HookVersionArgs.__new__(HookVersionArgs)

            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["logging_config"] = logging_config
            if schema_handler_package is None and not opts.urn:
                raise TypeError("Missing required property 'schema_handler_package'")
            __props__.__dict__["schema_handler_package"] = schema_handler_package
            if type_name is None and not opts.urn:
                raise TypeError("Missing required property 'type_name'")
            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["is_default_version"] = None
            __props__.__dict__["type_arn"] = None
            __props__.__dict__["version_id"] = None
            __props__.__dict__["visibility"] = None
        super(HookVersion, __self__).__init__(
            'aws-native:cloudformation:HookVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HookVersion':
        """
        Get an existing HookVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HookVersionArgs.__new__(HookVersionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["is_default_version"] = None
        __props__.__dict__["logging_config"] = None
        __props__.__dict__["schema_handler_package"] = None
        __props__.__dict__["type_arn"] = None
        __props__.__dict__["type_name"] = None
        __props__.__dict__["version_id"] = None
        __props__.__dict__["visibility"] = None
        return HookVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the type, here the HookVersion. This is used to uniquely identify a HookVersion resource
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM execution role to use to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="isDefaultVersion")
    def is_default_version(self) -> pulumi.Output[bool]:
        """
        Indicates if this type version is the current default version
        """
        return pulumi.get(self, "is_default_version")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.HookVersionLoggingConfig']]:
        """
        Specifies logging configuration information for a type.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="schemaHandlerPackage")
    def schema_handler_package(self) -> pulumi.Output[str]:
        """
        A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.

        For information on generating a schema handler package for the type you want to register, see submit in the CloudFormation CLI User Guide.
        """
        return pulumi.get(self, "schema_handler_package")

    @property
    @pulumi.getter(name="typeArn")
    def type_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the type without the versionID.
        """
        return pulumi.get(self, "type_arn")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[str]:
        """
        The name of the type being registered.

        We recommend that type names adhere to the following pattern: company_or_organization::service::type.
        """
        return pulumi.get(self, "type_name")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The ID of the version of the type represented by this hook instance.
        """
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output['HookVersionVisibility']:
        """
        The scope at which the type is visible and usable in CloudFormation operations.

        Valid values include:

        PRIVATE: The type is only visible and usable within the account in which it is registered. Currently, AWS CloudFormation marks any types you register as PRIVATE.

        PUBLIC: The type is publically visible and usable within any Amazon account.
        """
        return pulumi.get(self, "visibility")

