# Generate Metainfo

This tool also support generating some metainfo to a file like

```python
"""This file is generated by setuptools-generate.
The information comes from pyproject.toml.
It provide some metainfo for docs/conf.py to build documents and
help2man to build man pages.
"""

# For docs/conf.py
project = "translate-shell"
author = """Wu Zhenyu <wuzhenyu@ustc.edu> """
copyright = "2022"

# For help2man
DESCRIPTION = "Translate text by google, bing, youdaozhiyun, haici, stardict,
etc at same time from CLI, GUI (GNU/Linux, Android, macOS and Windows), REPL,
python, shell and vim."
EPILOG = "Report bugs to https://github.com/Freed-Wu/translate-shell/issues"
# format __version__ by yourself
VERSION = """translate-shell {__version__}
Copyright (C) 2022
Written by Wu Zhenyu <wuzhenyu@ustc.edu> """
```

Just

```toml
[tool.setuptools-generate]
write-to = "src/translate_shell/_metainfo.py"
```

You can customize template by

```toml
[tool.setuptools-generate]
write-to = "src/translate_shell/_metainfo.py"

[tool.setuptools-generate.metainfo-template]
text = "XXXXX"
```

or

```toml
[tool.setuptools-generate]
write-to = "src/translate_shell/_metainfo.py"

[tool.setuptools-generate.metainfo-template]
file = "XXXXX"
```

The template language is jinja2.

## sphinx

For sphinx's `docs/conf.py`, just

```python
from translate_shell._metainfo import author, copyright, project
```

You don't need write these metainfo twice: in `pyproject.toml` and
`docs/conf.py`.

## help2man

For help2man, just in your `__main__.py`:

```python
from argparse import ArgumentParser
from translate_shell._metainfo import author, copyright, project


def get_parser():
    parser = ArgumentParser(description=DESCRIPTION, epilog=EPILOG)
    parser.add_argument("--version", action="version", version=VERSION)
```
