from __future__ import annotations

from tcsoa.gen.BusinessObjects import BusinessObject, ImanQuery
from typing import List
from tcsoa.base import TcBaseObj
from dataclasses import dataclass


@dataclass
class QueryInput(TcBaseObj):
    """
    The information about each Saved Query to be processed is provided
     by way of this data structure.
    
    :var query: The saved query object to be executed.
    :var entries: The names of criteria. They are User Entry Name of the' query' seen in Query Builder, not User Entry
    L10N Key. To get User Entry Name in different local, use com.teamcenter.rac.kernel.TcTextService.getTextValue() for
    Teamcenter rich client customization, use com.teamcenter.services.strong.core._2008_06.Session.getDisplayStrings()
    for Teamcenter service customization.
    
    :var values: The values of criteria.
    :var limitList: A list of objects (optional) against which the search is conducted,
    if the list is empty, search will be conducted against the database.
    :var maxNumToReturn: A specified maximum number of matches to be returned,
    0 means no limit.
    :var resultsType: The type of results expected from this operation:
    0 (top-level objects only),
    1 (top-level objects plus children: Hierarchical/Indented results),
    2 (default value as specified on the query object).
    :var requestId: Unique ID used to register the query execution task. This can be used by the caller to cancel the
    time consuming query, the value can be generated by any unique string generator.
    :var clientId: This unique ID is used to identify return data elements and partial errors associated with this
    input structure.
    """
    query: ImanQuery = None
    entries: List[str] = ()
    values: List[str] = ()
    limitList: List[BusinessObject] = ()
    maxNumToReturn: int = 0
    resultsType: int = 0
    requestId: str = ''
    clientId: str = ''
