# om-cli 🧘‍♀️

**Advanced Mental Health CLI Platform with AI-Powered Wellness**

[![PyPI version](https://badge.fury.io/py/om-cli.svg)](https://badge.fury.io/py/om-cli)
[![Python](https://img.shields.io/badge/Python-3.11+-blue)](https://pypi.org/project/om-cli/)
[![License](https://img.shields.io/badge/License-MIT-blue)](https://github.com/frism/om/blob/main/LICENSE)
[![Privacy](https://img.shields.io/badge/Privacy-100%25%20Local-green)](#privacy--security)

> *"Mental wellness, compiled locally"*

A comprehensive command-line mental health companion featuring evidence-based interventions, AI coaching, and real-time wellness tracking. Built with privacy-first architecture and inspired by leading mental health research.

## 🚀 Quick Install

```bash
pip install om-cli
```

## ✨ Quick Start

```bash
# Start your wellness journey
om qm          # Quick mood check (10 seconds)
om qb          # Breathing exercise (2 minutes)
om rescue      # Crisis support resources
om coach daily # AI-powered daily insights
```

## 🧠 Core Features

### **Evidence-Based Mental Health Tools**
- **CBT Toolkit** - Thought challenging, anxiety management, cognitive distortion detection
- **AI Companion** - 24/7 conversational support with crisis detection
- **Enhanced Chatbot** - Therapeutic conversation patterns with crisis intervention
- **Crisis Support** - Immediate access to emergency resources (988, international)

### **Ultra-Fast Quick Actions**
```bash
om qm          # Quick mood check (10 seconds)
om qb          # 4-7-8 breathing exercise (2 minutes)  
om qg          # Gratitude practice (30 seconds)
om qf          # Focus reset (1 minute)
om qc          # Progressive relaxation (90 seconds)
```

### **Sleep & Wellness Optimization**
- **Sleep Cycle Calculator** - Optimal bedtimes based on 90-minute cycles
- **Sleep Sounds** - 18 therapeutic audio tracks for anxiety, ADHD, PTSD
- **Positive Psychology** - Three Good Things, character strengths, gratitude practices
- **Daily Check-ins** - Morning and evening wellness routines

### **Advanced Analytics**
- **Enhanced Mood Tracking** - 60+ emotions with pattern recognition
- **AI Mental Health Coach** - Personalized insights and recommendations
- **Wellness Dashboard** - Real-time progress visualization
- **Gamification** - Achievement system with 25+ wellness milestones

## 🌟 Revolutionary Philosophy

### **Fear as Friend** 🐺
Based on Nicky Case's groundbreaking "How to Mental Health" research:
```bash
om wolf        # Talk to your inner anxiety with compassion
om nicky       # Explore 9 evidence-based habits for wellbeing
```

> *"Your fear is not your enemy - it's a guard dog for your needs."*

## 🔒 Privacy & Security

### **100% Local Processing**
- ✅ **No cloud sync** - All data stays on your device
- ✅ **No external APIs** - Complete offline functionality  
- ✅ **No tracking** - Zero analytics or data collection
- ✅ **User controlled** - Delete your data anytime

### **Data Location**
```
~/.om/
├── mood_data.json           # Your emotional journey
├── wellness_stats.json      # Progress tracking
├── ai_conversations.json    # AI companion chats
└── crisis_support.json      # Safety planning (encrypted)
```

## 🆘 Crisis Support

**Immediate help available 24/7:**
```bash
om rescue      # Crisis resources and emergency contacts
om qgr         # 5-4-3-2-1 grounding technique
```

**Emergency Resources:**
- 🇺🇸 National Suicide Prevention Lifeline: **988**
- 🇺🇸 Crisis Text Line: Text **HOME** to **741741**
- 🌍 International crisis resources for 15+ countries

## 📚 Evidence-Based Foundation

Every feature is backed by peer-reviewed research:
- **CBT Techniques** - Most researched form of psychotherapy
- **Positive Psychology** - Martin Seligman's happiness research
- **Sleep Science** - Circadian rhythm optimization
- **AI Mental Health** - Digital therapeutics effectiveness studies

## 🤖 AI-Powered Features

### **Mental Health Coach**
```bash
om coach daily     # Get personalized daily insights
om coach analyze   # Deep pattern analysis of your wellness data
```

### **Enhanced Chatbot**
```bash
om chatbot         # Therapeutic conversations with crisis detection
om chat            # Same as chatbot
```

### **Wellness Autopilot**
```bash
om autopilot       # Automated wellness task generation
om morning         # Automated morning routine
om evening         # Automated evening routine
```

## 🎮 Gamification & Progress

```bash
om gamify status    # View achievements and progress
```

**Achievement Categories:**
- 🌱 Mood Tracking milestones
- 🫁 Breathing practice consistency  
- 🙏 Gratitude streaks
- 🔥 Daily wellness habits
- 🎯 Crisis recovery support

## 🌍 Global Impact

**Supporting mental health worldwide:**
- 🇺🇸 🇬🇧 🇨🇦 🇦🇺 🇩🇪 Crisis resources for 15+ countries
- 🌐 Automatic country detection with manual override
- 🏥 Integration with mental health professionals
- 🎓 Educational resources and research backing

## 📖 Complete Documentation

- 📘 **[Full Documentation](https://github.com/frism/om/tree/main/docs)** - Comprehensive guides
- 🚀 **[Quick Start Guide](https://github.com/frism/om/blob/main/docs/source/quickstart.rst)** - Get started in 5 minutes
- 🧠 **[CBT Toolkit](https://github.com/frism/om/blob/main/docs/source/cbt_toolkit.rst)** - Cognitive behavioral therapy tools
- 🤖 **[AI Companion](https://github.com/frism/om/blob/main/docs/source/ai_companion.rst)** - AI mental health support
- 🆘 **[Crisis Support](https://github.com/frism/om/blob/main/docs/source/rescue_sessions.rst)** - Emergency resources

## 🛠️ Installation & Requirements

### **Requirements**
- Python 3.11+
- 50MB disk space
- Terminal access

### **Install from PyPI**
```bash
pip install om-cli
```

### **Install from Source**
```bash
git clone https://github.com/frism/om.git
cd om
pip install -r requirements.txt
python setup.py install
```

### **Verify Installation**
```bash
om --version
om --help
om qm
```

## 🏆 Why Choose om-cli?

| Feature | om-cli | Headspace | Calm | BetterHelp |
|---------|--------|-----------|------|------------|
| **Privacy** | 100% Local | ❌ Cloud | ❌ Cloud | ❌ Cloud |
| **Cost** | Free | $12.99/mo | $14.99/mo | $80/week |
| **Crisis Support** | ✅ Global | ❌ None | ❌ None | ⚠️ Limited |
| **AI Coaching** | ✅ Personal | ❌ None | ❌ None | ✅ Human |
| **Offline Access** | ✅ Always | ❌ Limited | ❌ Limited | ❌ None |
| **Data Export** | ✅ Anytime | ❌ None | ❌ None | ❌ None |
| **Open Source** | ✅ MIT | ❌ Proprietary | ❌ Proprietary | ❌ Proprietary |

## 🤝 Contributing

We welcome contributions! See [CONTRIBUTING.md](https://github.com/frism/om/blob/main/CONTRIBUTING.md) for guidelines.

**Ways to help:**
- 🐛 Report bugs and issues
- 💡 Suggest evidence-based features
- 📝 Improve documentation
- 🌍 Add translations
- 💻 Contribute code

## 📊 Project Stats

- **47 Python modules** with comprehensive mental health features
- **18/19 modules documented** (95% coverage)
- **25+ achievements** in gamification system
- **15+ countries** with crisis support resources
- **60+ emotions** in enhanced mood tracking
- **100% privacy-respecting** architecture

## 📄 License & Disclaimer

**MIT License** - Use, modify, and distribute freely.

**Medical Disclaimer**: om-cli is a wellness tool designed to complement, not replace, professional mental health care. For mental health emergencies, contact emergency services or crisis hotlines immediately.

## 🙏 Acknowledgments

**Built with love for the mental health community:**
- Mental health professionals who provided guidance
- Nicky Case for revolutionary mental health insights
- Open source contributors and beta testers
- The research community for evidence-based interventions

## 💝 Support the Project

If om-cli has helped your mental wellness journey:

[![Ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/omcli)

Your support helps:
- Keep om-cli free and open source
- Fund new evidence-based features
- Support crisis intervention resources
- Maintain privacy-first development

---

<div align="center">

**🧘‍♀️ Take care of yourself. You deserve wellness and happiness. 🧘‍♂️**

**[GitHub](https://github.com/frism/om) • [Documentation](https://github.com/frism/om/tree/main/docs) • [PyPI](https://pypi.org/project/om-cli/) • [Support](https://ko-fi.com/omcli)**

*Made with ❤️ for mental health and wellness*

</div>

---

**Your mental health journey starts with one command:**
```bash
pip install om-cli && om qm
```
