from pinout.core import Group, Image
from pinout.components.layout import Diagram_2Rows
from pinout.components.text import TextBlock
from pinout import kicad2pinout as k2p


# Import KiCad data
kdata = k2p.PinoutParser("kicad_6_pcb/kicad_6_pcb.kicad_pcb", dpi=72, version=6)


# Create diagram layout
diagram = Diagram_2Rows(900, 575, 500, tag="diagram")
diagram.add_stylesheet("styles.css")


# Using a 'group' component for easy alignment of all sub-components
graphic = diagram.panel_01.add(Group(300, 65))


# Add an image that corrosponds to the KiCad PCB.
img = graphic.add(Image(src="pcb_graphic.svg", width=300, height=300))


# KiCad coordinates will be transformed to match the linked image.
kdata.link_image(img)


# Add pin-labels and annotations to the 'graphic' group
kdata.add_pinlabels(graphic)
kdata.add_annotations(graphic)


# Text from KiCad can be accessed as a dict
textblocks = kdata.gr_text()
diagram.panel_02.add(TextBlock(textblocks["pinout_title"], x=20, y=30))


# From the command line:
# ----------------------

# Export diagram as SVG:
# >>> py -m pinout.manager -e pinout_diagram.py diagram.svg -o

# OPTIONAL EXTRA: Auto generate styles
# >>> py -m pinout.manager --css pinout_diagram.py autostyles.css -o
