# duckQL 🐥

![PyPi package](https://img.shields.io/pypi/v/duckql)
![Tests](https://github.com/Sibyx/duckql-python/workflows/Tests/badge.svg)
[![codecov](https://codecov.io/gh/Sibyx/duckql-python/branch/master/graph/badge.svg)](https://codecov.io/gh/Sibyx/duckql-python)
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2FSibyx%2Fduckql-python.svg?type=shield)](https://app.fossa.io/projects/git%2Bgithub.com%2FSibyx%2Fduckql-python?ref=badge_shield)

duckQL is simple JSON-based notation for some SQL dialects (PostgreSQL, MariaDB, MySQL) based on
[pydantic](https://github.com/samuelcolvin/pydantic/) library.

## Example

Here is a simple example of library usage. For more examples please visit
[project page](https://sibyx.github.io/duckql-python/).

```python
from duckql import Query, Property, Comparision, Constant


my_query = Query(
    entity='users',
    properties=[
        Property(name='users.name'),
        Property(name='users.surname')
    ],
    conditions=Comparision(
        properties=[
            Property(name='users.age'),
            Constant(value=15)
        ],
        operation=Comparision.Operation.GREATER_EQUAL
    )
)
```

```json
{
  "obj": "structures.Query",
  "entity": "users",
  "properties": [
    {
      "obj": "properties.Property",
      "name": "users.name"
    },
    {
      "obj": "properties.Property",
      "name": "users.surname"
    }
  ],
  "conditions": {
    "obj": "structures.Comparision",
    "properties": [
      {
        "obj": "properties.Property",
        "name": "users.age"
      },
      {
        "obj": "properties.Constant",
        "value": "15"
      }
    ],
    "operation": "gte"
  }
}
```

```postgresql
SELECT users.name, users.surname FROM users WHERE (users.age >= 15);
```

## Development

Project is using [poetry](https://python-poetry.org/) and documentation is generated by
[MkDocs](https://www.mkdocs.org/). If you want to generate documentation you need to follow these simple steps
inside of your virtual environment:

1. `poetry install`
2. `mkdocs build`

Inside of your virtual environment, you can also use `mkdocs serve` to create temporary auto-reload http server with
live docs.

We use [pytest](https://docs.pytest.org/en/latest/) for unit tests and [flake8](https://flake8.pycqa.org/en/latest/)
for code-style validation. You can execute tests inside of pipenv shell using these commands:

- `pytest -v .`: executes unit tests
- `pytest -v --flake8 .`: flake8 code-style tests

## License
[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2FSibyx%2Fduckql-python.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2FSibyx%2Fduckql-python?ref=badge_large)

---
Made with ☕️ and ❤️ by Jakub Dubec & [BACKBONE s.r.o.](https://www.backbone.sk/en/)
