"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("./path");
var fs_1 = require("fs");
function packageIsDevDependency(_a) {
    var appPath = _a.appPath, packageDetails = _a.packageDetails;
    var packageJsonPath = path_1.join(appPath, "package.json");
    if (!fs_1.existsSync(packageJsonPath)) {
        return false;
    }
    var devDependencies = require(packageJsonPath).devDependencies;
    return Boolean(devDependencies && devDependencies[packageDetails.packageNames[0]]);
}
exports.packageIsDevDependency = packageIsDevDependency;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFja2FnZUlzRGV2RGVwZW5kZW5jeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9wYWNrYWdlSXNEZXZEZXBlbmRlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EsK0JBQTZCO0FBQzdCLHlCQUErQjtBQUUvQixTQUFnQixzQkFBc0IsQ0FBQyxFQU10QztRQUxDLG9CQUFPLEVBQ1Asa0NBQWM7SUFLZCxJQUFNLGVBQWUsR0FBRyxXQUFJLENBQUMsT0FBTyxFQUFFLGNBQWMsQ0FBQyxDQUFBO0lBQ3JELElBQUksQ0FBQyxlQUFVLENBQUMsZUFBZSxDQUFDLEVBQUU7UUFDaEMsT0FBTyxLQUFLLENBQUE7S0FDYjtJQUNPLElBQUEsMERBQWUsQ0FBNkI7SUFDcEQsT0FBTyxPQUFPLENBQUMsZUFBZSxJQUFJLGVBQWUsQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQTtBQUNwRixDQUFDO0FBYkQsd0RBYUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQYXRjaGVkUGFja2FnZURldGFpbHMgfSBmcm9tIFwiLi9QYWNrYWdlRGV0YWlsc1wiXG5pbXBvcnQgeyBqb2luIH0gZnJvbSBcIi4vcGF0aFwiXG5pbXBvcnQgeyBleGlzdHNTeW5jIH0gZnJvbSBcImZzXCJcblxuZXhwb3J0IGZ1bmN0aW9uIHBhY2thZ2VJc0RldkRlcGVuZGVuY3koe1xuICBhcHBQYXRoLFxuICBwYWNrYWdlRGV0YWlscyxcbn06IHtcbiAgYXBwUGF0aDogc3RyaW5nXG4gIHBhY2thZ2VEZXRhaWxzOiBQYXRjaGVkUGFja2FnZURldGFpbHNcbn0pIHtcbiAgY29uc3QgcGFja2FnZUpzb25QYXRoID0gam9pbihhcHBQYXRoLCBcInBhY2thZ2UuanNvblwiKVxuICBpZiAoIWV4aXN0c1N5bmMocGFja2FnZUpzb25QYXRoKSkge1xuICAgIHJldHVybiBmYWxzZVxuICB9XG4gIGNvbnN0IHsgZGV2RGVwZW5kZW5jaWVzIH0gPSByZXF1aXJlKHBhY2thZ2VKc29uUGF0aClcbiAgcmV0dXJuIEJvb2xlYW4oZGV2RGVwZW5kZW5jaWVzICYmIGRldkRlcGVuZGVuY2llc1twYWNrYWdlRGV0YWlscy5wYWNrYWdlTmFtZXNbMF1dKVxufVxuIl19