from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class SubstanceProteinSchema:
    """
    A SubstanceProtein is defined as a single unit of a linear amino acid
    sequence, or a combination of subunits that are either covalently linked or
    have a defined invariant stoichiometric relationship. This includes all
    synthetic, recombinant and purified SubstanceProteins of defined sequence,
    whether the use is therapeutic or prophylactic. This set of elements will be
    used to describe albumins, coagulation factors, cytokines, growth factors,
    peptide/SubstanceProtein hormones, enzymes, toxins, toxoids, recombinant
    vaccines, and immunomodulators.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2
    ) -> Union[StructType, DataType]:
        """
        A SubstanceProtein is defined as a single unit of a linear amino acid
        sequence, or a combination of subunits that are either covalently linked or
        have a defined invariant stoichiometric relationship. This includes all
        synthetic, recombinant and purified SubstanceProteins of defined sequence,
        whether the use is therapeutic or prophylactic. This set of elements will be
        used to describe albumins, coagulation factors, cytokines, growth factors,
        peptide/SubstanceProtein hormones, enzymes, toxins, toxoids, recombinant
        vaccines, and immunomodulators.


        resourceType: This is a SubstanceProtein resource

        id: The logical id of the resource, as used in the URL for the resource. Once
            assigned, this value never changes.

        meta: The metadata about the resource. This is content that is maintained by the
            infrastructure. Changes to the content might not always be associated with
            version changes to the resource.

        implicitRules: A reference to a set of rules that were followed when the resource was
            constructed, and which must be understood when processing the content. Often,
            this is a reference to an implementation guide that defines the special rules
            along with other profiles etc.

        language: The base language in which the resource is written.

        text: A human-readable narrative that contains a summary of the resource and can be
            used to represent the content of the resource to a human. The narrative need
            not encode all the structured data, but is required to contain sufficient
            detail to make it "clinically safe" for a human to just read the narrative.
            Resource definitions may define what content should be represented in the
            narrative to ensure clinical safety.

        contained: These resources do not have an independent existence apart from the resource
            that contains them - they cannot be identified independently, and nor can they
            have their own independent transaction scope.

        extension: May be used to represent additional information that is not part of the basic
            definition of the resource. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        sequenceType: The SubstanceProtein descriptive elements will only be used when a complete or
            partial amino acid sequence is available or derivable from a nucleic acid
            sequence.

        numberOfSubunits: Number of linear sequences of amino acids linked through peptide bonds. The
            number of subunits constituting the SubstanceProtein shall be described. It is
            possible that the number of subunits can be variable.

        disulfideLinkage: The disulphide bond between two cysteine residues either on the same subunit
            or on two different subunits shall be described. The position of the disulfide
            bonds in the SubstanceProtein shall be listed in increasing order of subunit
            number and position within subunit followed by the abbreviation of the amino
            acids involved. The disulfide linkage positions shall actually contain the
            amino acid Cysteine at the respective positions.

        subunit: This subclause refers to the description of each subunit constituting the
            SubstanceProtein. A subunit is a linear sequence of amino acids linked through
            peptide bonds. The Subunit information shall be provided when the finished
            SubstanceProtein is a complex of multiple sequences; subunits are not used to
            delineate domains within a single sequence. Subunits are listed in order of
            decreasing length; sequences of the same length will be ordered by decreasing
            molecular weight; subunits that have identical sequences will be repeated
            multiple times.

        """
        from spark_fhir_schemas.r4.simple_types.id import idSchema
        from spark_fhir_schemas.r4.complex_types.meta import MetaSchema
        from spark_fhir_schemas.r4.simple_types.uri import uriSchema
        from spark_fhir_schemas.r4.simple_types.code import codeSchema
        from spark_fhir_schemas.r4.complex_types.narrative import NarrativeSchema
        from spark_fhir_schemas.r4.complex_types.resourcelist import ResourceListSchema
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.r4.simple_types.integer import integerSchema
        from spark_fhir_schemas.r4.complex_types.substanceprotein_subunit import SubstanceProtein_SubunitSchema
        if (
            max_recursion_limit
            and nesting_list.count("SubstanceProtein") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["SubstanceProtein"]
        schema = StructType(
            [
                # This is a SubstanceProtein resource
                StructField("resourceType", StringType(), True),
                # The logical id of the resource, as used in the URL for the resource. Once
                # assigned, this value never changes.
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # The metadata about the resource. This is content that is maintained by the
                # infrastructure. Changes to the content might not always be associated with
                # version changes to the resource.
                StructField(
                    "meta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # A reference to a set of rules that were followed when the resource was
                # constructed, and which must be understood when processing the content. Often,
                # this is a reference to an implementation guide that defines the special rules
                # along with other profiles etc.
                StructField(
                    "implicitRules",
                    uriSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # The base language in which the resource is written.
                StructField(
                    "language",
                    codeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # A human-readable narrative that contains a summary of the resource and can be
                # used to represent the content of the resource to a human. The narrative need
                # not encode all the structured data, but is required to contain sufficient
                # detail to make it "clinically safe" for a human to just read the narrative.
                # Resource definitions may define what content should be represented in the
                # narrative to ensure clinical safety.
                StructField(
                    "text",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # These resources do not have an independent existence apart from the resource
                # that contains them - they cannot be identified independently, and nor can they
                # have their own independent transaction scope.
                StructField(
                    "contained",
                    ArrayType(
                        ResourceListSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit
                        )
                    ), True
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the resource. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit
                        )
                    ), True
                ),
                # The SubstanceProtein descriptive elements will only be used when a complete or
                # partial amino acid sequence is available or derivable from a nucleic acid
                # sequence.
                StructField(
                    "sequenceType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # Number of linear sequences of amino acids linked through peptide bonds. The
                # number of subunits constituting the SubstanceProtein shall be described. It is
                # possible that the number of subunits can be variable.
                StructField(
                    "numberOfSubunits",
                    integerSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit
                    ), True
                ),
                # The disulphide bond between two cysteine residues either on the same subunit
                # or on two different subunits shall be described. The position of the disulfide
                # bonds in the SubstanceProtein shall be listed in increasing order of subunit
                # number and position within subunit followed by the abbreviation of the amino
                # acids involved. The disulfide linkage positions shall actually contain the
                # amino acid Cysteine at the respective positions.
                StructField("disulfideLinkage", ArrayType(StringType()), True),
                # This subclause refers to the description of each subunit constituting the
                # SubstanceProtein. A subunit is a linear sequence of amino acids linked through
                # peptide bonds. The Subunit information shall be provided when the finished
                # SubstanceProtein is a complex of multiple sequences; subunits are not used to
                # delineate domains within a single sequence. Subunits are listed in order of
                # decreasing length; sequences of the same length will be ordered by decreasing
                # molecular weight; subunits that have identical sequences will be repeated
                # multiple times.
                StructField(
                    "subunit",
                    ArrayType(
                        SubstanceProtein_SubunitSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit
                        )
                    ), True
                ),
            ]
        )
        return schema
