# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.1.2] - 2024-03-30

### Changed
- Updated package name to match PyPI repository
- Fixed GitHub Actions workflow for automated releases

## [0.1.1] - 2024-03-30

### Added
- Comprehensive examples demonstrating key features
- Memory management with allocation stack
- Enhanced batch size calculation for multi-GPU scenarios
- Improved error handling and recovery
- Progress tracking with detailed statistics
- Data caching with automatic cleanup
- Support for various data formats (CSV, JSON, Images)

### Changed
- Improved memory management with better allocation tracking
- Enhanced batch size calculation for multi-GPU scenarios
- Better error handling and recovery mechanisms
- Updated documentation with examples and tutorials
- Optimized data loading performance

### Fixed
- Memory leaks in cleanup operations
- Batch size calculation for device distribution
- Progress tracking accuracy
- Test reliability and coverage
- Multi-GPU batch distribution issues

### Documentation
- Added comprehensive examples
- Updated README with installation and usage instructions
- Added API documentation
- Included example requirements and setup guide
- Added detailed feature documentation

### Examples
- Added data loading demo with multiple formats
- Included sample data generation scripts
- Added configuration examples
- Demonstrated key features with real-world scenarios
- Added multi-GPU usage examples

## [0.1.0] - 2024-03-19

### Added
- Initial release of JAX DataLoader
- Support for multiple data formats (CSV, JSON, Images)
- Multi-GPU support with automatic batch distribution
- Memory management with automatic batch size tuning
- Progress tracking and statistics
- Data caching and prefetching
- Type hints and documentation

### Changed
- Improved memory management with allocation stack
- Enhanced batch size calculation for multi-GPU scenarios
- Better error handling and recovery
- Updated documentation with examples

### Fixed
- Memory leaks in cleanup operations
- Batch size calculation for device distribution
- Progress tracking accuracy
- Test reliability and coverage

### Documentation
- Added comprehensive examples
- Updated README with installation and usage instructions
- Added API documentation
- Included example requirements and setup guide

### Examples
- Added data loading demo with multiple formats
- Included sample data generation scripts
- Added configuration examples
- Demonstrated key features with real-world scenarios 