
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: //:pygments-cl-repl

from setuptools import setup

setup(**{
    'authors': [
        {
            'name': 'Russell Sim',
            'email': 'russell.sim@gmail.com',
        },
    ],
    'classifiers': [
        'Development Status :: 4 - Beta',
        'Environment :: Plugins',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    'description': 'Pygments lexer for Common Lisp REPL',
    'entry_points': {
        'pygments.lexers': [
            'common-lisp-repl = pygments_cl_repl:CommonLispREPLLexer',
        ],
    },
    'home_page': 'https://github.com/russell/pygments-cl-repl',
    'install_requires': (
        'pygments',
    ),
    'license': 'GPLv3+',
    'long_description': """================
pygments-cl-repl
================

Syntax coloring for Common Lisp REPL sessions
---------------------------------------------

Overview
========

This package provides a Pygments_ lexer for `Common Lisp REPL`_
sessions.  The lexer is published as an entry point and, once
installed, Pygments will pick it up automatically.

You can then use this lexer with Pygments::

    $ pygmentize -l common-lisp-repl pygments_cl_repl/test.common-lisp-repl

In Sphinx_ documents the lexer is selected with the ``highlight``
directive::

    .. highlight:: common-lisp-repl

.. _Common Lisp REPL: http://www.cliki.net/REPL
.. _Pygments: http://pygments.org/
.. _Sphinx: http://sphinx-doc.org/

Installation
============

Use your favorite installer to install pygments-cl-repl into the same
Python you have installed Pygments. For example::

    $ pip install pygments-cl-repl

To verify the installation run::

    $ pygmentize -L lexer | grep -i common-lisp-repl
    * common-lisp-repl:
        Common Lisp REPL (filenames *.common-lisp-repl)
""",
    'long_description_content_type': 'text/x-rst',
    'name': 'pygments-cl-repl',
    'namespace_packages': (
    ),
    'package_data': {
    },
    'packages': (
        'pygments_cl_repl',
    ),
    'python_requires': '<4,>=3.7',
    'readme': {
        'file': 'README.rst',
        'content_type': 'text/x-rst',
    },
    'requires_python': '>=3.7',
    'urls': {
        'documentation': 'https://russell.github.io/pygments-cl-repl/',
        'source': 'https://github.com/russell/pygments-cl-repl',
        'tracker': 'https://github.com/russell/pygments-cl-repl/issues',
    },
    'version': '0.2.1',
})
