"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PredefinedMetric = exports.TargetTrackingScalingPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const applicationautoscaling_generated_1 = require("./applicationautoscaling.generated");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
class TargetTrackingScalingPolicy extends core_1.Construct {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_TargetTrackingScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TargetTrackingScalingPolicy);
            }
            throw error;
        }
        if ((props.customMetric === undefined) === (props.predefinedMetric === undefined)) {
            throw new Error('Exactly one of \'customMetric\' or \'predefinedMetric\' must be specified.');
        }
        if (props.customMetric && !props.customMetric.toMetricConfig().metricStat) {
            throw new Error('Only direct metrics are supported for Target Tracking. Use Step Scaling or supply a Metric object.');
        }
        super(scope, id);
        // replace dummy value in DYNAMODB_WRITE_CAPACITY_UTILIZATION due to a jsii bug (https://github.com/aws/jsii/issues/2782)
        const predefinedMetric = props.predefinedMetric === PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION ?
            PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION :
            props.predefinedMetric;
        const resource = new applicationautoscaling_generated_1.CfnScalingPolicy(this, 'Resource', {
            policyName: props.policyName || cdk.Names.uniqueId(this),
            policyType: 'TargetTrackingScaling',
            scalingTargetId: props.scalingTarget.scalableTargetId,
            targetTrackingScalingPolicyConfiguration: {
                customizedMetricSpecification: renderCustomMetric(props.customMetric),
                disableScaleIn: props.disableScaleIn,
                predefinedMetricSpecification: predefinedMetric !== undefined ? {
                    predefinedMetricType: predefinedMetric,
                    resourceLabel: props.resourceLabel,
                } : undefined,
                scaleInCooldown: props.scaleInCooldown && props.scaleInCooldown.toSeconds(),
                scaleOutCooldown: props.scaleOutCooldown && props.scaleOutCooldown.toSeconds(),
                targetValue: props.targetValue,
            },
        });
        this.scalingPolicyArn = resource.ref;
    }
}
exports.TargetTrackingScalingPolicy = TargetTrackingScalingPolicy;
_a = JSII_RTTI_SYMBOL_1;
TargetTrackingScalingPolicy[_a] = { fqn: "@aws-cdk/aws-applicationautoscaling.TargetTrackingScalingPolicy", version: "1.184.1" };
function renderCustomMetric(metric) {
    if (!metric) {
        return undefined;
    }
    const c = metric.toMetricConfig().metricStat;
    if (c.statistic.startsWith('p')) {
        throw new Error(`Cannot use statistic '${c.statistic}' for Target Tracking: only 'Average', 'Minimum', 'Maximum', 'SampleCount', and 'Sum' are supported.`);
    }
    return {
        dimensions: c.dimensions,
        metricName: c.metricName,
        namespace: c.namespace,
        statistic: c.statistic,
        unit: c.unitFilter,
    };
}
/**
 * One of the predefined autoscaling metrics
 */
var PredefinedMetric;
(function (PredefinedMetric) {
    /**
     * Average percentage of instances in an AppStream fleet that are being used.
     */
    PredefinedMetric["APPSTREAM_AVERAGE_CAPACITY_UTILIZATION"] = "AppStreamAverageCapacityUtilization";
    /**
     * Percentage of provisioned read capacity units utilized by a Keyspaces table.
     */
    PredefinedMetric["CASSANDRA_READ_CAPACITY_UTILIZATION"] = "CassandraReadCapacityUtilization";
    /**
     * Percentage of provisioned write capacity units utilized by a Keyspaces table.
     */
    PredefinedMetric["CASSANDRA_WRITE_CAPACITY_UTILIZATION"] = "CassandraWriteCapacityUtilization";
    /**
     * Percentage of provisioned inference units utilized by a Comprehend endpoint.
     */
    PredefinedMetric["COMPREHEND_INFERENCE_UTILIZATION"] = "ComprehendInferenceUtilization";
    /**
     * Average CPU Utilization of read replica instances in a Neptune DB cluster.
     */
    PredefinedMetric["NEPTURE_READER_AVERAGE_CPU_UTILIZATION"] = "NeptuneReaderAverageCPUUtilization";
    /**
     * Percentage of provisioned read capacity units consumed by a DynamoDB table.
     */
    PredefinedMetric["DYNAMODB_READ_CAPACITY_UTILIZATION"] = "DynamoDBReadCapacityUtilization";
    /**
     * Percentage of provisioned write capacity units consumed by a DynamoDB table.
     *
     * Suffix `dummy` is necessary due to jsii bug (https://github.com/aws/jsii/issues/2782).
     * Duplicate values will be dropped, so this suffix is added as a workaround.
     * The value will be replaced when this enum is used.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["DYNAMODB_WRITE_CAPACITY_UTILIZATION"] = "DynamoDBWriteCapacityUtilization-dummy";
    /**
     * DYANMODB_WRITE_CAPACITY_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     * @deprecated use `PredefinedMetric.DYNAMODB_WRITE_CAPACITY_UTILIZATION`
     */
    PredefinedMetric["DYANMODB_WRITE_CAPACITY_UTILIZATION"] = "DynamoDBWriteCapacityUtilization";
    /**
     * ALB_REQUEST_COUNT_PER_TARGET
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ALB_REQUEST_COUNT_PER_TARGET"] = "ALBRequestCountPerTarget";
    /**
     * RDS_READER_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["RDS_READER_AVERAGE_CPU_UTILIZATION"] = "RDSReaderAverageCPUUtilization";
    /**
     * RDS_READER_AVERAGE_DATABASE_CONNECTIONS
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["RDS_READER_AVERAGE_DATABASE_CONNECTIONS"] = "RDSReaderAverageDatabaseConnections";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION"] = "EC2SpotFleetRequestAverageCPUUtilization";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN"] = "EC2SpotFleetRequestAverageNetworkIn";
    /**
     * EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT"] = "EC2SpotFleetRequestAverageNetworkOut";
    /**
     * SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE"] = "SageMakerVariantInvocationsPerInstance";
    /**
     * ECS_SERVICE_AVERAGE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ECS_SERVICE_AVERAGE_CPU_UTILIZATION"] = "ECSServiceAverageCPUUtilization";
    /**
     * ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION"] = "ECSServiceAverageMemoryUtilization";
    /**
     * LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION
     * @see https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     */
    PredefinedMetric["LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION"] = "LambdaProvisionedConcurrencyUtilization";
    /**
     * KAFKA_BROKER_STORAGE_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["KAFKA_BROKER_STORAGE_UTILIZATION"] = "KafkaBrokerStorageUtilization";
    /**
     * ELASTIC_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION"] = "ElastiCachePrimaryEngineCPUUtilization";
    /**
     * ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_REPLICA_ENGINE_CPU_UTILIZATION"] = "ElastiCacheReplicaEngineCPUUtilization";
    /**
     * ELASTIC_CACHE_REPLICA_ENGINE_CPU_UTILIZATION
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PredefinedMetricSpecification.html
     */
    PredefinedMetric["ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE"] = "ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage";
})(PredefinedMetric = exports.PredefinedMetric || (exports.PredefinedMetric = {}));
//# sourceMappingURL=data:application/json;base64,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