"""Утилиты"""

import json
from common.variables import MAX_MSG_LENGTH, ENCODING
from decorators import Log
import time


@Log()
def get_message(client):
    encoded_response = client.recv(MAX_MSG_LENGTH)
    if isinstance(encoded_response, bytes):
        json_response = encoded_response.decode(ENCODING)
        response = json.loads(json_response)
        if isinstance(response, dict):
            return response
        raise ValueError
    raise ValueError


def send_message(sock, message):
    js_message = json.dumps(message)
    encoded_message = js_message.encode(ENCODING)
    sock.send(encoded_message)
