#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = []
setup_requirements = ['pytest-runner']
test_requirements = ['pytest']

setup(
    name='yamicache',
    version='0.6.0',
    description="Yet another in-memory caching package",
    long_description=readme + '\n\n' + history,
    author="Timothy McFadden",
    author_email='tim@timandjamie.com',
    url='https://github.com/mtik00/yamicache',
    packages=find_packages(include=['yamicache']),
    include_package_data=True,
    install_requires=requirements,
    license="MIT license",
    zip_safe=True,
    keywords='yamicache',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
    ],
    test_suite='tests',
    tests_require=test_requirements,
    setup_requires=setup_requirements,
)
