import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::HealthLake::FHIRDatastore`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html
 */
export interface CfnFHIRDatastoreProps {
    /**
     * `AWS::HealthLake::FHIRDatastore.DatastoreTypeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion
     */
    readonly datastoreTypeVersion: string;
    /**
     * `AWS::HealthLake::FHIRDatastore.DatastoreName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename
     */
    readonly datastoreName?: string;
    /**
     * `AWS::HealthLake::FHIRDatastore.PreloadDataConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig
     */
    readonly preloadDataConfig?: CfnFHIRDatastore.PreloadDataConfigProperty | cdk.IResolvable;
    /**
     * `AWS::HealthLake::FHIRDatastore.SseConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration
     */
    readonly sseConfiguration?: CfnFHIRDatastore.SseConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::HealthLake::FHIRDatastore.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::HealthLake::FHIRDatastore`.
 *
 * @external
 * @cloudformationResource AWS::HealthLake::FHIRDatastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html
 */
export declare class CfnFHIRDatastore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::HealthLake::FHIRDatastore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFHIRDatastore;
    /**
     * @external
     * @cloudformationAttribute DatastoreArn
     */
    readonly attrDatastoreArn: string;
    /**
     * @external
     * @cloudformationAttribute DatastoreEndpoint
     */
    readonly attrDatastoreEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute DatastoreId
     */
    readonly attrDatastoreId: string;
    /**
     * @external
     * @cloudformationAttribute DatastoreStatus
     */
    readonly attrDatastoreStatus: string;
    /**
     * `AWS::HealthLake::FHIRDatastore.DatastoreTypeVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion
     */
    datastoreTypeVersion: string;
    /**
     * `AWS::HealthLake::FHIRDatastore.DatastoreName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename
     */
    datastoreName: string | undefined;
    /**
     * `AWS::HealthLake::FHIRDatastore.PreloadDataConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig
     */
    preloadDataConfig: CfnFHIRDatastore.PreloadDataConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::HealthLake::FHIRDatastore.SseConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration
     */
    sseConfiguration: CfnFHIRDatastore.SseConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::HealthLake::FHIRDatastore.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::HealthLake::FHIRDatastore`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFHIRDatastoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::HealthLake::FHIRDatastore`.
 *
 * @external
 * @cloudformationResource AWS::HealthLake::FHIRDatastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html
 */
export declare namespace CfnFHIRDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html
     */
    interface KmsEncryptionConfigProperty {
        /**
         * `CfnFHIRDatastore.KmsEncryptionConfigProperty.CmkType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-cmktype
         */
        readonly cmkType: string;
        /**
         * `CfnFHIRDatastore.KmsEncryptionConfigProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-kmsencryptionconfig.html#cfn-healthlake-fhirdatastore-kmsencryptionconfig-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::HealthLake::FHIRDatastore`.
 *
 * @external
 * @cloudformationResource AWS::HealthLake::FHIRDatastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html
 */
export declare namespace CfnFHIRDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html
     */
    interface PreloadDataConfigProperty {
        /**
         * `CfnFHIRDatastore.PreloadDataConfigProperty.PreloadDataType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-preloaddataconfig.html#cfn-healthlake-fhirdatastore-preloaddataconfig-preloaddatatype
         */
        readonly preloadDataType: string;
    }
}
/**
 * A CloudFormation `AWS::HealthLake::FHIRDatastore`.
 *
 * @external
 * @cloudformationResource AWS::HealthLake::FHIRDatastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html
 */
export declare namespace CfnFHIRDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html
     */
    interface SseConfigurationProperty {
        /**
         * `CfnFHIRDatastore.SseConfigurationProperty.KmsEncryptionConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-healthlake-fhirdatastore-sseconfiguration.html#cfn-healthlake-fhirdatastore-sseconfiguration-kmsencryptionconfig
         */
        readonly kmsEncryptionConfig: CfnFHIRDatastore.KmsEncryptionConfigProperty | cdk.IResolvable;
    }
}
