from base64 import b64decode
from setuptools import setup
from io import open
import os

pwd = os.path.abspath(os.path.dirname(__file__))

VERSION = '1.0.2'
REQUIRES = open(os.path.join(pwd, 'requirements.txt')).read().splitlines()
DESCRIPTION = open(os.path.join(pwd, 'readme.rst'), encoding='utf-8').read()

setup(
    name='pelican-htmlmin',
    packages=['pelican_htmlmin'],

    version=VERSION,
    url='https://git.bryanbrattlof.com/pelican-htmlmin',

    description="Minifies HTML files generated by Pelican",
    long_description=DESCRIPTION,

    author='Bryan Brattlof',
    author_email=b64decode(b'aGVsbG9AYnJ5YW5icmF0dGxvZi5jb20=').decode('ascii'),

    license='MIT',

    install_requires=REQUIRES,

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 5 - Production/Stable',

        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries',

        'Framework :: Pelican',
        'Framework :: Pelican :: Plugins',

        'License :: OSI Approved :: MIT License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',

        'Natural Language :: English',
    ],
)
