from enum import Enum


class WindowMode(Enum):
    Auto = "auto"
    TopMost = "topmost"
    NoAction = "no-action"

class ClickType(Enum):
    Click = "click"
    DoubleClick = "double-click"
    Up = "up"
    Down = "down"

class PreAction(Enum):
    SetFocus = "setfocus"
    Click = "click"

class MouseButton(Enum):
    Left = "left"
    Right = "right"
    Middle = "middle"

class Location(Enum):
    Center = "center"
    LeftTop = "left-top"
    LeftBottom = "left-bottom"
    RightTop = "right-top"
    RightBottom = "right-bottom"

class ModifierKey(Enum):
    NoneKey = "none-key"
    Alt = "alt"
    Ctrl = "ctrl"
    Shift = "shift"
    Win = "win"

class CheckType(Enum):
    Check = "check"
    UnCheck = "uncheck"
    Toggle = "toggle"

class Color(object):
    Black = "#000000"
    Blue = "#0000ff"
    Green = "#008000"
    Orange = "#ffa500"
    Pink = "#ffcocb"
    Purple = "#800080"
    Red = "#ff0000"
    Yellow = "#ffff00"

class WebUserDataMode(Enum):
    Automatic = "automatic"
    DefaultFolder = "default-folder"
    CustomFolder = "custom-folder"

class InputMethod(Enum):
    Default = "default"
    ControlSetValue = "set-text"
    KeyboardSimulateWithClick = "keyboard-simulate-click"
    KeyboardSimulateWithSetFocus = "keyboard-simulate-setfocus"

class ClickMethod(Enum):
    Default = "default"
    MouseEmulation = "mouse-emulation"
    ControlInvocation = "control-invocation"

class ClearMethod(Enum):
    ControlClearValue = "set-text"
    SendHotKey = "send-hotkey"

class ClearHotKey(Enum):    
    CtrlA_Delete = "CAD"
    End_ShiftHome_Delete = "ESHD"
    Home_ShiftEnd_Delete = "HSED"

class BrowserType:
    IE = "ie"
    Chrome = "chrome"
    FireFox = "firefox"
    Edge = "edge"

class AutomationTech:
    Uia = "uia"
    Java ="java"
    IE ="ie"
    Chrome = "chrome"
    Firefox = "firefox"
    Sap = "sap"
    Edge = "edge"
    IA = 'ia'

class EventTypes:
    ApiCall = 0
    ExceptionReport = 1