/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.utils;

import com.clicknium.ClickniumJavaBridge;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class EventQueueInvokeUtil {
    public static void invokeAndWait(Runnable runnable, AccessibleContext accessibleContext) {
        try {
            if (accessibleContext != null) {
                Component component = EventQueueInvokeUtil.getComponent(accessibleContext);
                if (component == null && (component = ClickniumJavaBridge.theClickniumJavaBridge.getComponentFromAccessibleContext(accessibleContext)) == null) {
                    return;
                }
                AppContext appContext = SunToolkit.targetToAppContext(component);
                if (appContext == null) {
                    appContext = EventQueueInvokeUtil.getDefaultAppContext();
                }
                EventQueueInvokeUtil.invokeAndWait(runnable, appContext);
            } else {
                EventQueueInvokeUtil.invokeAndWait(runnable, EventQueueInvokeUtil.getDefaultAppContext());
            }
        }
        catch (Exception e) {
            ClickniumJavaBridge.theClickniumJavaBridge.debugString("EventQueueInvokeUtil.invokeAndWait failed, Message: " + e.getMessage() + ", StackTrace:" + e.getStackTrace().toString());
        }
    }

    private static AppContext getDefaultAppContext() {
        return AppContext.getAppContext();
    }

    private static Component getComponent(AccessibleContext accessibleContext) {
        Component component = null;
        try {
            Accessible parent = accessibleContext.getAccessibleParent();
            while (component == null && parent != null) {
                Object source;
                if (parent instanceof Component) {
                    component = (Component)((Object)parent);
                } else if (parent instanceof ClickniumAccessibleComponent && (source = ((ClickniumAccessibleComponent)parent).getSource()) instanceof Component) {
                    component = (Component)source;
                }
                AccessibleContext localObject2 = parent.getAccessibleContext();
                Accessible accessible = localObject2.getAccessibleParent();
                if (accessible == parent) {
                    accessible = null;
                }
                parent = accessible;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeAndWait(Runnable runnable, AppContext appContext) throws RuntimeException, Error {
        block12: {
            if (appContext == null) {
                throw new IllegalArgumentException("EventQueueInvokeUtil invokeAndWait failed, appContext is null");
            }
            try {
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                    break block12;
                }
                EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                Object object = new Object();
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                InvocationEvent invocationEvent = new InvocationEvent((Object)defaultToolkit, runnable, object, true);
                Object object2 = object;
                synchronized (object2) {
                    eventQueue.postEvent(invocationEvent);
                    object.wait();
                }
                Exception exception = invocationEvent.getException();
                if (exception != null) {
                    throw new InvocationTargetException(exception);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable targetException = invocationTargetException.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException.toString());
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }
}

