/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.Common;

import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;

public class ClickniumAccessibleComponent
extends AccessibleContext
implements Accessible,
AccessibleComponent,
Serializable {
    protected Object source = null;

    public ClickniumAccessibleComponent(Object component) {
        this.source = component;
        this.setChildComponentParent();
    }

    public Object getSource() {
        return this.source;
    }

    public AccessibleContext getAccessibleContext() {
        return this;
    }

    public String getAccessibleName() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getName();
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.AWT_COMPONENT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        Component currentComponent = this.getCurrentComponent();
        if (currentComponent != null) {
            this.AddFocusedState(accessibleStateSet);
            this.AddFocusableState(accessibleStateSet);
            this.AddVisibleState(accessibleStateSet);
            this.AddShowingState(accessibleStateSet);
            this.AddEnabledState(accessibleStateSet);
        }
        return accessibleStateSet;
    }

    public Accessible getAccessibleParent() {
        Container componentParent;
        Component currentComponent;
        Accessible parent = super.getAccessibleParent();
        if (parent == null && (currentComponent = this.getCurrentComponent()) != null && (componentParent = currentComponent.getParent()) != null) {
            parent = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(componentParent);
        }
        return parent;
    }

    public int getAccessibleIndexInParent() {
        Container componentParent;
        Component currentComponent = this.getCurrentComponent();
        if (currentComponent != null && (componentParent = currentComponent.getParent()) != null) {
            Component[] childrenComponents = componentParent.getComponents();
            for (int i = 0; i < childrenComponents.length; ++i) {
                if (!childrenComponents[i].equals(this.source)) continue;
                return i;
            }
        }
        return 0;
    }

    public int getAccessibleChildrenCount() {
        if (this.getSource() instanceof Container) {
            return ((Container)this.getSource()).getComponentCount();
        }
        return 0;
    }

    public Accessible getAccessibleChild(int index) {
        Component childComponent;
        if (this.getSource() instanceof Container && (childComponent = ((Container)this.getSource()).getComponent(index)) != null) {
            Accessible childAccessibleComponent = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(childComponent);
            this.setAccessibleParent(childAccessibleComponent, this);
            return childAccessibleComponent;
        }
        return null;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? Locale.getDefault() : currentComponent.getLocale();
    }

    public AccessibleAction getAccessibleAction() {
        if (this instanceof AccessibleAction) {
            return (AccessibleAction)((Object)this);
        }
        return null;
    }

    public AccessibleComponent getAccessibleComponent() {
        if (this instanceof AccessibleComponent) {
            return this;
        }
        return null;
    }

    public AccessibleSelection getAccessibleSelection() {
        if (this instanceof AccessibleSelection) {
            return (AccessibleSelection)((Object)this);
        }
        return null;
    }

    public AccessibleText getAccessibleText() {
        if (this instanceof AccessibleText) {
            return (AccessibleText)((Object)this);
        }
        return null;
    }

    public AccessibleValue getAccessibleValue() {
        if (this instanceof AccessibleValue) {
            return (AccessibleValue)((Object)this);
        }
        return null;
    }

    public Color getBackground() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? Color.WHITE : currentComponent.getBackground();
    }

    public void setBackground(Color color) {
        throw new UnsupportedOperationException("not support");
    }

    public Color getForeground() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? Color.WHITE : currentComponent.getForeground();
    }

    public void setForeground(Color color) {
        throw new UnsupportedOperationException("not support");
    }

    public Cursor getCursor() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getCursor();
    }

    public void setCursor(Cursor cursor) {
        throw new UnsupportedOperationException("not support");
    }

    public Font getFont() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getFont();
    }

    public void setFont(Font font) {
        throw new UnsupportedOperationException("not support");
    }

    public FontMetrics getFontMetrics(Font font) {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getFontMetrics(font);
    }

    public boolean isEnabled() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? false : currentComponent.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("not support");
    }

    public boolean isVisible() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? false : currentComponent.isVisible();
    }

    public void setVisible(boolean visible) {
        throw new UnsupportedOperationException("not support");
    }

    public boolean isShowing() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? false : currentComponent.isShowing();
    }

    public boolean contains(Point point) {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? false : currentComponent.contains(point);
    }

    public Point getLocationOnScreen() {
        Component currentComponent = this.getCurrentComponent();
        if (currentComponent != null && currentComponent.isShowing()) {
            return currentComponent.getLocationOnScreen();
        }
        return null;
    }

    public Point getLocation() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getLocation();
    }

    public void setLocation(Point point) {
        throw new UnsupportedOperationException("not support");
    }

    public Rectangle getBounds() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getBounds();
    }

    public void setBounds(Rectangle rectangle) {
        throw new UnsupportedOperationException("not support");
    }

    public Dimension getSize() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? null : currentComponent.getSize();
    }

    public void setSize(Dimension dimension) {
        throw new UnsupportedOperationException("not support");
    }

    public Accessible getAccessibleAt(Point point) {
        Component targetCompinent;
        if (this.getSource() instanceof Container && (targetCompinent = ((Container)this.getSource()).getComponentAt(point)) != null) {
            return ClickniumAccessibleComponentFactory.getAccessibleFromComponent(targetCompinent);
        }
        return null;
    }

    public boolean isFocusTraversable() {
        Component currentComponent = this.getCurrentComponent();
        return currentComponent == null ? false : currentComponent.isFocusable();
    }

    public void requestFocus() {
        Component currentComponent = this.getCurrentComponent();
        if (currentComponent != null) {
            currentComponent.requestFocus();
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        throw new UnsupportedOperationException("not support");
    }

    public void removeFocusListener(FocusListener focusListener) {
        throw new UnsupportedOperationException("not support");
    }

    public boolean equals(Object object) {
        if (object instanceof ClickniumAccessibleComponent) {
            if (object != this) {
                ClickniumAccessibleComponent ClickniumAccessibleComponent2 = (ClickniumAccessibleComponent)object;
                return ClickniumAccessibleComponent2.source != null && (ClickniumAccessibleComponent2.source == this.source || ClickniumAccessibleComponent2.source.equals(this.source));
            }
            return true;
        }
        return false;
    }

    private void setChildComponentParent() {
        Component[] components;
        Container currentSource;
        Container container = currentSource = this.source instanceof Container ? (Container)this.source : null;
        if (currentSource != null && (components = currentSource.getComponents()) != null) {
            int i = components.length;
            for (int j = 0; j < i; ++j) {
                AccessibleContext currentContext;
                if (!(components[j] instanceof Accessible) || (currentContext = components[j].getAccessibleContext()) == null || currentContext.getAccessibleParent() != null) continue;
                currentContext.setAccessibleParent(this);
            }
        }
    }

    private Component getCurrentComponent() {
        if (this.source instanceof Component) {
            return (Component)this.source;
        }
        return null;
    }

    private AccessibleStateSet AddFocusedState(AccessibleStateSet stateSet) {
        Component currentComponent = this.getCurrentComponent();
        for (Container parent = currentComponent.getParent(); parent != null; parent = parent.getParent()) {
            Window parentWindow;
            if (!(parent instanceof Window) || (parentWindow = (Window)parent).getFocusOwner() != currentComponent) continue;
            stateSet.add(AccessibleState.FOCUSED);
            break;
        }
        return stateSet;
    }

    private AccessibleStateSet AddFocusableState(AccessibleStateSet stateSet) {
        if (this.isFocusTraversable() || this.getSource() instanceof MenuItem) {
            stateSet.add(AccessibleState.FOCUSABLE);
        }
        return stateSet;
    }

    private AccessibleStateSet AddVisibleState(AccessibleStateSet stateSet) {
        if (this.isVisible()) {
            stateSet.add(AccessibleState.VISIBLE);
        }
        return stateSet;
    }

    private AccessibleStateSet AddShowingState(AccessibleStateSet stateSet) {
        if (this.isShowing()) {
            stateSet.add(AccessibleState.SHOWING);
        }
        return stateSet;
    }

    private AccessibleStateSet AddEnabledState(AccessibleStateSet stateSet) {
        if (this.isEnabled()) {
            stateSet.add(AccessibleState.ENABLED);
        }
        return stateSet;
    }

    private void setAccessibleParent(Accessible child, Accessible parent) {
        AccessibleContext childAccessibleContext;
        if (child != null && (childAccessibleContext = child.getAccessibleContext()) != null) {
            childAccessibleContext.setAccessibleParent(parent);
        }
    }
}

