// Copyright 2017-2019, Nicholas Sharp and the Polyscope contributors. http://polyscope.run.
#include "polyscope/render/color_maps.h"

#include "polyscope/render/colormap_defs.h"
#include "polyscope/render/engine.h"

#include "imgui.h"

namespace polyscope {

void loadColorMap(std::string cmapName, std::string filename) { render::engine->loadColorMap(cmapName, filename); }

namespace render {

// ImGUI helper to select a colormap. Returns true if the selection changed
bool buildColormapSelector(std::string& cm, std::string fieldName) {
  bool changed = false;

  ImGui::PushItemWidth(100);

  if (ImGui::BeginCombo(fieldName.c_str(), cm.c_str())) {
    for (auto& c : render::engine->colorMaps) {
      if (ImGui::Selectable(c->name.c_str(), c->name == cm)) {
        changed = true;
        cm = c->name;
      }
    }
    ImGui::EndCombo();
  }

  ImGui::PopItemWidth();

  return changed;
};


// === color map data buffers

// clang-format off

const std::vector<glm::vec3> CM_VIRIDIS =
{{0.267004,0.004874,0.329415},{0.267004,0.004874,0.329415},{0.26851,0.009605,0.335427},{0.26851,0.009605,0.335427},{0.269944,0.014625,0.341379},{0.269944,0.014625,0.341379},{0.271305,0.019942,0.347269},{0.271305,0.019942,0.347269},{0.272594,0.025563,0.353093},{0.272594,0.025563,0.353093},{0.273809,0.031497,0.358853},{0.273809,0.031497,0.358853},{0.274952,0.037752,0.364543},{0.274952,0.037752,0.364543},{0.276022,0.044167,0.370164},{0.276022,0.044167,0.370164},{0.277018,0.050344,0.375715},{0.277018,0.050344,0.375715},{0.277941,0.056324,0.381191},{0.277941,0.056324,0.381191},{0.278791,0.062145,0.386592},{0.278791,0.062145,0.386592},{0.279566,0.067836,0.391917},{0.279566,0.067836,0.391917},{0.280267,0.073417,0.397163},{0.280267,0.073417,0.397163},{0.280894,0.078907,0.402329},{0.280894,0.078907,0.402329},{0.281446,0.08432,0.407414},{0.281446,0.08432,0.407414},{0.281924,0.089666,0.412415},{0.281924,0.089666,0.412415},{0.282327,0.094955,0.417331},{0.282327,0.094955,0.417331},{0.282656,0.100196,0.42216},{0.282656,0.100196,0.42216},{0.28291,0.105393,0.426902},{0.28291,0.105393,0.426902},{0.283091,0.110553,0.431554},{0.283197,0.11568,0.436115},{0.283197,0.11568,0.436115},{0.283229,0.120777,0.440584},{0.283229,0.120777,0.440584},{0.283187,0.125848,0.44496},{0.283187,0.125848,0.44496},{0.283072,0.130895,0.449241},{0.283072,0.130895,0.449241},{0.282884,0.13592,0.453427},{0.282884,0.13592,0.453427},{0.282623,0.140926,0.457517},{0.282623,0.140926,0.457517},{0.28229,0.145912,0.46151},{0.28229,0.145912,0.46151},{0.281887,0.150881,0.465405},{0.281887,0.150881,0.465405},{0.281412,0.155834,0.469201},{0.281412,0.155834,0.469201},{0.280868,0.160771,0.472899},{0.280868,0.160771,0.472899},{0.280255,0.165693,0.476498},{0.280255,0.165693,0.476498},{0.279574,0.170599,0.479997},{0.279574,0.170599,0.479997},{0.278826,0.17549,0.483397},{0.278826,0.17549,0.483397},{0.278012,0.180367,0.486697},{0.278012,0.180367,0.486697},{0.277134,0.185228,0.489898},{0.277134,0.185228,0.489898},{0.276194,0.190074,0.493001},{0.276194,0.190074,0.493001},{0.275191,0.194905,0.496005},{0.275191,0.194905,0.496005},{0.274128,0.199721,0.498911},{0.274128,0.199721,0.498911},{0.273006,0.20452,0.501721},{0.273006,0.20452,0.501721},{0.271828,0.209303,0.504434},{0.270595,0.214069,0.507052},{0.270595,0.214069,0.507052},{0.269308,0.218818,0.509577},{0.269308,0.218818,0.509577},{0.267968,0.223549,0.512008},{0.267968,0.223549,0.512008},{0.26658,0.228262,0.514349},{0.26658,0.228262,0.514349},{0.265145,0.232956,0.516599},{0.265145,0.232956,0.516599},{0.263663,0.237631,0.518762},{0.263663,0.237631,0.518762},{0.262138,0.242286,0.520837},{0.262138,0.242286,0.520837},{0.260571,0.246922,0.522828},{0.260571,0.246922,0.522828},{0.258965,0.251537,0.524736},{0.258965,0.251537,0.524736},{0.257322,0.25613,0.526563},{0.257322,0.25613,0.526563},{0.255645,0.260703,0.528312},{0.255645,0.260703,0.528312},{0.253935,0.265254,0.529983},{0.253935,0.265254,0.529983},{0.252194,0.269783,0.531579},{0.252194,0.269783,0.531579},{0.250425,0.27429,0.533103},{0.250425,0.27429,0.533103},{0.248629,0.278775,0.534556},{0.248629,0.278775,0.534556},{0.246811,0.283237,0.535941},{0.246811,0.283237,0.535941},{0.244972,0.287675,0.53726},{0.244972,0.287675,0.53726},{0.243113,0.292092,0.538516},{0.243113,0.292092,0.538516},{0.241237,0.296485,0.539709},{0.241237,0.296485,0.539709},{0.239346,0.300855,0.540844},{0.237441,0.305202,0.541921},{0.237441,0.305202,0.541921},{0.235526,0.309527,0.542944},{0.235526,0.309527,0.542944},{0.233603,0.313828,0.543914},{0.233603,0.313828,0.543914},{0.231674,0.318106,0.544834},{0.231674,0.318106,0.544834},{0.229739,0.322361,0.545706},{0.229739,0.322361,0.545706},{0.227802,0.326594,0.546532},{0.227802,0.326594,0.546532},{0.225863,0.330805,0.547314},{0.225863,0.330805,0.547314},{0.223925,0.334994,0.548053},{0.223925,0.334994,0.548053},{0.221989,0.339161,0.548752},{0.221989,0.339161,0.548752},{0.220057,0.343307,0.549413},{0.220057,0.343307,0.549413},{0.21813,0.347432,0.550038},{0.21813,0.347432,0.550038},{0.21621,0.351535,0.550627},{0.21621,0.351535,0.550627},{0.214298,0.355619,0.551184},{0.214298,0.355619,0.551184},{0.212395,0.359683,0.55171},{0.212395,0.359683,0.55171},{0.210503,0.363727,0.552206},{0.210503,0.363727,0.552206},{0.208623,0.367752,0.552675},{0.208623,0.367752,0.552675},{0.206756,0.371758,0.553117},{0.206756,0.371758,0.553117},{0.204903,0.375746,0.553533},{0.204903,0.375746,0.553533},{0.203063,0.379716,0.553925},{0.201239,0.38367,0.554294},{0.201239,0.38367,0.554294},{0.19943,0.387607,0.554642},{0.19943,0.387607,0.554642},{0.197636,0.391528,0.554969},{0.197636,0.391528,0.554969},{0.19586,0.395433,0.555276},{0.19586,0.395433,0.555276},{0.1941,0.399323,0.555565},{0.1941,0.399323,0.555565},{0.192357,0.403199,0.555836},{0.192357,0.403199,0.555836},{0.190631,0.407061,0.556089},{0.190631,0.407061,0.556089},{0.188923,0.41091,0.556326},{0.188923,0.41091,0.556326},{0.187231,0.414746,0.556547},{0.187231,0.414746,0.556547},{0.185556,0.41857,0.556753},{0.185556,0.41857,0.556753},{0.183898,0.422383,0.556944},{0.183898,0.422383,0.556944},{0.182256,0.426184,0.55712},{0.182256,0.426184,0.55712},{0.180629,0.429975,0.557282},{0.180629,0.429975,0.557282},{0.179019,0.433756,0.55743},{0.179019,0.433756,0.55743},{0.177423,0.437527,0.557565},{0.177423,0.437527,0.557565},{0.175841,0.44129,0.557685},{0.175841,0.44129,0.557685},{0.174274,0.445044,0.557792},{0.174274,0.445044,0.557792},{0.172719,0.448791,0.557885},{0.172719,0.448791,0.557885},{0.171176,0.45253,0.557965},{0.171176,0.45253,0.557965},{0.169646,0.456262,0.55803},{0.168126,0.459988,0.558082},{0.168126,0.459988,0.558082},{0.166617,0.463708,0.558119},{0.166617,0.463708,0.558119},{0.165117,0.467423,0.558141},{0.165117,0.467423,0.558141},{0.163625,0.471133,0.558148},{0.163625,0.471133,0.558148},{0.162142,0.474838,0.55814},{0.162142,0.474838,0.55814},{0.160665,0.47854,0.558115},{0.160665,0.47854,0.558115},{0.159194,0.482237,0.558073},{0.159194,0.482237,0.558073},{0.157729,0.485932,0.558013},{0.157729,0.485932,0.558013},{0.15627,0.489624,0.557936},{0.15627,0.489624,0.557936},{0.154815,0.493313,0.55784},{0.154815,0.493313,0.55784},{0.153364,0.497,0.557724},{0.153364,0.497,0.557724},{0.151918,0.500685,0.557587},{0.151918,0.500685,0.557587},{0.150476,0.504369,0.55743},{0.150476,0.504369,0.55743},{0.149039,0.508051,0.55725},{0.149039,0.508051,0.55725},{0.147607,0.511733,0.557049},{0.147607,0.511733,0.557049},{0.14618,0.515413,0.556823},{0.14618,0.515413,0.556823},{0.144759,0.519093,0.556572},{0.144759,0.519093,0.556572},{0.143343,0.522773,0.556295},{0.143343,0.522773,0.556295},{0.141935,0.526453,0.555991},{0.141935,0.526453,0.555991},{0.140536,0.530132,0.555659},{0.139147,0.533812,0.555298},{0.139147,0.533812,0.555298},{0.13777,0.537492,0.554906},{0.13777,0.537492,0.554906},{0.136408,0.541173,0.554483},{0.136408,0.541173,0.554483},{0.135066,0.544853,0.554029},{0.135066,0.544853,0.554029},{0.133743,0.548535,0.553541},{0.133743,0.548535,0.553541},{0.132444,0.552216,0.553018},{0.132444,0.552216,0.553018},{0.131172,0.555899,0.552459},{0.131172,0.555899,0.552459},{0.129933,0.559582,0.551864},{0.129933,0.559582,0.551864},{0.128729,0.563265,0.551229},{0.128729,0.563265,0.551229},{0.127568,0.566949,0.550556},{0.127568,0.566949,0.550556},{0.126453,0.570633,0.549841},{0.126453,0.570633,0.549841},{0.125394,0.574318,0.549086},{0.125394,0.574318,0.549086},{0.124395,0.578002,0.548287},{0.124395,0.578002,0.548287},{0.123463,0.581687,0.547445},{0.123463,0.581687,0.547445},{0.122606,0.585371,0.546557},{0.122606,0.585371,0.546557},{0.121831,0.589055,0.545623},{0.121831,0.589055,0.545623},{0.121148,0.592739,0.544641},{0.121148,0.592739,0.544641},{0.120565,0.596422,0.543611},{0.120565,0.596422,0.543611},{0.120092,0.600104,0.54253},{0.119738,0.603785,0.5414},{0.119738,0.603785,0.5414},{0.119512,0.607464,0.540218},{0.119512,0.607464,0.540218},{0.119423,0.611141,0.538982},{0.119423,0.611141,0.538982},{0.119483,0.614817,0.537692},{0.119483,0.614817,0.537692},{0.119699,0.61849,0.536347},{0.119699,0.61849,0.536347},{0.120081,0.622161,0.534946},{0.120081,0.622161,0.534946},{0.120638,0.625828,0.533488},{0.120638,0.625828,0.533488},{0.12138,0.629492,0.531973},{0.12138,0.629492,0.531973},{0.122312,0.633153,0.530398},{0.122312,0.633153,0.530398},{0.123444,0.636809,0.528763},{0.123444,0.636809,0.528763},{0.12478,0.640461,0.527068},{0.12478,0.640461,0.527068},{0.126326,0.644107,0.525311},{0.126326,0.644107,0.525311},{0.128087,0.647749,0.523491},{0.128087,0.647749,0.523491},{0.130067,0.651384,0.521608},{0.130067,0.651384,0.521608},{0.132268,0.655014,0.519661},{0.132268,0.655014,0.519661},{0.134692,0.658636,0.517649},{0.134692,0.658636,0.517649},{0.137339,0.662252,0.515571},{0.137339,0.662252,0.515571},{0.14021,0.665859,0.513427},{0.14021,0.665859,0.513427},{0.143303,0.669459,0.511215},{0.143303,0.669459,0.511215},{0.146616,0.67305,0.508936},{0.150148,0.676631,0.506589},{0.150148,0.676631,0.506589},{0.153894,0.680203,0.504172},{0.153894,0.680203,0.504172},{0.157851,0.683765,0.501686},{0.157851,0.683765,0.501686},{0.162016,0.687316,0.499129},{0.162016,0.687316,0.499129},{0.166383,0.690856,0.496502},{0.166383,0.690856,0.496502},{0.170948,0.694384,0.493803},{0.170948,0.694384,0.493803},{0.175707,0.6979,0.491033},{0.175707,0.6979,0.491033},{0.180653,0.701402,0.488189},{0.180653,0.701402,0.488189},{0.185783,0.704891,0.485273},{0.185783,0.704891,0.485273},{0.19109,0.708366,0.482284},{0.19109,0.708366,0.482284},{0.196571,0.711827,0.479221},{0.196571,0.711827,0.479221},{0.202219,0.715272,0.476084},{0.202219,0.715272,0.476084},{0.20803,0.718701,0.472873},{0.20803,0.718701,0.472873},{0.214,0.722114,0.469588},{0.214,0.722114,0.469588},{0.220124,0.725509,0.466226},{0.220124,0.725509,0.466226},{0.226397,0.728888,0.462789},{0.226397,0.728888,0.462789},{0.232815,0.732247,0.459277},{0.232815,0.732247,0.459277},{0.239374,0.735588,0.455688},{0.239374,0.735588,0.455688},{0.24607,0.73891,0.452024},{0.24607,0.73891,0.452024},{0.252899,0.742211,0.448284},{0.259857,0.745492,0.444467},{0.259857,0.745492,0.444467},{0.266941,0.748751,0.440573},{0.266941,0.748751,0.440573},{0.274149,0.751988,0.436601},{0.274149,0.751988,0.436601},{0.281477,0.755203,0.432552},{0.281477,0.755203,0.432552},{0.288921,0.758394,0.428426},{0.288921,0.758394,0.428426},{0.296479,0.761561,0.424223},{0.296479,0.761561,0.424223},{0.304148,0.764704,0.419943},{0.304148,0.764704,0.419943},{0.311925,0.767822,0.415586},{0.311925,0.767822,0.415586},{0.319809,0.770914,0.411152},{0.319809,0.770914,0.411152},{0.327796,0.77398,0.40664},{0.327796,0.77398,0.40664},{0.335885,0.777018,0.402049},{0.335885,0.777018,0.402049},{0.344074,0.780029,0.397381},{0.344074,0.780029,0.397381},{0.35236,0.783011,0.392636},{0.35236,0.783011,0.392636},{0.360741,0.785964,0.387814},{0.360741,0.785964,0.387814},{0.369214,0.788888,0.382914},{0.369214,0.788888,0.382914},{0.377779,0.791781,0.377939},{0.377779,0.791781,0.377939},{0.386433,0.794644,0.372886},{0.386433,0.794644,0.372886},{0.395174,0.797475,0.367757},{0.395174,0.797475,0.367757},{0.404001,0.800275,0.362552},{0.412913,0.803041,0.357269},{0.412913,0.803041,0.357269},{0.421908,0.805774,0.35191},{0.421908,0.805774,0.35191},{0.430983,0.808473,0.346476},{0.430983,0.808473,0.346476},{0.440137,0.811138,0.340967},{0.440137,0.811138,0.340967},{0.449368,0.813768,0.335384},{0.449368,0.813768,0.335384},{0.458674,0.816363,0.329727},{0.458674,0.816363,0.329727},{0.468053,0.818921,0.323998},{0.468053,0.818921,0.323998},{0.477504,0.821444,0.318195},{0.477504,0.821444,0.318195},{0.487026,0.823929,0.312321},{0.487026,0.823929,0.312321},{0.496615,0.826376,0.306377},{0.496615,0.826376,0.306377},{0.506271,0.828786,0.300362},{0.506271,0.828786,0.300362},{0.515992,0.831158,0.294279},{0.515992,0.831158,0.294279},{0.525776,0.833491,0.288127},{0.525776,0.833491,0.288127},{0.535621,0.835785,0.281908},{0.535621,0.835785,0.281908},{0.545524,0.838039,0.275626},{0.545524,0.838039,0.275626},{0.555484,0.840254,0.269281},{0.555484,0.840254,0.269281},{0.565498,0.84243,0.262877},{0.565498,0.84243,0.262877},{0.575563,0.844566,0.256415},{0.575563,0.844566,0.256415},{0.585678,0.846661,0.249897},{0.585678,0.846661,0.249897},{0.595839,0.848717,0.243329},{0.606045,0.850733,0.236712},{0.606045,0.850733,0.236712},{0.616293,0.852709,0.230052},{0.616293,0.852709,0.230052},{0.626579,0.854645,0.223353},{0.626579,0.854645,0.223353},{0.636902,0.856542,0.21662},{0.636902,0.856542,0.21662},{0.647257,0.8584,0.209861},{0.647257,0.8584,0.209861},{0.657642,0.860219,0.203082},{0.657642,0.860219,0.203082},{0.668054,0.861999,0.196293},{0.668054,0.861999,0.196293},{0.678489,0.863742,0.189503},{0.678489,0.863742,0.189503},{0.688944,0.865448,0.182725},{0.688944,0.865448,0.182725},{0.699415,0.867117,0.175971},{0.699415,0.867117,0.175971},{0.709898,0.868751,0.169257},{0.709898,0.868751,0.169257},{0.720391,0.87035,0.162603},{0.720391,0.87035,0.162603},{0.730889,0.871916,0.156029},{0.730889,0.871916,0.156029},{0.741388,0.873449,0.149561},{0.741388,0.873449,0.149561},{0.751884,0.874951,0.143228},{0.751884,0.874951,0.143228},{0.762373,0.876424,0.137064},{0.762373,0.876424,0.137064},{0.772852,0.877868,0.131109},{0.772852,0.877868,0.131109},{0.783315,0.879285,0.125405},{0.783315,0.879285,0.125405},{0.79376,0.880678,0.120005},{0.79376,0.880678,0.120005},{0.804182,0.882046,0.114965},{0.814576,0.883393,0.110347},{0.814576,0.883393,0.110347},{0.82494,0.88472,0.106217},{0.82494,0.88472,0.106217},{0.83527,0.886029,0.102646},{0.83527,0.886029,0.102646},{0.845561,0.887322,0.099702},{0.845561,0.887322,0.099702},{0.85581,0.888601,0.097452},{0.85581,0.888601,0.097452},{0.866013,0.889868,0.095953},{0.866013,0.889868,0.095953},{0.876168,0.891125,0.09525},{0.876168,0.891125,0.09525},{0.886271,0.892374,0.095374},{0.886271,0.892374,0.095374},{0.89632,0.893616,0.096335},{0.89632,0.893616,0.096335},{0.906311,0.894855,0.098125},{0.906311,0.894855,0.098125},{0.916242,0.896091,0.100717},{0.916242,0.896091,0.100717},{0.926106,0.89733,0.104071},{0.926106,0.89733,0.104071},{0.935904,0.89857,0.108131},{0.935904,0.89857,0.108131},{0.945636,0.899815,0.112838},{0.945636,0.899815,0.112838},{0.9553,0.901065,0.118128},{0.9553,0.901065,0.118128},{0.964894,0.902323,0.123941},{0.964894,0.902323,0.123941},{0.974417,0.90359,0.130215},{0.974417,0.90359,0.130215},{0.983868,0.904867,0.136897},{0.983868,0.904867,0.136897},{0.993248,0.906157,0.143936},{0.993248,0.906157,0.143936},};

const std::vector<glm::vec3> CM_COOLWARM =
{{0.2298057,0.298717966,0.753683153},{0.2298057,0.298717966,0.753683153},{0.234377079451,0.305541730329,0.759679527588},{0.234377079451,0.305541730329,0.759679527588},{0.238948458902,0.312365494659,0.765675902176},{0.238948458902,0.312365494659,0.765675902176},{0.243519838353,0.319189258988,0.771672276765},{0.243519838353,0.319189258988,0.771672276765},{0.248091217804,0.326013023318,0.777668651353},{0.248091217804,0.326013023318,0.777668651353},{0.252662597255,0.332836787647,0.783665025941},{0.252662597255,0.332836787647,0.783665025941},{0.257233976706,0.339660551976,0.789661400529},{0.257233976706,0.339660551976,0.789661400529},{0.261805356157,0.346484316306,0.795657775118},{0.261805356157,0.346484316306,0.795657775118},{0.266381468353,0.353304408424,0.801637319498},{0.266381468353,0.353304408424,0.801637319498},{0.271104295647,0.360010661976,0.807095127435},{0.271104295647,0.360010661976,0.807095127435},{0.275827122941,0.366716915529,0.812552935373},{0.275827122941,0.366716915529,0.812552935373},{0.280549950235,0.373423169082,0.81801074331},{0.280549950235,0.373423169082,0.81801074331},{0.285272777529,0.380129422635,0.823468551247},{0.285272777529,0.380129422635,0.823468551247},{0.289995604824,0.386835676188,0.828926359184},{0.289995604824,0.386835676188,0.828926359184},{0.294718432118,0.393541929741,0.834384167122},{0.294718432118,0.393541929741,0.834384167122},{0.299441259412,0.400248183294,0.839841975059},{0.299441259412,0.400248183294,0.839841975059},{0.304174287004,0.406944882839,0.845262726698},{0.304174287004,0.406944882839,0.845262726698},{0.309060319067,0.413498272267,0.850127633867},{0.309060319067,0.413498272267,0.850127633867},{0.313946351129,0.420051661694,0.854992541035},{0.313946351129,0.420051661694,0.854992541035},{0.318832383192,0.426605051122,0.859857448204},{0.323718415255,0.433158440549,0.864722355373},{0.323718415255,0.433158440549,0.864722355373},{0.328604447318,0.439711829976,0.869587262541},{0.328604447318,0.439711829976,0.869587262541},{0.33349047938,0.446265219404,0.87445216971},{0.33349047938,0.446265219404,0.87445216971},{0.338376511443,0.452818608831,0.879317076878},{0.338376511443,0.452818608831,0.879317076878},{0.343277523435,0.459353634729,0.884121921624},{0.343277523435,0.459353634729,0.884121921624},{0.348323341412,0.46571114651,0.888346162941},{0.348323341412,0.46571114651,0.888346162941},{0.353369159388,0.47206865829,0.892570404259},{0.353369159388,0.47206865829,0.892570404259},{0.358414977365,0.478426170071,0.896794645576},{0.358414977365,0.478426170071,0.896794645576},{0.363460795341,0.484783681851,0.901018886894},{0.363460795341,0.484783681851,0.901018886894},{0.368506613318,0.491141193631,0.905243128212},{0.368506613318,0.491141193631,0.905243128212},{0.373552431294,0.497498705412,0.909467369529},{0.373552431294,0.497498705412,0.909467369529},{0.378598249271,0.503856217192,0.913691610847},{0.378598249271,0.503856217192,0.913691610847},{0.383662065773,0.510183417286,0.917830673231},{0.383662065773,0.510183417286,0.917830673231},{0.388851871953,0.516298435576,0.921373483082},{0.388851871953,0.516298435576,0.921373483082},{0.394041678133,0.522413453867,0.924916292933},{0.394041678133,0.522413453867,0.924916292933},{0.399231484314,0.528528472157,0.928459102784},{0.399231484314,0.528528472157,0.928459102784},{0.404421290494,0.534643490447,0.932001912635},{0.404421290494,0.534643490447,0.932001912635},{0.409611096675,0.540758508737,0.935544722486},{0.409611096675,0.540758508737,0.935544722486},{0.414800902855,0.546873527027,0.939087532337},{0.414800902855,0.546873527027,0.939087532337},{0.419990709035,0.552988545318,0.942630342188},{0.425198970196,0.559058179765,0.946061457078},{0.425198970196,0.559058179765,0.946061457078},{0.430506888251,0.564882741459,0.94888941918},{0.430506888251,0.564882741459,0.94888941918},{0.435814806306,0.570707303153,0.951717381282},{0.435814806306,0.570707303153,0.951717381282},{0.441122724361,0.576531864847,0.954545343384},{0.441122724361,0.576531864847,0.954545343384},{0.446430642416,0.582356426541,0.957373305486},{0.446430642416,0.582356426541,0.957373305486},{0.451738560471,0.588180988235,0.960201267588},{0.451738560471,0.588180988235,0.960201267588},{0.457046478525,0.594005549929,0.96302922969},{0.457046478525,0.594005549929,0.96302922969},{0.46235439658,0.599830111624,0.965857191792},{0.46235439658,0.599830111624,0.965857191792},{0.467678094682,0.605591231624,0.968546281094},{0.467678094682,0.605591231624,0.968546281094},{0.473070172988,0.611077437616,0.970633588263},{0.473070172988,0.611077437616,0.970633588263},{0.478462251294,0.616563643608,0.972720895431},{0.478462251294,0.616563643608,0.972720895431},{0.4838543296,0.6220498496,0.9748082026},{0.4838543296,0.6220498496,0.9748082026},{0.489246407906,0.627536055592,0.976895509769},{0.489246407906,0.627536055592,0.976895509769},{0.494638486212,0.633022261584,0.978982816937},{0.494638486212,0.633022261584,0.978982816937},{0.500030564518,0.638508467576,0.981070124106},{0.500030564518,0.638508467576,0.981070124106},{0.505422642824,0.643994673569,0.983157431275},{0.505422642824,0.643994673569,0.983157431275},{0.510824324251,0.649396614824,0.985078776376},{0.510824324251,0.649396614824,0.985078776376},{0.516260302541,0.654497610588,0.986407399812},{0.516260302541,0.654497610588,0.986407399812},{0.521696280831,0.659598606353,0.987736023247},{0.521696280831,0.659598606353,0.987736023247},{0.527132259122,0.664699602118,0.989064646682},{0.532568237412,0.669800597882,0.990393270118},{0.532568237412,0.669800597882,0.990393270118},{0.538004215702,0.674901593647,0.991721893553},{0.538004215702,0.674901593647,0.991721893553},{0.543440193992,0.680002589412,0.993050516988},{0.543440193992,0.680002589412,0.993050516988},{0.548876172282,0.685103585176,0.994379140424},{0.548876172282,0.685103585176,0.994379140424},{0.554311869914,0.690097011216,0.995515548235},{0.554311869914,0.690097011216,0.995515548235},{0.559746725569,0.694767728078,0.996075309176},{0.559746725569,0.694767728078,0.996075309176},{0.565181581224,0.699438444941,0.996635070118},{0.565181581224,0.699438444941,0.996635070118},{0.570616436878,0.704109161804,0.997194831059},{0.570616436878,0.704109161804,0.997194831059},{0.576051292533,0.708779878667,0.997754592},{0.576051292533,0.708779878667,0.997754592},{0.581486148188,0.713450595529,0.998314352941},{0.581486148188,0.713450595529,0.998314352941},{0.586921003843,0.718121312392,0.998874113882},{0.586921003843,0.718121312392,0.998874113882},{0.592355859498,0.722792029255,0.999433874824},{0.592355859498,0.722792029255,0.999433874824},{0.597776775494,0.727329724882,0.999776731776},{0.597776775494,0.727329724882,0.999776731776},{0.603162067918,0.731527477353,0.999565278537},{0.603162067918,0.731527477353,0.999565278537},{0.608547360341,0.735725229824,0.999353825298},{0.608547360341,0.735725229824,0.999353825298},{0.613932652765,0.739922982294,0.999142372059},{0.613932652765,0.739922982294,0.999142372059},{0.619317945188,0.744120734765,0.99893091882},{0.619317945188,0.744120734765,0.99893091882},{0.624703237612,0.748318487235,0.99871946558},{0.624703237612,0.748318487235,0.99871946558},{0.630088530035,0.752516239706,0.998508012341},{0.635473822459,0.756713992176,0.998296559102},{0.635473822459,0.756713992176,0.998296559102},{0.640827782373,0.760751506412,0.997845774882},{0.640827782373,0.760751506412,0.997845774882},{0.646112810765,0.764436496529,0.996868462506},{0.646112810765,0.764436496529,0.996868462506},{0.651397839157,0.768121486647,0.995891150129},{0.651397839157,0.768121486647,0.995891150129},{0.656682867549,0.771806476765,0.994913837753},{0.656682867549,0.771806476765,0.994913837753},{0.661967895941,0.775491466882,0.993936525376},{0.661967895941,0.775491466882,0.993936525376},{0.667252924333,0.779176457,0.992959213},{0.667252924333,0.779176457,0.992959213},{0.672537952725,0.782861447118,0.991981900624},{0.672537952725,0.782861447118,0.991981900624},{0.677822981118,0.786546437235,0.991004588247},{0.677822981118,0.786546437235,0.991004588247},{0.683055681561,0.79004262689,0.989768428184},{0.683055681561,0.79004262689,0.989768428184},{0.688188483192,0.793178379298,0.988038104357},{0.688188483192,0.793178379298,0.988038104357},{0.693321284824,0.796314131706,0.986307780529},{0.693321284824,0.796314131706,0.986307780529},{0.698454086455,0.799449884114,0.984577456702},{0.698454086455,0.799449884114,0.984577456702},{0.703586888086,0.802585636522,0.982847132875},{0.703586888086,0.802585636522,0.982847132875},{0.708719689718,0.805721388929,0.981116809047},{0.708719689718,0.805721388929,0.981116809047},{0.713852491349,0.808857141337,0.97938648522},{0.713852491349,0.808857141337,0.97938648522},{0.71898529298,0.811992893745,0.977656161392},{0.71898529298,0.811992893745,0.977656161392},{0.724041371882,0.814910392647,0.975650970647},{0.724041371882,0.814910392647,0.975650970647},{0.728969579569,0.817464135706,0.973187668373},{0.728969579569,0.817464135706,0.973187668373},{0.733897787255,0.820017878765,0.970724366098},{0.738825994941,0.822571621824,0.968261063824},{0.738825994941,0.822571621824,0.968261063824},{0.743754202627,0.825125364882,0.965797761549},{0.743754202627,0.825125364882,0.965797761549},{0.748682410314,0.827679107941,0.963334459275},{0.748682410314,0.827679107941,0.963334459275},{0.753610618,0.830232851,0.960871157},{0.753610618,0.830232851,0.960871157},{0.758538825686,0.832786594059,0.958407854725},{0.758538825686,0.832786594059,0.958407854725},{0.763362780102,0.83509222182,0.955657676557},{0.763362780102,0.83509222182,0.955657676557},{0.768034364353,0.837035219529,0.952488218235},{0.768034364353,0.837035219529,0.952488218235},{0.772705948604,0.838978217239,0.949318759914},{0.772705948604,0.838978217239,0.949318759914},{0.777377532855,0.840921214949,0.946149301592},{0.777377532855,0.840921214949,0.946149301592},{0.782049117106,0.842864212659,0.942979843271},{0.782049117106,0.842864212659,0.942979843271},{0.786720701357,0.844807210369,0.939810384949},{0.786720701357,0.844807210369,0.939810384949},{0.791392285608,0.846750208078,0.936640926627},{0.791392285608,0.846750208078,0.936640926627},{0.796063869859,0.848693205788,0.933471468306},{0.796063869859,0.848693205788,0.933471468306},{0.800600847294,0.850358321561,0.930007560392},{0.800600847294,0.850358321561,0.930007560392},{0.804964758824,0.851666160557,0.926165074431},{0.804964758824,0.851666160557,0.926165074431},{0.809328670353,0.852973999553,0.922322588471},{0.809328670353,0.852973999553,0.922322588471},{0.813692581882,0.854281838549,0.91848010251},{0.813692581882,0.854281838549,0.91848010251},{0.818056493412,0.855589677545,0.914637616549},{0.818056493412,0.855589677545,0.914637616549},{0.822420404941,0.856897516541,0.910795130588},{0.822420404941,0.856897516541,0.910795130588},{0.826784316471,0.858205355537,0.906952644627},{0.831148228,0.859513194533,0.903110158667},{0.831148228,0.859513194533,0.903110158667},{0.835344711353,0.860513997294,0.898970409941},{0.835344711353,0.860513997294,0.898970409941},{0.839351442773,0.861166825655,0.894493763416},{0.839351442773,0.861166825655,0.894493763416},{0.843358174192,0.861819654016,0.89001711689},{0.843358174192,0.861819654016,0.89001711689},{0.847364905612,0.862472482376,0.885540470365},{0.847364905612,0.862472482376,0.885540470365},{0.851371637031,0.863125310737,0.881063823839},{0.851371637031,0.863125310737,0.881063823839},{0.855378368451,0.863778139098,0.876587177314},{0.855378368451,0.863778139098,0.876587177314},{0.859385099871,0.864430967459,0.872110530788},{0.859385099871,0.864430967459,0.872110530788},{0.86339183129,0.86508379582,0.867633884263},{0.86339183129,0.86508379582,0.867633884263},{0.867427635086,0.864376599773,0.86260246202},{0.867427635086,0.864376599773,0.86260246202},{0.871492511259,0.862309379318,0.857016264059},{0.871492511259,0.862309379318,0.857016264059},{0.875557387431,0.860242158863,0.851430066098},{0.875557387431,0.860242158863,0.851430066098},{0.879622263604,0.858174938408,0.845843868137},{0.879622263604,0.858174938408,0.845843868137},{0.883687139776,0.856107717953,0.840257670176},{0.883687139776,0.856107717953,0.840257670176},{0.887752015949,0.854040497498,0.834671472216},{0.887752015949,0.854040497498,0.834671472216},{0.891816892122,0.851973277043,0.829085274255},{0.891816892122,0.851973277043,0.829085274255},{0.895881768294,0.849906056588,0.823499076294},{0.895881768294,0.849906056588,0.823499076294},{0.8995432066,0.847500236,0.8177890744},{0.8995432066,0.847500236,0.8177890744},{0.902848670318,0.844795650588,0.811969833741},{0.906154134035,0.842091065176,0.806150593082},{0.906154134035,0.842091065176,0.806150593082},{0.909459597753,0.839386479765,0.800331352424},{0.909459597753,0.839386479765,0.800331352424},{0.912765061471,0.836681894353,0.794512111765},{0.912765061471,0.836681894353,0.794512111765},{0.916070525188,0.833977308941,0.788692871106},{0.916070525188,0.833977308941,0.788692871106},{0.919375988906,0.831272723529,0.782873630447},{0.919375988906,0.831272723529,0.782873630447},{0.922681452624,0.828568138118,0.777054389788},{0.922681452624,0.828568138118,0.777054389788},{0.925563423,0.825517298071,0.771136307812},{0.925563423,0.825517298071,0.771136307812},{0.928116009667,0.822197148863,0.765141349255},{0.928116009667,0.822197148863,0.765141349255},{0.930668596333,0.818876999655,0.759146390698},{0.930668596333,0.818876999655,0.759146390698},{0.933221183,0.815556850447,0.753151432141},{0.933221183,0.815556850447,0.753151432141},{0.935773769667,0.812236701239,0.747156473584},{0.935773769667,0.812236701239,0.747156473584},{0.938326356333,0.808916552031,0.741161515027},{0.938326356333,0.808916552031,0.741161515027},{0.940878943,0.805596402824,0.735166556471},{0.940878943,0.805596402824,0.735166556471},{0.943431529667,0.802276253616,0.729171597914},{0.943431529667,0.802276253616,0.729171597914},{0.94554029891,0.798605740533,0.723105417298},{0.94554029891,0.798605740533,0.723105417298},{0.9473454036,0.7946955048,0.7169905058},{0.9473454036,0.7946955048,0.7169905058},{0.94915050829,0.790785269067,0.710875594302},{0.94915050829,0.790785269067,0.710875594302},{0.95095561298,0.786875033333,0.704760682804},{0.95095561298,0.786875033333,0.704760682804},{0.952760717671,0.7829647976,0.698645771306},{0.952760717671,0.7829647976,0.698645771306},{0.954565822361,0.779054561867,0.692530859808},{0.956370927051,0.775144326133,0.68641594831},{0.956370927051,0.775144326133,0.68641594831},{0.958176031741,0.7712340904,0.680301036812},{0.958176031741,0.7712340904,0.680301036812},{0.959517658471,0.76697285451,0.674144715039},{0.959517658471,0.76697285451,0.674144715039},{0.960581198424,0.762501018525,0.667963547102},{0.960581198424,0.762501018525,0.667963547102},{0.961644738376,0.758029182541,0.661782379165},{0.961644738376,0.758029182541,0.661782379165},{0.962708278329,0.753557346557,0.655601211227},{0.962708278329,0.753557346557,0.655601211227},{0.963771818282,0.749085510573,0.64942004329},{0.963771818282,0.749085510573,0.64942004329},{0.964835358235,0.744613674588,0.643238875353},{0.964835358235,0.744613674588,0.643238875353},{0.965898898188,0.740141838604,0.637057707416},{0.965898898188,0.740141838604,0.637057707416},{0.966962438141,0.73567000262,0.630876539478},{0.966962438141,0.73567000262,0.630876539478},{0.967544297635,0.730849716188,0.624685478235},{0.967544297635,0.730849716188,0.624685478235},{0.967873848318,0.725846908094,0.618489234784},{0.967873848318,0.725846908094,0.618489234784},{0.968203399,0.7208441,0.612292991333},{0.968203399,0.7208441,0.612292991333},{0.968532949682,0.715841291906,0.606096747882},{0.968532949682,0.715841291906,0.606096747882},{0.968862500365,0.710838483812,0.599900504431},{0.968862500365,0.710838483812,0.599900504431},{0.969192051047,0.705835675718,0.59370426098},{0.969192051047,0.705835675718,0.59370426098},{0.969521601729,0.700832867624,0.587508017529},{0.969521601729,0.700832867624,0.587508017529},{0.969851152412,0.695830059529,0.581311774078},{0.969851152412,0.695830059529,0.581311774078},{0.969682979667,0.690483930737,0.575138361365},{0.969682979667,0.690483930737,0.575138361365},{0.969288569,0.684981747082,0.568975326259},{0.968894158333,0.679479563427,0.562812291153},{0.968894158333,0.679479563427,0.562812291153},{0.968499747667,0.673977379773,0.556649256047},{0.968499747667,0.673977379773,0.556649256047},{0.968105337,0.668475196118,0.550486220941},{0.968105337,0.668475196118,0.550486220941},{0.967710926333,0.662973012463,0.544323185835},{0.967710926333,0.662973012463,0.544323185835},{0.967316515667,0.657470828808,0.538160150729},{0.967316515667,0.657470828808,0.538160150729},{0.966922105,0.651968645153,0.531997115624},{0.966922105,0.651968645153,0.531997115624},{0.966016719839,0.646129741588,0.525890348259},{0.966016719839,0.646129741588,0.525890348259},{0.964911388137,0.640159078059,0.519805598706},{0.964911388137,0.640159078059,0.519805598706},{0.963806056435,0.634188414529,0.513720849153},{0.963806056435,0.634188414529,0.513720849153},{0.962700724733,0.628217751,0.5076360996},{0.962700724733,0.628217751,0.5076360996},{0.961595393031,0.622247087471,0.501551350047},{0.961595393031,0.622247087471,0.501551350047},{0.960490061329,0.616276423941,0.495466600494},{0.960490061329,0.616276423941,0.495466600494},{0.959384729627,0.610305760412,0.489381850941},{0.959384729627,0.610305760412,0.489381850941},{0.958279397925,0.604335096882,0.483297101388},{0.958279397925,0.604335096882,0.483297101388},{0.956653210976,0.598033822718,0.477302292353},{0.956653210976,0.598033822718,0.477302292353},{0.954853405612,0.591622345008,0.47133746349},{0.954853405612,0.591622345008,0.47133746349},{0.953053600247,0.585210867298,0.465372634627},{0.953053600247,0.585210867298,0.465372634627},{0.951253794882,0.578799389588,0.459407805765},{0.951253794882,0.578799389588,0.459407805765},{0.949453989518,0.572387911878,0.453442976902},{0.947654184153,0.565976434169,0.447478148039},{0.947654184153,0.565976434169,0.447478148039},{0.945854378788,0.559564956459,0.441513319176},{0.945854378788,0.559564956459,0.441513319176},{0.944054573424,0.553153478749,0.435548490314},{0.944054573424,0.553153478749,0.435548490314},{0.941727929824,0.54641347702,0.429707070373},{0.941727929824,0.54641347702,0.429707070373},{0.939253771518,0.539581488565,0.423900204929},{0.939253771518,0.539581488565,0.423900204929},{0.936779613212,0.53274950011,0.418093339486},{0.936779613212,0.53274950011,0.418093339486},{0.934305454906,0.525917511655,0.412286474043},{0.934305454906,0.525917511655,0.412286474043},{0.9318312966,0.5190855232,0.4064796086},{0.9318312966,0.5190855232,0.4064796086},{0.929357138294,0.512253534745,0.400672743157},{0.929357138294,0.512253534745,0.400672743157},{0.926882979988,0.50542154629,0.394865877714},{0.926882979988,0.50542154629,0.394865877714},{0.924408821682,0.498589557835,0.389059012271},{0.924408821682,0.498589557835,0.389059012271},{0.921406221227,0.491420417184,0.383408435376},{0.921406221227,0.491420417184,0.383408435376},{0.918281672584,0.48417347218,0.377793925071},{0.918281672584,0.48417347218,0.377793925071},{0.915157123941,0.476926527176,0.372179414765},{0.915157123941,0.476926527176,0.372179414765},{0.912032575298,0.469679582173,0.366564904459},{0.912032575298,0.469679582173,0.366564904459},{0.908908026655,0.462432637169,0.360950394153},{0.908908026655,0.462432637169,0.360950394153},{0.905783478012,0.455185692165,0.355335883847},{0.905783478012,0.455185692165,0.355335883847},{0.902658929369,0.447938747161,0.349721373541},{0.902658929369,0.447938747161,0.349721373541},{0.899534380725,0.440691802157,0.344106863235},{0.899534380725,0.440691802157,0.344106863235},{0.895884594835,0.433074556706,0.338680634518},{0.892137542788,0.425388737098,0.333289272761},{0.892137542788,0.425388737098,0.333289272761},{0.888390490741,0.41770291749,0.327897911004},{0.888390490741,0.41770291749,0.327897911004},{0.884643438694,0.410017097882,0.322506549247},{0.884643438694,0.410017097882,0.322506549247},{0.880896386647,0.402331278275,0.31711518749},{0.880896386647,0.402331278275,0.31711518749},{0.8771493346,0.394645458667,0.311723825733},{0.8771493346,0.394645458667,0.311723825733},{0.873402282553,0.386959639059,0.306332463976},{0.873402282553,0.386959639059,0.306332463976},{0.869655230506,0.379273819451,0.30094110222},{0.869655230506,0.379273819451,0.30094110222},{0.865391332937,0.371127672047,0.295768956416},{0.865391332937,0.371127672047,0.295768956416},{0.861053600294,0.362915763529,0.290628127176},{0.861053600294,0.362915763529,0.290628127176},{0.856715867651,0.354703855012,0.285487297937},{0.856715867651,0.354703855012,0.285487297937},{0.852378135008,0.346491946494,0.280346468698},{0.852378135008,0.346491946494,0.280346468698},{0.848040402365,0.338280037976,0.275205639459},{0.848040402365,0.338280037976,0.275205639459},{0.843702669722,0.330068129459,0.27006481022},{0.843702669722,0.330068129459,0.27006481022},{0.839364937078,0.321856220941,0.26492398098},{0.839364937078,0.321856220941,0.26492398098},{0.835027204435,0.313644312424,0.259783151741},{0.835027204435,0.313644312424,0.259783151741},{0.830186521949,0.304732763553,0.254891428067},{0.830186521949,0.304732763553,0.254891428067},{0.825293810169,0.295748838094,0.250025473933},{0.825293810169,0.295748838094,0.250025473933},{0.820401098388,0.286764912635,0.2451595198},{0.820401098388,0.286764912635,0.2451595198},{0.815508386608,0.277780987176,0.240293565667},{0.815508386608,0.277780987176,0.240293565667},{0.810615674827,0.268797061718,0.235427611533},{0.805722963047,0.259813136259,0.2305616574},{0.805722963047,0.259813136259,0.2305616574},{0.800830251267,0.2508292108,0.225695703267},{0.800830251267,0.2508292108,0.225695703267},{0.795937539486,0.241845285341,0.220829749133},{0.795937539486,0.241845285341,0.220829749133},{0.790561531941,0.231396999059,0.216242038294},{0.790561531941,0.231396999059,0.216242038294},{0.785153304678,0.220851088722,0.211672877008},{0.785153304678,0.220851088722,0.211672877008},{0.779745077416,0.210305178384,0.207103715722},{0.779745077416,0.210305178384,0.207103715722},{0.774336850153,0.199759268047,0.202534554435},{0.774336850153,0.199759268047,0.202534554435},{0.76892862289,0.18921335771,0.197965393149},{0.76892862289,0.18921335771,0.197965393149},{0.763520395627,0.178667447373,0.193396231863},{0.763520395627,0.178667447373,0.193396231863},{0.758112168365,0.168121537035,0.188827070576},{0.758112168365,0.168121537035,0.188827070576},{0.752703941102,0.157575626698,0.18425790929},{0.752703941102,0.157575626698,0.18425790929},{0.746838012212,0.140021019482,0.179996096957},{0.746838012212,0.140021019482,0.179996096957},{0.740957318753,0.122240325271,0.175744199106},{0.740957318753,0.122240325271,0.175744199106},{0.735076625294,0.104459631059,0.171492301255},{0.735076625294,0.104459631059,0.171492301255},{0.729195931835,0.0866789368471,0.167240403404},{0.729195931835,0.0866789368471,0.167240403404},{0.723315238376,0.0688982426353,0.162988505553},{0.723315238376,0.0688982426353,0.162988505553},{0.717434544918,0.0511175484235,0.158736607702},{0.717434544918,0.0511175484235,0.158736607702},{0.711553851459,0.0333368542118,0.154484709851},{0.711553851459,0.0333368542118,0.154484709851},{0.705673158,0.01555616,0.150232812},{0.705673158,0.01555616,0.150232812},};

const std::vector<glm::vec3> CM_BLUES =
{{0.96862745285,0.984313726425,1.0},{0.96862745285,0.984313726425,1.0},{0.965551712934,0.982345252879,0.999015763227},{0.965551712934,0.982345252879,0.999015763227},{0.962475973017,0.980376779332,0.998031526453},{0.962475973017,0.980376779332,0.998031526453},{0.9594002331,0.978408305785,0.99704728968},{0.9594002331,0.978408305785,0.99704728968},{0.956324493184,0.976439832239,0.996063052907},{0.956324493184,0.976439832239,0.996063052907},{0.953248753267,0.974471358692,0.995078816133},{0.953248753267,0.974471358692,0.995078816133},{0.950173013351,0.972502885145,0.99409457936},{0.950173013351,0.972502885145,0.99409457936},{0.947097273434,0.970534411599,0.993110342587},{0.947097273434,0.970534411599,0.993110342587},{0.944021533517,0.968565938052,0.992126105813},{0.944021533517,0.968565938052,0.992126105813},{0.940945793601,0.966597464505,0.99114186904},{0.940945793601,0.966597464505,0.99114186904},{0.937870053684,0.964628990959,0.990157632267},{0.937870053684,0.964628990959,0.990157632267},{0.934794313767,0.962660517412,0.989173395493},{0.934794313767,0.962660517412,0.989173395493},{0.931718573851,0.960692043865,0.98818915872},{0.931718573851,0.960692043865,0.98818915872},{0.928642833934,0.958723570319,0.987204921947},{0.928642833934,0.958723570319,0.987204921947},{0.925567094017,0.956755096772,0.986220685173},{0.925567094017,0.956755096772,0.986220685173},{0.922491354101,0.954786623225,0.9852364484},{0.922491354101,0.954786623225,0.9852364484},{0.919415614184,0.952818149679,0.984252211627},{0.919415614184,0.952818149679,0.984252211627},{0.916339874268,0.950849676132,0.983267974854},{0.916339874268,0.950849676132,0.983267974854},{0.913264134351,0.948881202586,0.98228373808},{0.913264134351,0.948881202586,0.98228373808},{0.910188394434,0.946912729039,0.981299501307},{0.907112654518,0.944944255492,0.980315264534},{0.907112654518,0.944944255492,0.980315264534},{0.904036914601,0.942975781946,0.97933102776},{0.904036914601,0.942975781946,0.97933102776},{0.900961174684,0.941007308399,0.978346790987},{0.900961174684,0.941007308399,0.978346790987},{0.897885434768,0.939038834852,0.977362554214},{0.897885434768,0.939038834852,0.977362554214},{0.894809694851,0.937070361306,0.97637831744},{0.894809694851,0.937070361306,0.97637831744},{0.891733954935,0.935101887759,0.975394080667},{0.891733954935,0.935101887759,0.975394080667},{0.888658215018,0.933133414212,0.974409843894},{0.888658215018,0.933133414212,0.974409843894},{0.885582475101,0.931164940666,0.97342560712},{0.885582475101,0.931164940666,0.97342560712},{0.882506735185,0.929196467119,0.972441370347},{0.882506735185,0.929196467119,0.972441370347},{0.879430995268,0.927227993572,0.971457133574},{0.879430995268,0.927227993572,0.971457133574},{0.876355255351,0.925259520026,0.9704728968},{0.876355255351,0.925259520026,0.9704728968},{0.873279515435,0.923291046479,0.969488660027},{0.873279515435,0.923291046479,0.969488660027},{0.870219154218,0.921322572933,0.968504423254},{0.870219154218,0.921322572933,0.968504423254},{0.867266443898,0.919354099386,0.96752018648},{0.867266443898,0.919354099386,0.96752018648},{0.864313733578,0.917385625839,0.966535949707},{0.864313733578,0.917385625839,0.966535949707},{0.861361023258,0.915417152293,0.965551712934},{0.861361023258,0.915417152293,0.965551712934},{0.858408312938,0.913448678746,0.96456747616},{0.858408312938,0.913448678746,0.96456747616},{0.855455602618,0.911480205199,0.963583239387},{0.855455602618,0.911480205199,0.963583239387},{0.852502892298,0.909511731653,0.962599002614},{0.852502892298,0.909511731653,0.962599002614},{0.849550181978,0.907543258106,0.96161476584},{0.846597471658,0.905574784559,0.960630529067},{0.846597471658,0.905574784559,0.960630529067},{0.843644761338,0.903606311013,0.959646292294},{0.843644761338,0.903606311013,0.959646292294},{0.840692051018,0.901637837466,0.95866205552},{0.840692051018,0.901637837466,0.95866205552},{0.837739340698,0.899669363919,0.957677818747},{0.837739340698,0.899669363919,0.957677818747},{0.834786630378,0.897700890373,0.956693581974},{0.834786630378,0.897700890373,0.956693581974},{0.831833920058,0.895732416826,0.9557093452},{0.831833920058,0.895732416826,0.9557093452},{0.828881209738,0.893763943279,0.954725108427},{0.828881209738,0.893763943279,0.954725108427},{0.825928499418,0.891795469733,0.953740871654},{0.825928499418,0.891795469733,0.953740871654},{0.822975789098,0.889826996186,0.952756634881},{0.822975789098,0.889826996186,0.952756634881},{0.820023078778,0.88785852264,0.951772398107},{0.820023078778,0.88785852264,0.951772398107},{0.817070368458,0.885890049093,0.950788161334},{0.817070368458,0.885890049093,0.950788161334},{0.814117658138,0.883921575546,0.949803924561},{0.814117658138,0.883921575546,0.949803924561},{0.811164947818,0.881953102,0.948819687787},{0.811164947818,0.881953102,0.948819687787},{0.808212237498,0.879984628453,0.947835451014},{0.808212237498,0.879984628453,0.947835451014},{0.805259527178,0.878016154906,0.946851214241},{0.805259527178,0.878016154906,0.946851214241},{0.802306816858,0.87604768136,0.945866977467},{0.802306816858,0.87604768136,0.945866977467},{0.799354106538,0.874079207813,0.944882740694},{0.799354106538,0.874079207813,0.944882740694},{0.796401396218,0.872110734266,0.943898503921},{0.796401396218,0.872110734266,0.943898503921},{0.793448685899,0.87014226072,0.942914267147},{0.793448685899,0.87014226072,0.942914267147},{0.790495975579,0.868173787173,0.941930030374},{0.787543265259,0.866205313626,0.940945793601},{0.787543265259,0.866205313626,0.940945793601},{0.784590554939,0.86423684008,0.939961556827},{0.784590554939,0.86423684008,0.939961556827},{0.781637844619,0.862268366533,0.938977320054},{0.781637844619,0.862268366533,0.938977320054},{0.778685134299,0.860299892987,0.937993083281},{0.778685134299,0.860299892987,0.937993083281},{0.775240305592,0.858300662041,0.936824302112},{0.775240305592,0.858300662041,0.936824302112},{0.770319121725,0.856209158897,0.935101887759},{0.770319121725,0.856209158897,0.935101887759},{0.765397937859,0.854117655754,0.933379473406},{0.765397937859,0.854117655754,0.933379473406},{0.760476753992,0.852026152611,0.931657059052},{0.760476753992,0.852026152611,0.931657059052},{0.755555570126,0.849934649467,0.929934644699},{0.755555570126,0.849934649467,0.929934644699},{0.750634386259,0.847843146324,0.928212230346},{0.750634386259,0.847843146324,0.928212230346},{0.745713202392,0.845751643181,0.926489815992},{0.745713202392,0.845751643181,0.926489815992},{0.740792018526,0.843660140038,0.924767401639},{0.740792018526,0.843660140038,0.924767401639},{0.735870834659,0.841568636894,0.923044987286},{0.735870834659,0.841568636894,0.923044987286},{0.730949650793,0.839477133751,0.921322572933},{0.730949650793,0.839477133751,0.921322572933},{0.726028466926,0.837385630608,0.919600158579},{0.726028466926,0.837385630608,0.919600158579},{0.721107283059,0.835294127464,0.917877744226},{0.721107283059,0.835294127464,0.917877744226},{0.716186099193,0.833202624321,0.916155329873},{0.716186099193,0.833202624321,0.916155329873},{0.711264915326,0.831111121178,0.914432915519},{0.711264915326,0.831111121178,0.914432915519},{0.706343731459,0.829019618034,0.912710501166},{0.701422547593,0.826928114891,0.910988086813},{0.701422547593,0.826928114891,0.910988086813},{0.696501363726,0.824836611748,0.909265672459},{0.696501363726,0.824836611748,0.909265672459},{0.69158017986,0.822745108604,0.907543258106},{0.69158017986,0.822745108604,0.907543258106},{0.686658995993,0.820653605461,0.905820843753},{0.686658995993,0.820653605461,0.905820843753},{0.681737812126,0.818562102318,0.904098429399},{0.681737812126,0.818562102318,0.904098429399},{0.67681662826,0.816470599174,0.902376015046},{0.67681662826,0.816470599174,0.902376015046},{0.671895444393,0.814379096031,0.900653600693},{0.671895444393,0.814379096031,0.900653600693},{0.666974260527,0.812287592888,0.898931186339},{0.666974260527,0.812287592888,0.898931186339},{0.66205307666,0.810196089745,0.897208771986},{0.66205307666,0.810196089745,0.897208771986},{0.657131892793,0.808104586601,0.895486357633},{0.657131892793,0.808104586601,0.895486357633},{0.652210708927,0.806013083458,0.893763943279},{0.652210708927,0.806013083458,0.893763943279},{0.64728952506,0.803921580315,0.892041528926},{0.64728952506,0.803921580315,0.892041528926},{0.642368341193,0.801830077171,0.890319114573},{0.642368341193,0.801830077171,0.890319114573},{0.637447157327,0.799738574028,0.88859670022},{0.637447157327,0.799738574028,0.88859670022},{0.63252597346,0.797647070885,0.886874285866},{0.63252597346,0.797647070885,0.886874285866},{0.627604789594,0.795555567741,0.885151871513},{0.627604789594,0.795555567741,0.885151871513},{0.622683605727,0.793464064598,0.88342945716},{0.622683605727,0.793464064598,0.88342945716},{0.617254924424,0.790865064369,0.881845451103},{0.617254924424,0.790865064369,0.881845451103},{0.610980414059,0.787420235662,0.880492125539},{0.610980414059,0.787420235662,0.880492125539},{0.604705903694,0.783975406955,0.879138799976},{0.598431393329,0.780530578249,0.877785474413},{0.598431393329,0.780530578249,0.877785474413},{0.592156882964,0.777085749542,0.876432148849},{0.592156882964,0.777085749542,0.876432148849},{0.585882372599,0.773640920835,0.875078823286},{0.585882372599,0.773640920835,0.875078823286},{0.579607862234,0.770196092129,0.873725497723},{0.579607862234,0.770196092129,0.873725497723},{0.573333351869,0.766751263422,0.872372172159},{0.573333351869,0.766751263422,0.872372172159},{0.567058841504,0.763306434715,0.871018846596},{0.567058841504,0.763306434715,0.871018846596},{0.560784331139,0.759861606009,0.869665521033},{0.560784331139,0.759861606009,0.869665521033},{0.554509820774,0.756416777302,0.868312195469},{0.554509820774,0.756416777302,0.868312195469},{0.54823531041,0.752971948596,0.866958869906},{0.54823531041,0.752971948596,0.866958869906},{0.541960800045,0.749527119889,0.865605544343},{0.541960800045,0.749527119889,0.865605544343},{0.53568628968,0.746082291182,0.864252218779},{0.53568628968,0.746082291182,0.864252218779},{0.529411779315,0.742637462476,0.862898893216},{0.529411779315,0.742637462476,0.862898893216},{0.52313726895,0.739192633769,0.861545567653},{0.52313726895,0.739192633769,0.861545567653},{0.516862758585,0.735747805062,0.860192242089},{0.516862758585,0.735747805062,0.860192242089},{0.51058824822,0.732302976356,0.858838916526},{0.51058824822,0.732302976356,0.858838916526},{0.504313737855,0.728858147649,0.857485590963},{0.504313737855,0.728858147649,0.857485590963},{0.49803922749,0.725413318943,0.856132265399},{0.49803922749,0.725413318943,0.856132265399},{0.491764717125,0.721968490236,0.854778939836},{0.491764717125,0.721968490236,0.854778939836},{0.485490206761,0.718523661529,0.853425614273},{0.485490206761,0.718523661529,0.853425614273},{0.479215696396,0.715078832823,0.85207228871},{0.472941186031,0.711634004116,0.850718963146},{0.472941186031,0.711634004116,0.850718963146},{0.466666675666,0.708189175409,0.849365637583},{0.466666675666,0.708189175409,0.849365637583},{0.460392165301,0.704744346703,0.84801231202},{0.460392165301,0.704744346703,0.84801231202},{0.454117654936,0.701299517996,0.846658986456},{0.454117654936,0.701299517996,0.846658986456},{0.447843144571,0.69785468929,0.845305660893},{0.447843144571,0.69785468929,0.845305660893},{0.441568634206,0.694409860583,0.84395233533},{0.441568634206,0.694409860583,0.84395233533},{0.435294123841,0.690965031876,0.842599009766},{0.435294123841,0.690965031876,0.842599009766},{0.429019613476,0.68752020317,0.841245684203},{0.429019613476,0.68752020317,0.841245684203},{0.422745103111,0.684075374463,0.83989235864},{0.422745103111,0.684075374463,0.83989235864},{0.417085741197,0.680630545756,0.838231459085},{0.417085741197,0.680630545756,0.838231459085},{0.412041527734,0.67718571705,0.836262985538},{0.412041527734,0.67718571705,0.836262985538},{0.406997314271,0.673740888343,0.834294511991},{0.406997314271,0.673740888343,0.834294511991},{0.401953100808,0.670296059637,0.832326038445},{0.401953100808,0.670296059637,0.832326038445},{0.396908887344,0.66685123093,0.830357564898},{0.396908887344,0.66685123093,0.830357564898},{0.391864673881,0.663406402223,0.828389091351},{0.391864673881,0.663406402223,0.828389091351},{0.386820460418,0.659961573517,0.826420617805},{0.386820460418,0.659961573517,0.826420617805},{0.381776246954,0.65651674481,0.824452144258},{0.381776246954,0.65651674481,0.824452144258},{0.376732033491,0.653071916103,0.822483670712},{0.376732033491,0.653071916103,0.822483670712},{0.371687820028,0.649627087397,0.820515197165},{0.366643606565,0.64618225869,0.818546723618},{0.366643606565,0.64618225869,0.818546723618},{0.361599393101,0.642737429983,0.816578250072},{0.361599393101,0.642737429983,0.816578250072},{0.356555179638,0.639292601277,0.814609776525},{0.356555179638,0.639292601277,0.814609776525},{0.351510966175,0.63584777257,0.812641302978},{0.351510966175,0.63584777257,0.812641302978},{0.346466752711,0.632402943864,0.810672829432},{0.346466752711,0.632402943864,0.810672829432},{0.341422539248,0.628958115157,0.808704355885},{0.341422539248,0.628958115157,0.808704355885},{0.336378325785,0.62551328645,0.806735882338},{0.336378325785,0.62551328645,0.806735882338},{0.331334112322,0.622068457744,0.804767408792},{0.331334112322,0.622068457744,0.804767408792},{0.326289898858,0.618623629037,0.802798935245},{0.326289898858,0.618623629037,0.802798935245},{0.321245685395,0.61517880033,0.800830461698},{0.321245685395,0.61517880033,0.800830461698},{0.316201471932,0.611733971624,0.798861988152},{0.316201471932,0.611733971624,0.798861988152},{0.311157258469,0.608289142917,0.796893514605},{0.311157258469,0.608289142917,0.796893514605},{0.306113045005,0.604844314211,0.794925041058},{0.306113045005,0.604844314211,0.794925041058},{0.301068831542,0.601399485504,0.792956567512},{0.301068831542,0.601399485504,0.792956567512},{0.296024618079,0.597954656797,0.790988093965},{0.296024618079,0.597954656797,0.790988093965},{0.290980404615,0.594509828091,0.789019620419},{0.290980404615,0.594509828091,0.789019620419},{0.285936191152,0.591064999384,0.787051146872},{0.285936191152,0.591064999384,0.787051146872},{0.280891977689,0.587620170677,0.785082673325},{0.280891977689,0.587620170677,0.785082673325},{0.275847764226,0.584175341971,0.783114199779},{0.275847764226,0.584175341971,0.783114199779},{0.270803550762,0.580730513264,0.781145726232},{0.265759337299,0.577285684558,0.779177252685},{0.265759337299,0.577285684558,0.779177252685},{0.260715123836,0.573840855851,0.777208779139},{0.260715123836,0.573840855851,0.777208779139},{0.256286058064,0.57001155907,0.775163412094},{0.256286058064,0.57001155907,0.775163412094},{0.252226080906,0.565951581445,0.773071908951},{0.252226080906,0.565951581445,0.773071908951},{0.248166103749,0.56189160382,0.770980405807},{0.248166103749,0.56189160382,0.770980405807},{0.244106126591,0.557831626196,0.768888902664},{0.244106126591,0.557831626196,0.768888902664},{0.240046149434,0.553771648571,0.766797399521},{0.240046149434,0.553771648571,0.766797399521},{0.235986172276,0.549711670946,0.764705896378},{0.235986172276,0.549711670946,0.764705896378},{0.231926195119,0.545651693321,0.762614393234},{0.231926195119,0.545651693321,0.762614393234},{0.227866217961,0.541591715696,0.760522890091},{0.227866217961,0.541591715696,0.760522890091},{0.223806240804,0.537531738071,0.758431386948},{0.223806240804,0.537531738071,0.758431386948},{0.219746263647,0.533471760446,0.756339883804},{0.219746263647,0.533471760446,0.756339883804},{0.215686286489,0.529411782821,0.754248380661},{0.215686286489,0.529411782821,0.754248380661},{0.211626309332,0.525351805196,0.752156877518},{0.211626309332,0.525351805196,0.752156877518},{0.207566332174,0.521291827571,0.750065374374},{0.207566332174,0.521291827571,0.750065374374},{0.203506355017,0.517231849946,0.747973871231},{0.203506355017,0.517231849946,0.747973871231},{0.199446377859,0.513171872321,0.745882368088},{0.199446377859,0.513171872321,0.745882368088},{0.195386400702,0.509111894696,0.743790864944},{0.195386400702,0.509111894696,0.743790864944},{0.191326423545,0.505051917071,0.741699361801},{0.191326423545,0.505051917071,0.741699361801},{0.187266446387,0.500991939447,0.739607858658},{0.18320646923,0.496931961822,0.737516355515},{0.18320646923,0.496931961822,0.737516355515},{0.179146492072,0.492871984197,0.735424852371},{0.179146492072,0.492871984197,0.735424852371},{0.175086514915,0.488812006572,0.733333349228},{0.175086514915,0.488812006572,0.733333349228},{0.171026537757,0.484752028947,0.731241846085},{0.171026537757,0.484752028947,0.731241846085},{0.1669665606,0.480692051322,0.729150342941},{0.1669665606,0.480692051322,0.729150342941},{0.162906583442,0.476632073697,0.727058839798},{0.162906583442,0.476632073697,0.727058839798},{0.158846606285,0.472572096072,0.724967336655},{0.158846606285,0.472572096072,0.724967336655},{0.154786629128,0.468512118447,0.722875833511},{0.154786629128,0.468512118447,0.722875833511},{0.15072665197,0.464452140822,0.720784330368},{0.15072665197,0.464452140822,0.720784330368},{0.146666674813,0.460392163197,0.718692827225},{0.146666674813,0.460392163197,0.718692827225},{0.142606697655,0.456332185572,0.716601324081},{0.142606697655,0.456332185572,0.716601324081},{0.138546720498,0.452272207947,0.714509820938},{0.138546720498,0.452272207947,0.714509820938},{0.13448674334,0.448212230322,0.712418317795},{0.13448674334,0.448212230322,0.712418317795},{0.130426766183,0.444152252697,0.710326814651},{0.130426766183,0.444152252697,0.710326814651},{0.127104966693,0.440184547971,0.707497133928},{0.127104966693,0.440184547971,0.707497133928},{0.124029226426,0.436247600878,0.704421394012},{0.124029226426,0.436247600878,0.704421394012},{0.120953486159,0.432310653785,0.701345654095},{0.120953486159,0.432310653785,0.701345654095},{0.117877745891,0.428373706691,0.698269914178},{0.117877745891,0.428373706691,0.698269914178},{0.114802005624,0.424436759598,0.695194174262},{0.111726265357,0.420499812505,0.692118434345},{0.111726265357,0.420499812505,0.692118434345},{0.10865052509,0.416562865412,0.689042694428},{0.10865052509,0.416562865412,0.689042694428},{0.105574784822,0.412625918318,0.685966954512},{0.105574784822,0.412625918318,0.685966954512},{0.102499044555,0.408688971225,0.682891214595},{0.102499044555,0.408688971225,0.682891214595},{0.0994233042878,0.404752024132,0.679815474678},{0.0994233042878,0.404752024132,0.679815474678},{0.0963475640206,0.400815077038,0.676739734762},{0.0963475640206,0.400815077038,0.676739734762},{0.0932718237533,0.396878129945,0.673663994845},{0.0932718237533,0.396878129945,0.673663994845},{0.0901960834861,0.392941182852,0.670588254929},{0.0901960834861,0.392941182852,0.670588254929},{0.0871203432188,0.389004235759,0.667512515012},{0.0871203432188,0.389004235759,0.667512515012},{0.0840446029516,0.385067288665,0.664436775095},{0.0840446029516,0.385067288665,0.664436775095},{0.0809688626843,0.381130341572,0.661361035179},{0.0809688626843,0.381130341572,0.661361035179},{0.0778931224171,0.377193394479,0.658285295262},{0.0778931224171,0.377193394479,0.658285295262},{0.0748173821498,0.373256447385,0.655209555345},{0.0748173821498,0.373256447385,0.655209555345},{0.0717416418826,0.369319500292,0.652133815429},{0.0717416418826,0.369319500292,0.652133815429},{0.0686659016153,0.365382553199,0.649058075512},{0.0686659016153,0.365382553199,0.649058075512},{0.0655901613481,0.361445606105,0.645982335596},{0.0655901613481,0.361445606105,0.645982335596},{0.0625144210808,0.357508659012,0.642906595679},{0.0625144210808,0.357508659012,0.642906595679},{0.0594386808136,0.353571711919,0.639830855762},{0.0594386808136,0.353571711919,0.639830855762},{0.0563629405463,0.349634764826,0.636755115846},{0.0563629405463,0.349634764826,0.636755115846},{0.0532872002791,0.345697817732,0.633679375929},{0.0502114600118,0.341760870639,0.630603636012},{0.0502114600118,0.341760870639,0.630603636012},{0.0471357197446,0.337823923546,0.627527896096},{0.0471357197446,0.337823923546,0.627527896096},{0.0440599794773,0.333886976452,0.624452156179},{0.0440599794773,0.333886976452,0.624452156179},{0.0409842392101,0.329950029359,0.621376416262},{0.0409842392101,0.329950029359,0.621376416262},{0.0379084989429,0.326013082266,0.618300676346},{0.0379084989429,0.326013082266,0.618300676346},{0.0348327586756,0.322076135173,0.615224936429},{0.0348327586756,0.322076135173,0.615224936429},{0.0317570184084,0.318139188079,0.612149196513},{0.0317570184084,0.318139188079,0.612149196513},{0.0313725508749,0.31409458968,0.606489834248},{0.0313725508749,0.31409458968,0.606489834248},{0.0313725508749,0.310034612522,0.600461383076},{0.0313725508749,0.310034612522,0.600461383076},{0.0313725508749,0.305974635365,0.594432931905},{0.0313725508749,0.305974635365,0.594432931905},{0.0313725508749,0.301914658208,0.588404480733},{0.0313725508749,0.301914658208,0.588404480733},{0.0313725508749,0.29785468105,0.582376029562},{0.0313725508749,0.29785468105,0.582376029562},{0.0313725508749,0.293794703893,0.57634757839},{0.0313725508749,0.293794703893,0.57634757839},{0.0313725508749,0.289734726735,0.570319127218},{0.0313725508749,0.289734726735,0.570319127218},{0.0313725508749,0.285674749578,0.564290676047},{0.0313725508749,0.285674749578,0.564290676047},{0.0313725508749,0.28161477242,0.558262224875},{0.0313725508749,0.28161477242,0.558262224875},{0.0313725508749,0.277554795263,0.552233773704},{0.0313725508749,0.277554795263,0.552233773704},{0.0313725508749,0.273494818105,0.546205322532},{0.0313725508749,0.273494818105,0.546205322532},{0.0313725508749,0.269434840948,0.540176871361},{0.0313725508749,0.269434840948,0.540176871361},{0.0313725508749,0.265374863791,0.534148420189},{0.0313725508749,0.261314886633,0.528119969017},{0.0313725508749,0.261314886633,0.528119969017},{0.0313725508749,0.257254909476,0.522091517846},{0.0313725508749,0.257254909476,0.522091517846},{0.0313725508749,0.253194932318,0.516063066674},{0.0313725508749,0.253194932318,0.516063066674},{0.0313725508749,0.249134955161,0.510034615503},{0.0313725508749,0.249134955161,0.510034615503},{0.0313725508749,0.245074978003,0.504006164331},{0.0313725508749,0.245074978003,0.504006164331},{0.0313725508749,0.241015000846,0.497977713159},{0.0313725508749,0.241015000846,0.497977713159},{0.0313725508749,0.236955023688,0.491949261988},{0.0313725508749,0.236955023688,0.491949261988},{0.0313725508749,0.232895046531,0.485920810816},{0.0313725508749,0.232895046531,0.485920810816},{0.0313725508749,0.228835069374,0.479892359645},{0.0313725508749,0.228835069374,0.479892359645},{0.0313725508749,0.224775092216,0.473863908473},{0.0313725508749,0.224775092216,0.473863908473},{0.0313725508749,0.220715115059,0.467835457302},{0.0313725508749,0.220715115059,0.467835457302},{0.0313725508749,0.216655137901,0.46180700613},{0.0313725508749,0.216655137901,0.46180700613},{0.0313725508749,0.212595160744,0.455778554958},{0.0313725508749,0.212595160744,0.455778554958},{0.0313725508749,0.208535183586,0.449750103787},{0.0313725508749,0.208535183586,0.449750103787},{0.0313725508749,0.204475206429,0.443721652615},{0.0313725508749,0.204475206429,0.443721652615},{0.0313725508749,0.200415229271,0.437693201444},{0.0313725508749,0.200415229271,0.437693201444},{0.0313725508749,0.196355252114,0.431664750272},{0.0313725508749,0.196355252114,0.431664750272},{0.0313725508749,0.192295274957,0.425636299101},{0.0313725508749,0.192295274957,0.425636299101},{0.0313725508749,0.188235297799,0.419607847929},{0.0313725508749,0.188235297799,0.419607847929},};

const std::vector<glm::vec3> CM_PIYG = 
{{0.556862771511,0.00392156885937,0.321568638086},{0.556862771511,0.00392156885937,0.321568638086},{0.565321056282,0.00792003102491,0.328181478907},{0.565321056282,0.00792003102491,0.328181478907},{0.573779341053,0.0119184931905,0.334794319728},{0.573779341053,0.0119184931905,0.334794319728},{0.582237625823,0.015916955356,0.341407160549},{0.582237625823,0.015916955356,0.341407160549},{0.590695910594,0.0199154175215,0.348020001369},{0.590695910594,0.0199154175215,0.348020001369},{0.599154195365,0.0239138796871,0.35463284219},{0.599154195365,0.0239138796871,0.35463284219},{0.607612480136,0.0279123418526,0.361245683011},{0.607612480136,0.0279123418526,0.361245683011},{0.616070764906,0.0319108040182,0.367858523832},{0.616070764906,0.0319108040182,0.367858523832},{0.624529049677,0.0359092661837,0.374471364652},{0.624529049677,0.0359092661837,0.374471364652},{0.632987334448,0.0399077283492,0.381084205473},{0.632987334448,0.0399077283492,0.381084205473},{0.641445619218,0.0439061905148,0.387697046294},{0.641445619218,0.0439061905148,0.387697046294},{0.649903903989,0.0479046526803,0.394309887115},{0.649903903989,0.0479046526803,0.394309887115},{0.65836218876,0.0519031148459,0.400922727935},{0.65836218876,0.0519031148459,0.400922727935},{0.666820473531,0.0559015770114,0.407535568756},{0.666820473531,0.0559015770114,0.407535568756},{0.675278758301,0.0599000391769,0.414148409577},{0.675278758301,0.0599000391769,0.414148409577},{0.683737043072,0.0638985013425,0.420761250398},{0.683737043072,0.0638985013425,0.420761250398},{0.692195327843,0.067896963508,0.427374091218},{0.692195327843,0.067896963508,0.427374091218},{0.700653612614,0.0718954256736,0.433986932039},{0.700653612614,0.0718954256736,0.433986932039},{0.709111897384,0.0758938878391,0.44059977286},{0.709111897384,0.0758938878391,0.44059977286},{0.717570182155,0.0798923500047,0.447212613681},{0.726028466926,0.0838908121702,0.453825454502},{0.726028466926,0.0838908121702,0.453825454502},{0.734486751697,0.0878892743357,0.460438295322},{0.734486751697,0.0878892743357,0.460438295322},{0.742945036467,0.0918877365013,0.467051136143},{0.742945036467,0.0918877365013,0.467051136143},{0.751403321238,0.0958861986668,0.473663976964},{0.751403321238,0.0958861986668,0.473663976964},{0.759861606009,0.0998846608324,0.480276817785},{0.759861606009,0.0998846608324,0.480276817785},{0.76831989078,0.103883122998,0.486889658605},{0.76831989078,0.103883122998,0.486889658605},{0.774471370613,0.112956556327,0.493963860998},{0.774471370613,0.112956556327,0.493963860998},{0.778316045509,0.12710496082,0.501499424962},{0.778316045509,0.12710496082,0.501499424962},{0.782160720404,0.141253365313,0.509034988927},{0.782160720404,0.141253365313,0.509034988927},{0.7860053953,0.155401769806,0.516570552891},{0.7860053953,0.155401769806,0.516570552891},{0.789850070196,0.169550174299,0.524106116856},{0.789850070196,0.169550174299,0.524106116856},{0.793694745092,0.183698578792,0.53164168082},{0.793694745092,0.183698578792,0.53164168082},{0.797539419988,0.197846983286,0.539177244785},{0.797539419988,0.197846983286,0.539177244785},{0.801384094883,0.211995387779,0.546712808749},{0.801384094883,0.211995387779,0.546712808749},{0.805228769779,0.226143792272,0.554248372714},{0.805228769779,0.226143792272,0.554248372714},{0.809073444675,0.240292196765,0.561783936678},{0.809073444675,0.240292196765,0.561783936678},{0.812918119571,0.254440601258,0.569319500643},{0.812918119571,0.254440601258,0.569319500643},{0.816762794467,0.268589005751,0.576855064607},{0.816762794467,0.268589005751,0.576855064607},{0.820607469362,0.282737410244,0.584390628572},{0.820607469362,0.282737410244,0.584390628572},{0.824452144258,0.296885814737,0.591926192536},{0.828296819154,0.31103421923,0.599461756501},{0.828296819154,0.31103421923,0.599461756501},{0.83214149405,0.325182623723,0.606997320465},{0.83214149405,0.325182623723,0.606997320465},{0.835986168946,0.339331028216,0.614532884429},{0.835986168946,0.339331028216,0.614532884429},{0.839830843841,0.353479432709,0.622068448394},{0.839830843841,0.353479432709,0.622068448394},{0.843675518737,0.367627837202,0.629604012358},{0.843675518737,0.367627837202,0.629604012358},{0.847520193633,0.381776241695,0.637139576323},{0.847520193633,0.381776241695,0.637139576323},{0.851364868529,0.395924646188,0.644675140287},{0.851364868529,0.395924646188,0.644675140287},{0.855209543424,0.410073050681,0.652210704252},{0.855209543424,0.410073050681,0.652210704252},{0.85905421832,0.424221455174,0.659746268216},{0.85905421832,0.424221455174,0.659746268216},{0.862898893216,0.438369859667,0.667281832181},{0.862898893216,0.438369859667,0.667281832181},{0.866743568112,0.45251826416,0.674817396145},{0.866743568112,0.45251826416,0.674817396145},{0.870588243008,0.466666668653,0.68235296011},{0.870588243008,0.466666668653,0.68235296011},{0.873510195928,0.47635525056,0.689119587926},{0.873510195928,0.47635525056,0.689119587926},{0.876432148849,0.486043832466,0.695886215743},{0.876432148849,0.486043832466,0.695886215743},{0.87935410177,0.495732414372,0.702652843559},{0.87935410177,0.495732414372,0.702652843559},{0.882276054691,0.505420996278,0.709419471376},{0.882276054691,0.505420996278,0.709419471376},{0.885198007612,0.515109578184,0.716186099193},{0.885198007612,0.515109578184,0.716186099193},{0.888119960532,0.52479816009,0.722952727009},{0.888119960532,0.52479816009,0.722952727009},{0.891041913453,0.534486741996,0.729719354826},{0.891041913453,0.534486741996,0.729719354826},{0.893963866374,0.544175323902,0.736485982642},{0.896885819295,0.553863905809,0.743252610459},{0.896885819295,0.553863905809,0.743252610459},{0.899807772216,0.563552487715,0.750019238276},{0.899807772216,0.563552487715,0.750019238276},{0.902729725136,0.573241069621,0.756785866092},{0.902729725136,0.573241069621,0.756785866092},{0.905651678057,0.582929651527,0.763552493909},{0.905651678057,0.582929651527,0.763552493909},{0.908573630978,0.592618233433,0.770319121725},{0.908573630978,0.592618233433,0.770319121725},{0.911495583899,0.602306815339,0.777085749542},{0.911495583899,0.602306815339,0.777085749542},{0.91441753682,0.611995397245,0.783852377359},{0.91441753682,0.611995397245,0.783852377359},{0.91733948974,0.621683979151,0.790619005175},{0.91733948974,0.621683979151,0.790619005175},{0.920261442661,0.631372561057,0.797385632992},{0.920261442661,0.631372561057,0.797385632992},{0.923183395582,0.641061142964,0.804152260808},{0.923183395582,0.641061142964,0.804152260808},{0.926105348503,0.65074972487,0.810918888625},{0.926105348503,0.65074972487,0.810918888625},{0.929027301424,0.660438306776,0.817685516442},{0.929027301424,0.660438306776,0.817685516442},{0.931949254344,0.670126888682,0.824452144258},{0.931949254344,0.670126888682,0.824452144258},{0.934871207265,0.679815470588,0.831218772075},{0.934871207265,0.679815470588,0.831218772075},{0.937793160186,0.689504052494,0.837985399891},{0.937793160186,0.689504052494,0.837985399891},{0.940715113107,0.6991926344,0.844752027708},{0.940715113107,0.6991926344,0.844752027708},{0.943637066028,0.708881216306,0.851518655525},{0.943637066028,0.708881216306,0.851518655525},{0.946020764463,0.716955034172,0.856516732889},{0.946020764463,0.716955034172,0.856516732889},{0.947866208413,0.723414087997,0.859746259802},{0.949711652363,0.729873141822,0.862975786714},{0.949711652363,0.729873141822,0.862975786714},{0.951557096313,0.736332195647,0.866205313626},{0.951557096313,0.736332195647,0.866205313626},{0.953402540263,0.742791249472,0.869434840539},{0.953402540263,0.742791249472,0.869434840539},{0.955247984213,0.749250303296,0.872664367451},{0.955247984213,0.749250303296,0.872664367451},{0.957093428163,0.755709357121,0.875893894364},{0.957093428163,0.755709357121,0.875893894364},{0.958938872113,0.762168410946,0.879123421276},{0.958938872113,0.762168410946,0.879123421276},{0.960784316063,0.768627464771,0.882352948189},{0.960784316063,0.768627464771,0.882352948189},{0.962629760013,0.775086518596,0.885582475101},{0.962629760013,0.775086518596,0.885582475101},{0.964475203963,0.781545572421,0.888812002014},{0.964475203963,0.781545572421,0.888812002014},{0.966320647913,0.788004626246,0.892041528926},{0.966320647913,0.788004626246,0.892041528926},{0.968166091863,0.794463680071,0.895271055839},{0.968166091863,0.794463680071,0.895271055839},{0.970011535813,0.800922733896,0.898500582751},{0.970011535813,0.800922733896,0.898500582751},{0.971856979763,0.807381787721,0.901730109664},{0.971856979763,0.807381787721,0.901730109664},{0.973702423713,0.813840841546,0.904959636576},{0.973702423713,0.813840841546,0.904959636576},{0.975547867663,0.820299895371,0.908189163489},{0.975547867663,0.820299895371,0.908189163489},{0.977393311613,0.826758949196,0.911418690401},{0.977393311613,0.826758949196,0.911418690401},{0.979238755563,0.833218003021,0.914648217313},{0.979238755563,0.833218003021,0.914648217313},{0.981084199513,0.839677056845,0.917877744226},{0.981084199513,0.839677056845,0.917877744226},{0.982929643463,0.84613611067,0.921107271138},{0.982929643463,0.84613611067,0.921107271138},{0.984775087413,0.852595164495,0.924336798051},{0.986620531363,0.85905421832,0.927566324963},{0.986620531363,0.85905421832,0.927566324963},{0.988465975313,0.865513272145,0.930795851876},{0.988465975313,0.865513272145,0.930795851876},{0.990311419263,0.87197232597,0.934025378788},{0.990311419263,0.87197232597,0.934025378788},{0.992156863213,0.878431379795,0.937254905701},{0.992156863213,0.878431379795,0.937254905701},{0.991234141238,0.881968480699,0.938485201667},{0.991234141238,0.881968480699,0.938485201667},{0.990311419263,0.885505581603,0.939715497634},{0.990311419263,0.885505581603,0.939715497634},{0.989388697288,0.889042682507,0.940945793601},{0.989388697288,0.889042682507,0.940945793601},{0.988465975313,0.892579783412,0.942176089567},{0.988465975313,0.892579783412,0.942176089567},{0.987543253338,0.896116884316,0.943406385534},{0.987543253338,0.896116884316,0.943406385534},{0.986620531363,0.89965398522,0.944636681501},{0.986620531363,0.89965398522,0.944636681501},{0.985697809388,0.903191086124,0.945866977467},{0.985697809388,0.903191086124,0.945866977467},{0.984775087413,0.906728187028,0.947097273434},{0.984775087413,0.906728187028,0.947097273434},{0.983852365438,0.910265287932,0.948327569401},{0.983852365438,0.910265287932,0.948327569401},{0.982929643463,0.913802388836,0.949557865367},{0.982929643463,0.913802388836,0.949557865367},{0.982006921488,0.91733948974,0.950788161334},{0.982006921488,0.91733948974,0.950788161334},{0.981084199513,0.920876590645,0.952018457301},{0.981084199513,0.920876590645,0.952018457301},{0.980161477538,0.924413691549,0.953248753267},{0.980161477538,0.924413691549,0.953248753267},{0.979238755563,0.927950792453,0.954479049234},{0.979238755563,0.927950792453,0.954479049234},{0.978316033588,0.931487893357,0.9557093452},{0.978316033588,0.931487893357,0.9557093452},{0.977393311613,0.935024994261,0.956939641167},{0.976470589638,0.938562095165,0.958169937134},{0.976470589638,0.938562095165,0.958169937134},{0.975547867663,0.942099196069,0.9594002331},{0.975547867663,0.942099196069,0.9594002331},{0.974625145688,0.945636296974,0.960630529067},{0.974625145688,0.945636296974,0.960630529067},{0.973702423713,0.949173397878,0.961860825034},{0.973702423713,0.949173397878,0.961860825034},{0.972779701738,0.952710498782,0.963091121},{0.972779701738,0.952710498782,0.963091121},{0.971856979763,0.956247599686,0.964321416967},{0.971856979763,0.956247599686,0.964321416967},{0.970934257788,0.95978470059,0.965551712934},{0.970934257788,0.95978470059,0.965551712934},{0.970011535813,0.963321801494,0.9667820089},{0.970011535813,0.963321801494,0.9667820089},{0.969088813838,0.966858902398,0.968012304867},{0.969088813838,0.966858902398,0.968012304867},{0.967320263386,0.968473665855,0.965628606432},{0.967320263386,0.968473665855,0.965628606432},{0.964705884457,0.968166091863,0.959630913594},{0.964705884457,0.968166091863,0.959630913594},{0.962091505527,0.967858517871,0.953633220757},{0.962091505527,0.967858517871,0.953633220757},{0.959477126598,0.96755094388,0.947635527919},{0.959477126598,0.96755094388,0.947635527919},{0.956862747669,0.967243369888,0.941637835082},{0.956862747669,0.967243369888,0.941637835082},{0.95424836874,0.966935795896,0.935640142244},{0.95424836874,0.966935795896,0.935640142244},{0.951633989811,0.966628221905,0.929642449407},{0.951633989811,0.966628221905,0.929642449407},{0.949019610882,0.966320647913,0.92364475657},{0.949019610882,0.966320647913,0.92364475657},{0.946405231953,0.966013073921,0.917647063732},{0.946405231953,0.966013073921,0.917647063732},{0.943790853024,0.96570549993,0.911649370895},{0.941176474094,0.965397925938,0.905651678057},{0.941176474094,0.965397925938,0.905651678057},{0.938562095165,0.965090351946,0.89965398522},{0.938562095165,0.965090351946,0.89965398522},{0.935947716236,0.964782777955,0.893656292382},{0.935947716236,0.964782777955,0.893656292382},{0.933333337307,0.964475203963,0.887658599545},{0.933333337307,0.964475203963,0.887658599545},{0.930718958378,0.964167629971,0.881660906708},{0.930718958378,0.964167629971,0.881660906708},{0.928104579449,0.96386005598,0.87566321387},{0.928104579449,0.96386005598,0.87566321387},{0.92549020052,0.963552481988,0.869665521033},{0.92549020052,0.963552481988,0.869665521033},{0.92287582159,0.963244907996,0.863667828195},{0.92287582159,0.963244907996,0.863667828195},{0.920261442661,0.962937334005,0.857670135358},{0.920261442661,0.962937334005,0.857670135358},{0.917647063732,0.962629760013,0.85167244252},{0.917647063732,0.962629760013,0.85167244252},{0.915032684803,0.962322186021,0.845674749683},{0.915032684803,0.962322186021,0.845674749683},{0.912418305874,0.96201461203,0.839677056845},{0.912418305874,0.96201461203,0.839677056845},{0.909803926945,0.961707038038,0.833679364008},{0.909803926945,0.961707038038,0.833679364008},{0.907189548016,0.961399464046,0.827681671171},{0.907189548016,0.961399464046,0.827681671171},{0.904575169086,0.961091890055,0.821683978333},{0.904575169086,0.961091890055,0.821683978333},{0.901960790157,0.960784316063,0.815686285496},{0.901960790157,0.960784316063,0.815686285496},{0.894886588349,0.957708576146,0.804306047804},{0.894886588349,0.957708576146,0.804306047804},{0.887812386541,0.95463283623,0.792925810113},{0.887812386541,0.95463283623,0.792925810113},{0.880738184733,0.951557096313,0.781545572421},{0.880738184733,0.951557096313,0.781545572421},{0.873663982924,0.948481356396,0.77016533473},{0.866589781116,0.94540561648,0.758785097038},{0.866589781116,0.94540561648,0.758785097038},{0.859515579308,0.942329876563,0.747404859347},{0.859515579308,0.942329876563,0.747404859347},{0.8524413775,0.939254136646,0.736024621655},{0.8524413775,0.939254136646,0.736024621655},{0.845367175691,0.93617839673,0.724644383963},{0.845367175691,0.93617839673,0.724644383963},{0.838292973883,0.933102656813,0.713264146272},{0.838292973883,0.933102656813,0.713264146272},{0.831218772075,0.930026916897,0.70188390858},{0.831218772075,0.930026916897,0.70188390858},{0.824144570266,0.92695117698,0.690503670889},{0.824144570266,0.92695117698,0.690503670889},{0.817070368458,0.923875437063,0.679123433197},{0.817070368458,0.923875437063,0.679123433197},{0.80999616665,0.920799697147,0.667743195506},{0.80999616665,0.920799697147,0.667743195506},{0.802921964842,0.91772395723,0.656362957814},{0.802921964842,0.91772395723,0.656362957814},{0.795847763033,0.914648217313,0.644982720123},{0.795847763033,0.914648217313,0.644982720123},{0.788773561225,0.911572477397,0.633602482431},{0.788773561225,0.911572477397,0.633602482431},{0.781699359417,0.90849673748,0.62222224474},{0.781699359417,0.90849673748,0.62222224474},{0.774625157609,0.905420997564,0.610842007048},{0.774625157609,0.905420997564,0.610842007048},{0.7675509558,0.902345257647,0.599461769356},{0.7675509558,0.902345257647,0.599461769356},{0.760476753992,0.89926951773,0.588081531665},{0.760476753992,0.89926951773,0.588081531665},{0.753402552184,0.896193777814,0.576701293973},{0.753402552184,0.896193777814,0.576701293973},{0.746328350376,0.893118037897,0.565321056282},{0.746328350376,0.893118037897,0.565321056282},{0.739254148567,0.89004229798,0.55394081859},{0.739254148567,0.89004229798,0.55394081859},{0.732179946759,0.886966558064,0.542560580899},{0.725105744951,0.883890818147,0.531180343207},{0.725105744951,0.883890818147,0.531180343207},{0.717185714081,0.879507888766,0.520184572421},{0.717185714081,0.879507888766,0.520184572421},{0.70841985415,0.87381776992,0.50957326854},{0.70841985415,0.87381776992,0.50957326854},{0.699653994219,0.868127651074,0.498961964659},{0.699653994219,0.868127651074,0.498961964659},{0.690888134288,0.862437532229,0.488350660778},{0.690888134288,0.862437532229,0.488350660778},{0.682122274357,0.856747413383,0.477739356896},{0.682122274357,0.856747413383,0.477739356896},{0.673356414426,0.851057294537,0.467128053015},{0.673356414426,0.851057294537,0.467128053015},{0.664590554494,0.845367175691,0.456516749134},{0.664590554494,0.845367175691,0.456516749134},{0.655824694563,0.839677056845,0.445905445253},{0.655824694563,0.839677056845,0.445905445253},{0.647058834632,0.833986938,0.435294141372},{0.647058834632,0.833986938,0.435294141372},{0.638292974701,0.828296819154,0.424682837491},{0.638292974701,0.828296819154,0.424682837491},{0.62952711477,0.822606700308,0.41407153361},{0.62952711477,0.822606700308,0.41407153361},{0.620761254839,0.816916581462,0.403460229729},{0.620761254839,0.816916581462,0.403460229729},{0.611995394908,0.811226462617,0.392848925848},{0.611995394908,0.811226462617,0.392848925848},{0.603229534977,0.805536343771,0.382237621967},{0.603229534977,0.805536343771,0.382237621967},{0.594463675045,0.799846224925,0.371626318085},{0.594463675045,0.799846224925,0.371626318085},{0.585697815114,0.794156106079,0.361015014204},{0.585697815114,0.794156106079,0.361015014204},{0.576931955183,0.788465987234,0.350403710323},{0.576931955183,0.788465987234,0.350403710323},{0.568166095252,0.782775868388,0.339792406442},{0.559400235321,0.777085749542,0.329181102561},{0.559400235321,0.777085749542,0.329181102561},{0.55063437539,0.771395630696,0.31856979868},{0.55063437539,0.771395630696,0.31856979868},{0.541868515459,0.76570551185,0.307958494799},{0.541868515459,0.76570551185,0.307958494799},{0.533102655528,0.760015393005,0.297347190918},{0.533102655528,0.760015393005,0.297347190918},{0.524336795597,0.754325274159,0.286735887037},{0.524336795597,0.754325274159,0.286735887037},{0.515570935665,0.748635155313,0.276124583156},{0.515570935665,0.748635155313,0.276124583156},{0.506805075734,0.742945036467,0.265513279274},{0.506805075734,0.742945036467,0.265513279274},{0.498039215803,0.737254917622,0.254901975393},{0.498039215803,0.737254917622,0.254901975393},{0.490349866012,0.730795863797,0.249980790942},{0.490349866012,0.730795863797,0.249980790942},{0.48266051622,0.724336809972,0.245059606491},{0.48266051622,0.724336809972,0.245059606491},{0.474971166428,0.717877756147,0.24013842204},{0.474971166428,0.717877756147,0.24013842204},{0.467281816637,0.711418702322,0.235217237589},{0.467281816637,0.711418702322,0.235217237589},{0.459592466845,0.704959648497,0.230296053138},{0.459592466845,0.704959648497,0.230296053138},{0.451903117054,0.698500594672,0.225374868687},{0.451903117054,0.698500594672,0.225374868687},{0.444213767262,0.692041540847,0.220453684236},{0.444213767262,0.692041540847,0.220453684236},{0.43652441747,0.685582487022,0.215532499786},{0.43652441747,0.685582487022,0.215532499786},{0.428835067679,0.679123433197,0.210611315335},{0.428835067679,0.679123433197,0.210611315335},{0.421145717887,0.672664379372,0.205690130884},{0.421145717887,0.672664379372,0.205690130884},{0.413456368096,0.666205325547,0.200768946433},{0.413456368096,0.666205325547,0.200768946433},{0.405767018304,0.659746271722,0.195847761982},{0.398077668513,0.653287217898,0.190926577531},{0.398077668513,0.653287217898,0.190926577531},{0.390388318721,0.646828164073,0.18600539308},{0.390388318721,0.646828164073,0.18600539308},{0.382698968929,0.640369110248,0.181084208629},{0.382698968929,0.640369110248,0.181084208629},{0.375009619138,0.633910056423,0.176163024178},{0.375009619138,0.633910056423,0.176163024178},{0.367320269346,0.627451002598,0.171241839727},{0.367320269346,0.627451002598,0.171241839727},{0.359630919555,0.620991948773,0.166320655276},{0.359630919555,0.620991948773,0.166320655276},{0.351941569763,0.614532894948,0.161399470825},{0.351941569763,0.614532894948,0.161399470825},{0.344252219971,0.608073841123,0.156478286374},{0.344252219971,0.608073841123,0.156478286374},{0.33656287018,0.601614787298,0.151557101923},{0.33656287018,0.601614787298,0.151557101923},{0.328873520388,0.595155733473,0.146635917472},{0.328873520388,0.595155733473,0.146635917472},{0.321184170597,0.588696679648,0.141714733021},{0.321184170597,0.588696679648,0.141714733021},{0.313494820805,0.582237625823,0.13679354857},{0.313494820805,0.582237625823,0.13679354857},{0.305805471014,0.575778571998,0.131872364119},{0.305805471014,0.575778571998,0.131872364119},{0.299038842905,0.569011943597,0.128796623764},{0.299038842905,0.569011943597,0.128796623764},{0.293194936479,0.56193774062,0.127566327505},{0.293194936479,0.56193774062,0.127566327505},{0.287351030053,0.554863537643,0.126336031246},{0.287351030053,0.554863537643,0.126336031246},{0.281507123627,0.547789334666,0.125105734988},{0.281507123627,0.547789334666,0.125105734988},{0.275663217201,0.54071513169,0.123875438729},{0.275663217201,0.54071513169,0.123875438729},{0.269819310775,0.533640928713,0.12264514247},{0.269819310775,0.533640928713,0.12264514247},{0.263975404349,0.526566725736,0.121414846211},{0.258131497923,0.519492522759,0.120184549952},{0.258131497923,0.519492522759,0.120184549952},{0.252287591497,0.512418319782,0.118954253693},{0.252287591497,0.512418319782,0.118954253693},{0.246443685071,0.505344116805,0.117723957435},{0.246443685071,0.505344116805,0.117723957435},{0.240599778645,0.498269913828,0.116493661176},{0.240599778645,0.498269913828,0.116493661176},{0.234755872219,0.491195710851,0.115263364917},{0.234755872219,0.491195710851,0.115263364917},{0.228911965793,0.484121507874,0.114033068658},{0.228911965793,0.484121507874,0.114033068658},{0.223068059367,0.477047304897,0.112802772399},{0.223068059367,0.477047304897,0.112802772399},{0.217224152941,0.46997310192,0.11157247614},{0.217224152941,0.46997310192,0.11157247614},{0.211380246515,0.462898898943,0.110342179882},{0.211380246515,0.462898898943,0.110342179882},{0.205536340089,0.455824695966,0.109111883623},{0.205536340089,0.455824695966,0.109111883623},{0.199692433663,0.448750492989,0.107881587364},{0.199692433663,0.448750492989,0.107881587364},{0.193848527237,0.441676290012,0.106651291105},{0.193848527237,0.441676290012,0.106651291105},{0.188004620812,0.434602087035,0.105420994846},{0.188004620812,0.434602087035,0.105420994846},{0.182160714386,0.427527884058,0.104190698587},{0.182160714386,0.427527884058,0.104190698587},{0.17631680796,0.420453681081,0.102960402329},{0.17631680796,0.420453681081,0.102960402329},{0.170472901534,0.413379478104,0.10173010607},{0.170472901534,0.413379478104,0.10173010607},{0.164628995108,0.406305275127,0.100499809811},{0.164628995108,0.406305275127,0.100499809811},{0.158785088682,0.39923107215,0.0992695135521},{0.158785088682,0.39923107215,0.0992695135521},{0.152941182256,0.392156869173,0.0980392172933},{0.152941182256,0.392156869173,0.0980392172933},};

const std::vector<glm::vec3> CM_SPECTRAL =
{{0.61960786581,0.00392156885937,0.258823543787},{0.61960786581,0.00392156885937,0.258823543787},{0.628066150581,0.0133025761712,0.260822774733},{0.628066150581,0.0133025761712,0.260822774733},{0.636524435352,0.022683583483,0.262822005679},{0.636524435352,0.022683583483,0.262822005679},{0.644982720123,0.0320645907949,0.264821236624},{0.644982720123,0.0320645907949,0.264821236624},{0.653441004893,0.0414455981067,0.26682046757},{0.653441004893,0.0414455981067,0.26682046757},{0.661899289664,0.0508266054185,0.268819698516},{0.661899289664,0.0508266054185,0.268819698516},{0.670357574435,0.0602076127303,0.270818929462},{0.670357574435,0.0602076127303,0.270818929462},{0.678815859206,0.0695886200422,0.272818160408},{0.678815859206,0.0695886200422,0.272818160408},{0.687274143976,0.078969627354,0.274817391353},{0.687274143976,0.078969627354,0.274817391353},{0.695732428747,0.0883506346658,0.276816622299},{0.695732428747,0.0883506346658,0.276816622299},{0.704190713518,0.0977316419777,0.278815853245},{0.704190713518,0.0977316419777,0.278815853245},{0.712648998289,0.107112649289,0.280815084191},{0.712648998289,0.107112649289,0.280815084191},{0.721107283059,0.116493656601,0.282814315137},{0.721107283059,0.116493656601,0.282814315137},{0.72956556783,0.125874663913,0.284813546083},{0.72956556783,0.125874663913,0.284813546083},{0.738023852601,0.135255671225,0.286812777028},{0.738023852601,0.135255671225,0.286812777028},{0.746482137372,0.144636678537,0.288812007974},{0.746482137372,0.144636678537,0.288812007974},{0.754940422142,0.154017685849,0.29081123892},{0.754940422142,0.154017685849,0.29081123892},{0.763398706913,0.16339869316,0.292810469866},{0.763398706913,0.16339869316,0.292810469866},{0.771856991684,0.172779700472,0.294809700812},{0.771856991684,0.172779700472,0.294809700812},{0.780315276454,0.182160707784,0.296808931757},{0.788773561225,0.191541715096,0.298808162703},{0.788773561225,0.191541715096,0.298808162703},{0.797231845996,0.200922722408,0.300807393649},{0.797231845996,0.200922722408,0.300807393649},{0.805690130767,0.21030372972,0.302806624595},{0.805690130767,0.21030372972,0.302806624595},{0.814148415537,0.219684737031,0.304805855541},{0.814148415537,0.219684737031,0.304805855541},{0.822606700308,0.229065744343,0.306805086486},{0.822606700308,0.229065744343,0.306805086486},{0.831064985079,0.238446751655,0.308804317432},{0.831064985079,0.238446751655,0.308804317432},{0.8376778259,0.246751250005,0.30888121093},{0.8376778259,0.246751250005,0.30888121093},{0.84244522277,0.253979239394,0.30703576698},{0.84244522277,0.253979239394,0.30703576698},{0.847212619641,0.261207228782,0.30519032303},{0.847212619641,0.261207228782,0.30519032303},{0.851980016512,0.268435218171,0.30334487908},{0.851980016512,0.268435218171,0.30334487908},{0.856747413383,0.275663207559,0.30149943513},{0.856747413383,0.275663207559,0.30149943513},{0.861514810254,0.282891196947,0.29965399118},{0.861514810254,0.282891196947,0.29965399118},{0.866282207124,0.290119186336,0.29780854723},{0.866282207124,0.290119186336,0.29780854723},{0.871049603995,0.297347175724,0.29596310328},{0.871049603995,0.297347175724,0.29596310328},{0.875817000866,0.304575165113,0.29411765933},{0.875817000866,0.304575165113,0.29411765933},{0.880584397737,0.311803154501,0.29227221538},{0.880584397737,0.311803154501,0.29227221538},{0.885351794607,0.31903114389,0.29042677143},{0.885351794607,0.31903114389,0.29042677143},{0.890119191478,0.326259133278,0.28858132748},{0.890119191478,0.326259133278,0.28858132748},{0.894886588349,0.333487122667,0.28673588353},{0.894886588349,0.333487122667,0.28673588353},{0.89965398522,0.340715112055,0.28489043958},{0.904421382091,0.347943101443,0.28304499563},{0.904421382091,0.347943101443,0.28304499563},{0.909188778961,0.355171090832,0.281199551681},{0.909188778961,0.355171090832,0.281199551681},{0.913956175832,0.36239908022,0.279354107731},{0.913956175832,0.36239908022,0.279354107731},{0.918723572703,0.369627069609,0.277508663781},{0.918723572703,0.369627069609,0.277508663781},{0.923490969574,0.376855058997,0.275663219831},{0.923490969574,0.376855058997,0.275663219831},{0.928258366445,0.384083048386,0.273817775881},{0.928258366445,0.384083048386,0.273817775881},{0.933025763315,0.391311037774,0.271972331931},{0.933025763315,0.391311037774,0.271972331931},{0.937793160186,0.398539027163,0.270126887981},{0.937793160186,0.398539027163,0.270126887981},{0.942560557057,0.405767016551,0.268281444031},{0.942560557057,0.405767016551,0.268281444031},{0.947327953928,0.41299500594,0.266436000081},{0.947327953928,0.41299500594,0.266436000081},{0.952095350798,0.420222995328,0.264590556131},{0.952095350798,0.420222995328,0.264590556131},{0.956862747669,0.427450984716,0.262745112181},{0.956862747669,0.427450984716,0.262745112181},{0.958246830632,0.437447140614,0.267358722056},{0.958246830632,0.437447140614,0.267358722056},{0.959630913594,0.447443296512,0.271972331931},{0.959630913594,0.447443296512,0.271972331931},{0.961014996557,0.45743945241,0.276585941806},{0.961014996557,0.45743945241,0.276585941806},{0.962399079519,0.467435608308,0.281199551681},{0.962399079519,0.467435608308,0.281199551681},{0.963783162482,0.477431764205,0.285813161555},{0.963783162482,0.477431764205,0.285813161555},{0.965167245444,0.487427920103,0.29042677143},{0.965167245444,0.487427920103,0.29042677143},{0.966551328407,0.497424076001,0.295040381305},{0.966551328407,0.497424076001,0.295040381305},{0.967935411369,0.507420231899,0.29965399118},{0.969319494332,0.517416387796,0.304267601055},{0.969319494332,0.517416387796,0.304267601055},{0.970703577294,0.527412543694,0.30888121093},{0.970703577294,0.527412543694,0.30888121093},{0.972087660257,0.537408699592,0.313494820805},{0.972087660257,0.537408699592,0.313494820805},{0.973471743219,0.54740485549,0.31810843068},{0.973471743219,0.54740485549,0.31810843068},{0.974855826182,0.557401011388,0.322722040555},{0.974855826182,0.557401011388,0.322722040555},{0.976239909144,0.567397167285,0.32733565043},{0.976239909144,0.567397167285,0.32733565043},{0.977623992106,0.577393323183,0.331949260305},{0.977623992106,0.577393323183,0.331949260305},{0.979008075069,0.587389479081,0.33656287018},{0.979008075069,0.587389479081,0.33656287018},{0.980392158031,0.597385634979,0.341176480055},{0.980392158031,0.597385634979,0.341176480055},{0.981776240994,0.607381790876,0.34579008993},{0.981776240994,0.607381790876,0.34579008993},{0.983160323956,0.617377946774,0.350403699805},{0.983160323956,0.617377946774,0.350403699805},{0.984544406919,0.627374102672,0.35501730968},{0.984544406919,0.627374102672,0.35501730968},{0.985928489881,0.63737025857,0.359630919555},{0.985928489881,0.63737025857,0.359630919555},{0.987312572844,0.647366414467,0.36424452943},{0.987312572844,0.647366414467,0.36424452943},{0.988696655806,0.657362570365,0.368858139305},{0.988696655806,0.657362570365,0.368858139305},{0.990080738769,0.667358726263,0.37347174918},{0.990080738769,0.667358726263,0.37347174918},{0.991464821731,0.677354882161,0.378085359054},{0.991464821731,0.677354882161,0.378085359054},{0.992233756711,0.686197635006,0.383621691489},{0.992233756711,0.686197635006,0.383621691489},{0.992387543706,0.693886984797,0.390080746482},{0.992541330702,0.701576334589,0.396539801476},{0.992541330702,0.701576334589,0.396539801476},{0.992695117698,0.70926568438,0.40299885647},{0.992695117698,0.70926568438,0.40299885647},{0.992848904694,0.716955034172,0.409457911463},{0.992848904694,0.716955034172,0.409457911463},{0.99300269169,0.724644383963,0.415916966457},{0.99300269169,0.724644383963,0.415916966457},{0.993156478685,0.732333733755,0.422376021451},{0.993156478685,0.732333733755,0.422376021451},{0.993310265681,0.740023083547,0.428835076444},{0.993310265681,0.740023083547,0.428835076444},{0.993464052677,0.747712433338,0.435294131438},{0.993464052677,0.747712433338,0.435294131438},{0.993617839673,0.75540178313,0.441753186432},{0.993617839673,0.75540178313,0.441753186432},{0.993771626669,0.763091132921,0.448212241425},{0.993771626669,0.763091132921,0.448212241425},{0.993925413665,0.770780482713,0.454671296419},{0.993925413665,0.770780482713,0.454671296419},{0.99407920066,0.778469832504,0.461130351413},{0.99407920066,0.778469832504,0.461130351413},{0.994232987656,0.786159182296,0.467589406406},{0.994232987656,0.786159182296,0.467589406406},{0.994386774652,0.793848532088,0.4740484614},{0.994386774652,0.793848532088,0.4740484614},{0.994540561648,0.801537881879,0.480507516393},{0.994540561648,0.801537881879,0.480507516393},{0.994694348644,0.809227231671,0.486966571387},{0.994694348644,0.809227231671,0.486966571387},{0.99484813564,0.816916581462,0.493425626381},{0.99484813564,0.816916581462,0.493425626381},{0.995001922635,0.824605931254,0.499884681374},{0.995001922635,0.824605931254,0.499884681374},{0.995155709631,0.832295281046,0.506343736368},{0.995155709631,0.832295281046,0.506343736368},{0.995309496627,0.839984630837,0.512802791362},{0.995309496627,0.839984630837,0.512802791362},{0.995463283623,0.847673980629,0.519261846355},{0.995617070619,0.85536333042,0.525720901349},{0.995617070619,0.85536333042,0.525720901349},{0.995770857615,0.863052680212,0.532179956343},{0.995770857615,0.863052680212,0.532179956343},{0.99592464461,0.870742030003,0.538639011336},{0.99592464461,0.870742030003,0.538639011336},{0.996078431606,0.878431379795,0.54509806633},{0.996078431606,0.878431379795,0.54509806633},{0.996232218602,0.883198776666,0.553094990113},{0.996232218602,0.883198776666,0.553094990113},{0.996386005598,0.887966173537,0.561091913896},{0.996386005598,0.887966173537,0.561091913896},{0.996539792594,0.892733570407,0.56908883768},{0.996539792594,0.892733570407,0.56908883768},{0.99669357959,0.897500967278,0.577085761463},{0.99669357959,0.897500967278,0.577085761463},{0.996847366585,0.902268364149,0.585082685246},{0.996847366585,0.902268364149,0.585082685246},{0.997001153581,0.90703576102,0.593079609029},{0.997001153581,0.90703576102,0.593079609029},{0.997154940577,0.911803157891,0.601076532813},{0.997154940577,0.911803157891,0.601076532813},{0.997308727573,0.916570554761,0.609073456596},{0.997308727573,0.916570554761,0.609073456596},{0.997462514569,0.921337951632,0.617070380379},{0.997462514569,0.921337951632,0.617070380379},{0.997616301565,0.926105348503,0.625067304162},{0.997616301565,0.926105348503,0.625067304162},{0.99777008856,0.930872745374,0.633064227946},{0.99777008856,0.930872745374,0.633064227946},{0.997923875556,0.935640142244,0.641061151729},{0.997923875556,0.935640142244,0.641061151729},{0.998077662552,0.940407539115,0.649058075512},{0.998077662552,0.940407539115,0.649058075512},{0.998231449548,0.945174935986,0.657054999295},{0.998231449548,0.945174935986,0.657054999295},{0.998385236544,0.949942332857,0.665051923079},{0.998385236544,0.949942332857,0.665051923079},{0.99853902354,0.954709729728,0.673048846862},{0.998692810535,0.959477126598,0.681045770645},{0.998692810535,0.959477126598,0.681045770645},{0.998846597531,0.964244523469,0.689042694428},{0.998846597531,0.964244523469,0.689042694428},{0.999000384527,0.96901192034,0.697039618212},{0.999000384527,0.96901192034,0.697039618212},{0.999154171523,0.973779317211,0.705036541995},{0.999154171523,0.973779317211,0.705036541995},{0.999307958519,0.978546714081,0.713033465778},{0.999307958519,0.978546714081,0.713033465778},{0.999461745515,0.983314110952,0.721030389561},{0.999461745515,0.983314110952,0.721030389561},{0.99961553251,0.988081507823,0.729027313345},{0.99961553251,0.988081507823,0.729027313345},{0.999769319506,0.992848904694,0.737024237128},{0.999769319506,0.992848904694,0.737024237128},{0.999923106502,0.997616301565,0.745021160911},{0.999923106502,0.997616301565,0.745021160911},{0.998077662552,0.999231065021,0.746020776384},{0.998077662552,0.999231065021,0.746020776384},{0.994232987656,0.997693195063,0.740023083547},{0.994232987656,0.997693195063,0.740023083547},{0.990388312761,0.996155325104,0.734025390709},{0.990388312761,0.996155325104,0.734025390709},{0.986543637865,0.994617455146,0.728027697872},{0.986543637865,0.994617455146,0.728027697872},{0.982698962969,0.993079585188,0.722030005034},{0.982698962969,0.993079585188,0.722030005034},{0.978854288073,0.991541715229,0.716032312197},{0.978854288073,0.991541715229,0.716032312197},{0.975009613177,0.990003845271,0.710034619359},{0.975009613177,0.990003845271,0.710034619359},{0.971164938282,0.988465975313,0.704036926522},{0.971164938282,0.988465975313,0.704036926522},{0.967320263386,0.986928105354,0.698039233685},{0.967320263386,0.986928105354,0.698039233685},{0.96347558849,0.985390235396,0.692041540847},{0.959630913594,0.983852365438,0.68604384801},{0.959630913594,0.983852365438,0.68604384801},{0.955786238698,0.982314495479,0.680046155172},{0.955786238698,0.982314495479,0.680046155172},{0.951941563803,0.980776625521,0.674048462335},{0.951941563803,0.980776625521,0.674048462335},{0.948096888907,0.979238755563,0.668050769497},{0.948096888907,0.979238755563,0.668050769497},{0.944252214011,0.977700885604,0.66205307666},{0.944252214011,0.977700885604,0.66205307666},{0.940407539115,0.976163015646,0.656055383822},{0.940407539115,0.976163015646,0.656055383822},{0.936562864219,0.974625145688,0.650057690985},{0.936562864219,0.974625145688,0.650057690985},{0.932718189324,0.973087275729,0.644059998148},{0.932718189324,0.973087275729,0.644059998148},{0.928873514428,0.971549405771,0.63806230531},{0.928873514428,0.971549405771,0.63806230531},{0.925028839532,0.970011535813,0.632064612473},{0.925028839532,0.970011535813,0.632064612473},{0.921184164636,0.968473665855,0.626066919635},{0.921184164636,0.968473665855,0.626066919635},{0.91733948974,0.966935795896,0.620069226798},{0.91733948974,0.966935795896,0.620069226798},{0.913494814845,0.965397925938,0.61407153396},{0.913494814845,0.965397925938,0.61407153396},{0.909650139949,0.96386005598,0.608073841123},{0.909650139949,0.96386005598,0.608073841123},{0.905805465053,0.962322186021,0.602076148286},{0.905805465053,0.962322186021,0.602076148286},{0.901960790157,0.960784316063,0.596078455448},{0.901960790157,0.960784316063,0.596078455448},{0.892887357403,0.957093428163,0.597923899398},{0.892887357403,0.957093428163,0.597923899398},{0.883813924649,0.953402540263,0.599769343348},{0.883813924649,0.953402540263,0.599769343348},{0.874740491895,0.949711652363,0.601614787298},{0.874740491895,0.949711652363,0.601614787298},{0.865667059141,0.946020764463,0.603460231248},{0.856593626387,0.942329876563,0.605305675198},{0.856593626387,0.942329876563,0.605305675198},{0.847520193633,0.938638988663,0.607151119148},{0.847520193633,0.938638988663,0.607151119148},{0.838446760879,0.934948100763,0.608996563098},{0.838446760879,0.934948100763,0.608996563098},{0.829373328125,0.931257212863,0.610842007048},{0.829373328125,0.931257212863,0.610842007048},{0.820299895371,0.927566324963,0.612687450998},{0.820299895371,0.927566324963,0.612687450998},{0.811226462617,0.923875437063,0.614532894948},{0.811226462617,0.923875437063,0.614532894948},{0.802153029863,0.920184549163,0.616378338898},{0.802153029863,0.920184549163,0.616378338898},{0.793079597109,0.916493661263,0.618223782848},{0.793079597109,0.916493661263,0.618223782848},{0.784006164354,0.912802773363,0.620069226798},{0.784006164354,0.912802773363,0.620069226798},{0.7749327316,0.909111885463,0.621914670748},{0.7749327316,0.909111885463,0.621914670748},{0.765859298846,0.905420997564,0.623760114698},{0.765859298846,0.905420997564,0.623760114698},{0.756785866092,0.901730109664,0.625605558648},{0.756785866092,0.901730109664,0.625605558648},{0.747712433338,0.898039221764,0.627451002598},{0.747712433338,0.898039221764,0.627451002598},{0.738639000584,0.894348333864,0.629296446548},{0.738639000584,0.894348333864,0.629296446548},{0.72956556783,0.890657445964,0.631141890498},{0.72956556783,0.890657445964,0.631141890498},{0.720492135076,0.886966558064,0.632987334448},{0.720492135076,0.886966558064,0.632987334448},{0.711418702322,0.883275670164,0.634832778398},{0.711418702322,0.883275670164,0.634832778398},{0.702345269568,0.879584782264,0.636678222348},{0.702345269568,0.879584782264,0.636678222348},{0.693271836814,0.875893894364,0.638523666298},{0.693271836814,0.875893894364,0.638523666298},{0.68419840406,0.872203006464,0.640369110248},{0.675124971306,0.868512118564,0.642214554198},{0.675124971306,0.868512118564,0.642214554198},{0.665282602988,0.86459055017,0.643214169671},{0.665282602988,0.86459055017,0.643214169671},{0.654671299107,0.860438301283,0.643367956666},{0.654671299107,0.860438301283,0.643367956666},{0.644059995226,0.856286052395,0.643521743662},{0.644059995226,0.856286052395,0.643521743662},{0.633448691345,0.852133803508,0.643675530658},{0.633448691345,0.852133803508,0.643675530658},{0.622837387464,0.84798155462,0.643829317654},{0.622837387464,0.84798155462,0.643829317654},{0.612226083583,0.843829305733,0.64398310465},{0.612226083583,0.843829305733,0.64398310465},{0.601614779701,0.839677056845,0.644136891646},{0.601614779701,0.839677056845,0.644136891646},{0.59100347582,0.835524807958,0.644290678641},{0.59100347582,0.835524807958,0.644290678641},{0.580392171939,0.831372559071,0.644444465637},{0.580392171939,0.831372559071,0.644444465637},{0.569780868058,0.827220310183,0.644598252633},{0.569780868058,0.827220310183,0.644598252633},{0.559169564177,0.823068061296,0.644752039629},{0.559169564177,0.823068061296,0.644752039629},{0.548558260296,0.818915812408,0.644905826625},{0.548558260296,0.818915812408,0.644905826625},{0.537946956415,0.814763563521,0.645059613621},{0.537946956415,0.814763563521,0.645059613621},{0.527335652534,0.810611314633,0.645213400616},{0.527335652534,0.810611314633,0.645213400616},{0.516724348653,0.806459065746,0.645367187612},{0.516724348653,0.806459065746,0.645367187612},{0.506113044771,0.802306816858,0.645520974608},{0.506113044771,0.802306816858,0.645520974608},{0.49550174089,0.798154567971,0.645674761604},{0.49550174089,0.798154567971,0.645674761604},{0.484890437009,0.794002319083,0.6458285486},{0.474279133128,0.789850070196,0.645982335596},{0.474279133128,0.789850070196,0.645982335596},{0.463667829247,0.785697821309,0.646136122591},{0.463667829247,0.785697821309,0.646136122591},{0.453056525366,0.781545572421,0.646289909587},{0.453056525366,0.781545572421,0.646289909587},{0.442445221485,0.777393323534,0.646443696583},{0.442445221485,0.777393323534,0.646443696583},{0.431833917604,0.773241074646,0.646597483579},{0.431833917604,0.773241074646,0.646597483579},{0.421222613723,0.769088825759,0.646751270575},{0.421222613723,0.769088825759,0.646751270575},{0.410611309842,0.764936576871,0.646905057571},{0.410611309842,0.764936576871,0.646905057571},{0.40000000596,0.760784327984,0.647058844566},{0.40000000596,0.760784327984,0.647058844566},{0.392003081593,0.751864682226,0.650749732466},{0.392003081593,0.751864682226,0.650749732466},{0.384006157225,0.742945036467,0.654440620366},{0.384006157225,0.742945036467,0.654440620366},{0.376009232858,0.734025390709,0.658131508266},{0.376009232858,0.734025390709,0.658131508266},{0.36801230849,0.725105744951,0.661822396166},{0.36801230849,0.725105744951,0.661822396166},{0.360015384122,0.716186099193,0.665513284066},{0.360015384122,0.716186099193,0.665513284066},{0.352018459755,0.707266453434,0.669204171966},{0.352018459755,0.707266453434,0.669204171966},{0.344021535387,0.698346807676,0.672895059866},{0.344021535387,0.698346807676,0.672895059866},{0.33602461102,0.689427161918,0.676585947766},{0.33602461102,0.689427161918,0.676585947766},{0.328027686652,0.68050751616,0.680276835666},{0.328027686652,0.68050751616,0.680276835666},{0.320030762284,0.671587870401,0.683967723566},{0.320030762284,0.671587870401,0.683967723566},{0.312033837917,0.662668224643,0.687658611466},{0.312033837917,0.662668224643,0.687658611466},{0.304036913549,0.653748578885,0.691349499366},{0.296039989182,0.644828933127,0.695040387266},{0.296039989182,0.644828933127,0.695040387266},{0.288043064814,0.635909287369,0.698731275166},{0.288043064814,0.635909287369,0.698731275166},{0.280046140446,0.62698964161,0.702422163066},{0.280046140446,0.62698964161,0.702422163066},{0.272049216079,0.618069995852,0.706113050966},{0.272049216079,0.618069995852,0.706113050966},{0.264052291711,0.609150350094,0.709803938866},{0.264052291711,0.609150350094,0.709803938866},{0.256055367344,0.600230704336,0.713494826766},{0.256055367344,0.600230704336,0.713494826766},{0.248058442976,0.591311058577,0.717185714666},{0.248058442976,0.591311058577,0.717185714666},{0.240061518608,0.582391412819,0.720876602566},{0.240061518608,0.582391412819,0.720876602566},{0.232064594241,0.573471767061,0.724567490466},{0.232064594241,0.573471767061,0.724567490466},{0.224067669873,0.564552121303,0.728258378365},{0.224067669873,0.564552121303,0.728258378365},{0.216070745506,0.555632475544,0.731949266265},{0.216070745506,0.555632475544,0.731949266265},{0.208073821138,0.546712829786,0.735640154165},{0.208073821138,0.546712829786,0.735640154165},{0.20007689677,0.537793184028,0.739331042065},{0.20007689677,0.537793184028,0.739331042065},{0.199461748787,0.528950431183,0.739100361572},{0.199461748787,0.528950431183,0.739100361572},{0.206228377188,0.520184571252,0.734948112684},{0.206228377188,0.520184571252,0.734948112684},{0.212995005589,0.511418711321,0.730795863797},{0.212995005589,0.511418711321,0.730795863797},{0.21976163399,0.50265285139,0.726643614909},{0.21976163399,0.50265285139,0.726643614909},{0.226528262391,0.493886991459,0.722491366022},{0.226528262391,0.493886991459,0.722491366022},{0.233294890792,0.485121131528,0.718339117134},{0.233294890792,0.485121131528,0.718339117134},{0.240061519193,0.476355271597,0.714186868247},{0.246828147594,0.467589411665,0.710034619359},{0.246828147594,0.467589411665,0.710034619359},{0.253594775995,0.458823551734,0.705882370472},{0.253594775995,0.458823551734,0.705882370472},{0.260361404396,0.450057691803,0.701730121584},{0.260361404396,0.450057691803,0.701730121584},{0.267128032797,0.441291831872,0.697577872697},{0.267128032797,0.441291831872,0.697577872697},{0.273894661197,0.432525971941,0.69342562381},{0.273894661197,0.432525971941,0.69342562381},{0.280661289598,0.42376011201,0.689273374922},{0.280661289598,0.42376011201,0.689273374922},{0.287427917999,0.414994252079,0.685121126035},{0.287427917999,0.414994252079,0.685121126035},{0.2941945464,0.406228392148,0.680968877147},{0.2941945464,0.406228392148,0.680968877147},{0.300961174801,0.397462532216,0.67681662826},{0.300961174801,0.397462532216,0.67681662826},{0.307727803202,0.388696672285,0.672664379372},{0.307727803202,0.388696672285,0.672664379372},{0.314494431603,0.379930812354,0.668512130485},{0.314494431603,0.379930812354,0.668512130485},{0.321261060004,0.371164952423,0.664359881597},{0.321261060004,0.371164952423,0.664359881597},{0.328027688405,0.362399092492,0.66020763271},{0.328027688405,0.362399092492,0.66020763271},{0.334794316806,0.353633232561,0.656055383822},{0.334794316806,0.353633232561,0.656055383822},{0.341560945207,0.34486737263,0.651903134935},{0.341560945207,0.34486737263,0.651903134935},{0.348327573608,0.336101512699,0.647750886048},{0.348327573608,0.336101512699,0.647750886048},{0.355094202009,0.327335652767,0.64359863716},{0.355094202009,0.327335652767,0.64359863716},{0.36186083041,0.318569792836,0.639446388273},{0.36186083041,0.318569792836,0.639446388273},{0.368627458811,0.309803932905,0.635294139385},{0.368627458811,0.309803932905,0.635294139385},};

const std::vector<glm::vec3> CM_RAINBOW =
{{0.5,0.0,1.0},{0.5,0.0,1.0},{0.492156862745,0.0123196595352,0.999981027349},{0.492156862745,0.0123196595352,0.999981027349},{0.48431372549,0.0246374491954,0.999924110115},{0.48431372549,0.0246374491954,0.999924110115},{0.476470588235,0.0369514993891,0.999829250458},{0.476470588235,0.0369514993891,0.999829250458},{0.46862745098,0.0492599410928,0.999696451978},{0.46862745098,0.0492599410928,0.999696451978},{0.460784313725,0.0615609061339,0.999525719713},{0.460784313725,0.0615609061339,0.999525719713},{0.452941176471,0.0738525274749,0.999317060143},{0.452941176471,0.0738525274749,0.999317060143},{0.445098039216,0.0861329394961,0.999070481184},{0.445098039216,0.0861329394961,0.999070481184},{0.437254901961,0.0984002782796,0.998785992194},{0.437254901961,0.0984002782796,0.998785992194},{0.429411764706,0.110652681892,0.998463603967},{0.429411764706,0.110652681892,0.998463603967},{0.421568627451,0.122888290665,0.998103328737},{0.421568627451,0.122888290665,0.998103328737},{0.413725490196,0.135105247481,0.997705180174},{0.413725490196,0.135105247481,0.997705180174},{0.405882352941,0.147301698055,0.997269173386},{0.405882352941,0.147301698055,0.997269173386},{0.398039215686,0.15947579121,0.996795324917},{0.398039215686,0.15947579121,0.996795324917},{0.390196078431,0.171625679166,0.996283652748},{0.390196078431,0.171625679166,0.996283652748},{0.382352941176,0.183749517817,0.995734176295},{0.382352941176,0.183749517817,0.995734176295},{0.374509803922,0.195845467007,0.995146916407},{0.374509803922,0.195845467007,0.995146916407},{0.366666666667,0.207911690818,0.994521895368},{0.366666666667,0.207911690818,0.994521895368},{0.358823529412,0.21994635784,0.993859136895},{0.358823529412,0.21994635784,0.993859136895},{0.350980392157,0.231947641454,0.993158666137},{0.343137254902,0.243913720108,0.992420509672},{0.343137254902,0.243913720108,0.992420509672},{0.335294117647,0.255842777594,0.991644695511},{0.335294117647,0.255842777594,0.991644695511},{0.327450980392,0.267733003322,0.990831253092},{0.327450980392,0.267733003322,0.990831253092},{0.319607843137,0.279582592597,0.989980213281},{0.319607843137,0.279582592597,0.989980213281},{0.311764705882,0.291389746889,0.989091608371},{0.311764705882,0.291389746889,0.989091608371},{0.303921568627,0.303152674113,0.988165472081},{0.303921568627,0.303152674113,0.988165472081},{0.296078431373,0.314869588894,0.987201839554},{0.296078431373,0.314869588894,0.987201839554},{0.288235294118,0.32653871284,0.986200747353},{0.288235294118,0.32653871284,0.986200747353},{0.280392156863,0.338158274816,0.985162233468},{0.280392156863,0.338158274816,0.985162233468},{0.272549019608,0.349726511206,0.984086337303},{0.272549019608,0.349726511206,0.984086337303},{0.264705882353,0.361241666187,0.982973099684},{0.264705882353,0.361241666187,0.982973099684},{0.256862745098,0.372701991991,0.981822562854},{0.256862745098,0.372701991991,0.981822562854},{0.249019607843,0.384105749172,0.980634770469},{0.249019607843,0.384105749172,0.980634770469},{0.241176470588,0.395451206871,0.979409767601},{0.241176470588,0.395451206871,0.979409767601},{0.233333333333,0.406736643076,0.978147600734},{0.233333333333,0.406736643076,0.978147600734},{0.225490196078,0.417960344887,0.97684831776},{0.225490196078,0.417960344887,0.97684831776},{0.217647058824,0.429120608773,0.97551196798},{0.217647058824,0.429120608773,0.97551196798},{0.209803921569,0.440215740831,0.974138602105},{0.209803921569,0.440215740831,0.974138602105},{0.201960784314,0.451244057045,0.972728272245},{0.201960784314,0.451244057045,0.972728272245},{0.194117647059,0.46220388354,0.971281031916},{0.186274509804,0.473093556836,0.969796936035},{0.186274509804,0.473093556836,0.969796936035},{0.178431372549,0.4839114241,0.968276040916},{0.178431372549,0.4839114241,0.968276040916},{0.170588235294,0.4946558434,0.966718404269},{0.170588235294,0.4946558434,0.966718404269},{0.162745098039,0.505325183949,0.9651240852},{0.162745098039,0.505325183949,0.9651240852},{0.154901960784,0.515917826358,0.963493144206},{0.154901960784,0.515917826358,0.963493144206},{0.147058823529,0.526432162877,0.961825643173},{0.147058823529,0.526432162877,0.961825643173},{0.139215686275,0.536866597644,0.960121645375},{0.139215686275,0.536866597644,0.960121645375},{0.13137254902,0.547219546922,0.95838121547},{0.13137254902,0.547219546922,0.95838121547},{0.123529411765,0.557489439343,0.9566044195},{0.123529411765,0.557489439343,0.9566044195},{0.11568627451,0.567674716145,0.954791324887},{0.11568627451,0.567674716145,0.954791324887},{0.107843137255,0.577773831408,0.952942000427},{0.107843137255,0.577773831408,0.952942000427},{0.1,0.587785252292,0.951056516295},{0.1,0.587785252292,0.951056516295},{0.0921568627451,0.597707459266,0.949134944036},{0.0921568627451,0.597707459266,0.949134944036},{0.0843137254902,0.607538946339,0.947177356564},{0.0843137254902,0.607538946339,0.947177356564},{0.0764705882353,0.61727822129,0.945183828161},{0.0764705882353,0.61727822129,0.945183828161},{0.0686274509804,0.626923805894,0.943154434471},{0.0686274509804,0.626923805894,0.943154434471},{0.0607843137255,0.636474236147,0.941089252501},{0.0607843137255,0.636474236147,0.941089252501},{0.0529411764706,0.645928062487,0.938988360615},{0.0529411764706,0.645928062487,0.938988360615},{0.0450980392157,0.655283850013,0.936851838531},{0.0450980392157,0.655283850013,0.936851838531},{0.0372549019608,0.664540178708,0.934679767321},{0.0294117647059,0.673695643647,0.932472229404},{0.0294117647059,0.673695643647,0.932472229404},{0.021568627451,0.682748855215,0.930229308547},{0.021568627451,0.682748855215,0.930229308547},{0.0137254901961,0.691698439319,0.927951089857},{0.0137254901961,0.691698439319,0.927951089857},{0.00588235294118,0.700543037593,0.925637659782},{0.00588235294118,0.700543037593,0.925637659782},{0.00196078431373,0.709281307606,0.923289106105},{0.00196078431373,0.709281307606,0.923289106105},{0.00980392156863,0.717911923064,0.920905517945},{0.00980392156863,0.717911923064,0.920905517945},{0.0176470588235,0.726433574016,0.918486985746},{0.0176470588235,0.726433574016,0.918486985746},{0.0254901960784,0.734844967047,0.91603360128},{0.0254901960784,0.734844967047,0.91603360128},{0.0333333333333,0.743144825477,0.913545457643},{0.0333333333333,0.743144825477,0.913545457643},{0.0411764705882,0.751331889557,0.911022649246},{0.0411764705882,0.751331889557,0.911022649246},{0.0490196078431,0.759404916655,0.90846527182},{0.0490196078431,0.759404916655,0.90846527182},{0.056862745098,0.767362681449,0.905873422403},{0.056862745098,0.767362681449,0.905873422403},{0.0647058823529,0.775203976111,0.903247199346},{0.0647058823529,0.775203976111,0.903247199346},{0.0725490196078,0.782927610492,0.900586702301},{0.0725490196078,0.782927610492,0.900586702301},{0.0803921568627,0.7905324123,0.89789203222},{0.0803921568627,0.7905324123,0.89789203222},{0.0882352941176,0.79801722728,0.895163291355},{0.0882352941176,0.79801722728,0.895163291355},{0.0960784313725,0.805380919389,0.892400583248},{0.0960784313725,0.805380919389,0.892400583248},{0.103921568627,0.812622370966,0.889604012731},{0.103921568627,0.812622370966,0.889604012731},{0.111764705882,0.819740482907,0.88677368592},{0.119607843137,0.826734174826,0.883909710214},{0.119607843137,0.826734174826,0.883909710214},{0.127450980392,0.833602385221,0.881012194286},{0.127450980392,0.833602385221,0.881012194286},{0.135294117647,0.840344071638,0.878081248084},{0.135294117647,0.840344071638,0.878081248084},{0.143137254902,0.846958210824,0.875116982823},{0.143137254902,0.846958210824,0.875116982823},{0.150980392157,0.853443798888,0.872119510984},{0.150980392157,0.853443798888,0.872119510984},{0.158823529412,0.859799851448,0.869088946306},{0.158823529412,0.859799851448,0.869088946306},{0.166666666667,0.866025403784,0.866025403784},{0.166666666667,0.866025403784,0.866025403784},{0.174509803922,0.872119510984,0.862928999667},{0.174509803922,0.872119510984,0.862928999667},{0.182352941176,0.878081248084,0.859799851448},{0.182352941176,0.878081248084,0.859799851448},{0.190196078431,0.883909710214,0.856638077864},{0.190196078431,0.883909710214,0.856638077864},{0.198039215686,0.889604012731,0.853443798888},{0.198039215686,0.889604012731,0.853443798888},{0.205882352941,0.895163291355,0.85021713573},{0.205882352941,0.895163291355,0.85021713573},{0.213725490196,0.900586702301,0.846958210824},{0.213725490196,0.900586702301,0.846958210824},{0.221568627451,0.905873422403,0.843667147834},{0.221568627451,0.905873422403,0.843667147834},{0.229411764706,0.911022649246,0.840344071638},{0.229411764706,0.911022649246,0.840344071638},{0.237254901961,0.91603360128,0.836989108332},{0.237254901961,0.91603360128,0.836989108332},{0.245098039216,0.920905517945,0.833602385221},{0.245098039216,0.920905517945,0.833602385221},{0.252941176471,0.925637659782,0.830184030816},{0.252941176471,0.925637659782,0.830184030816},{0.260784313725,0.930229308547,0.826734174826},{0.260784313725,0.930229308547,0.826734174826},{0.26862745098,0.934679767321,0.823252948158},{0.276470588235,0.938988360615,0.819740482907},{0.276470588235,0.938988360615,0.819740482907},{0.28431372549,0.943154434471,0.816196912356},{0.28431372549,0.943154434471,0.816196912356},{0.292156862745,0.947177356564,0.812622370966},{0.292156862745,0.947177356564,0.812622370966},{0.3,0.951056516295,0.809016994375},{0.3,0.951056516295,0.809016994375},{0.307843137255,0.954791324887,0.805380919389},{0.307843137255,0.954791324887,0.805380919389},{0.31568627451,0.95838121547,0.80171428398},{0.31568627451,0.95838121547,0.80171428398},{0.323529411765,0.961825643173,0.79801722728},{0.323529411765,0.961825643173,0.79801722728},{0.33137254902,0.9651240852,0.794289889575},{0.33137254902,0.9651240852,0.794289889575},{0.339215686275,0.968276040916,0.7905324123},{0.339215686275,0.968276040916,0.7905324123},{0.347058823529,0.971281031916,0.786744938033},{0.347058823529,0.971281031916,0.786744938033},{0.354901960784,0.974138602105,0.782927610492},{0.354901960784,0.974138602105,0.782927610492},{0.362745098039,0.97684831776,0.779080574526},{0.362745098039,0.97684831776,0.779080574526},{0.370588235294,0.979409767601,0.775203976111},{0.370588235294,0.979409767601,0.775203976111},{0.378431372549,0.981822562854,0.771297962347},{0.378431372549,0.981822562854,0.771297962347},{0.386274509804,0.984086337303,0.767362681449},{0.386274509804,0.984086337303,0.767362681449},{0.394117647059,0.986200747353,0.763398282741},{0.394117647059,0.986200747353,0.763398282741},{0.401960784314,0.988165472081,0.759404916655},{0.401960784314,0.988165472081,0.759404916655},{0.409803921569,0.989980213281,0.755382734719},{0.409803921569,0.989980213281,0.755382734719},{0.417647058824,0.991644695511,0.751331889557},{0.417647058824,0.991644695511,0.751331889557},{0.425490196078,0.993158666137,0.747252534879},{0.433333333333,0.994521895368,0.743144825477},{0.433333333333,0.994521895368,0.743144825477},{0.441176470588,0.995734176295,0.739008917221},{0.441176470588,0.995734176295,0.739008917221},{0.449019607843,0.996795324917,0.734844967047},{0.449019607843,0.996795324917,0.734844967047},{0.456862745098,0.997705180174,0.730653132959},{0.456862745098,0.997705180174,0.730653132959},{0.464705882353,0.998463603967,0.726433574016},{0.464705882353,0.998463603967,0.726433574016},{0.472549019608,0.999070481184,0.722186450332},{0.472549019608,0.999070481184,0.722186450332},{0.480392156863,0.999525719713,0.717911923064},{0.480392156863,0.999525719713,0.717911923064},{0.488235294118,0.999829250458,0.713610154412},{0.488235294118,0.999829250458,0.713610154412},{0.496078431373,0.999981027349,0.709281307606},{0.496078431373,0.999981027349,0.709281307606},{0.503921568627,0.999981027349,0.704925546906},{0.503921568627,0.999981027349,0.704925546906},{0.511764705882,0.999829250458,0.700543037593},{0.511764705882,0.999829250458,0.700543037593},{0.519607843137,0.999525719713,0.696133945963},{0.519607843137,0.999525719713,0.696133945963},{0.527450980392,0.999070481184,0.691698439319},{0.527450980392,0.999070481184,0.691698439319},{0.535294117647,0.998463603967,0.687236685969},{0.535294117647,0.998463603967,0.687236685969},{0.543137254902,0.997705180174,0.682748855215},{0.543137254902,0.997705180174,0.682748855215},{0.550980392157,0.996795324917,0.678235117349},{0.550980392157,0.996795324917,0.678235117349},{0.558823529412,0.995734176295,0.673695643647},{0.558823529412,0.995734176295,0.673695643647},{0.566666666667,0.994521895368,0.669130606359},{0.566666666667,0.994521895368,0.669130606359},{0.574509803922,0.993158666137,0.664540178708},{0.582352941176,0.991644695511,0.659924534879},{0.582352941176,0.991644695511,0.659924534879},{0.590196078431,0.989980213281,0.655283850013},{0.590196078431,0.989980213281,0.655283850013},{0.598039215686,0.988165472081,0.650618300204},{0.598039215686,0.988165472081,0.650618300204},{0.605882352941,0.986200747353,0.645928062487},{0.605882352941,0.986200747353,0.645928062487},{0.613725490196,0.984086337303,0.641213314834},{0.613725490196,0.984086337303,0.641213314834},{0.621568627451,0.981822562854,0.636474236147},{0.621568627451,0.981822562854,0.636474236147},{0.629411764706,0.979409767601,0.631711006253},{0.629411764706,0.979409767601,0.631711006253},{0.637254901961,0.97684831776,0.626923805894},{0.637254901961,0.97684831776,0.626923805894},{0.645098039216,0.974138602105,0.622112816721},{0.645098039216,0.974138602105,0.622112816721},{0.652941176471,0.971281031916,0.61727822129},{0.652941176471,0.971281031916,0.61727822129},{0.660784313725,0.968276040916,0.612420203049},{0.660784313725,0.968276040916,0.612420203049},{0.66862745098,0.9651240852,0.607538946339},{0.66862745098,0.9651240852,0.607538946339},{0.676470588235,0.961825643173,0.602634636379},{0.676470588235,0.961825643173,0.602634636379},{0.68431372549,0.95838121547,0.597707459266},{0.68431372549,0.95838121547,0.597707459266},{0.692156862745,0.954791324887,0.592757601963},{0.692156862745,0.954791324887,0.592757601963},{0.7,0.951056516295,0.587785252292},{0.7,0.951056516295,0.587785252292},{0.707843137255,0.947177356564,0.582790598933},{0.707843137255,0.947177356564,0.582790598933},{0.71568627451,0.943154434471,0.577773831408},{0.71568627451,0.943154434471,0.577773831408},{0.723529411765,0.938988360615,0.572735140081},{0.723529411765,0.938988360615,0.572735140081},{0.73137254902,0.934679767321,0.567674716145},{0.739215686275,0.930229308547,0.56259275162},{0.739215686275,0.930229308547,0.56259275162},{0.747058823529,0.925637659782,0.557489439343},{0.747058823529,0.925637659782,0.557489439343},{0.754901960784,0.920905517945,0.552364972961},{0.754901960784,0.920905517945,0.552364972961},{0.762745098039,0.91603360128,0.547219546922},{0.762745098039,0.91603360128,0.547219546922},{0.770588235294,0.911022649246,0.542053356472},{0.770588235294,0.911022649246,0.542053356472},{0.778431372549,0.905873422403,0.536866597644},{0.778431372549,0.905873422403,0.536866597644},{0.786274509804,0.900586702301,0.53165946725},{0.786274509804,0.900586702301,0.53165946725},{0.794117647059,0.895163291355,0.526432162877},{0.794117647059,0.895163291355,0.526432162877},{0.801960784314,0.889604012731,0.521184882877},{0.801960784314,0.889604012731,0.521184882877},{0.809803921569,0.883909710214,0.515917826358},{0.809803921569,0.883909710214,0.515917826358},{0.817647058824,0.878081248084,0.510631193181},{0.817647058824,0.878081248084,0.510631193181},{0.825490196078,0.872119510984,0.505325183949},{0.825490196078,0.872119510984,0.505325183949},{0.833333333333,0.866025403784,0.5},{0.833333333333,0.866025403784,0.5},{0.841176470588,0.859799851448,0.4946558434},{0.841176470588,0.859799851448,0.4946558434},{0.849019607843,0.853443798888,0.489292916934},{0.849019607843,0.853443798888,0.489292916934},{0.856862745098,0.846958210824,0.4839114241},{0.856862745098,0.846958210824,0.4839114241},{0.864705882353,0.840344071638,0.478511569101},{0.864705882353,0.840344071638,0.478511569101},{0.872549019608,0.833602385221,0.473093556836},{0.872549019608,0.833602385221,0.473093556836},{0.880392156863,0.826734174826,0.467657592893},{0.880392156863,0.826734174826,0.467657592893},{0.888235294118,0.819740482907,0.46220388354},{0.896078431373,0.812622370966,0.456732635722},{0.896078431373,0.812622370966,0.456732635722},{0.903921568627,0.805380919389,0.451244057045},{0.903921568627,0.805380919389,0.451244057045},{0.911764705882,0.79801722728,0.445738355777},{0.911764705882,0.79801722728,0.445738355777},{0.919607843137,0.7905324123,0.440215740831},{0.919607843137,0.7905324123,0.440215740831},{0.927450980392,0.782927610492,0.434676421766},{0.927450980392,0.782927610492,0.434676421766},{0.935294117647,0.775203976111,0.429120608773},{0.935294117647,0.775203976111,0.429120608773},{0.943137254902,0.767362681449,0.423548512668},{0.943137254902,0.767362681449,0.423548512668},{0.950980392157,0.759404916655,0.417960344887},{0.950980392157,0.759404916655,0.417960344887},{0.958823529412,0.751331889557,0.412356317474},{0.958823529412,0.751331889557,0.412356317474},{0.966666666667,0.743144825477,0.406736643076},{0.966666666667,0.743144825477,0.406736643076},{0.974509803922,0.734844967047,0.401101534933},{0.974509803922,0.734844967047,0.401101534933},{0.982352941176,0.726433574016,0.395451206871},{0.982352941176,0.726433574016,0.395451206871},{0.990196078431,0.717911923064,0.389785873293},{0.990196078431,0.717911923064,0.389785873293},{0.998039215686,0.709281307606,0.384105749172},{0.998039215686,0.709281307606,0.384105749172},{1.0,0.700543037593,0.378411050042},{1.0,0.700543037593,0.378411050042},{1.0,0.691698439319,0.372701991991},{1.0,0.691698439319,0.372701991991},{1.0,0.682748855215,0.36697879165},{1.0,0.682748855215,0.36697879165},{1.0,0.673695643647,0.361241666187},{1.0,0.673695643647,0.361241666187},{1.0,0.664540178708,0.3554908333},{1.0,0.655283850013,0.349726511206},{1.0,0.655283850013,0.349726511206},{1.0,0.645928062487,0.343948918634},{1.0,0.645928062487,0.343948918634},{1.0,0.636474236147,0.338158274816},{1.0,0.636474236147,0.338158274816},{1.0,0.626923805894,0.33235479948},{1.0,0.626923805894,0.33235479948},{1.0,0.61727822129,0.32653871284},{1.0,0.61727822129,0.32653871284},{1.0,0.607538946339,0.32071023559},{1.0,0.607538946339,0.32071023559},{1.0,0.597707459266,0.314869588894},{1.0,0.597707459266,0.314869588894},{1.0,0.587785252292,0.309016994375},{1.0,0.587785252292,0.309016994375},{1.0,0.577773831408,0.303152674113},{1.0,0.577773831408,0.303152674113},{1.0,0.567674716145,0.297276850631},{1.0,0.567674716145,0.297276850631},{1.0,0.557489439343,0.291389746889},{1.0,0.557489439343,0.291389746889},{1.0,0.547219546922,0.285491586275},{1.0,0.547219546922,0.285491586275},{1.0,0.536866597644,0.279582592597},{1.0,0.536866597644,0.279582592597},{1.0,0.526432162877,0.273662990072},{1.0,0.526432162877,0.273662990072},{1.0,0.515917826358,0.267733003322},{1.0,0.515917826358,0.267733003322},{1.0,0.505325183949,0.261792857363},{1.0,0.505325183949,0.261792857363},{1.0,0.4946558434,0.255842777594},{1.0,0.4946558434,0.255842777594},{1.0,0.4839114241,0.249882989794},{1.0,0.4839114241,0.249882989794},{1.0,0.473093556836,0.243913720108},{1.0,0.473093556836,0.243913720108},{1.0,0.46220388354,0.237935195043},{1.0,0.451244057045,0.231947641454},{1.0,0.451244057045,0.231947641454},{1.0,0.440215740831,0.225951286542},{1.0,0.440215740831,0.225951286542},{1.0,0.429120608773,0.21994635784},{1.0,0.429120608773,0.21994635784},{1.0,0.417960344887,0.213933083206},{1.0,0.417960344887,0.213933083206},{1.0,0.406736643076,0.207911690818},{1.0,0.406736643076,0.207911690818},{1.0,0.395451206871,0.201882409157},{1.0,0.395451206871,0.201882409157},{1.0,0.384105749172,0.195845467007},{1.0,0.384105749172,0.195845467007},{1.0,0.372701991991,0.189801093442},{1.0,0.372701991991,0.189801093442},{1.0,0.361241666187,0.183749517817},{1.0,0.361241666187,0.183749517817},{1.0,0.349726511206,0.17769096976},{1.0,0.349726511206,0.17769096976},{1.0,0.338158274816,0.171625679166},{1.0,0.338158274816,0.171625679166},{1.0,0.32653871284,0.165553876184},{1.0,0.32653871284,0.165553876184},{1.0,0.314869588894,0.15947579121},{1.0,0.314869588894,0.15947579121},{1.0,0.303152674113,0.153391654879},{1.0,0.303152674113,0.153391654879},{1.0,0.291389746889,0.147301698055},{1.0,0.291389746889,0.147301698055},{1.0,0.279582592597,0.141206151823},{1.0,0.279582592597,0.141206151823},{1.0,0.267733003322,0.135105247481},{1.0,0.267733003322,0.135105247481},{1.0,0.255842777594,0.12899921653},{1.0,0.255842777594,0.12899921653},{1.0,0.243913720108,0.122888290665},{1.0,0.243913720108,0.122888290665},{1.0,0.231947641454,0.116772701766},{1.0,0.21994635784,0.110652681892},{1.0,0.21994635784,0.110652681892},{1.0,0.207911690818,0.104528463268},{1.0,0.207911690818,0.104528463268},{1.0,0.195845467007,0.0984002782796},{1.0,0.195845467007,0.0984002782796},{1.0,0.183749517817,0.0922683594633},{1.0,0.183749517817,0.0922683594633},{1.0,0.171625679166,0.0861329394961},{1.0,0.171625679166,0.0861329394961},{1.0,0.15947579121,0.0799942511885},{1.0,0.15947579121,0.0799942511885},{1.0,0.147301698055,0.0738525274749},{1.0,0.147301698055,0.0738525274749},{1.0,0.135105247481,0.0677080014047},{1.0,0.135105247481,0.0677080014047},{1.0,0.122888290665,0.0615609061339},{1.0,0.122888290665,0.0615609061339},{1.0,0.110652681892,0.055411474916},{1.0,0.110652681892,0.055411474916},{1.0,0.0984002782796,0.0492599410928},{1.0,0.0984002782796,0.0492599410928},{1.0,0.0861329394961,0.0431065380863},{1.0,0.0861329394961,0.0431065380863},{1.0,0.0738525274749,0.0369514993891},{1.0,0.0738525274749,0.0369514993891},{1.0,0.0615609061339,0.0307950585562},{1.0,0.0615609061339,0.0307950585562},{1.0,0.0492599410928,0.0246374491954},{1.0,0.0492599410928,0.0246374491954},{1.0,0.0369514993891,0.0184789049591},{1.0,0.0369514993891,0.0184789049591},{1.0,0.0246374491954,0.0123196595352},{1.0,0.0246374491954,0.0123196595352},{1.0,0.0123196595352,0.00615994663814},{1.0,0.0123196595352,0.00615994663814},{1.0,1.22464679915e-16,6.12323399574e-17},{1.0,1.22464679915e-16,6.12323399574e-17},};


const std::vector<glm::vec3> CM_JET = 
{{0.0,0.0,0.5},{0.0,0.0,0.5},{0.0,0.0,0.517825311943},{0.0,0.0,0.517825311943},{0.0,0.0,0.535650623886},{0.0,0.0,0.535650623886},{0.0,0.0,0.553475935829},{0.0,0.0,0.553475935829},{0.0,0.0,0.571301247772},{0.0,0.0,0.571301247772},{0.0,0.0,0.589126559715},{0.0,0.0,0.589126559715},{0.0,0.0,0.606951871658},{0.0,0.0,0.606951871658},{0.0,0.0,0.624777183601},{0.0,0.0,0.624777183601},{0.0,0.0,0.642602495544},{0.0,0.0,0.642602495544},{0.0,0.0,0.660427807487},{0.0,0.0,0.660427807487},{0.0,0.0,0.67825311943},{0.0,0.0,0.67825311943},{0.0,0.0,0.696078431373},{0.0,0.0,0.696078431373},{0.0,0.0,0.713903743316},{0.0,0.0,0.713903743316},{0.0,0.0,0.731729055258},{0.0,0.0,0.731729055258},{0.0,0.0,0.749554367201},{0.0,0.0,0.749554367201},{0.0,0.0,0.767379679144},{0.0,0.0,0.767379679144},{0.0,0.0,0.785204991087},{0.0,0.0,0.785204991087},{0.0,0.0,0.80303030303},{0.0,0.0,0.80303030303},{0.0,0.0,0.820855614973},{0.0,0.0,0.820855614973},{0.0,0.0,0.838680926916},{0.0,0.0,0.856506238859},{0.0,0.0,0.856506238859},{0.0,0.0,0.874331550802},{0.0,0.0,0.874331550802},{0.0,0.0,0.892156862745},{0.0,0.0,0.892156862745},{0.0,0.0,0.909982174688},{0.0,0.0,0.909982174688},{0.0,0.0,0.927807486631},{0.0,0.0,0.927807486631},{0.0,0.0,0.945632798574},{0.0,0.0,0.945632798574},{0.0,0.0,0.963458110517},{0.0,0.0,0.963458110517},{0.0,0.0,0.98128342246},{0.0,0.0,0.98128342246},{0.0,0.0,0.999108734403},{0.0,0.0,0.999108734403},{0.0,0.0,1.0},{0.0,0.0,1.0},{0.0,0.0,1.0},{0.0,0.0,1.0},{0.0,0.0,1.0},{0.0,0.0,1.0},{0.0,0.00196078431373,1.0},{0.0,0.00196078431373,1.0},{0.0,0.0176470588235,1.0},{0.0,0.0176470588235,1.0},{0.0,0.0333333333333,1.0},{0.0,0.0333333333333,1.0},{0.0,0.0490196078431,1.0},{0.0,0.0490196078431,1.0},{0.0,0.0647058823529,1.0},{0.0,0.0647058823529,1.0},{0.0,0.0803921568627,1.0},{0.0,0.0803921568627,1.0},{0.0,0.0960784313725,1.0},{0.0,0.0960784313725,1.0},{0.0,0.111764705882,1.0},{0.0,0.127450980392,1.0},{0.0,0.127450980392,1.0},{0.0,0.143137254902,1.0},{0.0,0.143137254902,1.0},{0.0,0.158823529412,1.0},{0.0,0.158823529412,1.0},{0.0,0.174509803922,1.0},{0.0,0.174509803922,1.0},{0.0,0.190196078431,1.0},{0.0,0.190196078431,1.0},{0.0,0.205882352941,1.0},{0.0,0.205882352941,1.0},{0.0,0.221568627451,1.0},{0.0,0.221568627451,1.0},{0.0,0.237254901961,1.0},{0.0,0.237254901961,1.0},{0.0,0.252941176471,1.0},{0.0,0.252941176471,1.0},{0.0,0.26862745098,1.0},{0.0,0.26862745098,1.0},{0.0,0.28431372549,1.0},{0.0,0.28431372549,1.0},{0.0,0.3,1.0},{0.0,0.3,1.0},{0.0,0.31568627451,1.0},{0.0,0.31568627451,1.0},{0.0,0.33137254902,1.0},{0.0,0.33137254902,1.0},{0.0,0.347058823529,1.0},{0.0,0.347058823529,1.0},{0.0,0.362745098039,1.0},{0.0,0.362745098039,1.0},{0.0,0.378431372549,1.0},{0.0,0.378431372549,1.0},{0.0,0.394117647059,1.0},{0.0,0.394117647059,1.0},{0.0,0.409803921569,1.0},{0.0,0.409803921569,1.0},{0.0,0.425490196078,1.0},{0.0,0.441176470588,1.0},{0.0,0.441176470588,1.0},{0.0,0.456862745098,1.0},{0.0,0.456862745098,1.0},{0.0,0.472549019608,1.0},{0.0,0.472549019608,1.0},{0.0,0.488235294118,1.0},{0.0,0.488235294118,1.0},{0.0,0.503921568627,1.0},{0.0,0.503921568627,1.0},{0.0,0.519607843137,1.0},{0.0,0.519607843137,1.0},{0.0,0.535294117647,1.0},{0.0,0.535294117647,1.0},{0.0,0.550980392157,1.0},{0.0,0.550980392157,1.0},{0.0,0.566666666667,1.0},{0.0,0.566666666667,1.0},{0.0,0.582352941176,1.0},{0.0,0.582352941176,1.0},{0.0,0.598039215686,1.0},{0.0,0.598039215686,1.0},{0.0,0.613725490196,1.0},{0.0,0.613725490196,1.0},{0.0,0.629411764706,1.0},{0.0,0.629411764706,1.0},{0.0,0.645098039216,1.0},{0.0,0.645098039216,1.0},{0.0,0.660784313725,1.0},{0.0,0.660784313725,1.0},{0.0,0.676470588235,1.0},{0.0,0.676470588235,1.0},{0.0,0.692156862745,1.0},{0.0,0.692156862745,1.0},{0.0,0.707843137255,1.0},{0.0,0.707843137255,1.0},{0.0,0.723529411765,1.0},{0.0,0.739215686275,1.0},{0.0,0.739215686275,1.0},{0.0,0.754901960784,1.0},{0.0,0.754901960784,1.0},{0.0,0.770588235294,1.0},{0.0,0.770588235294,1.0},{0.0,0.786274509804,1.0},{0.0,0.786274509804,1.0},{0.0,0.801960784314,1.0},{0.0,0.801960784314,1.0},{0.0,0.817647058824,1.0},{0.0,0.817647058824,1.0},{0.0,0.833333333333,1.0},{0.0,0.833333333333,1.0},{0.0,0.849019607843,1.0},{0.0,0.849019607843,1.0},{0.0,0.864705882353,0.996204933586},{0.0,0.864705882353,0.996204933586},{0.0,0.880392156863,0.983554712207},{0.0,0.880392156863,0.983554712207},{0.0,0.896078431373,0.970904490829},{0.0,0.896078431373,0.970904490829},{0.00948766603416,0.911764705882,0.95825426945},{0.00948766603416,0.911764705882,0.95825426945},{0.022137887413,0.927450980392,0.945604048071},{0.022137887413,0.927450980392,0.945604048071},{0.0347881087919,0.943137254902,0.932953826692},{0.0347881087919,0.943137254902,0.932953826692},{0.0474383301708,0.958823529412,0.920303605313},{0.0474383301708,0.958823529412,0.920303605313},{0.0600885515497,0.974509803922,0.907653383934},{0.0600885515497,0.974509803922,0.907653383934},{0.0727387729285,0.990196078431,0.895003162555},{0.0727387729285,0.990196078431,0.895003162555},{0.0853889943074,1.0,0.882352941176},{0.0853889943074,1.0,0.882352941176},{0.0980392156863,1.0,0.869702719798},{0.0980392156863,1.0,0.869702719798},{0.110689437065,1.0,0.857052498419},{0.123339658444,1.0,0.84440227704},{0.123339658444,1.0,0.84440227704},{0.135989879823,1.0,0.831752055661},{0.135989879823,1.0,0.831752055661},{0.148640101202,1.0,0.819101834282},{0.148640101202,1.0,0.819101834282},{0.161290322581,1.0,0.806451612903},{0.161290322581,1.0,0.806451612903},{0.17394054396,1.0,0.793801391524},{0.17394054396,1.0,0.793801391524},{0.186590765338,1.0,0.781151170145},{0.186590765338,1.0,0.781151170145},{0.199240986717,1.0,0.768500948767},{0.199240986717,1.0,0.768500948767},{0.211891208096,1.0,0.755850727388},{0.211891208096,1.0,0.755850727388},{0.224541429475,1.0,0.743200506009},{0.224541429475,1.0,0.743200506009},{0.237191650854,1.0,0.73055028463},{0.237191650854,1.0,0.73055028463},{0.249841872233,1.0,0.717900063251},{0.249841872233,1.0,0.717900063251},{0.262492093612,1.0,0.705249841872},{0.262492093612,1.0,0.705249841872},{0.275142314991,1.0,0.692599620493},{0.275142314991,1.0,0.692599620493},{0.287792536369,1.0,0.679949399114},{0.287792536369,1.0,0.679949399114},{0.300442757748,1.0,0.667299177736},{0.300442757748,1.0,0.667299177736},{0.313092979127,1.0,0.654648956357},{0.313092979127,1.0,0.654648956357},{0.325743200506,1.0,0.641998734978},{0.325743200506,1.0,0.641998734978},{0.338393421885,1.0,0.629348513599},{0.338393421885,1.0,0.629348513599},{0.351043643264,1.0,0.61669829222},{0.351043643264,1.0,0.61669829222},{0.363693864643,1.0,0.604048070841},{0.376344086022,1.0,0.591397849462},{0.376344086022,1.0,0.591397849462},{0.3889943074,1.0,0.578747628083},{0.3889943074,1.0,0.578747628083},{0.401644528779,1.0,0.566097406705},{0.401644528779,1.0,0.566097406705},{0.414294750158,1.0,0.553447185326},{0.414294750158,1.0,0.553447185326},{0.426944971537,1.0,0.540796963947},{0.426944971537,1.0,0.540796963947},{0.439595192916,1.0,0.528146742568},{0.439595192916,1.0,0.528146742568},{0.452245414295,1.0,0.515496521189},{0.452245414295,1.0,0.515496521189},{0.464895635674,1.0,0.50284629981},{0.464895635674,1.0,0.50284629981},{0.477545857052,1.0,0.490196078431},{0.477545857052,1.0,0.490196078431},{0.490196078431,1.0,0.477545857052},{0.490196078431,1.0,0.477545857052},{0.50284629981,1.0,0.464895635674},{0.50284629981,1.0,0.464895635674},{0.515496521189,1.0,0.452245414295},{0.515496521189,1.0,0.452245414295},{0.528146742568,1.0,0.439595192916},{0.528146742568,1.0,0.439595192916},{0.540796963947,1.0,0.426944971537},{0.540796963947,1.0,0.426944971537},{0.553447185326,1.0,0.414294750158},{0.553447185326,1.0,0.414294750158},{0.566097406705,1.0,0.401644528779},{0.566097406705,1.0,0.401644528779},{0.578747628083,1.0,0.3889943074},{0.578747628083,1.0,0.3889943074},{0.591397849462,1.0,0.376344086022},{0.591397849462,1.0,0.376344086022},{0.604048070841,1.0,0.363693864643},{0.61669829222,1.0,0.351043643264},{0.61669829222,1.0,0.351043643264},{0.629348513599,1.0,0.338393421885},{0.629348513599,1.0,0.338393421885},{0.641998734978,1.0,0.325743200506},{0.641998734978,1.0,0.325743200506},{0.654648956357,1.0,0.313092979127},{0.654648956357,1.0,0.313092979127},{0.667299177736,1.0,0.300442757748},{0.667299177736,1.0,0.300442757748},{0.679949399114,1.0,0.287792536369},{0.679949399114,1.0,0.287792536369},{0.692599620493,1.0,0.275142314991},{0.692599620493,1.0,0.275142314991},{0.705249841872,1.0,0.262492093612},{0.705249841872,1.0,0.262492093612},{0.717900063251,1.0,0.249841872233},{0.717900063251,1.0,0.249841872233},{0.73055028463,1.0,0.237191650854},{0.73055028463,1.0,0.237191650854},{0.743200506009,1.0,0.224541429475},{0.743200506009,1.0,0.224541429475},{0.755850727388,1.0,0.211891208096},{0.755850727388,1.0,0.211891208096},{0.768500948767,1.0,0.199240986717},{0.768500948767,1.0,0.199240986717},{0.781151170145,1.0,0.186590765338},{0.781151170145,1.0,0.186590765338},{0.793801391524,1.0,0.17394054396},{0.793801391524,1.0,0.17394054396},{0.806451612903,1.0,0.161290322581},{0.806451612903,1.0,0.161290322581},{0.819101834282,1.0,0.148640101202},{0.819101834282,1.0,0.148640101202},{0.831752055661,1.0,0.135989879823},{0.831752055661,1.0,0.135989879823},{0.84440227704,1.0,0.123339658444},{0.84440227704,1.0,0.123339658444},{0.857052498419,1.0,0.110689437065},{0.869702719798,1.0,0.0980392156863},{0.869702719798,1.0,0.0980392156863},{0.882352941176,1.0,0.0853889943074},{0.882352941176,1.0,0.0853889943074},{0.895003162555,1.0,0.0727387729285},{0.895003162555,1.0,0.0727387729285},{0.907653383934,1.0,0.0600885515497},{0.907653383934,1.0,0.0600885515497},{0.920303605313,1.0,0.0474383301708},{0.920303605313,1.0,0.0474383301708},{0.932953826692,1.0,0.0347881087919},{0.932953826692,1.0,0.0347881087919},{0.945604048071,0.9883805374,0.022137887413},{0.945604048071,0.9883805374,0.022137887413},{0.95825426945,0.97385620915,0.00948766603416},{0.95825426945,0.97385620915,0.00948766603416},{0.970904490829,0.959331880901,0.0},{0.970904490829,0.959331880901,0.0},{0.983554712207,0.944807552651,0.0},{0.983554712207,0.944807552651,0.0},{0.996204933586,0.930283224401,0.0},{0.996204933586,0.930283224401,0.0},{1.0,0.915758896151,0.0},{1.0,0.915758896151,0.0},{1.0,0.901234567901,0.0},{1.0,0.901234567901,0.0},{1.0,0.886710239651,0.0},{1.0,0.886710239651,0.0},{1.0,0.872185911402,0.0},{1.0,0.872185911402,0.0},{1.0,0.857661583152,0.0},{1.0,0.857661583152,0.0},{1.0,0.843137254902,0.0},{1.0,0.843137254902,0.0},{1.0,0.828612926652,0.0},{1.0,0.828612926652,0.0},{1.0,0.814088598402,0.0},{1.0,0.814088598402,0.0},{1.0,0.799564270153,0.0},{1.0,0.785039941903,0.0},{1.0,0.785039941903,0.0},{1.0,0.770515613653,0.0},{1.0,0.770515613653,0.0},{1.0,0.755991285403,0.0},{1.0,0.755991285403,0.0},{1.0,0.741466957153,0.0},{1.0,0.741466957153,0.0},{1.0,0.726942628903,0.0},{1.0,0.726942628903,0.0},{1.0,0.712418300654,0.0},{1.0,0.712418300654,0.0},{1.0,0.697893972404,0.0},{1.0,0.697893972404,0.0},{1.0,0.683369644154,0.0},{1.0,0.683369644154,0.0},{1.0,0.668845315904,0.0},{1.0,0.668845315904,0.0},{1.0,0.654320987654,0.0},{1.0,0.654320987654,0.0},{1.0,0.639796659405,0.0},{1.0,0.639796659405,0.0},{1.0,0.625272331155,0.0},{1.0,0.625272331155,0.0},{1.0,0.610748002905,0.0},{1.0,0.610748002905,0.0},{1.0,0.596223674655,0.0},{1.0,0.596223674655,0.0},{1.0,0.581699346405,0.0},{1.0,0.581699346405,0.0},{1.0,0.567175018155,0.0},{1.0,0.567175018155,0.0},{1.0,0.552650689906,0.0},{1.0,0.552650689906,0.0},{1.0,0.538126361656,0.0},{1.0,0.538126361656,0.0},{1.0,0.523602033406,0.0},{1.0,0.509077705156,0.0},{1.0,0.509077705156,0.0},{1.0,0.494553376906,0.0},{1.0,0.494553376906,0.0},{1.0,0.480029048656,0.0},{1.0,0.480029048656,0.0},{1.0,0.465504720407,0.0},{1.0,0.465504720407,0.0},{1.0,0.450980392157,0.0},{1.0,0.450980392157,0.0},{1.0,0.436456063907,0.0},{1.0,0.436456063907,0.0},{1.0,0.421931735657,0.0},{1.0,0.421931735657,0.0},{1.0,0.407407407407,0.0},{1.0,0.407407407407,0.0},{1.0,0.392883079158,0.0},{1.0,0.392883079158,0.0},{1.0,0.378358750908,0.0},{1.0,0.378358750908,0.0},{1.0,0.363834422658,0.0},{1.0,0.363834422658,0.0},{1.0,0.349310094408,0.0},{1.0,0.349310094408,0.0},{1.0,0.334785766158,0.0},{1.0,0.334785766158,0.0},{1.0,0.320261437908,0.0},{1.0,0.320261437908,0.0},{1.0,0.305737109659,0.0},{1.0,0.305737109659,0.0},{1.0,0.291212781409,0.0},{1.0,0.291212781409,0.0},{1.0,0.276688453159,0.0},{1.0,0.276688453159,0.0},{1.0,0.262164124909,0.0},{1.0,0.262164124909,0.0},{1.0,0.247639796659,0.0},{1.0,0.247639796659,0.0},{1.0,0.23311546841,0.0},{1.0,0.21859114016,0.0},{1.0,0.21859114016,0.0},{1.0,0.20406681191,0.0},{1.0,0.20406681191,0.0},{1.0,0.18954248366,0.0},{1.0,0.18954248366,0.0},{1.0,0.17501815541,0.0},{1.0,0.17501815541,0.0},{1.0,0.16049382716,0.0},{1.0,0.16049382716,0.0},{1.0,0.145969498911,0.0},{1.0,0.145969498911,0.0},{1.0,0.131445170661,0.0},{1.0,0.131445170661,0.0},{1.0,0.116920842411,0.0},{1.0,0.116920842411,0.0},{1.0,0.102396514161,0.0},{1.0,0.102396514161,0.0},{1.0,0.0878721859114,0.0},{1.0,0.0878721859114,0.0},{0.999108734403,0.0733478576616,0.0},{0.999108734403,0.0733478576616,0.0},{0.98128342246,0.0588235294118,0.0},{0.98128342246,0.0588235294118,0.0},{0.963458110517,0.0442992011619,0.0},{0.963458110517,0.0442992011619,0.0},{0.945632798574,0.0297748729121,0.0},{0.945632798574,0.0297748729121,0.0},{0.927807486631,0.0152505446623,0.0},{0.927807486631,0.0152505446623,0.0},{0.909982174688,0.000726216412491,0.0},{0.909982174688,0.000726216412491,0.0},{0.892156862745,0.0,0.0},{0.892156862745,0.0,0.0},{0.874331550802,0.0,0.0},{0.874331550802,0.0,0.0},{0.856506238859,0.0,0.0},{0.856506238859,0.0,0.0},{0.838680926916,0.0,0.0},{0.820855614973,0.0,0.0},{0.820855614973,0.0,0.0},{0.80303030303,0.0,0.0},{0.80303030303,0.0,0.0},{0.785204991087,0.0,0.0},{0.785204991087,0.0,0.0},{0.767379679144,0.0,0.0},{0.767379679144,0.0,0.0},{0.749554367201,0.0,0.0},{0.749554367201,0.0,0.0},{0.731729055258,0.0,0.0},{0.731729055258,0.0,0.0},{0.713903743316,0.0,0.0},{0.713903743316,0.0,0.0},{0.696078431373,0.0,0.0},{0.696078431373,0.0,0.0},{0.67825311943,0.0,0.0},{0.67825311943,0.0,0.0},{0.660427807487,0.0,0.0},{0.660427807487,0.0,0.0},{0.642602495544,0.0,0.0},{0.642602495544,0.0,0.0},{0.624777183601,0.0,0.0},{0.624777183601,0.0,0.0},{0.606951871658,0.0,0.0},{0.606951871658,0.0,0.0},{0.589126559715,0.0,0.0},{0.589126559715,0.0,0.0},{0.571301247772,0.0,0.0},{0.571301247772,0.0,0.0},{0.553475935829,0.0,0.0},{0.553475935829,0.0,0.0},{0.535650623886,0.0,0.0},{0.535650623886,0.0,0.0},{0.517825311943,0.0,0.0},{0.517825311943,0.0,0.0},{0.5,0.0,0.0},{0.5,0.0,0.0},};


const std::vector<glm::vec3> CM_REDS =
{{1.0,0.960784316063,0.941176474094},{1.0,0.960784316063,0.941176474094},{0.999876970403,0.958200694533,0.937485586194},{0.999876970403,0.958200694533,0.937485586194},{0.999753940807,0.955617073003,0.933794698294},{0.999753940807,0.955617073003,0.933794698294},{0.99963091121,0.953033451473,0.930103810395},{0.99963091121,0.953033451473,0.930103810395},{0.999507881613,0.950449829943,0.926412922495},{0.999507881613,0.950449829943,0.926412922495},{0.999384852017,0.947866208413,0.922722034595},{0.999384852017,0.947866208413,0.922722034595},{0.99926182242,0.945282586883,0.919031146695},{0.99926182242,0.945282586883,0.919031146695},{0.999138792823,0.942698965353,0.915340258795},{0.999138792823,0.942698965353,0.915340258795},{0.999015763227,0.940115343823,0.911649370895},{0.999015763227,0.940115343823,0.911649370895},{0.99889273363,0.937531722293,0.907958482995},{0.99889273363,0.937531722293,0.907958482995},{0.998769704033,0.934948100763,0.904267595095},{0.998769704033,0.934948100763,0.904267595095},{0.998646674437,0.932364479233,0.900576707195},{0.998646674437,0.932364479233,0.900576707195},{0.99852364484,0.929780857703,0.896885819295},{0.99852364484,0.929780857703,0.896885819295},{0.998400615243,0.927197236173,0.893194931395},{0.998400615243,0.927197236173,0.893194931395},{0.998277585647,0.924613614643,0.889504043495},{0.998277585647,0.924613614643,0.889504043495},{0.99815455605,0.922029993113,0.885813155595},{0.99815455605,0.922029993113,0.885813155595},{0.998031526453,0.919446371583,0.882122267695},{0.998031526453,0.919446371583,0.882122267695},{0.997908496857,0.916862750053,0.878431379795},{0.997908496857,0.916862750053,0.878431379795},{0.99778546726,0.914279128523,0.874740491895},{0.99778546726,0.914279128523,0.874740491895},{0.997662437663,0.911695506993,0.871049603995},{0.997539408067,0.909111885463,0.867358716095},{0.997539408067,0.909111885463,0.867358716095},{0.99741637847,0.906528263934,0.863667828195},{0.99741637847,0.906528263934,0.863667828195},{0.997293348873,0.903944642404,0.859976940295},{0.997293348873,0.903944642404,0.859976940295},{0.997170319277,0.901361020874,0.856286052395},{0.997170319277,0.901361020874,0.856286052395},{0.99704728968,0.898777399344,0.852595164495},{0.99704728968,0.898777399344,0.852595164495},{0.996924260083,0.896193777814,0.848904276595},{0.996924260083,0.896193777814,0.848904276595},{0.996801230487,0.893610156284,0.845213388695},{0.996801230487,0.893610156284,0.845213388695},{0.99667820089,0.891026534754,0.841522500795},{0.99667820089,0.891026534754,0.841522500795},{0.996555171293,0.888442913224,0.837831612896},{0.996555171293,0.888442913224,0.837831612896},{0.996432141697,0.885859291694,0.834140724996},{0.996432141697,0.885859291694,0.834140724996},{0.9963091121,0.883275670164,0.830449837096},{0.9963091121,0.883275670164,0.830449837096},{0.996186082503,0.880692048634,0.826758949196},{0.996186082503,0.880692048634,0.826758949196},{0.996047674207,0.87786236791,0.822775866004},{0.996047674207,0.87786236791,0.822775866004},{0.995801615014,0.873310272834,0.816747415767},{0.995801615014,0.873310272834,0.816747415767},{0.99555555582,0.868758177757,0.81071896553},{0.99555555582,0.868758177757,0.81071896553},{0.995309496627,0.864206082681,0.804690515294},{0.995309496627,0.864206082681,0.804690515294},{0.995063437434,0.859653987604,0.798662065057},{0.995063437434,0.859653987604,0.798662065057},{0.99481737824,0.855101892527,0.792633614821},{0.99481737824,0.855101892527,0.792633614821},{0.994571319047,0.850549797451,0.786605164584},{0.994571319047,0.850549797451,0.786605164584},{0.994325259854,0.845997702374,0.780576714347},{0.99407920066,0.841445607298,0.774548264111},{0.99407920066,0.841445607298,0.774548264111},{0.993833141467,0.836893512221,0.768519813874},{0.993833141467,0.836893512221,0.768519813874},{0.993587082274,0.832341417144,0.762491363638},{0.993587082274,0.832341417144,0.762491363638},{0.99334102308,0.827789322068,0.756462913401},{0.99334102308,0.827789322068,0.756462913401},{0.993094963887,0.823237226991,0.750434463164},{0.993094963887,0.823237226991,0.750434463164},{0.992848904694,0.818685131914,0.744406012928},{0.992848904694,0.818685131914,0.744406012928},{0.9926028455,0.814133036838,0.738377562691},{0.9926028455,0.814133036838,0.738377562691},{0.992356786307,0.809580941761,0.732349112455},{0.992356786307,0.809580941761,0.732349112455},{0.992110727114,0.805028846685,0.726320662218},{0.992110727114,0.805028846685,0.726320662218},{0.991864667921,0.800476751608,0.720292211981},{0.991864667921,0.800476751608,0.720292211981},{0.991618608727,0.795924656531,0.714263761745},{0.991618608727,0.795924656531,0.714263761745},{0.991372549534,0.791372561455,0.708235311508},{0.991372549534,0.791372561455,0.708235311508},{0.991126490341,0.786820466378,0.702206861272},{0.991126490341,0.786820466378,0.702206861272},{0.990880431147,0.782268371302,0.696178411035},{0.990880431147,0.782268371302,0.696178411035},{0.990634371954,0.777716276225,0.690149960798},{0.990634371954,0.777716276225,0.690149960798},{0.990388312761,0.773164181148,0.684121510562},{0.990388312761,0.773164181148,0.684121510562},{0.990142253567,0.768612086072,0.678093060325},{0.990142253567,0.768612086072,0.678093060325},{0.989896194374,0.764059990995,0.672064610089},{0.989896194374,0.764059990995,0.672064610089},{0.989650135181,0.759507895918,0.666036159852},{0.989650135181,0.759507895918,0.666036159852},{0.989404075987,0.754955800842,0.660007709615},{0.989158016794,0.750403705765,0.653979259379},{0.989158016794,0.750403705765,0.653979259379},{0.988911957601,0.745851610689,0.647950809142},{0.988911957601,0.745851610689,0.647950809142},{0.988665898407,0.741299515612,0.641922358906},{0.988665898407,0.741299515612,0.641922358906},{0.988419839214,0.736747420535,0.635893908669},{0.988419839214,0.736747420535,0.635893908669},{0.988235294819,0.732072295862,0.629926972997},{0.988235294819,0.732072295862,0.629926972997},{0.988235294819,0.727028082399,0.624144581019},{0.988235294819,0.727028082399,0.624144581019},{0.988235294819,0.721983868936,0.61836218904},{0.988235294819,0.721983868936,0.61836218904},{0.988235294819,0.716939655472,0.612579797062},{0.988235294819,0.716939655472,0.612579797062},{0.988235294819,0.711895442009,0.606797405084},{0.988235294819,0.711895442009,0.606797405084},{0.988235294819,0.706851228546,0.601015013106},{0.988235294819,0.706851228546,0.601015013106},{0.988235294819,0.701807015082,0.595232621127},{0.988235294819,0.701807015082,0.595232621127},{0.988235294819,0.696762801619,0.589450229149},{0.988235294819,0.696762801619,0.589450229149},{0.988235294819,0.691718588156,0.583667837171},{0.988235294819,0.691718588156,0.583667837171},{0.988235294819,0.686674374693,0.577885445193},{0.988235294819,0.686674374693,0.577885445193},{0.988235294819,0.681630161229,0.572103053215},{0.988235294819,0.681630161229,0.572103053215},{0.988235294819,0.676585947766,0.566320661236},{0.988235294819,0.676585947766,0.566320661236},{0.988235294819,0.671541734303,0.560538269258},{0.988235294819,0.671541734303,0.560538269258},{0.988235294819,0.666497520839,0.55475587728},{0.988235294819,0.666497520839,0.55475587728},{0.988235294819,0.661453307376,0.548973485302},{0.988235294819,0.656409093913,0.543191093323},{0.988235294819,0.656409093913,0.543191093323},{0.988235294819,0.65136488045,0.537408701345},{0.988235294819,0.65136488045,0.537408701345},{0.988235294819,0.646320666986,0.531626309367},{0.988235294819,0.646320666986,0.531626309367},{0.988235294819,0.641276453523,0.525843917389},{0.988235294819,0.641276453523,0.525843917389},{0.988235294819,0.63623224006,0.52006152541},{0.988235294819,0.63623224006,0.52006152541},{0.988235294819,0.631188026597,0.514279133432},{0.988235294819,0.631188026597,0.514279133432},{0.988235294819,0.626143813133,0.508496741454},{0.988235294819,0.626143813133,0.508496741454},{0.988235294819,0.62109959967,0.502714349476},{0.988235294819,0.62109959967,0.502714349476},{0.988235294819,0.616055386207,0.496931957497},{0.988235294819,0.616055386207,0.496931957497},{0.988235294819,0.611011172743,0.491149565519},{0.988235294819,0.611011172743,0.491149565519},{0.988235294819,0.60596695928,0.485367173541},{0.988235294819,0.60596695928,0.485367173541},{0.988235294819,0.600922745817,0.479584781563},{0.988235294819,0.600922745817,0.479584781563},{0.988235294819,0.595878532354,0.473802389584},{0.988235294819,0.595878532354,0.473802389584},{0.988235294819,0.59083431889,0.468019997606},{0.988235294819,0.59083431889,0.468019997606},{0.988235294819,0.585790105427,0.462237605628},{0.988235294819,0.585790105427,0.462237605628},{0.988235294819,0.580745891964,0.45645521365},{0.988235294819,0.580745891964,0.45645521365},{0.988235294819,0.5757016785,0.450672821671},{0.988235294819,0.5757016785,0.450672821671},{0.98818915872,0.570703600785,0.445213382735},{0.98818915872,0.570703600785,0.445213382735},{0.988066129123,0.565782415984,0.440292198868},{0.988066129123,0.565782415984,0.440292198868},{0.987943099527,0.560861231182,0.435371015002},{0.98782006993,0.555940046381,0.430449831135},{0.98782006993,0.555940046381,0.430449831135},{0.987697040333,0.551018861579,0.425528647269},{0.987697040333,0.551018861579,0.425528647269},{0.987574010737,0.546097676777,0.420607463402},{0.987574010737,0.546097676777,0.420607463402},{0.98745098114,0.541176491976,0.415686279535},{0.98745098114,0.541176491976,0.415686279535},{0.987327951543,0.536255307174,0.410765095669},{0.987327951543,0.536255307174,0.410765095669},{0.987204921947,0.531334122373,0.405843911802},{0.987204921947,0.531334122373,0.405843911802},{0.98708189235,0.526412937571,0.400922727935},{0.98708189235,0.526412937571,0.400922727935},{0.986958862753,0.521491752769,0.396001544069},{0.986958862753,0.521491752769,0.396001544069},{0.986835833157,0.516570567968,0.391080360202},{0.986835833157,0.516570567968,0.391080360202},{0.98671280356,0.511649383166,0.386159176336},{0.98671280356,0.511649383166,0.386159176336},{0.986589773963,0.506728198365,0.381237992469},{0.986589773963,0.506728198365,0.381237992469},{0.986466744367,0.501807013563,0.376316808602},{0.986466744367,0.501807013563,0.376316808602},{0.98634371477,0.496885828761,0.371395624736},{0.98634371477,0.496885828761,0.371395624736},{0.986220685173,0.49196464396,0.366474440869},{0.986220685173,0.49196464396,0.366474440869},{0.986097655577,0.487043459158,0.361553257003},{0.986097655577,0.487043459158,0.361553257003},{0.98597462598,0.482122274357,0.356632073136},{0.98597462598,0.482122274357,0.356632073136},{0.985851596383,0.477201089555,0.351710889269},{0.985851596383,0.477201089555,0.351710889269},{0.985728566787,0.472279904754,0.346789705403},{0.985728566787,0.472279904754,0.346789705403},{0.98560553719,0.467358719952,0.341868521536},{0.98560553719,0.467358719952,0.341868521536},{0.985482507593,0.46243753515,0.336947337669},{0.985359477997,0.457516350349,0.332026153803},{0.985359477997,0.457516350349,0.332026153803},{0.9852364484,0.452595165547,0.327104969936},{0.9852364484,0.452595165547,0.327104969936},{0.985113418803,0.447673980746,0.32218378607},{0.985113418803,0.447673980746,0.32218378607},{0.984990389207,0.442752795944,0.317262602203},{0.984990389207,0.442752795944,0.317262602203},{0.98486735961,0.437831611142,0.312341418336},{0.98486735961,0.437831611142,0.312341418336},{0.984744330013,0.432910426341,0.30742023447},{0.984744330013,0.432910426341,0.30742023447},{0.984621300417,0.427989241539,0.302499050603},{0.984621300417,0.427989241539,0.302499050603},{0.98449827082,0.423068056738,0.297577866737},{0.98449827082,0.423068056738,0.297577866737},{0.984375241224,0.418146871936,0.29265668287},{0.984375241224,0.418146871936,0.29265668287},{0.983575548845,0.41279508378,0.288350646753},{0.983575548845,0.41279508378,0.288350646753},{0.982099193685,0.407012692269,0.284659758385},{0.982099193685,0.407012692269,0.284659758385},{0.980622838525,0.401230300758,0.280968870018},{0.980622838525,0.401230300758,0.280968870018},{0.979146483365,0.395447909248,0.277277981651},{0.979146483365,0.395447909248,0.277277981651},{0.977670128205,0.389665517737,0.273587093283},{0.977670128205,0.389665517737,0.273587093283},{0.976193773045,0.383883126226,0.269896204916},{0.976193773045,0.383883126226,0.269896204916},{0.974717417885,0.378100734715,0.266205316548},{0.974717417885,0.378100734715,0.266205316548},{0.973241062725,0.372318343205,0.262514428181},{0.973241062725,0.372318343205,0.262514428181},{0.971764707565,0.366535951694,0.258823539813},{0.971764707565,0.366535951694,0.258823539813},{0.970288352405,0.360753560183,0.255132651446},{0.968811997245,0.354971168672,0.251441763078},{0.968811997245,0.354971168672,0.251441763078},{0.967335642085,0.349188777162,0.247750874711},{0.967335642085,0.349188777162,0.247750874711},{0.965859286925,0.343406385651,0.244059986344},{0.965859286925,0.343406385651,0.244059986344},{0.964382931765,0.33762399414,0.240369097976},{0.964382931765,0.33762399414,0.240369097976},{0.962906576605,0.331841602629,0.236678209609},{0.962906576605,0.331841602629,0.236678209609},{0.961430221445,0.326059211119,0.232987321241},{0.961430221445,0.326059211119,0.232987321241},{0.959953866285,0.320276819608,0.229296432874},{0.959953866285,0.320276819608,0.229296432874},{0.958477511125,0.314494428097,0.225605544506},{0.958477511125,0.314494428097,0.225605544506},{0.957001155965,0.308712036586,0.221914656139},{0.957001155965,0.308712036586,0.221914656139},{0.955524800805,0.302929645076,0.218223767771},{0.955524800805,0.302929645076,0.218223767771},{0.954048445646,0.297147253565,0.214532879404},{0.954048445646,0.297147253565,0.214532879404},{0.952572090486,0.291364862054,0.210841991037},{0.952572090486,0.291364862054,0.210841991037},{0.951095735326,0.285582470543,0.207151102669},{0.951095735326,0.285582470543,0.207151102669},{0.949619380166,0.279800079032,0.203460214302},{0.949619380166,0.279800079032,0.203460214302},{0.948143025006,0.274017687522,0.199769325934},{0.948143025006,0.274017687522,0.199769325934},{0.946666669846,0.268235296011,0.196078437567},{0.946666669846,0.268235296011,0.196078437567},{0.945190314686,0.2624529045,0.192387549199},{0.945190314686,0.2624529045,0.192387549199},{0.943713959526,0.256670512989,0.188696660832},{0.943713959526,0.256670512989,0.188696660832},{0.942237604366,0.250888121479,0.185005772464},{0.942237604366,0.250888121479,0.185005772464},{0.940761249206,0.245105729968,0.181314884097},{0.939284894046,0.239323338457,0.17762399573},{0.939284894046,0.239323338457,0.17762399573},{0.937808538886,0.233540946946,0.173933107362},{0.937808538886,0.233540946946,0.173933107362},{0.934486739776,0.228681277557,0.171395621609},{0.934486739776,0.228681277557,0.171395621609},{0.930057674296,0.22437524144,0.169550177426},{0.930057674296,0.22437524144,0.169550177426},{0.925628608816,0.220069205323,0.167704733242},{0.925628608816,0.220069205323,0.167704733242},{0.921199543336,0.215763169206,0.165859289058},{0.921199543336,0.215763169206,0.165859289058},{0.916770477856,0.211457133089,0.164013844875},{0.916770477856,0.211457133089,0.164013844875},{0.912341412376,0.207151096972,0.162168400691},{0.912341412376,0.207151096972,0.162168400691},{0.907912346896,0.202845060855,0.160322956507},{0.907912346896,0.202845060855,0.160322956507},{0.903483281416,0.198539024738,0.158477512323},{0.903483281416,0.198539024738,0.158477512323},{0.899054215936,0.194232988621,0.15663206814},{0.899054215936,0.194232988621,0.15663206814},{0.894625150456,0.189926952503,0.154786623956},{0.894625150456,0.189926952503,0.154786623956},{0.890196084976,0.185620916386,0.152941179772},{0.890196084976,0.185620916386,0.152941179772},{0.885767019496,0.181314880269,0.151095735588},{0.885767019496,0.181314880269,0.151095735588},{0.881337954016,0.177008844152,0.149250291405},{0.881337954016,0.177008844152,0.149250291405},{0.876908888536,0.172702808035,0.147404847221},{0.876908888536,0.172702808035,0.147404847221},{0.872479823056,0.168396771918,0.145559403037},{0.872479823056,0.168396771918,0.145559403037},{0.868050757576,0.164090735801,0.143713958854},{0.868050757576,0.164090735801,0.143713958854},{0.863621692096,0.159784699684,0.14186851467},{0.863621692096,0.159784699684,0.14186851467},{0.859192626617,0.155478663567,0.140023070486},{0.854763561137,0.15117262745,0.138177626302},{0.854763561137,0.15117262745,0.138177626302},{0.850334495657,0.146866591333,0.136332182119},{0.850334495657,0.146866591333,0.136332182119},{0.845905430177,0.142560555216,0.134486737935},{0.845905430177,0.142560555216,0.134486737935},{0.841476364697,0.138254519099,0.132641293751},{0.841476364697,0.138254519099,0.132641293751},{0.837047299217,0.133948482982,0.130795849568},{0.837047299217,0.133948482982,0.130795849568},{0.832618233737,0.129642446865,0.128950405384},{0.832618233737,0.129642446865,0.128950405384},{0.828189168257,0.125336410748,0.1271049612},{0.828189168257,0.125336410748,0.1271049612},{0.823760102777,0.121030374631,0.125259517016},{0.823760102777,0.121030374631,0.125259517016},{0.819331037297,0.116724338514,0.123414072833},{0.819331037297,0.116724338514,0.123414072833},{0.814901971817,0.112418302397,0.121568628649},{0.814901971817,0.112418302397,0.121568628649},{0.810472906337,0.10811226628,0.119723184465},{0.810472906337,0.10811226628,0.119723184465},{0.806043840857,0.103806230163,0.117877740281},{0.806043840857,0.103806230163,0.117877740281},{0.801614775377,0.0995001940458,0.116032296098},{0.801614775377,0.0995001940458,0.116032296098},{0.797185709897,0.0951941579288,0.114186851914},{0.797185709897,0.0951941579288,0.114186851914},{0.792572100022,0.0932871990344,0.112987313288},{0.792572100022,0.0932871990344,0.112987313288},{0.787896975349,0.0921799325476,0.112003076515},{0.787896975349,0.0921799325476,0.112003076515},{0.783221850676,0.0910726660607,0.111018839741},{0.783221850676,0.0910726660607,0.111018839741},{0.778546726002,0.0899653995738,0.110034602968},{0.778546726002,0.0899653995738,0.110034602968},{0.773871601329,0.088858133087,0.109050366195},{0.769196476656,0.0877508666001,0.108066129421},{0.769196476656,0.0877508666001,0.108066129421},{0.764521351983,0.0866436001133,0.107081892648},{0.764521351983,0.0866436001133,0.107081892648},{0.759846227309,0.0855363336264,0.106097655875},{0.759846227309,0.0855363336264,0.106097655875},{0.755171102636,0.0844290671395,0.105113419102},{0.755171102636,0.0844290671395,0.105113419102},{0.750495977963,0.0833218006527,0.104129182328},{0.750495977963,0.0833218006527,0.104129182328},{0.745820853289,0.0822145341658,0.103144945555},{0.745820853289,0.0822145341658,0.103144945555},{0.741145728616,0.081107267679,0.102160708782},{0.741145728616,0.081107267679,0.102160708782},{0.736470603943,0.0800000011921,0.101176472008},{0.736470603943,0.0800000011921,0.101176472008},{0.73179547927,0.0788927347052,0.100192235235},{0.73179547927,0.0788927347052,0.100192235235},{0.727120354596,0.0777854682184,0.0992079984616},{0.727120354596,0.0777854682184,0.0992079984616},{0.722445229923,0.0766782017315,0.0982237616883},{0.722445229923,0.0766782017315,0.0982237616883},{0.71777010525,0.0755709352447,0.0972395249149},{0.71777010525,0.0755709352447,0.0972395249149},{0.713094980576,0.0744636687578,0.0962552881416},{0.713094980576,0.0744636687578,0.0962552881416},{0.708419855903,0.0733564022709,0.0952710513683},{0.708419855903,0.0733564022709,0.0952710513683},{0.70374473123,0.0722491357841,0.094286814595},{0.70374473123,0.0722491357841,0.094286814595},{0.699069606557,0.0711418692972,0.0933025778216},{0.699069606557,0.0711418692972,0.0933025778216},{0.694394481883,0.0700346028104,0.0923183410483},{0.694394481883,0.0700346028104,0.0923183410483},{0.68971935721,0.0689273363235,0.091334104275},{0.68971935721,0.0689273363235,0.091334104275},{0.685044232537,0.0678200698366,0.0903498675017},{0.685044232537,0.0678200698366,0.0903498675017},{0.680369107863,0.0667128033498,0.0893656307284},{0.67569398319,0.0656055368629,0.088381393955},{0.67569398319,0.0656055368629,0.088381393955},{0.671018858517,0.0644982703761,0.0873971571817},{0.671018858517,0.0644982703761,0.0873971571817},{0.666343733844,0.0633910038892,0.0864129204084},{0.666343733844,0.0633910038892,0.0864129204084},{0.66166860917,0.0622837374023,0.0854286836351},{0.66166860917,0.0622837374023,0.0854286836351},{0.656993484497,0.0611764709155,0.0844444468617},{0.656993484497,0.0611764709155,0.0844444468617},{0.652318359824,0.0600692044286,0.0834602100884},{0.652318359824,0.0600692044286,0.0834602100884},{0.647643235151,0.0589619379418,0.0824759733151},{0.647643235151,0.0589619379418,0.0824759733151},{0.640384488129,0.0572087660724,0.0814917364395},{0.640384488129,0.0572087660724,0.0814917364395},{0.632756652201,0.0553633220056,0.0805074995493},{0.632756652201,0.0553633220056,0.0805074995493},{0.625128816273,0.0535178779387,0.0795232626591},{0.625128816273,0.0535178779387,0.0795232626591},{0.617500980344,0.0516724338718,0.0785390257689},{0.617500980344,0.0516724338718,0.0785390257689},{0.609873144416,0.049826989805,0.0775547888787},{0.609873144416,0.049826989805,0.0775547888787},{0.602245308488,0.0479815457381,0.0765705519885},{0.602245308488,0.0479815457381,0.0765705519885},{0.59461747256,0.0461361016713,0.0755863150983},{0.59461747256,0.0461361016713,0.0755863150983},{0.586989636632,0.0442906576044,0.0746020782082},{0.586989636632,0.0442906576044,0.0746020782082},{0.579361800703,0.0424452135376,0.073617841318},{0.579361800703,0.0424452135376,0.073617841318},{0.571733964775,0.0405997694707,0.0726336044278},{0.571733964775,0.0405997694707,0.0726336044278},{0.564106128847,0.0387543254039,0.0716493675376},{0.564106128847,0.0387543254039,0.0716493675376},{0.556478292919,0.036908881337,0.0706651306474},{0.556478292919,0.036908881337,0.0706651306474},{0.54885045699,0.0350634372702,0.0696808937572},{0.541222621062,0.0332179932033,0.068696656867},{0.541222621062,0.0332179932033,0.068696656867},{0.533594785134,0.0313725491365,0.0677124199768},{0.533594785134,0.0313725491365,0.0677124199768},{0.525966949206,0.0295271050696,0.0667281830866},{0.525966949206,0.0295271050696,0.0667281830866},{0.518339113278,0.0276816610028,0.0657439461964},{0.518339113278,0.0276816610028,0.0657439461964},{0.510711277349,0.0258362169359,0.0647597093062},{0.510711277349,0.0258362169359,0.0647597093062},{0.503083441421,0.0239907728691,0.063775472416},{0.503083441421,0.0239907728691,0.063775472416},{0.495455605493,0.0221453288022,0.0627912355258},{0.495455605493,0.0221453288022,0.0627912355258},{0.487827769565,0.0202998847354,0.0618069986356},{0.487827769565,0.0202998847354,0.0618069986356},{0.480199933636,0.0184544406685,0.0608227617454},{0.480199933636,0.0184544406685,0.0608227617454},{0.472572097708,0.0166089966017,0.0598385248552},{0.472572097708,0.0166089966017,0.0598385248552},{0.46494426178,0.0147635525348,0.058854287965},{0.46494426178,0.0147635525348,0.058854287965},{0.457316425852,0.012918108468,0.0578700510748},{0.457316425852,0.012918108468,0.0578700510748},{0.449688589924,0.0110726644011,0.0568858141847},{0.449688589924,0.0110726644011,0.0568858141847},{0.442060753995,0.00922722033426,0.0559015772945},{0.442060753995,0.00922722033426,0.0559015772945},{0.434432918067,0.00738177626741,0.0549173404043},{0.434432918067,0.00738177626741,0.0549173404043},{0.426805082139,0.00553633220056,0.0539331035141},{0.426805082139,0.00553633220056,0.0539331035141},{0.419177246211,0.0036908881337,0.0529488666239},{0.419177246211,0.0036908881337,0.0529488666239},{0.411549410282,0.00184544406685,0.0519646297337},{0.411549410282,0.00184544406685,0.0519646297337},{0.403921574354,0.0,0.0509803928435},{0.403921574354,0.0,0.0509803928435},};


const std::vector<glm::vec3> CM_PHASE =
{{0.658308392892,0.469939169032,0.0494128820399},{0.658308392892,0.469939169032,0.0494128820399},{0.664337418937,0.466201900857,0.057664734504},{0.664337418937,0.466201900857,0.057664734504},{0.670208692505,0.462480138122,0.0653456030954},{0.670208692505,0.462480138122,0.0653456030954},{0.676042990533,0.458698375996,0.0727317432221},{0.676042990533,0.458698375996,0.0727317432221},{0.681752284628,0.454914065184,0.0797926195668},{0.681752284628,0.454914065184,0.0797926195668},{0.687402804728,0.451084166991,0.0866710295087},{0.687402804728,0.451084166991,0.0866710295087},{0.692950498095,0.447238929651,0.0933586896015},{0.692950498095,0.447238929651,0.0933586896015},{0.698426191209,0.443357678593,0.0999283926833},{0.698426191209,0.443357678593,0.0999283926833},{0.703812298104,0.439453276235,0.106387104564},{0.703812298104,0.439453276235,0.106387104564},{0.709120692319,0.435517652511,0.112771744925},{0.709120692319,0.435517652511,0.112771744925},{0.714345244901,0.431555756203,0.119093478945},{0.714345244901,0.431555756203,0.119093478945},{0.719492886167,0.427562717169,0.125376059096},{0.719492886167,0.427562717169,0.125376059096},{0.724556192748,0.423544697127,0.13162325163},{0.724556192748,0.423544697127,0.13162325163},{0.72954894829,0.419490984923,0.137863048349},{0.72954894829,0.419490984923,0.137863048349},{0.734451724225,0.41541774051,0.144080393372},{0.734451724225,0.41541774051,0.144080393372},{0.739294955064,0.411299732702,0.150322173697},{0.739294955064,0.411299732702,0.150322173697},{0.744038335124,0.407171577287,0.156543346185},{0.744038335124,0.407171577287,0.156543346185},{0.748736952369,0.402985190782,0.16282281613},{0.748736952369,0.402985190782,0.16282281613},{0.753323193752,0.39880106902,0.169075663806},{0.753323193752,0.39880106902,0.169075663806},{0.757880829458,0.394542451134,0.175421792407},{0.762332602216,0.39028095672,0.181759153853},{0.762332602216,0.39028095672,0.181759153853},{0.7667320479,0.385965494354,0.188168187504},{0.7667320479,0.385965494354,0.188168187504},{0.771052472182,0.381621414822,0.194615319358},{0.771052472182,0.381621414822,0.194615319358},{0.775295277846,0.377247324652,0.201106520895},{0.775295277846,0.377247324652,0.201106520895},{0.779486659378,0.37281508501,0.207687295365},{0.779486659378,0.37281508501,0.207687295365},{0.783585336262,0.368367724773,0.214297364199},{0.783585336262,0.368367724773,0.214297364199},{0.787637631373,0.363853995029,0.221016475748},{0.787637631373,0.363853995029,0.221016475748},{0.79161133858,0.359308040423,0.22779740121},{0.79161133858,0.359308040423,0.22779740121},{0.795506055251,0.354729897918,0.234643526025},{0.795506055251,0.354729897918,0.234643526025},{0.799353983813,0.350079592948,0.241618319348},{0.799353983813,0.350079592948,0.241618319348},{0.803116708478,0.345401516392,0.248658916218},{0.803116708478,0.345401516392,0.248658916218},{0.806810326186,0.34067452251,0.25580075146},{0.806810326186,0.34067452251,0.25580075146},{0.8104452043,0.335882484131,0.263072216807},{0.8104452043,0.335882484131,0.263072216807},{0.813996801063,0.331055383196,0.270431826071},{0.813996801063,0.331055383196,0.270431826071},{0.817476894782,0.326175263767,0.277910961902},{0.817476894782,0.326175263767,0.277910961902},{0.820894148194,0.321226288958,0.285538460449},{0.820894148194,0.321226288958,0.285538460449},{0.824227126161,0.316236198585,0.293276167778},{0.824227126161,0.316236198585,0.293276167778},{0.827476613752,0.311201543345,0.301133878848},{0.827476613752,0.311201543345,0.301133878848},{0.830663985673,0.30608459405,0.309175785183},{0.830663985673,0.30608459405,0.309175785183},{0.833763065889,0.300922435954,0.317349208622},{0.836772858757,0.295713461259,0.325661993753},{0.836772858757,0.295713461259,0.325661993753},{0.839696930167,0.290447232868,0.334136649771},{0.839696930167,0.290447232868,0.334136649771},{0.842538733432,0.285111507699,0.342799619335},{0.842538733432,0.285111507699,0.342799619335},{0.845282969306,0.279729165834,0.351620780974},{0.845282969306,0.279729165834,0.351620780974},{0.847927041458,0.274300451817,0.360606806181},{0.847927041458,0.274300451817,0.360606806181},{0.850467925711,0.268826235069,0.369763947699},{0.850467925711,0.268826235069,0.369763947699},{0.852910557451,0.263288587404,0.379131161153},{0.852910557451,0.263288587404,0.379131161153},{0.855242004405,0.257708883964,0.388682169609},{0.855242004405,0.257708883964,0.388682169609},{0.857456726321,0.252093665886,0.398416010867},{0.857456726321,0.252093665886,0.398416010867},{0.859550232072,0.246447370855,0.408336253344},{0.859550232072,0.246447370855,0.408336253344},{0.861517669567,0.240775634951,0.418445571241},{0.861517669567,0.240775634951,0.418445571241},{0.863353924562,0.235085213863,0.428746057324},{0.863353924562,0.235085213863,0.428746057324},{0.865056845219,0.229372876811,0.43926007811},{0.865056845219,0.229372876811,0.43926007811},{0.866616063146,0.223663075912,0.449961266039},{0.866616063146,0.223663075912,0.449961266039},{0.86802577872,0.217967852481,0.46084758006},{0.86802577872,0.217967852481,0.46084758006},{0.86928002814,0.212301322732,0.471915544486},{0.86928002814,0.212301322732,0.471915544486},{0.870372741448,0.206679880751,0.483160154069},{0.870372741448,0.206679880751,0.483160154069},{0.871297806808,0.201122398412,0.49457479396},{0.871297806808,0.201122398412,0.49457479396},{0.872049140265,0.195650412874,0.506151179086},{0.872049140265,0.195650412874,0.506151179086},{0.87262075977,0.190288288901,0.517879317254},{0.873006861953,0.185063339211,0.529747499865},{0.873006861953,0.185063339211,0.529747499865},{0.873201899807,0.180005881391,0.541742323374},{0.873201899807,0.180005881391,0.541742323374},{0.87320065922,0.175149204974,0.553848743653},{0.87320065922,0.175149204974,0.553848743653},{0.872998332157,0.170529417732,0.566050164184},{0.872998332157,0.170529417732,0.566050164184},{0.872590584303,0.166185137096,0.578328557682},{0.872590584303,0.166185137096,0.578328557682},{0.871973612653,0.16215697962,0.590664660687},{0.871973612653,0.16215697962,0.590664660687},{0.87114414307,0.158486668076,0.603038808554},{0.87114414307,0.158486668076,0.603038808554},{0.870099660691,0.155216866248,0.615428437863},{0.870099660691,0.155216866248,0.615428437863},{0.868838231517,0.152388922857,0.627811754858},{0.868838231517,0.152388922857,0.627811754858},{0.867358580349,0.150041987043,0.640166505942},{0.867358580349,0.150041987043,0.640166505942},{0.865660095361,0.148211493519,0.65247021711},{0.865660095361,0.148211493519,0.65247021711},{0.863742820371,0.146927620733,0.664700433402},{0.863742820371,0.146927620733,0.664700433402},{0.861607435585,0.14621385657,0.676834951829},{0.861607435585,0.14621385657,0.676834951829},{0.85925522796,0.146085818174,0.688852041748},{0.85925522796,0.146085818174,0.688852041748},{0.856688052659,0.146550460138,0.700730647495},{0.856688052659,0.146550460138,0.700730647495},{0.853908294081,0.147605763482,0.712450541666},{0.853908294081,0.147605763482,0.712450541666},{0.850918813243,0.149240943921,0.723992497409},{0.850918813243,0.149240943921,0.723992497409},{0.847722873216,0.151437167202,0.735338489692},{0.847722873216,0.151437167202,0.735338489692},{0.844324093567,0.154168650668,0.746471739322},{0.840726393963,0.157404031455,0.757376782904},{0.840726393963,0.157404031455,0.757376782904},{0.836933938672,0.161107855552,0.76803951842},{0.836933938672,0.161107855552,0.76803951842},{0.832951083227,0.165242052784,0.778447227341},{0.832951083227,0.165242052784,0.778447227341},{0.828782324029,0.169767291005,0.788588575589},{0.828782324029,0.169767291005,0.788588575589},{0.824432251451,0.174644139132,0.798453595936},{0.824432251451,0.174644139132,0.798453595936},{0.819905506793,0.179834004693,0.808033654553},{0.819905506793,0.179834004693,0.808033654553},{0.81520674324,0.185299841441,0.817321404386},{0.81520674324,0.185299841441,0.817321404386},{0.810340590837,0.191006643757,0.826310727942},{0.810340590837,0.191006643757,0.826310727942},{0.805311757905,0.196921601061,0.834996450489},{0.805311757905,0.196921601061,0.834996450489},{0.800124669532,0.20301465242,0.843374862107},{0.800124669532,0.20301465242,0.843374862107},{0.794783673009,0.209258261464,0.851443195646},{0.794783673009,0.209258261464,0.851443195646},{0.789293018039,0.215627373716,0.859199565535},{0.789293018039,0.215627373716,0.859199565535},{0.783656806972,0.222099355044,0.866642944436},{0.783656806972,0.222099355044,0.866642944436},{0.777878979612,0.228653855109,0.87377308288},{0.777878979612,0.228653855109,0.87377308288},{0.771963300247,0.235272649647,0.880590429922},{0.771963300247,0.235272649647,0.880590429922},{0.765913346604,0.241939473532,0.887096055527},{0.765913346604,0.241939473532,0.887096055527},{0.759732500465,0.248639853039,0.893291575193},{0.759732500465,0.248639853039,0.893291575193},{0.753423939683,0.255360942964,0.899179077196},{0.753423939683,0.255360942964,0.899179077196},{0.74699063142,0.262091372137,0.904761052687},{0.74699063142,0.262091372137,0.904761052687},{0.740435326435,0.268821099342,0.910040328779},{0.733760554319,0.275541280537,0.915020004719},{0.733760554319,0.275541280537,0.915020004719},{0.726968619585,0.282244147513,0.919703391141},{0.726968619585,0.282244147513,0.919703391141},{0.720061598583,0.288922897644,0.924093952388},{0.720061598583,0.288922897644,0.924093952388},{0.713041337231,0.295571594063,0.92819525188},{0.713041337231,0.295571594063,0.92819525188},{0.705909449591,0.302185075438,0.932010900454},{0.705909449591,0.302185075438,0.932010900454},{0.698667317349,0.308758874406,0.935544507658},{0.698667317349,0.308758874406,0.935544507658},{0.691316090279,0.315289143767,0.938799635947},{0.691316090279,0.315289143767,0.938799635947},{0.683856687822,0.321772589498,0.941779757756},{0.683856687822,0.321772589498,0.941779757756},{0.676289801898,0.328206409748,0.944488215474},{0.676289801898,0.328206409748,0.944488215474},{0.66861590113,0.334588239008,0.946928184318},{0.66861590113,0.334588239008,0.946928184318},{0.660835236665,0.340916096734,0.949102638181},{0.660835236665,0.340916096734,0.949102638181},{0.652947849787,0.347188339785,0.951014318531},{0.652947849787,0.347188339785,0.951014318531},{0.644953581573,0.35340361808,0.952665706495},{0.644953581573,0.35340361808,0.952665706495},{0.636852084815,0.359560832988,0.954058998276},{0.636852084815,0.359560832988,0.954058998276},{0.628642838505,0.365659098003,0.955196084109},{0.628642838505,0.365659098003,0.955196084109},{0.620325165144,0.371697701338,0.956078530991},{0.620325165144,0.371697701338,0.956078530991},{0.611898251184,0.377676070126,0.956707569474},{0.611898251184,0.377676070126,0.956707569474},{0.603361170918,0.38359373599,0.957084084833},{0.603361170918,0.38359373599,0.957084084833},{0.594712914127,0.389450301774,0.957208612975},{0.594712914127,0.389450301774,0.957208612975},{0.585952417808,0.395245409322,0.957081341492},{0.577078602298,0.400978708233,0.956702116283},{0.577078602298,0.400978708233,0.956702116283},{0.568090412076,0.406649825569,0.956070454204},{0.568090412076,0.406649825569,0.956070454204},{0.55898686152,0.412258336579,0.955185562223},{0.55898686152,0.412258336579,0.955185562223},{0.549767085846,0.417803736546,0.954046363531},{0.549767085846,0.417803736546,0.954046363531},{0.540430397369,0.42328541394,0.952651531091},{0.540430397369,0.42328541394,0.952651531091},{0.530976347181,0.428702625127,0.950999529007},{0.530976347181,0.428702625127,0.950999529007},{0.521404792215,0.43405447093,0.94908866207},{0.521404792215,0.43405447093,0.94908866207},{0.511715967538,0.439339875449,0.94691713371},{0.511715967538,0.439339875449,0.94691713371},{0.501910563544,0.444557567548,0.944483112445},{0.501910563544,0.444557567548,0.944483112445},{0.491989807571,0.449706065529,0.941784806747},{0.491989807571,0.449706065529,0.941784806747},{0.481955549211,0.454783665516,0.938820547987},{0.481955549211,0.454783665516,0.938820547987},{0.471810348375,0.45978843412,0.93558888087},{0.471810348375,0.45978843412,0.93558888087},{0.461557564917,0.464718205967,0.932088660443},{0.461557564917,0.464718205967,0.932088660443},{0.451198008225,0.469572177684,0.92831786369},{0.451198008225,0.469572177684,0.92831786369},{0.440738524632,0.47434688193,0.924276690668},{0.440738524632,0.47434688193,0.924276690668},{0.430187219196,0.479038640683,0.919966197002},{0.430187219196,0.479038640683,0.919966197002},{0.419551659042,0.483644396275,0.91538759064},{0.419551659042,0.483644396275,0.91538759064},{0.408840633101,0.488160938611,0.910542931565},{0.408840633101,0.488160938611,0.910542931565},{0.398064208302,0.492584942395,0.905435227216},{0.387233771755,0.496913010871,0.900068517037},{0.387233771755,0.496913010871,0.900068517037},{0.376362056499,0.501141725475,0.894447942754},{0.376362056499,0.501141725475,0.894447942754},{0.365461266376,0.505268403433,0.888578767472},{0.365461266376,0.505268403433,0.888578767472},{0.354546543979,0.509289796888,0.882468192304},{0.354546543979,0.509289796888,0.882468192304},{0.343637793185,0.513201579589,0.876126636093},{0.343637793185,0.513201579589,0.876126636093},{0.332753093914,0.51700081982,0.869564086482},{0.332753093914,0.51700081982,0.869564086482},{0.321911658393,0.520684873358,0.862791658562},{0.321911658393,0.520684873358,0.862791658562},{0.311133719862,0.524251441443,0.855821520667},{0.311133719862,0.524251441443,0.855821520667},{0.300440398609,0.527698623816,0.848666794877},{0.300440398609,0.527698623816,0.848666794877},{0.289853256631,0.531025054992,0.841341230552},{0.289853256631,0.531025054992,0.841341230552},{0.279396159424,0.534229314818,0.833860509465},{0.279396159424,0.534229314818,0.833860509465},{0.269091811976,0.537310987157,0.82623984187},{0.269091811976,0.537310987157,0.82623984187},{0.258963000993,0.540270201043,0.81849474753},{0.258963000993,0.540270201043,0.81849474753},{0.249032393162,0.543107629026,0.810640895215},{0.249032393162,0.543107629026,0.810640895215},{0.239322289958,0.54582448394,0.80269392237},{0.239322289958,0.54582448394,0.80269392237},{0.229856635182,0.548421889,0.794671215898},{0.229856635182,0.548421889,0.794671215898},{0.220655100294,0.550902414196,0.786587062692},{0.220655100294,0.550902414196,0.786587062692},{0.211736409442,0.553269012911,0.778455329698},{0.211736409442,0.553269012911,0.778455329698},{0.203118430649,0.555524891192,0.770289734711},{0.203118430649,0.555524891192,0.770289734711},{0.194817201504,0.557673646703,0.76210317763},{0.186846596629,0.559719222965,0.753907633934},{0.186846596629,0.559719222965,0.753907633934},{0.179217988478,0.561665861309,0.745714066205},{0.179217988478,0.561665861309,0.745714066205},{0.171942195902,0.56351747024,0.737534984317},{0.171942195902,0.56351747024,0.737534984317},{0.165022951267,0.565279153364,0.729377543987},{0.165022951267,0.565279153364,0.729377543987},{0.158461160281,0.56695600177,0.721248188626},{0.158461160281,0.56695600177,0.721248188626},{0.152254991821,0.568552967252,0.713153205188},{0.152254991821,0.568552967252,0.713153205188},{0.146398761868,0.570075056921,0.705097686656},{0.146398761868,0.570075056921,0.705097686656},{0.140882840591,0.571527291452,0.697085535335},{0.140882840591,0.571527291452,0.697085535335},{0.135693662537,0.572914665847,0.689119475827},{0.135693662537,0.572914665847,0.689119475827},{0.130813852542,0.574242112738,0.681201076313},{0.130813852542,0.574242112738,0.681201076313},{0.126222473429,0.575514468206,0.673330776933},{0.126222473429,0.575514468206,0.673330776933},{0.121895393804,0.576736439983,0.665507924233},{0.121895393804,0.576736439983,0.665507924233},{0.117806543972,0.577912352304,0.657732326014},{0.117806543972,0.577912352304,0.657732326014},{0.113926129801,0.57904679578,0.649999836645},{0.113926129801,0.57904679578,0.649999836645},{0.110223478239,0.580143980837,0.642306368114},{0.110223478239,0.580143980837,0.642306368114},{0.106667323518,0.581207821548,0.634647331489},{0.106667323518,0.581207821548,0.634647331489},{0.103226306764,0.582241975777,0.627017287995},{0.103226306764,0.582241975777,0.627017287995},{0.0998697011666,0.583249824863,0.619410007498},{0.0998697011666,0.583249824863,0.619410007498},{0.0965681326987,0.584234454901,0.611818530585},{0.0965681326987,0.584234454901,0.611818530585},{0.0932942920612,0.585198639665,0.604235234177},{0.0900236427693,0.586144825264,0.596651900546},{0.0900236427693,0.586144825264,0.596651900546},{0.0867351401365,0.587075116665,0.589059789486},{0.0867351401365,0.587075116665,0.589059789486},{0.0834119859822,0.587991266222,0.581449713302},{0.0834119859822,0.587991266222,0.581449713302},{0.0800424540035,0.588894664373,0.573812114106},{0.0800424540035,0.588894664373,0.573812114106},{0.0766208306059,0.589786332627,0.566137142784},{0.0766208306059,0.589786332627,0.566137142784},{0.073148524854,0.590666918973,0.558414738841},{0.073148524854,0.590666918973,0.558414738841},{0.0696354071465,0.591536695753,0.55063471023},{0.0696354071465,0.591536695753,0.55063471023},{0.0661014350115,0.592395560023,0.542786812151},{0.0661014350115,0.592395560023,0.542786812151},{0.0625786076009,0.593243036315,0.534860823801},{0.0625786076009,0.593243036315,0.534860823801},{0.0591130375998,0.594078331469,0.526846137602},{0.0591130375998,0.594078331469,0.526846137602},{0.0557676501029,0.5949002975,0.518732197987},{0.0557676501029,0.5949002975,0.518732197987},{0.0526251056542,0.595707320083,0.510509780826},{0.0526251056542,0.595707320083,0.510509780826},{0.0497888068094,0.596497503811,0.502169359532},{0.0497888068094,0.596497503811,0.502169359532},{0.0473831926939,0.597268621556,0.493701736171},{0.0473831926939,0.597268621556,0.493701736171},{0.0455506684766,0.598018125295,0.485098086772},{0.0455506684766,0.598018125295,0.485098086772},{0.044443961893,0.59874315667,0.476350000404},{0.044443961893,0.59874315667,0.476350000404},{0.044213229489,0.599440556688,0.46744951244},{0.044213229489,0.599440556688,0.46744951244},{0.0449891786771,0.600106874013,0.458389132783},{0.0449891786771,0.600106874013,0.458389132783},{0.0468660448507,0.600738371276,0.449161870185},{0.0498897902424,0.601331028898,0.439761254173},{0.0498897902424,0.601331028898,0.439761254173},{0.0540557300631,0.601880554394,0.430181201574},{0.0540557300631,0.601880554394,0.430181201574},{0.0593220854021,0.602382887631,0.420405432562},{0.0593220854021,0.602382887631,0.420405432562},{0.0656077388042,0.602832583137,0.410437715603},{0.0656077388042,0.602832583137,0.410437715603},{0.0728196236389,0.603224415597,0.400273626235},{0.0728196236389,0.603224415597,0.400273626235},{0.0808617678135,0.603552833505,0.389909414935},{0.0808617678135,0.603552833505,0.389909414935},{0.0896436576776,0.603811940421,0.379342077786},{0.0896436576776,0.603811940421,0.379342077786},{0.0990895248698,0.603995543502,0.368564118402},{0.0990895248698,0.603995543502,0.368564118402},{0.109146168639,0.604096946088,0.357557987688},{0.109146168639,0.604096946088,0.357557987688},{0.119741186824,0.604108584409,0.34634096055},{0.119741186824,0.604108584409,0.34634096055},{0.130827463571,0.604022803635,0.334914160517},{0.130827463571,0.604022803635,0.334914160517},{0.14238003476,0.60383119145,0.323266999746},{0.14238003476,0.60383119145,0.323266999746},{0.154384700863,0.603524253284,0.311388229549},{0.154384700863,0.603524253284,0.311388229549},{0.166790927844,0.603093006307,0.299310287856},{0.166790927844,0.603093006307,0.299310287856},{0.179597574193,0.602526680057,0.287023704448},{0.179597574193,0.602526680057,0.287023704448},{0.192799657016,0.601813638169,0.274529642485},{0.192799657016,0.601813638169,0.274529642485},{0.206344646186,0.600944661405,0.261879400204},{0.206344646186,0.600944661405,0.261879400204},{0.220272872973,0.599904299374,0.249042513665},{0.220272872973,0.599904299374,0.249042513665},{0.234498332925,0.598685911475,0.236110215698},{0.234498332925,0.598685911475,0.236110215698},{0.249044157731,0.597274598402,0.223077804617},{0.263820058885,0.595666560172,0.210046733237},{0.263820058885,0.595666560172,0.210046733237},{0.278810397244,0.593852096035,0.197054842687},{0.278810397244,0.593852096035,0.197054842687},{0.293914943602,0.591833478387,0.184216205574},{0.293914943602,0.591833478387,0.184216205574},{0.309063395803,0.589613019789,0.171619421326},{0.309063395803,0.589613019789,0.171619421326},{0.324155770115,0.587201319418,0.159377534847},{0.324155770115,0.587201319418,0.159377534847},{0.339105898793,0.584611641776,0.147590123966},{0.339105898793,0.584611641776,0.147590123966},{0.353796240305,0.581867930492,0.136377340519},{0.353796240305,0.581867930492,0.136377340519},{0.368179053993,0.57898610151,0.125800541591},{0.368179053993,0.57898610151,0.125800541591},{0.382159657379,0.575995119173,0.115950397799},{0.382159657379,0.575995119173,0.115950397799},{0.395728244523,0.572909280944,0.106850382067},{0.395728244523,0.572909280944,0.106850382067},{0.408819264891,0.569757269791,0.0985552120261},{0.408819264891,0.569757269791,0.0985552120261},{0.421481064904,0.566541586272,0.0910400224657},{0.421481064904,0.566541586272,0.0910400224657},{0.433649533456,0.56329295616,0.0843411623911},{0.433649533456,0.56329295616,0.0843411623911},{0.445389078352,0.560008590638,0.0784130544391},{0.445389078352,0.560008590638,0.0784130544391},{0.456724213085,0.556694295148,0.0732291301251},{0.456724213085,0.556694295148,0.0732291301251},{0.467650170768,0.553363726905,0.0687676213476},{0.467650170768,0.553363726905,0.0687676213476},{0.478191378182,0.550021300819,0.0649843572199},{0.478191378182,0.550021300819,0.0649843572199},{0.488396861238,0.546661950698,0.0618216283741},{0.488396861238,0.546661950698,0.0618216283741},{0.498289239879,0.54328739536,0.0592272577501},{0.498289239879,0.54328739536,0.0592272577501},{0.507891137442,0.539898266893,0.0571446599845},{0.517224745646,0.53649428722,0.055514762882},{0.517224745646,0.53649428722,0.055514762882},{0.526311502589,0.533074430075,0.0542779255664},{0.526311502589,0.533074430075,0.0542779255664},{0.535171864525,0.529637065882,0.0533756685344},{0.535171864525,0.529637065882,0.0533756685344},{0.543825153637,0.526180088704,0.0527520754738},{0.543825153637,0.526180088704,0.0527520754738},{0.552289466379,0.522701025565,0.0523547907545},{0.552289466379,0.522701025565,0.0523547907545},{0.560581629478,0.519197129018,0.0521355994447},{0.560581629478,0.519197129018,0.0521355994447},{0.568717193317,0.515665454088,0.0520506243945},{0.568717193317,0.515665454088,0.0520506243945},{0.576710454772,0.512102920631,0.0520602020436},{0.576710454772,0.512102920631,0.0520602020436},{0.58457450375,0.508506361973,0.052128506748},{0.58457450375,0.508506361973,0.052128506748},{0.592321289445,0.504872560293,0.052222987749},{0.592321289445,0.504872560293,0.052222987749},{0.599961703895,0.501198268844,0.0523136690356},{0.599961703895,0.501198268844,0.0523136690356},{0.607505681632,0.497480220579,0.0523723445572},{0.607505681632,0.497480220579,0.0523723445572},{0.614962315274,0.493715122292,0.0523716818241},{0.614962315274,0.493715122292,0.0523716818241},{0.622339987733,0.489899632822,0.0522842261313},{0.622339987733,0.489899632822,0.0522842261313},{0.629646522519,0.486030323314,0.0520812738141},{0.629646522519,0.486030323314,0.0520812738141},{0.636889354233,0.482103616943,0.0517315523255},{0.636889354233,0.482103616943,0.0517315523255},{0.644075722043,0.478115704908,0.0511996007682},{0.644075722043,0.478115704908,0.0511996007682},{0.651212889353,0.474062435013,0.0504436747876},{0.651212889353,0.474062435013,0.0504436747876},{0.658308392892,0.469939169032,0.049412882041},{0.658308392892,0.469939169032,0.049412882041},};

// clang-format on


} // namespace render
} // namespace polyscope
