import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The guest name for the operating system when guest_id is otherGuest or otherGuest64.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#alternate_guest_name VirtualMachine#alternate_guest_name}
    */
    readonly alternateGuestName?: string;
    /**
    * User-provided description of the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#annotation VirtualMachine#annotation}
    */
    readonly annotation?: string;
    /**
    * The number of milliseconds to wait before starting the boot sequence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#boot_delay VirtualMachine#boot_delay}
    */
    readonly bootDelay?: number;
    /**
    * The number of milliseconds to wait before retrying the boot sequence. This only valid if boot_retry_enabled is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#boot_retry_delay VirtualMachine#boot_retry_delay}
    */
    readonly bootRetryDelay?: number;
    /**
    * If set to true, a virtual machine that fails to boot will try again after the delay defined in boot_retry_delay.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#boot_retry_enabled VirtualMachine#boot_retry_enabled}
    */
    readonly bootRetryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Allow CPUs to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_hot_add_enabled VirtualMachine#cpu_hot_add_enabled}
    */
    readonly cpuHotAddEnabled?: boolean | cdktf.IResolvable;
    /**
    * Allow CPUs to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_hot_remove_enabled VirtualMachine#cpu_hot_remove_enabled}
    */
    readonly cpuHotRemoveEnabled?: boolean | cdktf.IResolvable;
    /**
    * The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_limit VirtualMachine#cpu_limit}
    */
    readonly cpuLimit?: number;
    /**
    * Enable CPU performance counters on this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_performance_counters_enabled VirtualMachine#cpu_performance_counters_enabled}
    */
    readonly cpuPerformanceCountersEnabled?: boolean | cdktf.IResolvable;
    /**
    * The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_reservation VirtualMachine#cpu_reservation}
    */
    readonly cpuReservation?: number;
    /**
    * The amount of shares to allocate to cpu for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_share_count VirtualMachine#cpu_share_count}
    */
    readonly cpuShareCount?: number;
    /**
    * The allocation level for cpu resources. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cpu_share_level VirtualMachine#cpu_share_level}
    */
    readonly cpuShareLevel?: string;
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#custom_attributes VirtualMachine#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The ID of the datacenter where the VM is to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#datacenter_id VirtualMachine#datacenter_id}
    */
    readonly datacenterId?: string;
    /**
    * The ID of a datastore cluster to put the virtual machine in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#datastore_cluster_id VirtualMachine#datastore_cluster_id}
    */
    readonly datastoreClusterId?: string;
    /**
    * The ID of the virtual machine's datastore. The virtual machine configuration is placed here, along with any virtual disks that are created without datastores.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#datastore_id VirtualMachine#datastore_id}
    */
    readonly datastoreId?: string;
    /**
    * When the boot type set in firmware is efi, this enables EFI secure boot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#efi_secure_boot_enabled VirtualMachine#efi_secure_boot_enabled}
    */
    readonly efiSecureBootEnabled?: boolean | cdktf.IResolvable;
    /**
    * Expose the UUIDs of attached virtual disks to the virtual machine, allowing access to them in the guest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#enable_disk_uuid VirtualMachine#enable_disk_uuid}
    */
    readonly enableDiskUuid?: boolean | cdktf.IResolvable;
    /**
    * Enable logging on this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#enable_logging VirtualMachine#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * The EPT/RVI (hardware memory virtualization) setting for this virtual machine. Can be one of automatic, on, or off.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ept_rvi_mode VirtualMachine#ept_rvi_mode}
    */
    readonly eptRviMode?: string;
    /**
    * Extra configuration data for this virtual machine. Can be used to supply advanced parameters not normally in configuration, such as instance metadata, or configuration data for OVF images.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#extra_config VirtualMachine#extra_config}
    */
    readonly extraConfig?: {
        [key: string]: string;
    };
    /**
    * Allow the virtual machine to be rebooted when a change to `extra_config` occurs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#extra_config_reboot_required VirtualMachine#extra_config_reboot_required}
    */
    readonly extraConfigRebootRequired?: boolean | cdktf.IResolvable;
    /**
    * The firmware interface to use on the virtual machine. Can be one of bios or efi.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#firmware VirtualMachine#firmware}
    */
    readonly firmware?: string;
    /**
    * The name of the folder to locate the virtual machine in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#folder VirtualMachine#folder}
    */
    readonly folder?: string;
    /**
    * Set to true to force power-off a virtual machine if a graceful guest shutdown failed for a necessary operation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#force_power_off VirtualMachine#force_power_off}
    */
    readonly forcePowerOff?: boolean | cdktf.IResolvable;
    /**
    * The guest ID for the operating system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#guest_id VirtualMachine#guest_id}
    */
    readonly guestId?: string;
    /**
    * The hardware version for the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#hardware_version VirtualMachine#hardware_version}
    */
    readonly hardwareVersion?: number;
    /**
    * The ID of an optional host system to pin the virtual machine to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#host_system_id VirtualMachine#host_system_id}
    */
    readonly hostSystemId?: string;
    /**
    * The (non-nested) hardware virtualization setting for this virtual machine. Can be one of hvAuto, hvOn, or hvOff.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#hv_mode VirtualMachine#hv_mode}
    */
    readonly hvMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#id VirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of IDE controllers that Terraform manages on this virtual machine. This directly affects the amount of disks you can add to the virtual machine and the maximum disk unit number. Note that lowering this value does not remove controllers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ide_controller_count VirtualMachine#ide_controller_count}
    */
    readonly ideControllerCount?: number;
    /**
    * List of IP addresses and CIDR networks to ignore while waiting for an IP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ignored_guest_ips VirtualMachine#ignored_guest_ips}
    */
    readonly ignoredGuestIps?: string[];
    /**
    * Controls the scheduling delay of the virtual machine. Use a higher sensitivity for applications that require lower latency, such as VOIP, media player applications, or applications that require frequent access to mouse or keyboard devices. Can be one of low, normal, medium, or high.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#latency_sensitivity VirtualMachine#latency_sensitivity}
    */
    readonly latencySensitivity?: string;
    /**
    * The size of the virtual machine's memory, in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory VirtualMachine#memory}
    */
    readonly memory?: number;
    /**
    * Allow memory to be added to this virtual machine while it is running.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory_hot_add_enabled VirtualMachine#memory_hot_add_enabled}
    */
    readonly memoryHotAddEnabled?: boolean | cdktf.IResolvable;
    /**
    * The maximum amount of memory (in MB) or CPU (in MHz) that this virtual machine can consume, regardless of available resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory_limit VirtualMachine#memory_limit}
    */
    readonly memoryLimit?: number;
    /**
    * The amount of memory (in MB) or CPU (in MHz) that this virtual machine is guaranteed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory_reservation VirtualMachine#memory_reservation}
    */
    readonly memoryReservation?: number;
    /**
    * The amount of shares to allocate to memory for a custom share level.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory_share_count VirtualMachine#memory_share_count}
    */
    readonly memoryShareCount?: number;
    /**
    * The allocation level for memory resources. Can be one of high, low, normal, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#memory_share_level VirtualMachine#memory_share_level}
    */
    readonly memoryShareLevel?: string;
    /**
    * The amount of time, in minutes, to wait for a vMotion operation to complete before failing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#migrate_wait_timeout VirtualMachine#migrate_wait_timeout}
    */
    readonly migrateWaitTimeout?: number;
    /**
    * The name of this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#name VirtualMachine#name}
    */
    readonly name: string;
    /**
    * Enable nested hardware virtualization on this virtual machine, facilitating nested virtualization in the guest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#nested_hv_enabled VirtualMachine#nested_hv_enabled}
    */
    readonly nestedHvEnabled?: boolean | cdktf.IResolvable;
    /**
    * The number of cores to distribute amongst the CPUs in this virtual machine. If specified, the value supplied to num_cpus must be evenly divisible by this value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#num_cores_per_socket VirtualMachine#num_cores_per_socket}
    */
    readonly numCoresPerSocket?: number;
    /**
    * The number of virtual processors to assign to this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#num_cpus VirtualMachine#num_cpus}
    */
    readonly numCpus?: number;
    /**
    * A list of PCI passthrough devices
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#pci_device_id VirtualMachine#pci_device_id}
    */
    readonly pciDeviceId?: string[];
    /**
    * The amount of time, in seconds, that we will be trying to power on a VM
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#poweron_timeout VirtualMachine#poweron_timeout}
    */
    readonly poweronTimeout?: number;
    /**
    * Triggers replacement of resource whenever it changes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#replace_trigger VirtualMachine#replace_trigger}
    */
    readonly replaceTrigger?: string;
    /**
    * The ID of a resource pool to put the virtual machine in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#resource_pool_id VirtualMachine#resource_pool_id}
    */
    readonly resourcePoolId: string;
    /**
    * Enable the run of scripts after virtual machine power-on when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_tools_scripts_after_power_on VirtualMachine#run_tools_scripts_after_power_on}
    */
    readonly runToolsScriptsAfterPowerOn?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts after virtual machine resume when when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_tools_scripts_after_resume VirtualMachine#run_tools_scripts_after_resume}
    */
    readonly runToolsScriptsAfterResume?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system reboot when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_tools_scripts_before_guest_reboot VirtualMachine#run_tools_scripts_before_guest_reboot}
    */
    readonly runToolsScriptsBeforeGuestReboot?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system shutdown when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_tools_scripts_before_guest_shutdown VirtualMachine#run_tools_scripts_before_guest_shutdown}
    */
    readonly runToolsScriptsBeforeGuestShutdown?: boolean | cdktf.IResolvable;
    /**
    * Enable the run of scripts before guest operating system standby when VMware Tools is installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_tools_scripts_before_guest_standby VirtualMachine#run_tools_scripts_before_guest_standby}
    */
    readonly runToolsScriptsBeforeGuestStandby?: boolean | cdktf.IResolvable;
    /**
    * The number of SATA controllers that Terraform manages on this virtual machine. This directly affects the amount of disks you can add to the virtual machine and the maximum disk unit number. Note that lowering this value does not remove controllers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#sata_controller_count VirtualMachine#sata_controller_count}
    */
    readonly sataControllerCount?: number;
    /**
    * Mode for sharing the SCSI bus. The modes are physicalSharing, virtualSharing, and noSharing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#scsi_bus_sharing VirtualMachine#scsi_bus_sharing}
    */
    readonly scsiBusSharing?: string;
    /**
    * The number of SCSI controllers that Terraform manages on this virtual machine. This directly affects the amount of disks you can add to the virtual machine and the maximum disk unit number. Note that lowering this value does not remove controllers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#scsi_controller_count VirtualMachine#scsi_controller_count}
    */
    readonly scsiControllerCount?: number;
    /**
    * The type of SCSI bus this virtual machine will have. Can be one of lsilogic, lsilogic-sas or pvscsi.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#scsi_type VirtualMachine#scsi_type}
    */
    readonly scsiType?: string;
    /**
    * The amount of time, in minutes, to wait for shutdown when making necessary updates to the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#shutdown_wait_timeout VirtualMachine#shutdown_wait_timeout}
    */
    readonly shutdownWaitTimeout?: number;
    /**
    * The ID of the storage policy to assign to the virtual machine home directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#storage_policy_id VirtualMachine#storage_policy_id}
    */
    readonly storagePolicyId?: string;
    /**
    * The swap file placement policy for this virtual machine. Can be one of inherit, hostLocal, or vmDirectory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#swap_placement_policy VirtualMachine#swap_placement_policy}
    */
    readonly swapPlacementPolicy?: string;
    /**
    * Enable guest clock synchronization with the host. On vSphere 7.0 U1 and above, with only this setting the clock is synchronized on startup and resume. Requires VMware Tools to be installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#sync_time_with_host VirtualMachine#sync_time_with_host}
    */
    readonly syncTimeWithHost?: boolean | cdktf.IResolvable;
    /**
    * Enable periodic clock synchronization with the host. Supported only on vSphere 7.0 U1 and above. On prior versions setting `sync_time_with_host` is enough for periodic synchronization. Requires VMware Tools to be installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#sync_time_with_host_periodically VirtualMachine#sync_time_with_host_periodically}
    */
    readonly syncTimeWithHostPeriodically?: boolean | cdktf.IResolvable;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#tags VirtualMachine#tags}
    */
    readonly tags?: string[];
    /**
    * Set the upgrade policy for VMware Tools. Can be one of `manual` or `upgradeAtPowerCycle`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#tools_upgrade_policy VirtualMachine#tools_upgrade_policy}
    */
    readonly toolsUpgradePolicy?: string;
    /**
    * Flag to specify if Virtualization-based security is enabled for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#vbs_enabled VirtualMachine#vbs_enabled}
    */
    readonly vbsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Flag to specify if I/O MMU virtualization, also called Intel Virtualization Technology for Directed I/O (VT-d) and AMD I/O Virtualization (AMD-Vi or IOMMU), is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#vvtd_enabled VirtualMachine#vvtd_enabled}
    */
    readonly vvtdEnabled?: boolean | cdktf.IResolvable;
    /**
    * The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#wait_for_guest_ip_timeout VirtualMachine#wait_for_guest_ip_timeout}
    */
    readonly waitForGuestIpTimeout?: number;
    /**
    * Controls whether or not the guest network waiter waits for a routable address. When false, the waiter does not wait for a default gateway, nor are IP addresses checked against any discovered default gateways as part of its success criteria.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#wait_for_guest_net_routable VirtualMachine#wait_for_guest_net_routable}
    */
    readonly waitForGuestNetRoutable?: boolean | cdktf.IResolvable;
    /**
    * The amount of time, in minutes, to wait for an available IP address on this virtual machine. A value less than 1 disables the waiter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#wait_for_guest_net_timeout VirtualMachine#wait_for_guest_net_timeout}
    */
    readonly waitForGuestNetTimeout?: number;
    /**
    * cdrom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#cdrom VirtualMachine#cdrom}
    */
    readonly cdrom?: VirtualMachineCdrom[] | cdktf.IResolvable;
    /**
    * clone block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#clone VirtualMachine#clone}
    */
    readonly clone?: VirtualMachineClone;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#disk VirtualMachine#disk}
    */
    readonly disk?: VirtualMachineDisk[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#network_interface VirtualMachine#network_interface}
    */
    readonly networkInterface?: VirtualMachineNetworkInterface[] | cdktf.IResolvable;
    /**
    * ovf_deploy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ovf_deploy VirtualMachine#ovf_deploy}
    */
    readonly ovfDeploy?: VirtualMachineOvfDeploy;
    /**
    * vapp block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#vapp VirtualMachine#vapp}
    */
    readonly vapp?: VirtualMachineVapp;
}
export interface VirtualMachineCdrom {
    /**
    * Indicates whether the device should be mapped to a remote client device
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#client_device VirtualMachine#client_device}
    */
    readonly clientDevice?: boolean | cdktf.IResolvable;
    /**
    * The datastore ID the ISO is located on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#datastore_id VirtualMachine#datastore_id}
    */
    readonly datastoreId?: string;
    /**
    * The path to the ISO file on the datastore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#path VirtualMachine#path}
    */
    readonly path?: string;
}
export declare function virtualMachineCdromToTerraform(struct?: VirtualMachineCdrom | cdktf.IResolvable): any;
export declare class VirtualMachineCdromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineCdrom | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineCdrom | cdktf.IResolvable | undefined);
    private _clientDevice?;
    get clientDevice(): boolean | cdktf.IResolvable;
    set clientDevice(value: boolean | cdktf.IResolvable);
    resetClientDevice(): void;
    get clientDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _datastoreId?;
    get datastoreId(): string;
    set datastoreId(value: string);
    resetDatastoreId(): void;
    get datastoreIdInput(): string | undefined;
    get deviceAddress(): string;
    get key(): number;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class VirtualMachineCdromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineCdrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineCdromOutputReference;
}
export interface VirtualMachineCloneCustomizeLinuxOptions {
    /**
    * The domain name for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#domain VirtualMachine#domain}
    */
    readonly domain: string;
    /**
    * The hostname for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#host_name VirtualMachine#host_name}
    */
    readonly hostName: string;
    /**
    * Specifies whether or not the hardware clock should be in UTC or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#hw_clock_utc VirtualMachine#hw_clock_utc}
    */
    readonly hwClockUtc?: boolean | cdktf.IResolvable;
    /**
    * The customization script to run before and or after guest customization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#script_text VirtualMachine#script_text}
    */
    readonly scriptText?: string;
    /**
    * Customize the time zone on the VM. This should be a time zone-style entry, like America/Los_Angeles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#time_zone VirtualMachine#time_zone}
    */
    readonly timeZone?: string;
}
export declare function virtualMachineCloneCustomizeLinuxOptionsToTerraform(struct?: VirtualMachineCloneCustomizeLinuxOptionsOutputReference | VirtualMachineCloneCustomizeLinuxOptions): any;
export declare class VirtualMachineCloneCustomizeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineCloneCustomizeLinuxOptions | undefined;
    set internalValue(value: VirtualMachineCloneCustomizeLinuxOptions | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _hwClockUtc?;
    get hwClockUtc(): boolean | cdktf.IResolvable;
    set hwClockUtc(value: boolean | cdktf.IResolvable);
    resetHwClockUtc(): void;
    get hwClockUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _scriptText?;
    get scriptText(): string;
    set scriptText(value: string);
    resetScriptText(): void;
    get scriptTextInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export interface VirtualMachineCloneCustomizeNetworkInterface {
    /**
    * A DNS search domain to add to the DNS configuration on the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#dns_domain VirtualMachine#dns_domain}
    */
    readonly dnsDomain?: string;
    /**
    * Network-interface specific DNS settings for Windows operating systems. Ignored on Linux.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#dns_server_list VirtualMachine#dns_server_list}
    */
    readonly dnsServerList?: string[];
    /**
    * The IPv4 address assigned to this network adapter. If left blank, DHCP is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv4_address VirtualMachine#ipv4_address}
    */
    readonly ipv4Address?: string;
    /**
    * The IPv4 CIDR netmask for the supplied IP address. Ignored if DHCP is selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv4_netmask VirtualMachine#ipv4_netmask}
    */
    readonly ipv4Netmask?: number;
    /**
    * The IPv6 address assigned to this network adapter. If left blank, default auto-configuration is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv6_address VirtualMachine#ipv6_address}
    */
    readonly ipv6Address?: string;
    /**
    * The IPv6 CIDR netmask for the supplied IP address. Ignored if auto-configuration is selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv6_netmask VirtualMachine#ipv6_netmask}
    */
    readonly ipv6Netmask?: number;
}
export declare function virtualMachineCloneCustomizeNetworkInterfaceToTerraform(struct?: VirtualMachineCloneCustomizeNetworkInterface | cdktf.IResolvable): any;
export declare class VirtualMachineCloneCustomizeNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineCloneCustomizeNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineCloneCustomizeNetworkInterface | cdktf.IResolvable | undefined);
    private _dnsDomain?;
    get dnsDomain(): string;
    set dnsDomain(value: string);
    resetDnsDomain(): void;
    get dnsDomainInput(): string | undefined;
    private _dnsServerList?;
    get dnsServerList(): string[];
    set dnsServerList(value: string[]);
    resetDnsServerList(): void;
    get dnsServerListInput(): string[] | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    resetIpv4Address(): void;
    get ipv4AddressInput(): string | undefined;
    private _ipv4Netmask?;
    get ipv4Netmask(): number;
    set ipv4Netmask(value: number);
    resetIpv4Netmask(): void;
    get ipv4NetmaskInput(): number | undefined;
    private _ipv6Address?;
    get ipv6Address(): string;
    set ipv6Address(value: string);
    resetIpv6Address(): void;
    get ipv6AddressInput(): string | undefined;
    private _ipv6Netmask?;
    get ipv6Netmask(): number;
    set ipv6Netmask(value: number);
    resetIpv6Netmask(): void;
    get ipv6NetmaskInput(): number | undefined;
}
export declare class VirtualMachineCloneCustomizeNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineCloneCustomizeNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineCloneCustomizeNetworkInterfaceOutputReference;
}
export interface VirtualMachineCloneCustomizeWindowsOptions {
    /**
    * The new administrator password for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#admin_password VirtualMachine#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Specifies whether or not the VM automatically logs on as Administrator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#auto_logon VirtualMachine#auto_logon}
    */
    readonly autoLogon?: boolean | cdktf.IResolvable;
    /**
    * Specifies how many times the VM should auto-logon the Administrator account when auto_logon is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#auto_logon_count VirtualMachine#auto_logon_count}
    */
    readonly autoLogonCount?: number;
    /**
    * The host name for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#computer_name VirtualMachine#computer_name}
    */
    readonly computerName: string;
    /**
    * The password of the domain administrator used to join this virtual machine to the domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#domain_admin_password VirtualMachine#domain_admin_password}
    */
    readonly domainAdminPassword?: string;
    /**
    * The user account of the domain administrator used to join this virtual machine to the domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#domain_admin_user VirtualMachine#domain_admin_user}
    */
    readonly domainAdminUser?: string;
    /**
    * The full name of the user of this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#full_name VirtualMachine#full_name}
    */
    readonly fullName?: string;
    /**
    * The domain that the virtual machine should join.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#join_domain VirtualMachine#join_domain}
    */
    readonly joinDomain?: string;
    /**
    * The organization name this virtual machine is being installed for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#organization_name VirtualMachine#organization_name}
    */
    readonly organizationName?: string;
    /**
    * The product key for this virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#product_key VirtualMachine#product_key}
    */
    readonly productKey?: string;
    /**
    * A list of commands to run at first user logon, after guest customization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#run_once_command_list VirtualMachine#run_once_command_list}
    */
    readonly runOnceCommandList?: string[];
    /**
    * The new time zone for the virtual machine. This is a sysprep-dictated timezone code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#time_zone VirtualMachine#time_zone}
    */
    readonly timeZone?: number;
    /**
    * The workgroup for this virtual machine if not joining a domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#workgroup VirtualMachine#workgroup}
    */
    readonly workgroup?: string;
}
export declare function virtualMachineCloneCustomizeWindowsOptionsToTerraform(struct?: VirtualMachineCloneCustomizeWindowsOptionsOutputReference | VirtualMachineCloneCustomizeWindowsOptions): any;
export declare class VirtualMachineCloneCustomizeWindowsOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineCloneCustomizeWindowsOptions | undefined;
    set internalValue(value: VirtualMachineCloneCustomizeWindowsOptions | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _autoLogon?;
    get autoLogon(): boolean | cdktf.IResolvable;
    set autoLogon(value: boolean | cdktf.IResolvable);
    resetAutoLogon(): void;
    get autoLogonInput(): boolean | cdktf.IResolvable | undefined;
    private _autoLogonCount?;
    get autoLogonCount(): number;
    set autoLogonCount(value: number);
    resetAutoLogonCount(): void;
    get autoLogonCountInput(): number | undefined;
    private _computerName?;
    get computerName(): string;
    set computerName(value: string);
    get computerNameInput(): string | undefined;
    private _domainAdminPassword?;
    get domainAdminPassword(): string;
    set domainAdminPassword(value: string);
    resetDomainAdminPassword(): void;
    get domainAdminPasswordInput(): string | undefined;
    private _domainAdminUser?;
    get domainAdminUser(): string;
    set domainAdminUser(value: string);
    resetDomainAdminUser(): void;
    get domainAdminUserInput(): string | undefined;
    private _fullName?;
    get fullName(): string;
    set fullName(value: string);
    resetFullName(): void;
    get fullNameInput(): string | undefined;
    private _joinDomain?;
    get joinDomain(): string;
    set joinDomain(value: string);
    resetJoinDomain(): void;
    get joinDomainInput(): string | undefined;
    private _organizationName?;
    get organizationName(): string;
    set organizationName(value: string);
    resetOrganizationName(): void;
    get organizationNameInput(): string | undefined;
    private _productKey?;
    get productKey(): string;
    set productKey(value: string);
    resetProductKey(): void;
    get productKeyInput(): string | undefined;
    private _runOnceCommandList?;
    get runOnceCommandList(): string[];
    set runOnceCommandList(value: string[]);
    resetRunOnceCommandList(): void;
    get runOnceCommandListInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): number;
    set timeZone(value: number);
    resetTimeZone(): void;
    get timeZoneInput(): number | undefined;
    private _workgroup?;
    get workgroup(): string;
    set workgroup(value: string);
    resetWorkgroup(): void;
    get workgroupInput(): string | undefined;
}
export interface VirtualMachineCloneCustomize {
    /**
    * The list of DNS servers for a virtual network adapter with a static IP address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#dns_server_list VirtualMachine#dns_server_list}
    */
    readonly dnsServerList?: string[];
    /**
    * A list of DNS search domains to add to the DNS configuration on the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#dns_suffix_list VirtualMachine#dns_suffix_list}
    */
    readonly dnsSuffixList?: string[];
    /**
    * The IPv4 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv4_gateway VirtualMachine#ipv4_gateway}
    */
    readonly ipv4Gateway?: string;
    /**
    * The IPv6 default gateway when using network_interface customization on the virtual machine. This address must be local to a static IPv4 address configured in an interface sub-resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ipv6_gateway VirtualMachine#ipv6_gateway}
    */
    readonly ipv6Gateway?: string;
    /**
    * The amount of time, in minutes, to wait for guest OS customization to complete before returning with an error. Setting this value to 0 or a negative value skips the waiter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#timeout VirtualMachine#timeout}
    */
    readonly timeout?: number;
    /**
    * Use this option to specify a windows sysprep file directly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#windows_sysprep_text VirtualMachine#windows_sysprep_text}
    */
    readonly windowsSysprepText?: string;
    /**
    * linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#linux_options VirtualMachine#linux_options}
    */
    readonly linuxOptions?: VirtualMachineCloneCustomizeLinuxOptions;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#network_interface VirtualMachine#network_interface}
    */
    readonly networkInterface?: VirtualMachineCloneCustomizeNetworkInterface[] | cdktf.IResolvable;
    /**
    * windows_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#windows_options VirtualMachine#windows_options}
    */
    readonly windowsOptions?: VirtualMachineCloneCustomizeWindowsOptions;
}
export declare function virtualMachineCloneCustomizeToTerraform(struct?: VirtualMachineCloneCustomizeOutputReference | VirtualMachineCloneCustomize): any;
export declare class VirtualMachineCloneCustomizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineCloneCustomize | undefined;
    set internalValue(value: VirtualMachineCloneCustomize | undefined);
    private _dnsServerList?;
    get dnsServerList(): string[];
    set dnsServerList(value: string[]);
    resetDnsServerList(): void;
    get dnsServerListInput(): string[] | undefined;
    private _dnsSuffixList?;
    get dnsSuffixList(): string[];
    set dnsSuffixList(value: string[]);
    resetDnsSuffixList(): void;
    get dnsSuffixListInput(): string[] | undefined;
    private _ipv4Gateway?;
    get ipv4Gateway(): string;
    set ipv4Gateway(value: string);
    resetIpv4Gateway(): void;
    get ipv4GatewayInput(): string | undefined;
    private _ipv6Gateway?;
    get ipv6Gateway(): string;
    set ipv6Gateway(value: string);
    resetIpv6Gateway(): void;
    get ipv6GatewayInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _windowsSysprepText?;
    get windowsSysprepText(): string;
    set windowsSysprepText(value: string);
    resetWindowsSysprepText(): void;
    get windowsSysprepTextInput(): string | undefined;
    private _linuxOptions;
    get linuxOptions(): VirtualMachineCloneCustomizeLinuxOptionsOutputReference;
    putLinuxOptions(value: VirtualMachineCloneCustomizeLinuxOptions): void;
    resetLinuxOptions(): void;
    get linuxOptionsInput(): VirtualMachineCloneCustomizeLinuxOptions | undefined;
    private _networkInterface;
    get networkInterface(): VirtualMachineCloneCustomizeNetworkInterfaceList;
    putNetworkInterface(value: VirtualMachineCloneCustomizeNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | VirtualMachineCloneCustomizeNetworkInterface[] | undefined;
    private _windowsOptions;
    get windowsOptions(): VirtualMachineCloneCustomizeWindowsOptionsOutputReference;
    putWindowsOptions(value: VirtualMachineCloneCustomizeWindowsOptions): void;
    resetWindowsOptions(): void;
    get windowsOptionsInput(): VirtualMachineCloneCustomizeWindowsOptions | undefined;
}
export interface VirtualMachineClone {
    /**
    * Whether or not to create a linked clone when cloning. When this option is used, the source VM must have a single snapshot associated with it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#linked_clone VirtualMachine#linked_clone}
    */
    readonly linkedClone?: boolean | cdktf.IResolvable;
    /**
    * Mapping of ovf networks to the networks to use in vSphere.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ovf_network_map VirtualMachine#ovf_network_map}
    */
    readonly ovfNetworkMap?: {
        [key: string]: string;
    };
    /**
    * Mapping of ovf storage to the datastores to use in vSphere.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ovf_storage_map VirtualMachine#ovf_storage_map}
    */
    readonly ovfStorageMap?: {
        [key: string]: string;
    };
    /**
    * The UUID of the source virtual machine or template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#template_uuid VirtualMachine#template_uuid}
    */
    readonly templateUuid: string;
    /**
    * The timeout, in minutes, to wait for the virtual machine clone to complete.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#timeout VirtualMachine#timeout}
    */
    readonly timeout?: number;
    /**
    * customize block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#customize VirtualMachine#customize}
    */
    readonly customize?: VirtualMachineCloneCustomize;
}
export declare function virtualMachineCloneToTerraform(struct?: VirtualMachineCloneOutputReference | VirtualMachineClone): any;
export declare class VirtualMachineCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineClone | undefined;
    set internalValue(value: VirtualMachineClone | undefined);
    private _linkedClone?;
    get linkedClone(): boolean | cdktf.IResolvable;
    set linkedClone(value: boolean | cdktf.IResolvable);
    resetLinkedClone(): void;
    get linkedCloneInput(): boolean | cdktf.IResolvable | undefined;
    private _ovfNetworkMap?;
    get ovfNetworkMap(): {
        [key: string]: string;
    };
    set ovfNetworkMap(value: {
        [key: string]: string;
    });
    resetOvfNetworkMap(): void;
    get ovfNetworkMapInput(): {
        [key: string]: string;
    } | undefined;
    private _ovfStorageMap?;
    get ovfStorageMap(): {
        [key: string]: string;
    };
    set ovfStorageMap(value: {
        [key: string]: string;
    });
    resetOvfStorageMap(): void;
    get ovfStorageMapInput(): {
        [key: string]: string;
    } | undefined;
    private _templateUuid?;
    get templateUuid(): string;
    set templateUuid(value: string);
    get templateUuidInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _customize;
    get customize(): VirtualMachineCloneCustomizeOutputReference;
    putCustomize(value: VirtualMachineCloneCustomize): void;
    resetCustomize(): void;
    get customizeInput(): VirtualMachineCloneCustomize | undefined;
}
export interface VirtualMachineDisk {
    /**
    * If this is true, the disk is attached instead of created. Implies keep_on_remove.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#attach VirtualMachine#attach}
    */
    readonly attach?: boolean | cdktf.IResolvable;
    /**
    * The type of controller the disk should be connected to. Must be 'scsi', 'sata', or 'ide'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#controller_type VirtualMachine#controller_type}
    */
    readonly controllerType?: string;
    /**
    * The datastore ID for this virtual disk, if different than the virtual machine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#datastore_id VirtualMachine#datastore_id}
    */
    readonly datastoreId?: string;
    /**
    * The mode of this this virtual disk for purposes of writes and snapshotting. Can be one of append, independent_nonpersistent, independent_persistent, nonpersistent, persistent, or undoable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#disk_mode VirtualMachine#disk_mode}
    */
    readonly diskMode?: string;
    /**
    * The sharing mode of this virtual disk. Can be one of sharingMultiWriter or sharingNone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#disk_sharing VirtualMachine#disk_sharing}
    */
    readonly diskSharing?: string;
    /**
    * The virtual disk file zeroing policy when thin_provision is not true. The default is false, which lazily-zeros the disk, speeding up thick-provisioned disk creation time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#eagerly_scrub VirtualMachine#eagerly_scrub}
    */
    readonly eagerlyScrub?: boolean | cdktf.IResolvable;
    /**
    * The upper limit of IOPS that this disk can use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#io_limit VirtualMachine#io_limit}
    */
    readonly ioLimit?: number;
    /**
    * The I/O guarantee that this disk has, in IOPS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#io_reservation VirtualMachine#io_reservation}
    */
    readonly ioReservation?: number;
    /**
    * The share count for this disk when the share level is custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#io_share_count VirtualMachine#io_share_count}
    */
    readonly ioShareCount?: number;
    /**
    * The share allocation level for this disk. Can be one of low, normal, high, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#io_share_level VirtualMachine#io_share_level}
    */
    readonly ioShareLevel?: string;
    /**
    * Set to true to keep the underlying VMDK file when removing this virtual disk from configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#keep_on_remove VirtualMachine#keep_on_remove}
    */
    readonly keepOnRemove?: boolean | cdktf.IResolvable;
    /**
    * A unique label for this disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#label VirtualMachine#label}
    */
    readonly label: string;
    /**
    * The full path of the virtual disk. This can only be provided if attach is set to true, otherwise it is a read-only value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#path VirtualMachine#path}
    */
    readonly path?: string;
    /**
    * The size of the disk, in GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#size VirtualMachine#size}
    */
    readonly size?: number;
    /**
    * The ID of the storage policy to assign to the virtual disk in VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#storage_policy_id VirtualMachine#storage_policy_id}
    */
    readonly storagePolicyId?: string;
    /**
    * If true, this disk is thin provisioned, with space for the file being allocated on an as-needed basis.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#thin_provisioned VirtualMachine#thin_provisioned}
    */
    readonly thinProvisioned?: boolean | cdktf.IResolvable;
    /**
    * The unique device number for this disk. This number determines where on the SCSI bus this device will be attached.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#unit_number VirtualMachine#unit_number}
    */
    readonly unitNumber?: number;
    /**
    * If true, writes for this disk are sent directly to the filesystem immediately instead of being buffered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#write_through VirtualMachine#write_through}
    */
    readonly writeThrough?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineDiskToTerraform(struct?: VirtualMachineDisk | cdktf.IResolvable): any;
export declare class VirtualMachineDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineDisk | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineDisk | cdktf.IResolvable | undefined);
    private _attach?;
    get attach(): boolean | cdktf.IResolvable;
    set attach(value: boolean | cdktf.IResolvable);
    resetAttach(): void;
    get attachInput(): boolean | cdktf.IResolvable | undefined;
    private _controllerType?;
    get controllerType(): string;
    set controllerType(value: string);
    resetControllerType(): void;
    get controllerTypeInput(): string | undefined;
    private _datastoreId?;
    get datastoreId(): string;
    set datastoreId(value: string);
    resetDatastoreId(): void;
    get datastoreIdInput(): string | undefined;
    get deviceAddress(): string;
    private _diskMode?;
    get diskMode(): string;
    set diskMode(value: string);
    resetDiskMode(): void;
    get diskModeInput(): string | undefined;
    private _diskSharing?;
    get diskSharing(): string;
    set diskSharing(value: string);
    resetDiskSharing(): void;
    get diskSharingInput(): string | undefined;
    private _eagerlyScrub?;
    get eagerlyScrub(): boolean | cdktf.IResolvable;
    set eagerlyScrub(value: boolean | cdktf.IResolvable);
    resetEagerlyScrub(): void;
    get eagerlyScrubInput(): boolean | cdktf.IResolvable | undefined;
    private _ioLimit?;
    get ioLimit(): number;
    set ioLimit(value: number);
    resetIoLimit(): void;
    get ioLimitInput(): number | undefined;
    private _ioReservation?;
    get ioReservation(): number;
    set ioReservation(value: number);
    resetIoReservation(): void;
    get ioReservationInput(): number | undefined;
    private _ioShareCount?;
    get ioShareCount(): number;
    set ioShareCount(value: number);
    resetIoShareCount(): void;
    get ioShareCountInput(): number | undefined;
    private _ioShareLevel?;
    get ioShareLevel(): string;
    set ioShareLevel(value: string);
    resetIoShareLevel(): void;
    get ioShareLevelInput(): string | undefined;
    private _keepOnRemove?;
    get keepOnRemove(): boolean | cdktf.IResolvable;
    set keepOnRemove(value: boolean | cdktf.IResolvable);
    resetKeepOnRemove(): void;
    get keepOnRemoveInput(): boolean | cdktf.IResolvable | undefined;
    get key(): number;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _storagePolicyId?;
    get storagePolicyId(): string;
    set storagePolicyId(value: string);
    resetStoragePolicyId(): void;
    get storagePolicyIdInput(): string | undefined;
    private _thinProvisioned?;
    get thinProvisioned(): boolean | cdktf.IResolvable;
    set thinProvisioned(value: boolean | cdktf.IResolvable);
    resetThinProvisioned(): void;
    get thinProvisionedInput(): boolean | cdktf.IResolvable | undefined;
    private _unitNumber?;
    get unitNumber(): number;
    set unitNumber(value: number);
    resetUnitNumber(): void;
    get unitNumberInput(): number | undefined;
    get uuid(): string;
    private _writeThrough?;
    get writeThrough(): boolean | cdktf.IResolvable;
    set writeThrough(value: boolean | cdktf.IResolvable);
    resetWriteThrough(): void;
    get writeThroughInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class VirtualMachineDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineDiskOutputReference;
}
export interface VirtualMachineNetworkInterface {
    /**
    * The controller type. Can be one of e1000, e1000e, vmxnet3, or vrdma.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#adapter_type VirtualMachine#adapter_type}
    */
    readonly adapterType?: string;
    /**
    * The upper bandwidth limit of this network interface, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#bandwidth_limit VirtualMachine#bandwidth_limit}
    */
    readonly bandwidthLimit?: number;
    /**
    * The bandwidth reservation of this network interface, in Mbits/sec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#bandwidth_reservation VirtualMachine#bandwidth_reservation}
    */
    readonly bandwidthReservation?: number;
    /**
    * The share count for this network interface when the share level is custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#bandwidth_share_count VirtualMachine#bandwidth_share_count}
    */
    readonly bandwidthShareCount?: number;
    /**
    * The bandwidth share allocation level for this interface. Can be one of low, normal, high, or custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#bandwidth_share_level VirtualMachine#bandwidth_share_level}
    */
    readonly bandwidthShareLevel?: string;
    /**
    * The MAC address of this network interface. Can only be manually set if use_static_mac is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#mac_address VirtualMachine#mac_address}
    */
    readonly macAddress?: string;
    /**
    * The ID of the network to connect this network interface to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#network_id VirtualMachine#network_id}
    */
    readonly networkId: string;
    /**
    * Mapping of network interface to OVF network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ovf_mapping VirtualMachine#ovf_mapping}
    */
    readonly ovfMapping?: string;
    /**
    * If true, the mac_address field is treated as a static MAC address and set accordingly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#use_static_mac VirtualMachine#use_static_mac}
    */
    readonly useStaticMac?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineNetworkInterfaceToTerraform(struct?: VirtualMachineNetworkInterface | cdktf.IResolvable): any;
export declare class VirtualMachineNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineNetworkInterface | cdktf.IResolvable | undefined);
    private _adapterType?;
    get adapterType(): string;
    set adapterType(value: string);
    resetAdapterType(): void;
    get adapterTypeInput(): string | undefined;
    private _bandwidthLimit?;
    get bandwidthLimit(): number;
    set bandwidthLimit(value: number);
    resetBandwidthLimit(): void;
    get bandwidthLimitInput(): number | undefined;
    private _bandwidthReservation?;
    get bandwidthReservation(): number;
    set bandwidthReservation(value: number);
    resetBandwidthReservation(): void;
    get bandwidthReservationInput(): number | undefined;
    private _bandwidthShareCount?;
    get bandwidthShareCount(): number;
    set bandwidthShareCount(value: number);
    resetBandwidthShareCount(): void;
    get bandwidthShareCountInput(): number | undefined;
    private _bandwidthShareLevel?;
    get bandwidthShareLevel(): string;
    set bandwidthShareLevel(value: string);
    resetBandwidthShareLevel(): void;
    get bandwidthShareLevelInput(): string | undefined;
    get deviceAddress(): string;
    get key(): number;
    private _macAddress?;
    get macAddress(): string;
    set macAddress(value: string);
    resetMacAddress(): void;
    get macAddressInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    private _ovfMapping?;
    get ovfMapping(): string;
    set ovfMapping(value: string);
    resetOvfMapping(): void;
    get ovfMappingInput(): string | undefined;
    private _useStaticMac?;
    get useStaticMac(): boolean | cdktf.IResolvable;
    set useStaticMac(value: boolean | cdktf.IResolvable);
    resetUseStaticMac(): void;
    get useStaticMacInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class VirtualMachineNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineNetworkInterfaceOutputReference;
}
export interface VirtualMachineOvfDeploy {
    /**
    * Allow unverified ssl certificates while deploying ovf/ova from url.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#allow_unverified_ssl_cert VirtualMachine#allow_unverified_ssl_cert}
    */
    readonly allowUnverifiedSslCert?: boolean | cdktf.IResolvable;
    /**
    * The Deployment option to be chosen. If empty, the default option is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#deployment_option VirtualMachine#deployment_option}
    */
    readonly deploymentOption?: string;
    /**
    * An optional disk provisioning. If set, all the disks in the deployed ovf will have the same specified disk type (e.g., thin provisioned).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#disk_provisioning VirtualMachine#disk_provisioning}
    */
    readonly diskProvisioning?: string;
    /**
    * Allow properties with ovf:userConfigurable=false to be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#enable_hidden_properties VirtualMachine#enable_hidden_properties}
    */
    readonly enableHiddenProperties?: boolean | cdktf.IResolvable;
    /**
    * The IP allocation policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ip_allocation_policy VirtualMachine#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: string;
    /**
    * The IP protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ip_protocol VirtualMachine#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * The absolute path to the ovf/ova file in the local system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#local_ovf_path VirtualMachine#local_ovf_path}
    */
    readonly localOvfPath?: string;
    /**
    * The mapping of name of network identifiers from the ovf descriptor to network UUID in the VI infrastructure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#ovf_network_map VirtualMachine#ovf_network_map}
    */
    readonly ovfNetworkMap?: {
        [key: string]: string;
    };
    /**
    * URL to the remote ovf/ova file to be deployed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#remote_ovf_url VirtualMachine#remote_ovf_url}
    */
    readonly remoteOvfUrl?: string;
}
export declare function virtualMachineOvfDeployToTerraform(struct?: VirtualMachineOvfDeployOutputReference | VirtualMachineOvfDeploy): any;
export declare class VirtualMachineOvfDeployOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineOvfDeploy | undefined;
    set internalValue(value: VirtualMachineOvfDeploy | undefined);
    private _allowUnverifiedSslCert?;
    get allowUnverifiedSslCert(): boolean | cdktf.IResolvable;
    set allowUnverifiedSslCert(value: boolean | cdktf.IResolvable);
    resetAllowUnverifiedSslCert(): void;
    get allowUnverifiedSslCertInput(): boolean | cdktf.IResolvable | undefined;
    private _deploymentOption?;
    get deploymentOption(): string;
    set deploymentOption(value: string);
    resetDeploymentOption(): void;
    get deploymentOptionInput(): string | undefined;
    private _diskProvisioning?;
    get diskProvisioning(): string;
    set diskProvisioning(value: string);
    resetDiskProvisioning(): void;
    get diskProvisioningInput(): string | undefined;
    private _enableHiddenProperties?;
    get enableHiddenProperties(): boolean | cdktf.IResolvable;
    set enableHiddenProperties(value: boolean | cdktf.IResolvable);
    resetEnableHiddenProperties(): void;
    get enableHiddenPropertiesInput(): boolean | cdktf.IResolvable | undefined;
    private _ipAllocationPolicy?;
    get ipAllocationPolicy(): string;
    set ipAllocationPolicy(value: string);
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _localOvfPath?;
    get localOvfPath(): string;
    set localOvfPath(value: string);
    resetLocalOvfPath(): void;
    get localOvfPathInput(): string | undefined;
    private _ovfNetworkMap?;
    get ovfNetworkMap(): {
        [key: string]: string;
    };
    set ovfNetworkMap(value: {
        [key: string]: string;
    });
    resetOvfNetworkMap(): void;
    get ovfNetworkMapInput(): {
        [key: string]: string;
    } | undefined;
    private _remoteOvfUrl?;
    get remoteOvfUrl(): string;
    set remoteOvfUrl(value: string);
    resetRemoteOvfUrl(): void;
    get remoteOvfUrlInput(): string | undefined;
}
export interface VirtualMachineVapp {
    /**
    * A map of customizable vApp properties and their values. Allows customization of VMs cloned from OVF templates which have customizable vApp properties.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine#properties VirtualMachine#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function virtualMachineVappToTerraform(struct?: VirtualMachineVappOutputReference | VirtualMachineVapp): any;
export declare class VirtualMachineVappOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineVapp | undefined;
    set internalValue(value: VirtualMachineVapp | undefined);
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine vsphere_virtual_machine}
*/
export declare class VirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_virtual_machine";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/virtual_machine vsphere_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineConfig);
    private _alternateGuestName?;
    get alternateGuestName(): string;
    set alternateGuestName(value: string);
    resetAlternateGuestName(): void;
    get alternateGuestNameInput(): string | undefined;
    private _annotation?;
    get annotation(): string;
    set annotation(value: string);
    resetAnnotation(): void;
    get annotationInput(): string | undefined;
    private _bootDelay?;
    get bootDelay(): number;
    set bootDelay(value: number);
    resetBootDelay(): void;
    get bootDelayInput(): number | undefined;
    private _bootRetryDelay?;
    get bootRetryDelay(): number;
    set bootRetryDelay(value: number);
    resetBootRetryDelay(): void;
    get bootRetryDelayInput(): number | undefined;
    private _bootRetryEnabled?;
    get bootRetryEnabled(): boolean | cdktf.IResolvable;
    set bootRetryEnabled(value: boolean | cdktf.IResolvable);
    resetBootRetryEnabled(): void;
    get bootRetryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get changeVersion(): string;
    private _cpuHotAddEnabled?;
    get cpuHotAddEnabled(): boolean | cdktf.IResolvable;
    set cpuHotAddEnabled(value: boolean | cdktf.IResolvable);
    resetCpuHotAddEnabled(): void;
    get cpuHotAddEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuHotRemoveEnabled?;
    get cpuHotRemoveEnabled(): boolean | cdktf.IResolvable;
    set cpuHotRemoveEnabled(value: boolean | cdktf.IResolvable);
    resetCpuHotRemoveEnabled(): void;
    get cpuHotRemoveEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuLimit?;
    get cpuLimit(): number;
    set cpuLimit(value: number);
    resetCpuLimit(): void;
    get cpuLimitInput(): number | undefined;
    private _cpuPerformanceCountersEnabled?;
    get cpuPerformanceCountersEnabled(): boolean | cdktf.IResolvable;
    set cpuPerformanceCountersEnabled(value: boolean | cdktf.IResolvable);
    resetCpuPerformanceCountersEnabled(): void;
    get cpuPerformanceCountersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuReservation?;
    get cpuReservation(): number;
    set cpuReservation(value: number);
    resetCpuReservation(): void;
    get cpuReservationInput(): number | undefined;
    private _cpuShareCount?;
    get cpuShareCount(): number;
    set cpuShareCount(value: number);
    resetCpuShareCount(): void;
    get cpuShareCountInput(): number | undefined;
    private _cpuShareLevel?;
    get cpuShareLevel(): string;
    set cpuShareLevel(value: string);
    resetCpuShareLevel(): void;
    get cpuShareLevelInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    resetDatacenterId(): void;
    get datacenterIdInput(): string | undefined;
    private _datastoreClusterId?;
    get datastoreClusterId(): string;
    set datastoreClusterId(value: string);
    resetDatastoreClusterId(): void;
    get datastoreClusterIdInput(): string | undefined;
    private _datastoreId?;
    get datastoreId(): string;
    set datastoreId(value: string);
    resetDatastoreId(): void;
    get datastoreIdInput(): string | undefined;
    get defaultIpAddress(): string;
    private _efiSecureBootEnabled?;
    get efiSecureBootEnabled(): boolean | cdktf.IResolvable;
    set efiSecureBootEnabled(value: boolean | cdktf.IResolvable);
    resetEfiSecureBootEnabled(): void;
    get efiSecureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDiskUuid?;
    get enableDiskUuid(): boolean | cdktf.IResolvable;
    set enableDiskUuid(value: boolean | cdktf.IResolvable);
    resetEnableDiskUuid(): void;
    get enableDiskUuidInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _eptRviMode?;
    get eptRviMode(): string;
    set eptRviMode(value: string);
    resetEptRviMode(): void;
    get eptRviModeInput(): string | undefined;
    private _extraConfig?;
    get extraConfig(): {
        [key: string]: string;
    };
    set extraConfig(value: {
        [key: string]: string;
    });
    resetExtraConfig(): void;
    get extraConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _extraConfigRebootRequired?;
    get extraConfigRebootRequired(): boolean | cdktf.IResolvable;
    set extraConfigRebootRequired(value: boolean | cdktf.IResolvable);
    resetExtraConfigRebootRequired(): void;
    get extraConfigRebootRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _firmware?;
    get firmware(): string;
    set firmware(value: string);
    resetFirmware(): void;
    get firmwareInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _forcePowerOff?;
    get forcePowerOff(): boolean | cdktf.IResolvable;
    set forcePowerOff(value: boolean | cdktf.IResolvable);
    resetForcePowerOff(): void;
    get forcePowerOffInput(): boolean | cdktf.IResolvable | undefined;
    private _guestId?;
    get guestId(): string;
    set guestId(value: string);
    resetGuestId(): void;
    get guestIdInput(): string | undefined;
    get guestIpAddresses(): string[];
    private _hardwareVersion?;
    get hardwareVersion(): number;
    set hardwareVersion(value: number);
    resetHardwareVersion(): void;
    get hardwareVersionInput(): number | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    resetHostSystemId(): void;
    get hostSystemIdInput(): string | undefined;
    private _hvMode?;
    get hvMode(): string;
    set hvMode(value: string);
    resetHvMode(): void;
    get hvModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ideControllerCount?;
    get ideControllerCount(): number;
    set ideControllerCount(value: number);
    resetIdeControllerCount(): void;
    get ideControllerCountInput(): number | undefined;
    private _ignoredGuestIps?;
    get ignoredGuestIps(): string[];
    set ignoredGuestIps(value: string[]);
    resetIgnoredGuestIps(): void;
    get ignoredGuestIpsInput(): string[] | undefined;
    get imported(): cdktf.IResolvable;
    private _latencySensitivity?;
    get latencySensitivity(): string;
    set latencySensitivity(value: string);
    resetLatencySensitivity(): void;
    get latencySensitivityInput(): string | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _memoryHotAddEnabled?;
    get memoryHotAddEnabled(): boolean | cdktf.IResolvable;
    set memoryHotAddEnabled(value: boolean | cdktf.IResolvable);
    resetMemoryHotAddEnabled(): void;
    get memoryHotAddEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _memoryLimit?;
    get memoryLimit(): number;
    set memoryLimit(value: number);
    resetMemoryLimit(): void;
    get memoryLimitInput(): number | undefined;
    private _memoryReservation?;
    get memoryReservation(): number;
    set memoryReservation(value: number);
    resetMemoryReservation(): void;
    get memoryReservationInput(): number | undefined;
    private _memoryShareCount?;
    get memoryShareCount(): number;
    set memoryShareCount(value: number);
    resetMemoryShareCount(): void;
    get memoryShareCountInput(): number | undefined;
    private _memoryShareLevel?;
    get memoryShareLevel(): string;
    set memoryShareLevel(value: string);
    resetMemoryShareLevel(): void;
    get memoryShareLevelInput(): string | undefined;
    private _migrateWaitTimeout?;
    get migrateWaitTimeout(): number;
    set migrateWaitTimeout(value: number);
    resetMigrateWaitTimeout(): void;
    get migrateWaitTimeoutInput(): number | undefined;
    get moid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nestedHvEnabled?;
    get nestedHvEnabled(): boolean | cdktf.IResolvable;
    set nestedHvEnabled(value: boolean | cdktf.IResolvable);
    resetNestedHvEnabled(): void;
    get nestedHvEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _numCoresPerSocket?;
    get numCoresPerSocket(): number;
    set numCoresPerSocket(value: number);
    resetNumCoresPerSocket(): void;
    get numCoresPerSocketInput(): number | undefined;
    private _numCpus?;
    get numCpus(): number;
    set numCpus(value: number);
    resetNumCpus(): void;
    get numCpusInput(): number | undefined;
    private _pciDeviceId?;
    get pciDeviceId(): string[];
    set pciDeviceId(value: string[]);
    resetPciDeviceId(): void;
    get pciDeviceIdInput(): string[] | undefined;
    get powerState(): string;
    private _poweronTimeout?;
    get poweronTimeout(): number;
    set poweronTimeout(value: number);
    resetPoweronTimeout(): void;
    get poweronTimeoutInput(): number | undefined;
    get rebootRequired(): cdktf.IResolvable;
    private _replaceTrigger?;
    get replaceTrigger(): string;
    set replaceTrigger(value: string);
    resetReplaceTrigger(): void;
    get replaceTriggerInput(): string | undefined;
    private _resourcePoolId?;
    get resourcePoolId(): string;
    set resourcePoolId(value: string);
    get resourcePoolIdInput(): string | undefined;
    private _runToolsScriptsAfterPowerOn?;
    get runToolsScriptsAfterPowerOn(): boolean | cdktf.IResolvable;
    set runToolsScriptsAfterPowerOn(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsAfterPowerOn(): void;
    get runToolsScriptsAfterPowerOnInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsAfterResume?;
    get runToolsScriptsAfterResume(): boolean | cdktf.IResolvable;
    set runToolsScriptsAfterResume(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsAfterResume(): void;
    get runToolsScriptsAfterResumeInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestReboot?;
    get runToolsScriptsBeforeGuestReboot(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestReboot(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestReboot(): void;
    get runToolsScriptsBeforeGuestRebootInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestShutdown?;
    get runToolsScriptsBeforeGuestShutdown(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestShutdown(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestShutdown(): void;
    get runToolsScriptsBeforeGuestShutdownInput(): boolean | cdktf.IResolvable | undefined;
    private _runToolsScriptsBeforeGuestStandby?;
    get runToolsScriptsBeforeGuestStandby(): boolean | cdktf.IResolvable;
    set runToolsScriptsBeforeGuestStandby(value: boolean | cdktf.IResolvable);
    resetRunToolsScriptsBeforeGuestStandby(): void;
    get runToolsScriptsBeforeGuestStandbyInput(): boolean | cdktf.IResolvable | undefined;
    private _sataControllerCount?;
    get sataControllerCount(): number;
    set sataControllerCount(value: number);
    resetSataControllerCount(): void;
    get sataControllerCountInput(): number | undefined;
    private _scsiBusSharing?;
    get scsiBusSharing(): string;
    set scsiBusSharing(value: string);
    resetScsiBusSharing(): void;
    get scsiBusSharingInput(): string | undefined;
    private _scsiControllerCount?;
    get scsiControllerCount(): number;
    set scsiControllerCount(value: number);
    resetScsiControllerCount(): void;
    get scsiControllerCountInput(): number | undefined;
    private _scsiType?;
    get scsiType(): string;
    set scsiType(value: string);
    resetScsiType(): void;
    get scsiTypeInput(): string | undefined;
    private _shutdownWaitTimeout?;
    get shutdownWaitTimeout(): number;
    set shutdownWaitTimeout(value: number);
    resetShutdownWaitTimeout(): void;
    get shutdownWaitTimeoutInput(): number | undefined;
    private _storagePolicyId?;
    get storagePolicyId(): string;
    set storagePolicyId(value: string);
    resetStoragePolicyId(): void;
    get storagePolicyIdInput(): string | undefined;
    private _swapPlacementPolicy?;
    get swapPlacementPolicy(): string;
    set swapPlacementPolicy(value: string);
    resetSwapPlacementPolicy(): void;
    get swapPlacementPolicyInput(): string | undefined;
    private _syncTimeWithHost?;
    get syncTimeWithHost(): boolean | cdktf.IResolvable;
    set syncTimeWithHost(value: boolean | cdktf.IResolvable);
    resetSyncTimeWithHost(): void;
    get syncTimeWithHostInput(): boolean | cdktf.IResolvable | undefined;
    private _syncTimeWithHostPeriodically?;
    get syncTimeWithHostPeriodically(): boolean | cdktf.IResolvable;
    set syncTimeWithHostPeriodically(value: boolean | cdktf.IResolvable);
    resetSyncTimeWithHostPeriodically(): void;
    get syncTimeWithHostPeriodicallyInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _toolsUpgradePolicy?;
    get toolsUpgradePolicy(): string;
    set toolsUpgradePolicy(value: string);
    resetToolsUpgradePolicy(): void;
    get toolsUpgradePolicyInput(): string | undefined;
    get uuid(): string;
    get vappTransport(): string[];
    private _vbsEnabled?;
    get vbsEnabled(): boolean | cdktf.IResolvable;
    set vbsEnabled(value: boolean | cdktf.IResolvable);
    resetVbsEnabled(): void;
    get vbsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get vmwareToolsStatus(): string;
    get vmxPath(): string;
    private _vvtdEnabled?;
    get vvtdEnabled(): boolean | cdktf.IResolvable;
    set vvtdEnabled(value: boolean | cdktf.IResolvable);
    resetVvtdEnabled(): void;
    get vvtdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForGuestIpTimeout?;
    get waitForGuestIpTimeout(): number;
    set waitForGuestIpTimeout(value: number);
    resetWaitForGuestIpTimeout(): void;
    get waitForGuestIpTimeoutInput(): number | undefined;
    private _waitForGuestNetRoutable?;
    get waitForGuestNetRoutable(): boolean | cdktf.IResolvable;
    set waitForGuestNetRoutable(value: boolean | cdktf.IResolvable);
    resetWaitForGuestNetRoutable(): void;
    get waitForGuestNetRoutableInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForGuestNetTimeout?;
    get waitForGuestNetTimeout(): number;
    set waitForGuestNetTimeout(value: number);
    resetWaitForGuestNetTimeout(): void;
    get waitForGuestNetTimeoutInput(): number | undefined;
    private _cdrom;
    get cdrom(): VirtualMachineCdromList;
    putCdrom(value: VirtualMachineCdrom[] | cdktf.IResolvable): void;
    resetCdrom(): void;
    get cdromInput(): cdktf.IResolvable | VirtualMachineCdrom[] | undefined;
    private _clone;
    get clone(): VirtualMachineCloneOutputReference;
    putClone(value: VirtualMachineClone): void;
    resetClone(): void;
    get cloneInput(): VirtualMachineClone | undefined;
    private _disk;
    get disk(): VirtualMachineDiskList;
    putDisk(value: VirtualMachineDisk[] | cdktf.IResolvable): void;
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | VirtualMachineDisk[] | undefined;
    private _networkInterface;
    get networkInterface(): VirtualMachineNetworkInterfaceList;
    putNetworkInterface(value: VirtualMachineNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | VirtualMachineNetworkInterface[] | undefined;
    private _ovfDeploy;
    get ovfDeploy(): VirtualMachineOvfDeployOutputReference;
    putOvfDeploy(value: VirtualMachineOvfDeploy): void;
    resetOvfDeploy(): void;
    get ovfDeployInput(): VirtualMachineOvfDeploy | undefined;
    private _vapp;
    get vapp(): VirtualMachineVappOutputReference;
    putVapp(value: VirtualMachineVapp): void;
    resetVapp(): void;
    get vappInput(): VirtualMachineVapp | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
