"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostVirtualSwitch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch vsphere_host_virtual_switch}
*/
class HostVirtualSwitch extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch vsphere_host_virtual_switch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostVirtualSwitchConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_host_virtual_switch',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.3.1',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._activeNics = config.activeNics;
        this._allowForgedTransmits = config.allowForgedTransmits;
        this._allowMacChanges = config.allowMacChanges;
        this._allowPromiscuous = config.allowPromiscuous;
        this._beaconInterval = config.beaconInterval;
        this._checkBeacon = config.checkBeacon;
        this._failback = config.failback;
        this._hostSystemId = config.hostSystemId;
        this._id = config.id;
        this._linkDiscoveryOperation = config.linkDiscoveryOperation;
        this._linkDiscoveryProtocol = config.linkDiscoveryProtocol;
        this._mtu = config.mtu;
        this._name = config.name;
        this._networkAdapters = config.networkAdapters;
        this._notifySwitches = config.notifySwitches;
        this._numberOfPorts = config.numberOfPorts;
        this._shapingAverageBandwidth = config.shapingAverageBandwidth;
        this._shapingBurstSize = config.shapingBurstSize;
        this._shapingEnabled = config.shapingEnabled;
        this._shapingPeakBandwidth = config.shapingPeakBandwidth;
        this._standbyNics = config.standbyNics;
        this._teamingPolicy = config.teamingPolicy;
    }
    get activeNics() {
        return this.getListAttribute('active_nics');
    }
    set activeNics(value) {
        this._activeNics = value;
    }
    // Temporarily expose input value. Use with caution.
    get activeNicsInput() {
        return this._activeNics;
    }
    get allowForgedTransmits() {
        return this.getBooleanAttribute('allow_forged_transmits');
    }
    set allowForgedTransmits(value) {
        this._allowForgedTransmits = value;
    }
    resetAllowForgedTransmits() {
        this._allowForgedTransmits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowForgedTransmitsInput() {
        return this._allowForgedTransmits;
    }
    get allowMacChanges() {
        return this.getBooleanAttribute('allow_mac_changes');
    }
    set allowMacChanges(value) {
        this._allowMacChanges = value;
    }
    resetAllowMacChanges() {
        this._allowMacChanges = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMacChangesInput() {
        return this._allowMacChanges;
    }
    get allowPromiscuous() {
        return this.getBooleanAttribute('allow_promiscuous');
    }
    set allowPromiscuous(value) {
        this._allowPromiscuous = value;
    }
    resetAllowPromiscuous() {
        this._allowPromiscuous = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPromiscuousInput() {
        return this._allowPromiscuous;
    }
    get beaconInterval() {
        return this.getNumberAttribute('beacon_interval');
    }
    set beaconInterval(value) {
        this._beaconInterval = value;
    }
    resetBeaconInterval() {
        this._beaconInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get beaconIntervalInput() {
        return this._beaconInterval;
    }
    get checkBeacon() {
        return this.getBooleanAttribute('check_beacon');
    }
    set checkBeacon(value) {
        this._checkBeacon = value;
    }
    resetCheckBeacon() {
        this._checkBeacon = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkBeaconInput() {
        return this._checkBeacon;
    }
    get failback() {
        return this.getBooleanAttribute('failback');
    }
    set failback(value) {
        this._failback = value;
    }
    resetFailback() {
        this._failback = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failbackInput() {
        return this._failback;
    }
    get hostSystemId() {
        return this.getStringAttribute('host_system_id');
    }
    set hostSystemId(value) {
        this._hostSystemId = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdInput() {
        return this._hostSystemId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get linkDiscoveryOperation() {
        return this.getStringAttribute('link_discovery_operation');
    }
    set linkDiscoveryOperation(value) {
        this._linkDiscoveryOperation = value;
    }
    resetLinkDiscoveryOperation() {
        this._linkDiscoveryOperation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linkDiscoveryOperationInput() {
        return this._linkDiscoveryOperation;
    }
    get linkDiscoveryProtocol() {
        return this.getStringAttribute('link_discovery_protocol');
    }
    set linkDiscoveryProtocol(value) {
        this._linkDiscoveryProtocol = value;
    }
    resetLinkDiscoveryProtocol() {
        this._linkDiscoveryProtocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linkDiscoveryProtocolInput() {
        return this._linkDiscoveryProtocol;
    }
    get mtu() {
        return this.getNumberAttribute('mtu');
    }
    set mtu(value) {
        this._mtu = value;
    }
    resetMtu() {
        this._mtu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mtuInput() {
        return this._mtu;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get networkAdapters() {
        return this.getListAttribute('network_adapters');
    }
    set networkAdapters(value) {
        this._networkAdapters = value;
    }
    // Temporarily expose input value. Use with caution.
    get networkAdaptersInput() {
        return this._networkAdapters;
    }
    get notifySwitches() {
        return this.getBooleanAttribute('notify_switches');
    }
    set notifySwitches(value) {
        this._notifySwitches = value;
    }
    resetNotifySwitches() {
        this._notifySwitches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifySwitchesInput() {
        return this._notifySwitches;
    }
    get numberOfPorts() {
        return this.getNumberAttribute('number_of_ports');
    }
    set numberOfPorts(value) {
        this._numberOfPorts = value;
    }
    resetNumberOfPorts() {
        this._numberOfPorts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numberOfPortsInput() {
        return this._numberOfPorts;
    }
    get shapingAverageBandwidth() {
        return this.getNumberAttribute('shaping_average_bandwidth');
    }
    set shapingAverageBandwidth(value) {
        this._shapingAverageBandwidth = value;
    }
    resetShapingAverageBandwidth() {
        this._shapingAverageBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingAverageBandwidthInput() {
        return this._shapingAverageBandwidth;
    }
    get shapingBurstSize() {
        return this.getNumberAttribute('shaping_burst_size');
    }
    set shapingBurstSize(value) {
        this._shapingBurstSize = value;
    }
    resetShapingBurstSize() {
        this._shapingBurstSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingBurstSizeInput() {
        return this._shapingBurstSize;
    }
    get shapingEnabled() {
        return this.getBooleanAttribute('shaping_enabled');
    }
    set shapingEnabled(value) {
        this._shapingEnabled = value;
    }
    resetShapingEnabled() {
        this._shapingEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingEnabledInput() {
        return this._shapingEnabled;
    }
    get shapingPeakBandwidth() {
        return this.getNumberAttribute('shaping_peak_bandwidth');
    }
    set shapingPeakBandwidth(value) {
        this._shapingPeakBandwidth = value;
    }
    resetShapingPeakBandwidth() {
        this._shapingPeakBandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shapingPeakBandwidthInput() {
        return this._shapingPeakBandwidth;
    }
    get standbyNics() {
        return this.getListAttribute('standby_nics');
    }
    set standbyNics(value) {
        this._standbyNics = value;
    }
    resetStandbyNics() {
        this._standbyNics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get standbyNicsInput() {
        return this._standbyNics;
    }
    get teamingPolicy() {
        return this.getStringAttribute('teaming_policy');
    }
    set teamingPolicy(value) {
        this._teamingPolicy = value;
    }
    resetTeamingPolicy() {
        this._teamingPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get teamingPolicyInput() {
        return this._teamingPolicy;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            active_nics: cdktf.listMapper(cdktf.stringToTerraform, false)(this._activeNics),
            allow_forged_transmits: cdktf.booleanToTerraform(this._allowForgedTransmits),
            allow_mac_changes: cdktf.booleanToTerraform(this._allowMacChanges),
            allow_promiscuous: cdktf.booleanToTerraform(this._allowPromiscuous),
            beacon_interval: cdktf.numberToTerraform(this._beaconInterval),
            check_beacon: cdktf.booleanToTerraform(this._checkBeacon),
            failback: cdktf.booleanToTerraform(this._failback),
            host_system_id: cdktf.stringToTerraform(this._hostSystemId),
            id: cdktf.stringToTerraform(this._id),
            link_discovery_operation: cdktf.stringToTerraform(this._linkDiscoveryOperation),
            link_discovery_protocol: cdktf.stringToTerraform(this._linkDiscoveryProtocol),
            mtu: cdktf.numberToTerraform(this._mtu),
            name: cdktf.stringToTerraform(this._name),
            network_adapters: cdktf.listMapper(cdktf.stringToTerraform, false)(this._networkAdapters),
            notify_switches: cdktf.booleanToTerraform(this._notifySwitches),
            number_of_ports: cdktf.numberToTerraform(this._numberOfPorts),
            shaping_average_bandwidth: cdktf.numberToTerraform(this._shapingAverageBandwidth),
            shaping_burst_size: cdktf.numberToTerraform(this._shapingBurstSize),
            shaping_enabled: cdktf.booleanToTerraform(this._shapingEnabled),
            shaping_peak_bandwidth: cdktf.numberToTerraform(this._shapingPeakBandwidth),
            standby_nics: cdktf.listMapper(cdktf.stringToTerraform, false)(this._standbyNics),
            teaming_policy: cdktf.stringToTerraform(this._teamingPolicy),
        };
    }
}
exports.HostVirtualSwitch = HostVirtualSwitch;
_a = JSII_RTTI_SYMBOL_1;
HostVirtualSwitch[_a] = { fqn: "@cdktf/provider-vsphere.hostVirtualSwitch.HostVirtualSwitch", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
HostVirtualSwitch.tfResourceType = "vsphere_host_virtual_switch";
//# sourceMappingURL=data:application/json;base64,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