import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HostVirtualSwitchConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of active network adapters used for load balancing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#active_nics HostVirtualSwitch#active_nics}
    */
    readonly activeNics: string[];
    /**
    * Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than that of its own.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#allow_forged_transmits HostVirtualSwitch#allow_forged_transmits}
    */
    readonly allowForgedTransmits?: boolean | cdktf.IResolvable;
    /**
    * Controls whether or not the Media Access Control (MAC) address can be changed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#allow_mac_changes HostVirtualSwitch#allow_mac_changes}
    */
    readonly allowMacChanges?: boolean | cdktf.IResolvable;
    /**
    * Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#allow_promiscuous HostVirtualSwitch#allow_promiscuous}
    */
    readonly allowPromiscuous?: boolean | cdktf.IResolvable;
    /**
    * Determines how often, in seconds, a beacon should be sent to probe for the validity of a link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#beacon_interval HostVirtualSwitch#beacon_interval}
    */
    readonly beaconInterval?: number;
    /**
    * Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#check_beacon HostVirtualSwitch#check_beacon}
    */
    readonly checkBeacon?: boolean | cdktf.IResolvable;
    /**
    * If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#failback HostVirtualSwitch#failback}
    */
    readonly failback?: boolean | cdktf.IResolvable;
    /**
    * The managed object ID of the host to set the virtual switch up on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#host_system_id HostVirtualSwitch#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#id HostVirtualSwitch#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether to advertise or listen for link discovery. Valid values are advertise, both, listen, and none.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#link_discovery_operation HostVirtualSwitch#link_discovery_operation}
    */
    readonly linkDiscoveryOperation?: string;
    /**
    * The discovery protocol type. Valid values are cdp and lldp.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#link_discovery_protocol HostVirtualSwitch#link_discovery_protocol}
    */
    readonly linkDiscoveryProtocol?: string;
    /**
    * The maximum transmission unit (MTU) of the virtual switch in bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#mtu HostVirtualSwitch#mtu}
    */
    readonly mtu?: number;
    /**
    * The name of the virtual switch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#name HostVirtualSwitch#name}
    */
    readonly name: string;
    /**
    * The list of network adapters to bind to this virtual switch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#network_adapters HostVirtualSwitch#network_adapters}
    */
    readonly networkAdapters: string[];
    /**
    * If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#notify_switches HostVirtualSwitch#notify_switches}
    */
    readonly notifySwitches?: boolean | cdktf.IResolvable;
    /**
    * The number of ports that this virtual switch is configured to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#number_of_ports HostVirtualSwitch#number_of_ports}
    */
    readonly numberOfPorts?: number;
    /**
    * The average bandwidth in bits per second if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#shaping_average_bandwidth HostVirtualSwitch#shaping_average_bandwidth}
    */
    readonly shapingAverageBandwidth?: number;
    /**
    * The maximum burst size allowed in bytes if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#shaping_burst_size HostVirtualSwitch#shaping_burst_size}
    */
    readonly shapingBurstSize?: number;
    /**
    * Enable traffic shaping on this virtual switch or port group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#shaping_enabled HostVirtualSwitch#shaping_enabled}
    */
    readonly shapingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#shaping_peak_bandwidth HostVirtualSwitch#shaping_peak_bandwidth}
    */
    readonly shapingPeakBandwidth?: number;
    /**
    * List of standby network adapters used for failover.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#standby_nics HostVirtualSwitch#standby_nics}
    */
    readonly standbyNics?: string[];
    /**
    * The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or failover_explicit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch#teaming_policy HostVirtualSwitch#teaming_policy}
    */
    readonly teamingPolicy?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch vsphere_host_virtual_switch}
*/
export declare class HostVirtualSwitch extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_host_virtual_switch";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/host_virtual_switch vsphere_host_virtual_switch} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HostVirtualSwitchConfig
    */
    constructor(scope: Construct, id: string, config: HostVirtualSwitchConfig);
    private _activeNics?;
    get activeNics(): string[];
    set activeNics(value: string[]);
    get activeNicsInput(): string[] | undefined;
    private _allowForgedTransmits?;
    get allowForgedTransmits(): boolean | cdktf.IResolvable;
    set allowForgedTransmits(value: boolean | cdktf.IResolvable);
    resetAllowForgedTransmits(): void;
    get allowForgedTransmitsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowMacChanges?;
    get allowMacChanges(): boolean | cdktf.IResolvable;
    set allowMacChanges(value: boolean | cdktf.IResolvable);
    resetAllowMacChanges(): void;
    get allowMacChangesInput(): boolean | cdktf.IResolvable | undefined;
    private _allowPromiscuous?;
    get allowPromiscuous(): boolean | cdktf.IResolvable;
    set allowPromiscuous(value: boolean | cdktf.IResolvable);
    resetAllowPromiscuous(): void;
    get allowPromiscuousInput(): boolean | cdktf.IResolvable | undefined;
    private _beaconInterval?;
    get beaconInterval(): number;
    set beaconInterval(value: number);
    resetBeaconInterval(): void;
    get beaconIntervalInput(): number | undefined;
    private _checkBeacon?;
    get checkBeacon(): boolean | cdktf.IResolvable;
    set checkBeacon(value: boolean | cdktf.IResolvable);
    resetCheckBeacon(): void;
    get checkBeaconInput(): boolean | cdktf.IResolvable | undefined;
    private _failback?;
    get failback(): boolean | cdktf.IResolvable;
    set failback(value: boolean | cdktf.IResolvable);
    resetFailback(): void;
    get failbackInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkDiscoveryOperation?;
    get linkDiscoveryOperation(): string;
    set linkDiscoveryOperation(value: string);
    resetLinkDiscoveryOperation(): void;
    get linkDiscoveryOperationInput(): string | undefined;
    private _linkDiscoveryProtocol?;
    get linkDiscoveryProtocol(): string;
    set linkDiscoveryProtocol(value: string);
    resetLinkDiscoveryProtocol(): void;
    get linkDiscoveryProtocolInput(): string | undefined;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAdapters?;
    get networkAdapters(): string[];
    set networkAdapters(value: string[]);
    get networkAdaptersInput(): string[] | undefined;
    private _notifySwitches?;
    get notifySwitches(): boolean | cdktf.IResolvable;
    set notifySwitches(value: boolean | cdktf.IResolvable);
    resetNotifySwitches(): void;
    get notifySwitchesInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPorts?;
    get numberOfPorts(): number;
    set numberOfPorts(value: number);
    resetNumberOfPorts(): void;
    get numberOfPortsInput(): number | undefined;
    private _shapingAverageBandwidth?;
    get shapingAverageBandwidth(): number;
    set shapingAverageBandwidth(value: number);
    resetShapingAverageBandwidth(): void;
    get shapingAverageBandwidthInput(): number | undefined;
    private _shapingBurstSize?;
    get shapingBurstSize(): number;
    set shapingBurstSize(value: number);
    resetShapingBurstSize(): void;
    get shapingBurstSizeInput(): number | undefined;
    private _shapingEnabled?;
    get shapingEnabled(): boolean | cdktf.IResolvable;
    set shapingEnabled(value: boolean | cdktf.IResolvable);
    resetShapingEnabled(): void;
    get shapingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _shapingPeakBandwidth?;
    get shapingPeakBandwidth(): number;
    set shapingPeakBandwidth(value: number);
    resetShapingPeakBandwidth(): void;
    get shapingPeakBandwidthInput(): number | undefined;
    private _standbyNics?;
    get standbyNics(): string[];
    set standbyNics(value: string[]);
    resetStandbyNics(): void;
    get standbyNicsInput(): string[] | undefined;
    private _teamingPolicy?;
    get teamingPolicy(): string;
    set teamingPolicy(value: string);
    resetTeamingPolicy(): void;
    get teamingPolicyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
