"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVsphereVirtualMachine = exports.DataVsphereVirtualMachineVappOutputReference = exports.dataVsphereVirtualMachineVappToTerraform = exports.DataVsphereVirtualMachineNetworkInterfacesList = exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = exports.DataVsphereVirtualMachineDisksList = exports.DataVsphereVirtualMachineDisksOutputReference = exports.dataVsphereVirtualMachineDisksToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dataVsphereVirtualMachineDisksToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineDisksToTerraform = dataVsphereVirtualMachineDisksToTerraform;
class DataVsphereVirtualMachineDisksOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // eagerly_scrub - computed: true, optional: false, required: false
    get eagerlyScrub() {
        return this.getBooleanAttribute('eagerly_scrub');
    }
    // label - computed: true, optional: false, required: false
    get label() {
        return this.getStringAttribute('label');
    }
    // size - computed: true, optional: false, required: false
    get size() {
        return this.getNumberAttribute('size');
    }
    // thin_provisioned - computed: true, optional: false, required: false
    get thinProvisioned() {
        return this.getBooleanAttribute('thin_provisioned');
    }
    // unit_number - computed: true, optional: false, required: false
    get unitNumber() {
        return this.getNumberAttribute('unit_number');
    }
}
exports.DataVsphereVirtualMachineDisksOutputReference = DataVsphereVirtualMachineDisksOutputReference;
_a = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksOutputReference", version: "3.0.1" };
class DataVsphereVirtualMachineDisksList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineDisksOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineDisksList = DataVsphereVirtualMachineDisksList;
_b = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineDisksList[_b] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineDisksList", version: "3.0.1" };
function dataVsphereVirtualMachineNetworkInterfacesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.dataVsphereVirtualMachineNetworkInterfacesToTerraform = dataVsphereVirtualMachineNetworkInterfacesToTerraform;
class DataVsphereVirtualMachineNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // adapter_type - computed: true, optional: false, required: false
    get adapterType() {
        return this.getStringAttribute('adapter_type');
    }
    // bandwidth_limit - computed: true, optional: false, required: false
    get bandwidthLimit() {
        return this.getNumberAttribute('bandwidth_limit');
    }
    // bandwidth_reservation - computed: true, optional: false, required: false
    get bandwidthReservation() {
        return this.getNumberAttribute('bandwidth_reservation');
    }
    // bandwidth_share_count - computed: true, optional: false, required: false
    get bandwidthShareCount() {
        return this.getNumberAttribute('bandwidth_share_count');
    }
    // bandwidth_share_level - computed: true, optional: false, required: false
    get bandwidthShareLevel() {
        return this.getStringAttribute('bandwidth_share_level');
    }
    // mac_address - computed: true, optional: false, required: false
    get macAddress() {
        return this.getStringAttribute('mac_address');
    }
    // network_id - computed: true, optional: false, required: false
    get networkId() {
        return this.getStringAttribute('network_id');
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesOutputReference = DataVsphereVirtualMachineNetworkInterfacesOutputReference;
_c = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesOutputReference[_c] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesOutputReference", version: "3.0.1" };
class DataVsphereVirtualMachineNetworkInterfacesList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new DataVsphereVirtualMachineNetworkInterfacesOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.DataVsphereVirtualMachineNetworkInterfacesList = DataVsphereVirtualMachineNetworkInterfacesList;
_d = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineNetworkInterfacesList[_d] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineNetworkInterfacesList", version: "3.0.1" };
function dataVsphereVirtualMachineVappToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        properties: cdktf.hashMapper(cdktf.stringToTerraform)(struct.properties),
    };
}
exports.dataVsphereVirtualMachineVappToTerraform = dataVsphereVirtualMachineVappToTerraform;
class DataVsphereVirtualMachineVappOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._properties !== undefined) {
            hasAnyValues = true;
            internalValueResult.properties = this._properties;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._properties = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._properties = value.properties;
        }
    }
    get properties() {
        return this.getStringMapAttribute('properties');
    }
    set properties(value) {
        this._properties = value;
    }
    resetProperties() {
        this._properties = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get propertiesInput() {
        return this._properties;
    }
}
exports.DataVsphereVirtualMachineVappOutputReference = DataVsphereVirtualMachineVappOutputReference;
_e = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachineVappOutputReference[_e] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachineVappOutputReference", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine}
*/
class DataVsphereVirtualMachine extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/virtual_machine vsphere_virtual_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereVirtualMachineConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vsphere_virtual_machine',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.3.1',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // disks - computed: true, optional: false, required: false
        this._disks = new DataVsphereVirtualMachineDisksList(this, "disks", false);
        // network_interfaces - computed: true, optional: false, required: false
        this._networkInterfaces = new DataVsphereVirtualMachineNetworkInterfacesList(this, "network_interfaces", false);
        // vapp - computed: false, optional: true, required: false
        this._vapp = new DataVsphereVirtualMachineVappOutputReference(this, "vapp");
        this._alternateGuestName = config.alternateGuestName;
        this._annotation = config.annotation;
        this._bootDelay = config.bootDelay;
        this._bootRetryDelay = config.bootRetryDelay;
        this._bootRetryEnabled = config.bootRetryEnabled;
        this._cpuHotAddEnabled = config.cpuHotAddEnabled;
        this._cpuHotRemoveEnabled = config.cpuHotRemoveEnabled;
        this._cpuLimit = config.cpuLimit;
        this._cpuPerformanceCountersEnabled = config.cpuPerformanceCountersEnabled;
        this._cpuReservation = config.cpuReservation;
        this._cpuShareCount = config.cpuShareCount;
        this._cpuShareLevel = config.cpuShareLevel;
        this._datacenterId = config.datacenterId;
        this._efiSecureBootEnabled = config.efiSecureBootEnabled;
        this._enableDiskUuid = config.enableDiskUuid;
        this._enableLogging = config.enableLogging;
        this._eptRviMode = config.eptRviMode;
        this._extraConfig = config.extraConfig;
        this._extraConfigRebootRequired = config.extraConfigRebootRequired;
        this._firmware = config.firmware;
        this._guestId = config.guestId;
        this._hardwareVersion = config.hardwareVersion;
        this._hvMode = config.hvMode;
        this._id = config.id;
        this._ideControllerScanCount = config.ideControllerScanCount;
        this._latencySensitivity = config.latencySensitivity;
        this._memory = config.memory;
        this._memoryHotAddEnabled = config.memoryHotAddEnabled;
        this._memoryLimit = config.memoryLimit;
        this._memoryReservation = config.memoryReservation;
        this._memoryShareCount = config.memoryShareCount;
        this._memoryShareLevel = config.memoryShareLevel;
        this._name = config.name;
        this._nestedHvEnabled = config.nestedHvEnabled;
        this._numCoresPerSocket = config.numCoresPerSocket;
        this._numCpus = config.numCpus;
        this._replaceTrigger = config.replaceTrigger;
        this._runToolsScriptsAfterPowerOn = config.runToolsScriptsAfterPowerOn;
        this._runToolsScriptsAfterResume = config.runToolsScriptsAfterResume;
        this._runToolsScriptsBeforeGuestReboot = config.runToolsScriptsBeforeGuestReboot;
        this._runToolsScriptsBeforeGuestShutdown = config.runToolsScriptsBeforeGuestShutdown;
        this._runToolsScriptsBeforeGuestStandby = config.runToolsScriptsBeforeGuestStandby;
        this._sataControllerScanCount = config.sataControllerScanCount;
        this._scsiControllerScanCount = config.scsiControllerScanCount;
        this._storagePolicyId = config.storagePolicyId;
        this._swapPlacementPolicy = config.swapPlacementPolicy;
        this._syncTimeWithHost = config.syncTimeWithHost;
        this._syncTimeWithHostPeriodically = config.syncTimeWithHostPeriodically;
        this._toolsUpgradePolicy = config.toolsUpgradePolicy;
        this._uuid = config.uuid;
        this._vbsEnabled = config.vbsEnabled;
        this._vvtdEnabled = config.vvtdEnabled;
        this._vapp.internalValue = config.vapp;
    }
    get alternateGuestName() {
        return this.getStringAttribute('alternate_guest_name');
    }
    set alternateGuestName(value) {
        this._alternateGuestName = value;
    }
    resetAlternateGuestName() {
        this._alternateGuestName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alternateGuestNameInput() {
        return this._alternateGuestName;
    }
    get annotation() {
        return this.getStringAttribute('annotation');
    }
    set annotation(value) {
        this._annotation = value;
    }
    resetAnnotation() {
        this._annotation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get annotationInput() {
        return this._annotation;
    }
    get bootDelay() {
        return this.getNumberAttribute('boot_delay');
    }
    set bootDelay(value) {
        this._bootDelay = value;
    }
    resetBootDelay() {
        this._bootDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootDelayInput() {
        return this._bootDelay;
    }
    get bootRetryDelay() {
        return this.getNumberAttribute('boot_retry_delay');
    }
    set bootRetryDelay(value) {
        this._bootRetryDelay = value;
    }
    resetBootRetryDelay() {
        this._bootRetryDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryDelayInput() {
        return this._bootRetryDelay;
    }
    get bootRetryEnabled() {
        return this.getBooleanAttribute('boot_retry_enabled');
    }
    set bootRetryEnabled(value) {
        this._bootRetryEnabled = value;
    }
    resetBootRetryEnabled() {
        this._bootRetryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bootRetryEnabledInput() {
        return this._bootRetryEnabled;
    }
    // change_version - computed: true, optional: false, required: false
    get changeVersion() {
        return this.getStringAttribute('change_version');
    }
    get cpuHotAddEnabled() {
        return this.getBooleanAttribute('cpu_hot_add_enabled');
    }
    set cpuHotAddEnabled(value) {
        this._cpuHotAddEnabled = value;
    }
    resetCpuHotAddEnabled() {
        this._cpuHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotAddEnabledInput() {
        return this._cpuHotAddEnabled;
    }
    get cpuHotRemoveEnabled() {
        return this.getBooleanAttribute('cpu_hot_remove_enabled');
    }
    set cpuHotRemoveEnabled(value) {
        this._cpuHotRemoveEnabled = value;
    }
    resetCpuHotRemoveEnabled() {
        this._cpuHotRemoveEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuHotRemoveEnabledInput() {
        return this._cpuHotRemoveEnabled;
    }
    get cpuLimit() {
        return this.getNumberAttribute('cpu_limit');
    }
    set cpuLimit(value) {
        this._cpuLimit = value;
    }
    resetCpuLimit() {
        this._cpuLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuLimitInput() {
        return this._cpuLimit;
    }
    get cpuPerformanceCountersEnabled() {
        return this.getBooleanAttribute('cpu_performance_counters_enabled');
    }
    set cpuPerformanceCountersEnabled(value) {
        this._cpuPerformanceCountersEnabled = value;
    }
    resetCpuPerformanceCountersEnabled() {
        this._cpuPerformanceCountersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuPerformanceCountersEnabledInput() {
        return this._cpuPerformanceCountersEnabled;
    }
    get cpuReservation() {
        return this.getNumberAttribute('cpu_reservation');
    }
    set cpuReservation(value) {
        this._cpuReservation = value;
    }
    resetCpuReservation() {
        this._cpuReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuReservationInput() {
        return this._cpuReservation;
    }
    get cpuShareCount() {
        return this.getNumberAttribute('cpu_share_count');
    }
    set cpuShareCount(value) {
        this._cpuShareCount = value;
    }
    resetCpuShareCount() {
        this._cpuShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareCountInput() {
        return this._cpuShareCount;
    }
    get cpuShareLevel() {
        return this.getStringAttribute('cpu_share_level');
    }
    set cpuShareLevel(value) {
        this._cpuShareLevel = value;
    }
    resetCpuShareLevel() {
        this._cpuShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuShareLevelInput() {
        return this._cpuShareLevel;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    resetDatacenterId() {
        this._datacenterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    // default_ip_address - computed: true, optional: false, required: false
    get defaultIpAddress() {
        return this.getStringAttribute('default_ip_address');
    }
    get disks() {
        return this._disks;
    }
    get efiSecureBootEnabled() {
        return this.getBooleanAttribute('efi_secure_boot_enabled');
    }
    set efiSecureBootEnabled(value) {
        this._efiSecureBootEnabled = value;
    }
    resetEfiSecureBootEnabled() {
        this._efiSecureBootEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get efiSecureBootEnabledInput() {
        return this._efiSecureBootEnabled;
    }
    get enableDiskUuid() {
        return this.getBooleanAttribute('enable_disk_uuid');
    }
    set enableDiskUuid(value) {
        this._enableDiskUuid = value;
    }
    resetEnableDiskUuid() {
        this._enableDiskUuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableDiskUuidInput() {
        return this._enableDiskUuid;
    }
    get enableLogging() {
        return this.getBooleanAttribute('enable_logging');
    }
    set enableLogging(value) {
        this._enableLogging = value;
    }
    resetEnableLogging() {
        this._enableLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableLoggingInput() {
        return this._enableLogging;
    }
    get eptRviMode() {
        return this.getStringAttribute('ept_rvi_mode');
    }
    set eptRviMode(value) {
        this._eptRviMode = value;
    }
    resetEptRviMode() {
        this._eptRviMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eptRviModeInput() {
        return this._eptRviMode;
    }
    get extraConfig() {
        return this.getStringMapAttribute('extra_config');
    }
    set extraConfig(value) {
        this._extraConfig = value;
    }
    resetExtraConfig() {
        this._extraConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigInput() {
        return this._extraConfig;
    }
    get extraConfigRebootRequired() {
        return this.getBooleanAttribute('extra_config_reboot_required');
    }
    set extraConfigRebootRequired(value) {
        this._extraConfigRebootRequired = value;
    }
    resetExtraConfigRebootRequired() {
        this._extraConfigRebootRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get extraConfigRebootRequiredInput() {
        return this._extraConfigRebootRequired;
    }
    get firmware() {
        return this.getStringAttribute('firmware');
    }
    set firmware(value) {
        this._firmware = value;
    }
    resetFirmware() {
        this._firmware = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firmwareInput() {
        return this._firmware;
    }
    get guestId() {
        return this.getStringAttribute('guest_id');
    }
    set guestId(value) {
        this._guestId = value;
    }
    resetGuestId() {
        this._guestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get guestIdInput() {
        return this._guestId;
    }
    // guest_ip_addresses - computed: true, optional: false, required: false
    get guestIpAddresses() {
        return this.getListAttribute('guest_ip_addresses');
    }
    get hardwareVersion() {
        return this.getNumberAttribute('hardware_version');
    }
    set hardwareVersion(value) {
        this._hardwareVersion = value;
    }
    resetHardwareVersion() {
        this._hardwareVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hardwareVersionInput() {
        return this._hardwareVersion;
    }
    get hvMode() {
        return this.getStringAttribute('hv_mode');
    }
    set hvMode(value) {
        this._hvMode = value;
    }
    resetHvMode() {
        this._hvMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hvModeInput() {
        return this._hvMode;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ideControllerScanCount() {
        return this.getNumberAttribute('ide_controller_scan_count');
    }
    set ideControllerScanCount(value) {
        this._ideControllerScanCount = value;
    }
    resetIdeControllerScanCount() {
        this._ideControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ideControllerScanCountInput() {
        return this._ideControllerScanCount;
    }
    get latencySensitivity() {
        return this.getStringAttribute('latency_sensitivity');
    }
    set latencySensitivity(value) {
        this._latencySensitivity = value;
    }
    resetLatencySensitivity() {
        this._latencySensitivity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get latencySensitivityInput() {
        return this._latencySensitivity;
    }
    get memory() {
        return this.getNumberAttribute('memory');
    }
    set memory(value) {
        this._memory = value;
    }
    resetMemory() {
        this._memory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryInput() {
        return this._memory;
    }
    get memoryHotAddEnabled() {
        return this.getBooleanAttribute('memory_hot_add_enabled');
    }
    set memoryHotAddEnabled(value) {
        this._memoryHotAddEnabled = value;
    }
    resetMemoryHotAddEnabled() {
        this._memoryHotAddEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryHotAddEnabledInput() {
        return this._memoryHotAddEnabled;
    }
    get memoryLimit() {
        return this.getNumberAttribute('memory_limit');
    }
    set memoryLimit(value) {
        this._memoryLimit = value;
    }
    resetMemoryLimit() {
        this._memoryLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryLimitInput() {
        return this._memoryLimit;
    }
    get memoryReservation() {
        return this.getNumberAttribute('memory_reservation');
    }
    set memoryReservation(value) {
        this._memoryReservation = value;
    }
    resetMemoryReservation() {
        this._memoryReservation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryReservationInput() {
        return this._memoryReservation;
    }
    get memoryShareCount() {
        return this.getNumberAttribute('memory_share_count');
    }
    set memoryShareCount(value) {
        this._memoryShareCount = value;
    }
    resetMemoryShareCount() {
        this._memoryShareCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareCountInput() {
        return this._memoryShareCount;
    }
    get memoryShareLevel() {
        return this.getStringAttribute('memory_share_level');
    }
    set memoryShareLevel(value) {
        this._memoryShareLevel = value;
    }
    resetMemoryShareLevel() {
        this._memoryShareLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryShareLevelInput() {
        return this._memoryShareLevel;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    resetName() {
        this._name = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nestedHvEnabled() {
        return this.getBooleanAttribute('nested_hv_enabled');
    }
    set nestedHvEnabled(value) {
        this._nestedHvEnabled = value;
    }
    resetNestedHvEnabled() {
        this._nestedHvEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nestedHvEnabledInput() {
        return this._nestedHvEnabled;
    }
    // network_interface_types - computed: true, optional: false, required: false
    get networkInterfaceTypes() {
        return this.getListAttribute('network_interface_types');
    }
    get networkInterfaces() {
        return this._networkInterfaces;
    }
    get numCoresPerSocket() {
        return this.getNumberAttribute('num_cores_per_socket');
    }
    set numCoresPerSocket(value) {
        this._numCoresPerSocket = value;
    }
    resetNumCoresPerSocket() {
        this._numCoresPerSocket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCoresPerSocketInput() {
        return this._numCoresPerSocket;
    }
    get numCpus() {
        return this.getNumberAttribute('num_cpus');
    }
    set numCpus(value) {
        this._numCpus = value;
    }
    resetNumCpus() {
        this._numCpus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numCpusInput() {
        return this._numCpus;
    }
    get replaceTrigger() {
        return this.getStringAttribute('replace_trigger');
    }
    set replaceTrigger(value) {
        this._replaceTrigger = value;
    }
    resetReplaceTrigger() {
        this._replaceTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceTriggerInput() {
        return this._replaceTrigger;
    }
    get runToolsScriptsAfterPowerOn() {
        return this.getBooleanAttribute('run_tools_scripts_after_power_on');
    }
    set runToolsScriptsAfterPowerOn(value) {
        this._runToolsScriptsAfterPowerOn = value;
    }
    resetRunToolsScriptsAfterPowerOn() {
        this._runToolsScriptsAfterPowerOn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterPowerOnInput() {
        return this._runToolsScriptsAfterPowerOn;
    }
    get runToolsScriptsAfterResume() {
        return this.getBooleanAttribute('run_tools_scripts_after_resume');
    }
    set runToolsScriptsAfterResume(value) {
        this._runToolsScriptsAfterResume = value;
    }
    resetRunToolsScriptsAfterResume() {
        this._runToolsScriptsAfterResume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsAfterResumeInput() {
        return this._runToolsScriptsAfterResume;
    }
    get runToolsScriptsBeforeGuestReboot() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_reboot');
    }
    set runToolsScriptsBeforeGuestReboot(value) {
        this._runToolsScriptsBeforeGuestReboot = value;
    }
    resetRunToolsScriptsBeforeGuestReboot() {
        this._runToolsScriptsBeforeGuestReboot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestRebootInput() {
        return this._runToolsScriptsBeforeGuestReboot;
    }
    get runToolsScriptsBeforeGuestShutdown() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_shutdown');
    }
    set runToolsScriptsBeforeGuestShutdown(value) {
        this._runToolsScriptsBeforeGuestShutdown = value;
    }
    resetRunToolsScriptsBeforeGuestShutdown() {
        this._runToolsScriptsBeforeGuestShutdown = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestShutdownInput() {
        return this._runToolsScriptsBeforeGuestShutdown;
    }
    get runToolsScriptsBeforeGuestStandby() {
        return this.getBooleanAttribute('run_tools_scripts_before_guest_standby');
    }
    set runToolsScriptsBeforeGuestStandby(value) {
        this._runToolsScriptsBeforeGuestStandby = value;
    }
    resetRunToolsScriptsBeforeGuestStandby() {
        this._runToolsScriptsBeforeGuestStandby = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runToolsScriptsBeforeGuestStandbyInput() {
        return this._runToolsScriptsBeforeGuestStandby;
    }
    get sataControllerScanCount() {
        return this.getNumberAttribute('sata_controller_scan_count');
    }
    set sataControllerScanCount(value) {
        this._sataControllerScanCount = value;
    }
    resetSataControllerScanCount() {
        this._sataControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sataControllerScanCountInput() {
        return this._sataControllerScanCount;
    }
    // scsi_bus_sharing - computed: true, optional: false, required: false
    get scsiBusSharing() {
        return this.getStringAttribute('scsi_bus_sharing');
    }
    get scsiControllerScanCount() {
        return this.getNumberAttribute('scsi_controller_scan_count');
    }
    set scsiControllerScanCount(value) {
        this._scsiControllerScanCount = value;
    }
    resetScsiControllerScanCount() {
        this._scsiControllerScanCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scsiControllerScanCountInput() {
        return this._scsiControllerScanCount;
    }
    // scsi_type - computed: true, optional: false, required: false
    get scsiType() {
        return this.getStringAttribute('scsi_type');
    }
    get storagePolicyId() {
        return this.getStringAttribute('storage_policy_id');
    }
    set storagePolicyId(value) {
        this._storagePolicyId = value;
    }
    resetStoragePolicyId() {
        this._storagePolicyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storagePolicyIdInput() {
        return this._storagePolicyId;
    }
    get swapPlacementPolicy() {
        return this.getStringAttribute('swap_placement_policy');
    }
    set swapPlacementPolicy(value) {
        this._swapPlacementPolicy = value;
    }
    resetSwapPlacementPolicy() {
        this._swapPlacementPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapPlacementPolicyInput() {
        return this._swapPlacementPolicy;
    }
    get syncTimeWithHost() {
        return this.getBooleanAttribute('sync_time_with_host');
    }
    set syncTimeWithHost(value) {
        this._syncTimeWithHost = value;
    }
    resetSyncTimeWithHost() {
        this._syncTimeWithHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostInput() {
        return this._syncTimeWithHost;
    }
    get syncTimeWithHostPeriodically() {
        return this.getBooleanAttribute('sync_time_with_host_periodically');
    }
    set syncTimeWithHostPeriodically(value) {
        this._syncTimeWithHostPeriodically = value;
    }
    resetSyncTimeWithHostPeriodically() {
        this._syncTimeWithHostPeriodically = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get syncTimeWithHostPeriodicallyInput() {
        return this._syncTimeWithHostPeriodically;
    }
    get toolsUpgradePolicy() {
        return this.getStringAttribute('tools_upgrade_policy');
    }
    set toolsUpgradePolicy(value) {
        this._toolsUpgradePolicy = value;
    }
    resetToolsUpgradePolicy() {
        this._toolsUpgradePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get toolsUpgradePolicyInput() {
        return this._toolsUpgradePolicy;
    }
    get uuid() {
        return this.getStringAttribute('uuid');
    }
    set uuid(value) {
        this._uuid = value;
    }
    resetUuid() {
        this._uuid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uuidInput() {
        return this._uuid;
    }
    // vapp_transport - computed: true, optional: false, required: false
    get vappTransport() {
        return this.getListAttribute('vapp_transport');
    }
    get vbsEnabled() {
        return this.getBooleanAttribute('vbs_enabled');
    }
    set vbsEnabled(value) {
        this._vbsEnabled = value;
    }
    resetVbsEnabled() {
        this._vbsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vbsEnabledInput() {
        return this._vbsEnabled;
    }
    get vvtdEnabled() {
        return this.getBooleanAttribute('vvtd_enabled');
    }
    set vvtdEnabled(value) {
        this._vvtdEnabled = value;
    }
    resetVvtdEnabled() {
        this._vvtdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vvtdEnabledInput() {
        return this._vvtdEnabled;
    }
    get vapp() {
        return this._vapp;
    }
    putVapp(value) {
        this._vapp.internalValue = value;
    }
    resetVapp() {
        this._vapp.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vappInput() {
        return this._vapp.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alternate_guest_name: cdktf.stringToTerraform(this._alternateGuestName),
            annotation: cdktf.stringToTerraform(this._annotation),
            boot_delay: cdktf.numberToTerraform(this._bootDelay),
            boot_retry_delay: cdktf.numberToTerraform(this._bootRetryDelay),
            boot_retry_enabled: cdktf.booleanToTerraform(this._bootRetryEnabled),
            cpu_hot_add_enabled: cdktf.booleanToTerraform(this._cpuHotAddEnabled),
            cpu_hot_remove_enabled: cdktf.booleanToTerraform(this._cpuHotRemoveEnabled),
            cpu_limit: cdktf.numberToTerraform(this._cpuLimit),
            cpu_performance_counters_enabled: cdktf.booleanToTerraform(this._cpuPerformanceCountersEnabled),
            cpu_reservation: cdktf.numberToTerraform(this._cpuReservation),
            cpu_share_count: cdktf.numberToTerraform(this._cpuShareCount),
            cpu_share_level: cdktf.stringToTerraform(this._cpuShareLevel),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            efi_secure_boot_enabled: cdktf.booleanToTerraform(this._efiSecureBootEnabled),
            enable_disk_uuid: cdktf.booleanToTerraform(this._enableDiskUuid),
            enable_logging: cdktf.booleanToTerraform(this._enableLogging),
            ept_rvi_mode: cdktf.stringToTerraform(this._eptRviMode),
            extra_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._extraConfig),
            extra_config_reboot_required: cdktf.booleanToTerraform(this._extraConfigRebootRequired),
            firmware: cdktf.stringToTerraform(this._firmware),
            guest_id: cdktf.stringToTerraform(this._guestId),
            hardware_version: cdktf.numberToTerraform(this._hardwareVersion),
            hv_mode: cdktf.stringToTerraform(this._hvMode),
            id: cdktf.stringToTerraform(this._id),
            ide_controller_scan_count: cdktf.numberToTerraform(this._ideControllerScanCount),
            latency_sensitivity: cdktf.stringToTerraform(this._latencySensitivity),
            memory: cdktf.numberToTerraform(this._memory),
            memory_hot_add_enabled: cdktf.booleanToTerraform(this._memoryHotAddEnabled),
            memory_limit: cdktf.numberToTerraform(this._memoryLimit),
            memory_reservation: cdktf.numberToTerraform(this._memoryReservation),
            memory_share_count: cdktf.numberToTerraform(this._memoryShareCount),
            memory_share_level: cdktf.stringToTerraform(this._memoryShareLevel),
            name: cdktf.stringToTerraform(this._name),
            nested_hv_enabled: cdktf.booleanToTerraform(this._nestedHvEnabled),
            num_cores_per_socket: cdktf.numberToTerraform(this._numCoresPerSocket),
            num_cpus: cdktf.numberToTerraform(this._numCpus),
            replace_trigger: cdktf.stringToTerraform(this._replaceTrigger),
            run_tools_scripts_after_power_on: cdktf.booleanToTerraform(this._runToolsScriptsAfterPowerOn),
            run_tools_scripts_after_resume: cdktf.booleanToTerraform(this._runToolsScriptsAfterResume),
            run_tools_scripts_before_guest_reboot: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestReboot),
            run_tools_scripts_before_guest_shutdown: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestShutdown),
            run_tools_scripts_before_guest_standby: cdktf.booleanToTerraform(this._runToolsScriptsBeforeGuestStandby),
            sata_controller_scan_count: cdktf.numberToTerraform(this._sataControllerScanCount),
            scsi_controller_scan_count: cdktf.numberToTerraform(this._scsiControllerScanCount),
            storage_policy_id: cdktf.stringToTerraform(this._storagePolicyId),
            swap_placement_policy: cdktf.stringToTerraform(this._swapPlacementPolicy),
            sync_time_with_host: cdktf.booleanToTerraform(this._syncTimeWithHost),
            sync_time_with_host_periodically: cdktf.booleanToTerraform(this._syncTimeWithHostPeriodically),
            tools_upgrade_policy: cdktf.stringToTerraform(this._toolsUpgradePolicy),
            uuid: cdktf.stringToTerraform(this._uuid),
            vbs_enabled: cdktf.booleanToTerraform(this._vbsEnabled),
            vvtd_enabled: cdktf.booleanToTerraform(this._vvtdEnabled),
            vapp: dataVsphereVirtualMachineVappToTerraform(this._vapp.internalValue),
        };
    }
}
exports.DataVsphereVirtualMachine = DataVsphereVirtualMachine;
_f = JSII_RTTI_SYMBOL_1;
DataVsphereVirtualMachine[_f] = { fqn: "@cdktf/provider-vsphere.dataVsphereVirtualMachine.DataVsphereVirtualMachine", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
DataVsphereVirtualMachine.tfResourceType = "vsphere_virtual_machine";
//# sourceMappingURL=data:application/json;base64,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