"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeCluster = exports.ComputeClusterVsanDiskGroupList = exports.ComputeClusterVsanDiskGroupOutputReference = exports.computeClusterVsanDiskGroupToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeClusterVsanDiskGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cache: cdktf.stringToTerraform(struct.cache),
        storage: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.storage),
    };
}
exports.computeClusterVsanDiskGroupToTerraform = computeClusterVsanDiskGroupToTerraform;
class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cache !== undefined) {
            hasAnyValues = true;
            internalValueResult.cache = this._cache;
        }
        if (this._storage !== undefined) {
            hasAnyValues = true;
            internalValueResult.storage = this._storage;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._cache = undefined;
            this._storage = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._cache = value.cache;
            this._storage = value.storage;
        }
    }
    get cache() {
        return this.getStringAttribute('cache');
    }
    set cache(value) {
        this._cache = value;
    }
    resetCache() {
        this._cache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cacheInput() {
        return this._cache;
    }
    get storage() {
        return cdktf.Fn.tolist(this.getListAttribute('storage'));
    }
    set storage(value) {
        this._storage = value;
    }
    resetStorage() {
        this._storage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageInput() {
        return this._storage;
    }
}
exports.ComputeClusterVsanDiskGroupOutputReference = ComputeClusterVsanDiskGroupOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupOutputReference[_a] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupOutputReference", version: "3.0.1" };
class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ComputeClusterVsanDiskGroupOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ComputeClusterVsanDiskGroupList = ComputeClusterVsanDiskGroupList;
_b = JSII_RTTI_SYMBOL_1;
ComputeClusterVsanDiskGroupList[_b] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeClusterVsanDiskGroupList", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster}
*/
class ComputeCluster extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vsphere_compute_cluster',
            terraformGeneratorMetadata: {
                providerName: 'vsphere',
                providerVersion: '2.3.1',
                providerVersionConstraint: '~> 2.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // vsan_disk_group - computed: false, optional: true, required: false
        this._vsanDiskGroup = new ComputeClusterVsanDiskGroupList(this, "vsan_disk_group", false);
        this._customAttributes = config.customAttributes;
        this._datacenterId = config.datacenterId;
        this._dpmAutomationLevel = config.dpmAutomationLevel;
        this._dpmEnabled = config.dpmEnabled;
        this._dpmThreshold = config.dpmThreshold;
        this._drsAdvancedOptions = config.drsAdvancedOptions;
        this._drsAutomationLevel = config.drsAutomationLevel;
        this._drsEnablePredictiveDrs = config.drsEnablePredictiveDrs;
        this._drsEnableVmOverrides = config.drsEnableVmOverrides;
        this._drsEnabled = config.drsEnabled;
        this._drsMigrationThreshold = config.drsMigrationThreshold;
        this._drsScaleDescendantsShares = config.drsScaleDescendantsShares;
        this._folder = config.folder;
        this._forceEvacuateOnDestroy = config.forceEvacuateOnDestroy;
        this._haAdmissionControlFailoverHostSystemIds = config.haAdmissionControlFailoverHostSystemIds;
        this._haAdmissionControlHostFailureTolerance = config.haAdmissionControlHostFailureTolerance;
        this._haAdmissionControlPerformanceTolerance = config.haAdmissionControlPerformanceTolerance;
        this._haAdmissionControlPolicy = config.haAdmissionControlPolicy;
        this._haAdmissionControlResourcePercentageAutoCompute = config.haAdmissionControlResourcePercentageAutoCompute;
        this._haAdmissionControlResourcePercentageCpu = config.haAdmissionControlResourcePercentageCpu;
        this._haAdmissionControlResourcePercentageMemory = config.haAdmissionControlResourcePercentageMemory;
        this._haAdmissionControlSlotPolicyExplicitCpu = config.haAdmissionControlSlotPolicyExplicitCpu;
        this._haAdmissionControlSlotPolicyExplicitMemory = config.haAdmissionControlSlotPolicyExplicitMemory;
        this._haAdmissionControlSlotPolicyUseExplicitSize = config.haAdmissionControlSlotPolicyUseExplicitSize;
        this._haAdvancedOptions = config.haAdvancedOptions;
        this._haDatastoreApdRecoveryAction = config.haDatastoreApdRecoveryAction;
        this._haDatastoreApdResponse = config.haDatastoreApdResponse;
        this._haDatastoreApdResponseDelay = config.haDatastoreApdResponseDelay;
        this._haDatastorePdlResponse = config.haDatastorePdlResponse;
        this._haEnabled = config.haEnabled;
        this._haHeartbeatDatastoreIds = config.haHeartbeatDatastoreIds;
        this._haHeartbeatDatastorePolicy = config.haHeartbeatDatastorePolicy;
        this._haHostIsolationResponse = config.haHostIsolationResponse;
        this._haHostMonitoring = config.haHostMonitoring;
        this._haVmComponentProtection = config.haVmComponentProtection;
        this._haVmDependencyRestartCondition = config.haVmDependencyRestartCondition;
        this._haVmFailureInterval = config.haVmFailureInterval;
        this._haVmMaximumFailureWindow = config.haVmMaximumFailureWindow;
        this._haVmMaximumResets = config.haVmMaximumResets;
        this._haVmMinimumUptime = config.haVmMinimumUptime;
        this._haVmMonitoring = config.haVmMonitoring;
        this._haVmRestartAdditionalDelay = config.haVmRestartAdditionalDelay;
        this._haVmRestartPriority = config.haVmRestartPriority;
        this._haVmRestartTimeout = config.haVmRestartTimeout;
        this._hostClusterExitTimeout = config.hostClusterExitTimeout;
        this._hostManaged = config.hostManaged;
        this._hostSystemIds = config.hostSystemIds;
        this._id = config.id;
        this._name = config.name;
        this._proactiveHaAutomationLevel = config.proactiveHaAutomationLevel;
        this._proactiveHaEnabled = config.proactiveHaEnabled;
        this._proactiveHaModerateRemediation = config.proactiveHaModerateRemediation;
        this._proactiveHaProviderIds = config.proactiveHaProviderIds;
        this._proactiveHaSevereRemediation = config.proactiveHaSevereRemediation;
        this._tags = config.tags;
        this._vsanCompressionEnabled = config.vsanCompressionEnabled;
        this._vsanDedupEnabled = config.vsanDedupEnabled;
        this._vsanDitEncryptionEnabled = config.vsanDitEncryptionEnabled;
        this._vsanDitRekeyInterval = config.vsanDitRekeyInterval;
        this._vsanEnabled = config.vsanEnabled;
        this._vsanNetworkDiagnosticModeEnabled = config.vsanNetworkDiagnosticModeEnabled;
        this._vsanPerformanceEnabled = config.vsanPerformanceEnabled;
        this._vsanRemoteDatastoreIds = config.vsanRemoteDatastoreIds;
        this._vsanUnmapEnabled = config.vsanUnmapEnabled;
        this._vsanVerboseModeEnabled = config.vsanVerboseModeEnabled;
        this._vsanDiskGroup.internalValue = config.vsanDiskGroup;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get datacenterId() {
        return this.getStringAttribute('datacenter_id');
    }
    set datacenterId(value) {
        this._datacenterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterIdInput() {
        return this._datacenterId;
    }
    get dpmAutomationLevel() {
        return this.getStringAttribute('dpm_automation_level');
    }
    set dpmAutomationLevel(value) {
        this._dpmAutomationLevel = value;
    }
    resetDpmAutomationLevel() {
        this._dpmAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmAutomationLevelInput() {
        return this._dpmAutomationLevel;
    }
    get dpmEnabled() {
        return this.getBooleanAttribute('dpm_enabled');
    }
    set dpmEnabled(value) {
        this._dpmEnabled = value;
    }
    resetDpmEnabled() {
        this._dpmEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmEnabledInput() {
        return this._dpmEnabled;
    }
    get dpmThreshold() {
        return this.getNumberAttribute('dpm_threshold');
    }
    set dpmThreshold(value) {
        this._dpmThreshold = value;
    }
    resetDpmThreshold() {
        this._dpmThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dpmThresholdInput() {
        return this._dpmThreshold;
    }
    get drsAdvancedOptions() {
        return this.getStringMapAttribute('drs_advanced_options');
    }
    set drsAdvancedOptions(value) {
        this._drsAdvancedOptions = value;
    }
    resetDrsAdvancedOptions() {
        this._drsAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAdvancedOptionsInput() {
        return this._drsAdvancedOptions;
    }
    get drsAutomationLevel() {
        return this.getStringAttribute('drs_automation_level');
    }
    set drsAutomationLevel(value) {
        this._drsAutomationLevel = value;
    }
    resetDrsAutomationLevel() {
        this._drsAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsAutomationLevelInput() {
        return this._drsAutomationLevel;
    }
    get drsEnablePredictiveDrs() {
        return this.getBooleanAttribute('drs_enable_predictive_drs');
    }
    set drsEnablePredictiveDrs(value) {
        this._drsEnablePredictiveDrs = value;
    }
    resetDrsEnablePredictiveDrs() {
        this._drsEnablePredictiveDrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnablePredictiveDrsInput() {
        return this._drsEnablePredictiveDrs;
    }
    get drsEnableVmOverrides() {
        return this.getBooleanAttribute('drs_enable_vm_overrides');
    }
    set drsEnableVmOverrides(value) {
        this._drsEnableVmOverrides = value;
    }
    resetDrsEnableVmOverrides() {
        this._drsEnableVmOverrides = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnableVmOverridesInput() {
        return this._drsEnableVmOverrides;
    }
    get drsEnabled() {
        return this.getBooleanAttribute('drs_enabled');
    }
    set drsEnabled(value) {
        this._drsEnabled = value;
    }
    resetDrsEnabled() {
        this._drsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsEnabledInput() {
        return this._drsEnabled;
    }
    get drsMigrationThreshold() {
        return this.getNumberAttribute('drs_migration_threshold');
    }
    set drsMigrationThreshold(value) {
        this._drsMigrationThreshold = value;
    }
    resetDrsMigrationThreshold() {
        this._drsMigrationThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsMigrationThresholdInput() {
        return this._drsMigrationThreshold;
    }
    get drsScaleDescendantsShares() {
        return this.getStringAttribute('drs_scale_descendants_shares');
    }
    set drsScaleDescendantsShares(value) {
        this._drsScaleDescendantsShares = value;
    }
    resetDrsScaleDescendantsShares() {
        this._drsScaleDescendantsShares = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drsScaleDescendantsSharesInput() {
        return this._drsScaleDescendantsShares;
    }
    get folder() {
        return this.getStringAttribute('folder');
    }
    set folder(value) {
        this._folder = value;
    }
    resetFolder() {
        this._folder = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get folderInput() {
        return this._folder;
    }
    get forceEvacuateOnDestroy() {
        return this.getBooleanAttribute('force_evacuate_on_destroy');
    }
    set forceEvacuateOnDestroy(value) {
        this._forceEvacuateOnDestroy = value;
    }
    resetForceEvacuateOnDestroy() {
        this._forceEvacuateOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceEvacuateOnDestroyInput() {
        return this._forceEvacuateOnDestroy;
    }
    get haAdmissionControlFailoverHostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_admission_control_failover_host_system_ids'));
    }
    set haAdmissionControlFailoverHostSystemIds(value) {
        this._haAdmissionControlFailoverHostSystemIds = value;
    }
    resetHaAdmissionControlFailoverHostSystemIds() {
        this._haAdmissionControlFailoverHostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlFailoverHostSystemIdsInput() {
        return this._haAdmissionControlFailoverHostSystemIds;
    }
    get haAdmissionControlHostFailureTolerance() {
        return this.getNumberAttribute('ha_admission_control_host_failure_tolerance');
    }
    set haAdmissionControlHostFailureTolerance(value) {
        this._haAdmissionControlHostFailureTolerance = value;
    }
    resetHaAdmissionControlHostFailureTolerance() {
        this._haAdmissionControlHostFailureTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlHostFailureToleranceInput() {
        return this._haAdmissionControlHostFailureTolerance;
    }
    get haAdmissionControlPerformanceTolerance() {
        return this.getNumberAttribute('ha_admission_control_performance_tolerance');
    }
    set haAdmissionControlPerformanceTolerance(value) {
        this._haAdmissionControlPerformanceTolerance = value;
    }
    resetHaAdmissionControlPerformanceTolerance() {
        this._haAdmissionControlPerformanceTolerance = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPerformanceToleranceInput() {
        return this._haAdmissionControlPerformanceTolerance;
    }
    get haAdmissionControlPolicy() {
        return this.getStringAttribute('ha_admission_control_policy');
    }
    set haAdmissionControlPolicy(value) {
        this._haAdmissionControlPolicy = value;
    }
    resetHaAdmissionControlPolicy() {
        this._haAdmissionControlPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlPolicyInput() {
        return this._haAdmissionControlPolicy;
    }
    get haAdmissionControlResourcePercentageAutoCompute() {
        return this.getBooleanAttribute('ha_admission_control_resource_percentage_auto_compute');
    }
    set haAdmissionControlResourcePercentageAutoCompute(value) {
        this._haAdmissionControlResourcePercentageAutoCompute = value;
    }
    resetHaAdmissionControlResourcePercentageAutoCompute() {
        this._haAdmissionControlResourcePercentageAutoCompute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageAutoComputeInput() {
        return this._haAdmissionControlResourcePercentageAutoCompute;
    }
    get haAdmissionControlResourcePercentageCpu() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_cpu');
    }
    set haAdmissionControlResourcePercentageCpu(value) {
        this._haAdmissionControlResourcePercentageCpu = value;
    }
    resetHaAdmissionControlResourcePercentageCpu() {
        this._haAdmissionControlResourcePercentageCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageCpuInput() {
        return this._haAdmissionControlResourcePercentageCpu;
    }
    get haAdmissionControlResourcePercentageMemory() {
        return this.getNumberAttribute('ha_admission_control_resource_percentage_memory');
    }
    set haAdmissionControlResourcePercentageMemory(value) {
        this._haAdmissionControlResourcePercentageMemory = value;
    }
    resetHaAdmissionControlResourcePercentageMemory() {
        this._haAdmissionControlResourcePercentageMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlResourcePercentageMemoryInput() {
        return this._haAdmissionControlResourcePercentageMemory;
    }
    get haAdmissionControlSlotPolicyExplicitCpu() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_cpu');
    }
    set haAdmissionControlSlotPolicyExplicitCpu(value) {
        this._haAdmissionControlSlotPolicyExplicitCpu = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitCpu() {
        this._haAdmissionControlSlotPolicyExplicitCpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitCpuInput() {
        return this._haAdmissionControlSlotPolicyExplicitCpu;
    }
    get haAdmissionControlSlotPolicyExplicitMemory() {
        return this.getNumberAttribute('ha_admission_control_slot_policy_explicit_memory');
    }
    set haAdmissionControlSlotPolicyExplicitMemory(value) {
        this._haAdmissionControlSlotPolicyExplicitMemory = value;
    }
    resetHaAdmissionControlSlotPolicyExplicitMemory() {
        this._haAdmissionControlSlotPolicyExplicitMemory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyExplicitMemoryInput() {
        return this._haAdmissionControlSlotPolicyExplicitMemory;
    }
    get haAdmissionControlSlotPolicyUseExplicitSize() {
        return this.getBooleanAttribute('ha_admission_control_slot_policy_use_explicit_size');
    }
    set haAdmissionControlSlotPolicyUseExplicitSize(value) {
        this._haAdmissionControlSlotPolicyUseExplicitSize = value;
    }
    resetHaAdmissionControlSlotPolicyUseExplicitSize() {
        this._haAdmissionControlSlotPolicyUseExplicitSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdmissionControlSlotPolicyUseExplicitSizeInput() {
        return this._haAdmissionControlSlotPolicyUseExplicitSize;
    }
    get haAdvancedOptions() {
        return this.getStringMapAttribute('ha_advanced_options');
    }
    set haAdvancedOptions(value) {
        this._haAdvancedOptions = value;
    }
    resetHaAdvancedOptions() {
        this._haAdvancedOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haAdvancedOptionsInput() {
        return this._haAdvancedOptions;
    }
    get haDatastoreApdRecoveryAction() {
        return this.getStringAttribute('ha_datastore_apd_recovery_action');
    }
    set haDatastoreApdRecoveryAction(value) {
        this._haDatastoreApdRecoveryAction = value;
    }
    resetHaDatastoreApdRecoveryAction() {
        this._haDatastoreApdRecoveryAction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdRecoveryActionInput() {
        return this._haDatastoreApdRecoveryAction;
    }
    get haDatastoreApdResponse() {
        return this.getStringAttribute('ha_datastore_apd_response');
    }
    set haDatastoreApdResponse(value) {
        this._haDatastoreApdResponse = value;
    }
    resetHaDatastoreApdResponse() {
        this._haDatastoreApdResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseInput() {
        return this._haDatastoreApdResponse;
    }
    get haDatastoreApdResponseDelay() {
        return this.getNumberAttribute('ha_datastore_apd_response_delay');
    }
    set haDatastoreApdResponseDelay(value) {
        this._haDatastoreApdResponseDelay = value;
    }
    resetHaDatastoreApdResponseDelay() {
        this._haDatastoreApdResponseDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastoreApdResponseDelayInput() {
        return this._haDatastoreApdResponseDelay;
    }
    get haDatastorePdlResponse() {
        return this.getStringAttribute('ha_datastore_pdl_response');
    }
    set haDatastorePdlResponse(value) {
        this._haDatastorePdlResponse = value;
    }
    resetHaDatastorePdlResponse() {
        this._haDatastorePdlResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haDatastorePdlResponseInput() {
        return this._haDatastorePdlResponse;
    }
    get haEnabled() {
        return this.getBooleanAttribute('ha_enabled');
    }
    set haEnabled(value) {
        this._haEnabled = value;
    }
    resetHaEnabled() {
        this._haEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haEnabledInput() {
        return this._haEnabled;
    }
    get haHeartbeatDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('ha_heartbeat_datastore_ids'));
    }
    set haHeartbeatDatastoreIds(value) {
        this._haHeartbeatDatastoreIds = value;
    }
    resetHaHeartbeatDatastoreIds() {
        this._haHeartbeatDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastoreIdsInput() {
        return this._haHeartbeatDatastoreIds;
    }
    get haHeartbeatDatastorePolicy() {
        return this.getStringAttribute('ha_heartbeat_datastore_policy');
    }
    set haHeartbeatDatastorePolicy(value) {
        this._haHeartbeatDatastorePolicy = value;
    }
    resetHaHeartbeatDatastorePolicy() {
        this._haHeartbeatDatastorePolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHeartbeatDatastorePolicyInput() {
        return this._haHeartbeatDatastorePolicy;
    }
    get haHostIsolationResponse() {
        return this.getStringAttribute('ha_host_isolation_response');
    }
    set haHostIsolationResponse(value) {
        this._haHostIsolationResponse = value;
    }
    resetHaHostIsolationResponse() {
        this._haHostIsolationResponse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostIsolationResponseInput() {
        return this._haHostIsolationResponse;
    }
    get haHostMonitoring() {
        return this.getStringAttribute('ha_host_monitoring');
    }
    set haHostMonitoring(value) {
        this._haHostMonitoring = value;
    }
    resetHaHostMonitoring() {
        this._haHostMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haHostMonitoringInput() {
        return this._haHostMonitoring;
    }
    get haVmComponentProtection() {
        return this.getStringAttribute('ha_vm_component_protection');
    }
    set haVmComponentProtection(value) {
        this._haVmComponentProtection = value;
    }
    resetHaVmComponentProtection() {
        this._haVmComponentProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmComponentProtectionInput() {
        return this._haVmComponentProtection;
    }
    get haVmDependencyRestartCondition() {
        return this.getStringAttribute('ha_vm_dependency_restart_condition');
    }
    set haVmDependencyRestartCondition(value) {
        this._haVmDependencyRestartCondition = value;
    }
    resetHaVmDependencyRestartCondition() {
        this._haVmDependencyRestartCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmDependencyRestartConditionInput() {
        return this._haVmDependencyRestartCondition;
    }
    get haVmFailureInterval() {
        return this.getNumberAttribute('ha_vm_failure_interval');
    }
    set haVmFailureInterval(value) {
        this._haVmFailureInterval = value;
    }
    resetHaVmFailureInterval() {
        this._haVmFailureInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmFailureIntervalInput() {
        return this._haVmFailureInterval;
    }
    get haVmMaximumFailureWindow() {
        return this.getNumberAttribute('ha_vm_maximum_failure_window');
    }
    set haVmMaximumFailureWindow(value) {
        this._haVmMaximumFailureWindow = value;
    }
    resetHaVmMaximumFailureWindow() {
        this._haVmMaximumFailureWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumFailureWindowInput() {
        return this._haVmMaximumFailureWindow;
    }
    get haVmMaximumResets() {
        return this.getNumberAttribute('ha_vm_maximum_resets');
    }
    set haVmMaximumResets(value) {
        this._haVmMaximumResets = value;
    }
    resetHaVmMaximumResets() {
        this._haVmMaximumResets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMaximumResetsInput() {
        return this._haVmMaximumResets;
    }
    get haVmMinimumUptime() {
        return this.getNumberAttribute('ha_vm_minimum_uptime');
    }
    set haVmMinimumUptime(value) {
        this._haVmMinimumUptime = value;
    }
    resetHaVmMinimumUptime() {
        this._haVmMinimumUptime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMinimumUptimeInput() {
        return this._haVmMinimumUptime;
    }
    get haVmMonitoring() {
        return this.getStringAttribute('ha_vm_monitoring');
    }
    set haVmMonitoring(value) {
        this._haVmMonitoring = value;
    }
    resetHaVmMonitoring() {
        this._haVmMonitoring = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmMonitoringInput() {
        return this._haVmMonitoring;
    }
    get haVmRestartAdditionalDelay() {
        return this.getNumberAttribute('ha_vm_restart_additional_delay');
    }
    set haVmRestartAdditionalDelay(value) {
        this._haVmRestartAdditionalDelay = value;
    }
    resetHaVmRestartAdditionalDelay() {
        this._haVmRestartAdditionalDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartAdditionalDelayInput() {
        return this._haVmRestartAdditionalDelay;
    }
    get haVmRestartPriority() {
        return this.getStringAttribute('ha_vm_restart_priority');
    }
    set haVmRestartPriority(value) {
        this._haVmRestartPriority = value;
    }
    resetHaVmRestartPriority() {
        this._haVmRestartPriority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartPriorityInput() {
        return this._haVmRestartPriority;
    }
    get haVmRestartTimeout() {
        return this.getNumberAttribute('ha_vm_restart_timeout');
    }
    set haVmRestartTimeout(value) {
        this._haVmRestartTimeout = value;
    }
    resetHaVmRestartTimeout() {
        this._haVmRestartTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get haVmRestartTimeoutInput() {
        return this._haVmRestartTimeout;
    }
    get hostClusterExitTimeout() {
        return this.getNumberAttribute('host_cluster_exit_timeout');
    }
    set hostClusterExitTimeout(value) {
        this._hostClusterExitTimeout = value;
    }
    resetHostClusterExitTimeout() {
        this._hostClusterExitTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostClusterExitTimeoutInput() {
        return this._hostClusterExitTimeout;
    }
    get hostManaged() {
        return this.getBooleanAttribute('host_managed');
    }
    set hostManaged(value) {
        this._hostManaged = value;
    }
    resetHostManaged() {
        this._hostManaged = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostManagedInput() {
        return this._hostManaged;
    }
    get hostSystemIds() {
        return cdktf.Fn.tolist(this.getListAttribute('host_system_ids'));
    }
    set hostSystemIds(value) {
        this._hostSystemIds = value;
    }
    resetHostSystemIds() {
        this._hostSystemIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostSystemIdsInput() {
        return this._hostSystemIds;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get proactiveHaAutomationLevel() {
        return this.getStringAttribute('proactive_ha_automation_level');
    }
    set proactiveHaAutomationLevel(value) {
        this._proactiveHaAutomationLevel = value;
    }
    resetProactiveHaAutomationLevel() {
        this._proactiveHaAutomationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaAutomationLevelInput() {
        return this._proactiveHaAutomationLevel;
    }
    get proactiveHaEnabled() {
        return this.getBooleanAttribute('proactive_ha_enabled');
    }
    set proactiveHaEnabled(value) {
        this._proactiveHaEnabled = value;
    }
    resetProactiveHaEnabled() {
        this._proactiveHaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaEnabledInput() {
        return this._proactiveHaEnabled;
    }
    get proactiveHaModerateRemediation() {
        return this.getStringAttribute('proactive_ha_moderate_remediation');
    }
    set proactiveHaModerateRemediation(value) {
        this._proactiveHaModerateRemediation = value;
    }
    resetProactiveHaModerateRemediation() {
        this._proactiveHaModerateRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaModerateRemediationInput() {
        return this._proactiveHaModerateRemediation;
    }
    get proactiveHaProviderIds() {
        return cdktf.Fn.tolist(this.getListAttribute('proactive_ha_provider_ids'));
    }
    set proactiveHaProviderIds(value) {
        this._proactiveHaProviderIds = value;
    }
    resetProactiveHaProviderIds() {
        this._proactiveHaProviderIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaProviderIdsInput() {
        return this._proactiveHaProviderIds;
    }
    get proactiveHaSevereRemediation() {
        return this.getStringAttribute('proactive_ha_severe_remediation');
    }
    set proactiveHaSevereRemediation(value) {
        this._proactiveHaSevereRemediation = value;
    }
    resetProactiveHaSevereRemediation() {
        this._proactiveHaSevereRemediation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proactiveHaSevereRemediationInput() {
        return this._proactiveHaSevereRemediation;
    }
    // resource_pool_id - computed: true, optional: false, required: false
    get resourcePoolId() {
        return this.getStringAttribute('resource_pool_id');
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get vsanCompressionEnabled() {
        return this.getBooleanAttribute('vsan_compression_enabled');
    }
    set vsanCompressionEnabled(value) {
        this._vsanCompressionEnabled = value;
    }
    resetVsanCompressionEnabled() {
        this._vsanCompressionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanCompressionEnabledInput() {
        return this._vsanCompressionEnabled;
    }
    get vsanDedupEnabled() {
        return this.getBooleanAttribute('vsan_dedup_enabled');
    }
    set vsanDedupEnabled(value) {
        this._vsanDedupEnabled = value;
    }
    resetVsanDedupEnabled() {
        this._vsanDedupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDedupEnabledInput() {
        return this._vsanDedupEnabled;
    }
    get vsanDitEncryptionEnabled() {
        return this.getBooleanAttribute('vsan_dit_encryption_enabled');
    }
    set vsanDitEncryptionEnabled(value) {
        this._vsanDitEncryptionEnabled = value;
    }
    resetVsanDitEncryptionEnabled() {
        this._vsanDitEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitEncryptionEnabledInput() {
        return this._vsanDitEncryptionEnabled;
    }
    get vsanDitRekeyInterval() {
        return this.getNumberAttribute('vsan_dit_rekey_interval');
    }
    set vsanDitRekeyInterval(value) {
        this._vsanDitRekeyInterval = value;
    }
    resetVsanDitRekeyInterval() {
        this._vsanDitRekeyInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDitRekeyIntervalInput() {
        return this._vsanDitRekeyInterval;
    }
    get vsanEnabled() {
        return this.getBooleanAttribute('vsan_enabled');
    }
    set vsanEnabled(value) {
        this._vsanEnabled = value;
    }
    resetVsanEnabled() {
        this._vsanEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanEnabledInput() {
        return this._vsanEnabled;
    }
    get vsanNetworkDiagnosticModeEnabled() {
        return this.getBooleanAttribute('vsan_network_diagnostic_mode_enabled');
    }
    set vsanNetworkDiagnosticModeEnabled(value) {
        this._vsanNetworkDiagnosticModeEnabled = value;
    }
    resetVsanNetworkDiagnosticModeEnabled() {
        this._vsanNetworkDiagnosticModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanNetworkDiagnosticModeEnabledInput() {
        return this._vsanNetworkDiagnosticModeEnabled;
    }
    get vsanPerformanceEnabled() {
        return this.getBooleanAttribute('vsan_performance_enabled');
    }
    set vsanPerformanceEnabled(value) {
        this._vsanPerformanceEnabled = value;
    }
    resetVsanPerformanceEnabled() {
        this._vsanPerformanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanPerformanceEnabledInput() {
        return this._vsanPerformanceEnabled;
    }
    get vsanRemoteDatastoreIds() {
        return cdktf.Fn.tolist(this.getListAttribute('vsan_remote_datastore_ids'));
    }
    set vsanRemoteDatastoreIds(value) {
        this._vsanRemoteDatastoreIds = value;
    }
    resetVsanRemoteDatastoreIds() {
        this._vsanRemoteDatastoreIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanRemoteDatastoreIdsInput() {
        return this._vsanRemoteDatastoreIds;
    }
    get vsanUnmapEnabled() {
        return this.getBooleanAttribute('vsan_unmap_enabled');
    }
    set vsanUnmapEnabled(value) {
        this._vsanUnmapEnabled = value;
    }
    resetVsanUnmapEnabled() {
        this._vsanUnmapEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanUnmapEnabledInput() {
        return this._vsanUnmapEnabled;
    }
    get vsanVerboseModeEnabled() {
        return this.getBooleanAttribute('vsan_verbose_mode_enabled');
    }
    set vsanVerboseModeEnabled(value) {
        this._vsanVerboseModeEnabled = value;
    }
    resetVsanVerboseModeEnabled() {
        this._vsanVerboseModeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanVerboseModeEnabledInput() {
        return this._vsanVerboseModeEnabled;
    }
    get vsanDiskGroup() {
        return this._vsanDiskGroup;
    }
    putVsanDiskGroup(value) {
        this._vsanDiskGroup.internalValue = value;
    }
    resetVsanDiskGroup() {
        this._vsanDiskGroup.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vsanDiskGroupInput() {
        return this._vsanDiskGroup.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            datacenter_id: cdktf.stringToTerraform(this._datacenterId),
            dpm_automation_level: cdktf.stringToTerraform(this._dpmAutomationLevel),
            dpm_enabled: cdktf.booleanToTerraform(this._dpmEnabled),
            dpm_threshold: cdktf.numberToTerraform(this._dpmThreshold),
            drs_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._drsAdvancedOptions),
            drs_automation_level: cdktf.stringToTerraform(this._drsAutomationLevel),
            drs_enable_predictive_drs: cdktf.booleanToTerraform(this._drsEnablePredictiveDrs),
            drs_enable_vm_overrides: cdktf.booleanToTerraform(this._drsEnableVmOverrides),
            drs_enabled: cdktf.booleanToTerraform(this._drsEnabled),
            drs_migration_threshold: cdktf.numberToTerraform(this._drsMigrationThreshold),
            drs_scale_descendants_shares: cdktf.stringToTerraform(this._drsScaleDescendantsShares),
            folder: cdktf.stringToTerraform(this._folder),
            force_evacuate_on_destroy: cdktf.booleanToTerraform(this._forceEvacuateOnDestroy),
            ha_admission_control_failover_host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haAdmissionControlFailoverHostSystemIds),
            ha_admission_control_host_failure_tolerance: cdktf.numberToTerraform(this._haAdmissionControlHostFailureTolerance),
            ha_admission_control_performance_tolerance: cdktf.numberToTerraform(this._haAdmissionControlPerformanceTolerance),
            ha_admission_control_policy: cdktf.stringToTerraform(this._haAdmissionControlPolicy),
            ha_admission_control_resource_percentage_auto_compute: cdktf.booleanToTerraform(this._haAdmissionControlResourcePercentageAutoCompute),
            ha_admission_control_resource_percentage_cpu: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageCpu),
            ha_admission_control_resource_percentage_memory: cdktf.numberToTerraform(this._haAdmissionControlResourcePercentageMemory),
            ha_admission_control_slot_policy_explicit_cpu: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitCpu),
            ha_admission_control_slot_policy_explicit_memory: cdktf.numberToTerraform(this._haAdmissionControlSlotPolicyExplicitMemory),
            ha_admission_control_slot_policy_use_explicit_size: cdktf.booleanToTerraform(this._haAdmissionControlSlotPolicyUseExplicitSize),
            ha_advanced_options: cdktf.hashMapper(cdktf.stringToTerraform)(this._haAdvancedOptions),
            ha_datastore_apd_recovery_action: cdktf.stringToTerraform(this._haDatastoreApdRecoveryAction),
            ha_datastore_apd_response: cdktf.stringToTerraform(this._haDatastoreApdResponse),
            ha_datastore_apd_response_delay: cdktf.numberToTerraform(this._haDatastoreApdResponseDelay),
            ha_datastore_pdl_response: cdktf.stringToTerraform(this._haDatastorePdlResponse),
            ha_enabled: cdktf.booleanToTerraform(this._haEnabled),
            ha_heartbeat_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._haHeartbeatDatastoreIds),
            ha_heartbeat_datastore_policy: cdktf.stringToTerraform(this._haHeartbeatDatastorePolicy),
            ha_host_isolation_response: cdktf.stringToTerraform(this._haHostIsolationResponse),
            ha_host_monitoring: cdktf.stringToTerraform(this._haHostMonitoring),
            ha_vm_component_protection: cdktf.stringToTerraform(this._haVmComponentProtection),
            ha_vm_dependency_restart_condition: cdktf.stringToTerraform(this._haVmDependencyRestartCondition),
            ha_vm_failure_interval: cdktf.numberToTerraform(this._haVmFailureInterval),
            ha_vm_maximum_failure_window: cdktf.numberToTerraform(this._haVmMaximumFailureWindow),
            ha_vm_maximum_resets: cdktf.numberToTerraform(this._haVmMaximumResets),
            ha_vm_minimum_uptime: cdktf.numberToTerraform(this._haVmMinimumUptime),
            ha_vm_monitoring: cdktf.stringToTerraform(this._haVmMonitoring),
            ha_vm_restart_additional_delay: cdktf.numberToTerraform(this._haVmRestartAdditionalDelay),
            ha_vm_restart_priority: cdktf.stringToTerraform(this._haVmRestartPriority),
            ha_vm_restart_timeout: cdktf.numberToTerraform(this._haVmRestartTimeout),
            host_cluster_exit_timeout: cdktf.numberToTerraform(this._hostClusterExitTimeout),
            host_managed: cdktf.booleanToTerraform(this._hostManaged),
            host_system_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._hostSystemIds),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            proactive_ha_automation_level: cdktf.stringToTerraform(this._proactiveHaAutomationLevel),
            proactive_ha_enabled: cdktf.booleanToTerraform(this._proactiveHaEnabled),
            proactive_ha_moderate_remediation: cdktf.stringToTerraform(this._proactiveHaModerateRemediation),
            proactive_ha_provider_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._proactiveHaProviderIds),
            proactive_ha_severe_remediation: cdktf.stringToTerraform(this._proactiveHaSevereRemediation),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            vsan_compression_enabled: cdktf.booleanToTerraform(this._vsanCompressionEnabled),
            vsan_dedup_enabled: cdktf.booleanToTerraform(this._vsanDedupEnabled),
            vsan_dit_encryption_enabled: cdktf.booleanToTerraform(this._vsanDitEncryptionEnabled),
            vsan_dit_rekey_interval: cdktf.numberToTerraform(this._vsanDitRekeyInterval),
            vsan_enabled: cdktf.booleanToTerraform(this._vsanEnabled),
            vsan_network_diagnostic_mode_enabled: cdktf.booleanToTerraform(this._vsanNetworkDiagnosticModeEnabled),
            vsan_performance_enabled: cdktf.booleanToTerraform(this._vsanPerformanceEnabled),
            vsan_remote_datastore_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._vsanRemoteDatastoreIds),
            vsan_unmap_enabled: cdktf.booleanToTerraform(this._vsanUnmapEnabled),
            vsan_verbose_mode_enabled: cdktf.booleanToTerraform(this._vsanVerboseModeEnabled),
            vsan_disk_group: cdktf.listMapper(computeClusterVsanDiskGroupToTerraform, true)(this._vsanDiskGroup.internalValue),
        };
    }
}
exports.ComputeCluster = ComputeCluster;
_c = JSII_RTTI_SYMBOL_1;
ComputeCluster[_c] = { fqn: "@cdktf/provider-vsphere.computeCluster.ComputeCluster", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
ComputeCluster.tfResourceType = "vsphere_compute_cluster";
//# sourceMappingURL=data:application/json;base64,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