import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#custom_attributes ComputeCluster#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The managed object ID of the datacenter to put the cluster in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#datacenter_id ComputeCluster#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * The automation level for host power operations in this cluster. Can be one of manual or automated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#dpm_automation_level ComputeCluster#dpm_automation_level}
    */
    readonly dpmAutomationLevel?: string;
    /**
    * Enable DPM support for DRS. This allows you to dynamically control the power of hosts depending on the needs of virtual machines in the cluster. Requires that DRS be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#dpm_enabled ComputeCluster#dpm_enabled}
    */
    readonly dpmEnabled?: boolean | cdktf.IResolvable;
    /**
    * A value between 1 and 5 indicating the threshold of load within the cluster that influences host power operations. This affects both power on and power off operations - a lower setting will tolerate more of a surplus/deficit than a higher setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#dpm_threshold ComputeCluster#dpm_threshold}
    */
    readonly dpmThreshold?: number;
    /**
    * Advanced configuration options for DRS and DPM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_advanced_options ComputeCluster#drs_advanced_options}
    */
    readonly drsAdvancedOptions?: {
        [key: string]: string;
    };
    /**
    * The default automation level for all virtual machines in this cluster. Can be one of manual, partiallyAutomated, or fullyAutomated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_automation_level ComputeCluster#drs_automation_level}
    */
    readonly drsAutomationLevel?: string;
    /**
    * When true, enables DRS to use data from vRealize Operations Manager to make proactive DRS recommendations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_enable_predictive_drs ComputeCluster#drs_enable_predictive_drs}
    */
    readonly drsEnablePredictiveDrs?: boolean | cdktf.IResolvable;
    /**
    * When true, allows individual VM overrides within this cluster to be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_enable_vm_overrides ComputeCluster#drs_enable_vm_overrides}
    */
    readonly drsEnableVmOverrides?: boolean | cdktf.IResolvable;
    /**
    * Enable DRS for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_enabled ComputeCluster#drs_enabled}
    */
    readonly drsEnabled?: boolean | cdktf.IResolvable;
    /**
    * A value between 1 and 5 indicating the threshold of imbalance tolerated between hosts. A lower setting will tolerate more imbalance while a higher setting will tolerate less.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_migration_threshold ComputeCluster#drs_migration_threshold}
    */
    readonly drsMigrationThreshold?: number;
    /**
    * Enable scalable shares for all descendants of this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#drs_scale_descendants_shares ComputeCluster#drs_scale_descendants_shares}
    */
    readonly drsScaleDescendantsShares?: string;
    /**
    * The name of the folder to locate the cluster in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#folder ComputeCluster#folder}
    */
    readonly folder?: string;
    /**
    * Force removal of all hosts in the cluster during destroy and make them standalone hosts. Use of this flag mainly exists for testing and is not recommended in normal use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#force_evacuate_on_destroy ComputeCluster#force_evacuate_on_destroy}
    */
    readonly forceEvacuateOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * When ha_admission_control_policy is failoverHosts, this defines the managed object IDs of hosts to use as dedicated failover hosts. These hosts are kept as available as possible - admission control will block access to the host, and DRS will ignore the host when making recommendations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_failover_host_system_ids ComputeCluster#ha_admission_control_failover_host_system_ids}
    */
    readonly haAdmissionControlFailoverHostSystemIds?: string[];
    /**
    * The maximum number of failed hosts that admission control tolerates when making decisions on whether to permit virtual machine operations. The maximum is one less than the number of hosts in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_host_failure_tolerance ComputeCluster#ha_admission_control_host_failure_tolerance}
    */
    readonly haAdmissionControlHostFailureTolerance?: number;
    /**
    * The percentage of resource reduction that a cluster of VMs can tolerate in case of a failover. A value of 0 produces warnings only, whereas a value of 100 disables the setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_performance_tolerance ComputeCluster#ha_admission_control_performance_tolerance}
    */
    readonly haAdmissionControlPerformanceTolerance?: number;
    /**
    * The type of admission control policy to use with vSphere HA, which controls whether or not specific VM operations are permitted in the cluster in order to protect the reliability of the cluster. Can be one of resourcePercentage, slotPolicy, failoverHosts, or disabled. Note that disabling admission control is not recommended and can lead to service issues.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_policy ComputeCluster#ha_admission_control_policy}
    */
    readonly haAdmissionControlPolicy?: string;
    /**
    * When ha_admission_control_policy is resourcePercentage, automatically determine available resource percentages by subtracting the average number of host resources represented by the ha_admission_control_host_failure_tolerance setting from the total amount of resources in the cluster. Disable to supply user-defined values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_resource_percentage_auto_compute ComputeCluster#ha_admission_control_resource_percentage_auto_compute}
    */
    readonly haAdmissionControlResourcePercentageAutoCompute?: boolean | cdktf.IResolvable;
    /**
    * When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of CPU resources in the cluster to reserve for failover.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_resource_percentage_cpu ComputeCluster#ha_admission_control_resource_percentage_cpu}
    */
    readonly haAdmissionControlResourcePercentageCpu?: number;
    /**
    * When ha_admission_control_policy is resourcePercentage, this controls the user-defined percentage of memory resources in the cluster to reserve for failover.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_resource_percentage_memory ComputeCluster#ha_admission_control_resource_percentage_memory}
    */
    readonly haAdmissionControlResourcePercentageMemory?: number;
    /**
    * When ha_admission_control_policy is slotPolicy, this controls the user-defined CPU slot size, in MHz.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_slot_policy_explicit_cpu ComputeCluster#ha_admission_control_slot_policy_explicit_cpu}
    */
    readonly haAdmissionControlSlotPolicyExplicitCpu?: number;
    /**
    * When ha_admission_control_policy is slotPolicy, this controls the user-defined memory slot size, in MB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_slot_policy_explicit_memory ComputeCluster#ha_admission_control_slot_policy_explicit_memory}
    */
    readonly haAdmissionControlSlotPolicyExplicitMemory?: number;
    /**
    * When ha_admission_control_policy is slotPolicy, this setting controls whether or not you wish to supply explicit values to CPU and memory slot sizes. The default is to gather a automatic average based on all powered-on virtual machines currently in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_admission_control_slot_policy_use_explicit_size ComputeCluster#ha_admission_control_slot_policy_use_explicit_size}
    */
    readonly haAdmissionControlSlotPolicyUseExplicitSize?: boolean | cdktf.IResolvable;
    /**
    * Advanced configuration options for vSphere HA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_advanced_options ComputeCluster#ha_advanced_options}
    */
    readonly haAdvancedOptions?: {
        [key: string]: string;
    };
    /**
    * When ha_vm_component_protection is enabled, controls the action to take on virtual machines if an APD status on an affected datastore clears in the middle of an APD event. Can be one of none or reset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_datastore_apd_recovery_action ComputeCluster#ha_datastore_apd_recovery_action}
    */
    readonly haDatastoreApdRecoveryAction?: string;
    /**
    * When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has detected loss to all paths to a relevant datastore. Can be one of disabled, warning, restartConservative, or restartAggressive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_datastore_apd_response ComputeCluster#ha_datastore_apd_response}
    */
    readonly haDatastoreApdResponse?: string;
    /**
    * When ha_vm_component_protection is enabled, controls the delay in seconds to wait after an APD timeout event to execute the response action defined in ha_datastore_apd_response.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_datastore_apd_response_delay ComputeCluster#ha_datastore_apd_response_delay}
    */
    readonly haDatastoreApdResponseDelay?: number;
    /**
    * When ha_vm_component_protection is enabled, controls the action to take on virtual machines when the cluster has detected a permanent device loss to a relevant datastore. Can be one of disabled, warning, or restartAggressive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_datastore_pdl_response ComputeCluster#ha_datastore_pdl_response}
    */
    readonly haDatastorePdlResponse?: string;
    /**
    * Enable vSphere HA for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_enabled ComputeCluster#ha_enabled}
    */
    readonly haEnabled?: boolean | cdktf.IResolvable;
    /**
    * The list of managed object IDs for preferred datastores to use for HA heartbeating. This setting is only useful when ha_heartbeat_datastore_policy is set to either userSelectedDs or allFeasibleDsWithUserPreference.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_heartbeat_datastore_ids ComputeCluster#ha_heartbeat_datastore_ids}
    */
    readonly haHeartbeatDatastoreIds?: string[];
    /**
    * The selection policy for HA heartbeat datastores. Can be one of allFeasibleDs, userSelectedDs, or allFeasibleDsWithUserPreference.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_heartbeat_datastore_policy ComputeCluster#ha_heartbeat_datastore_policy}
    */
    readonly haHeartbeatDatastorePolicy?: string;
    /**
    * The action to take on virtual machines when a host has detected that it has been isolated from the rest of the cluster. Can be one of none, powerOff, or shutdown.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_host_isolation_response ComputeCluster#ha_host_isolation_response}
    */
    readonly haHostIsolationResponse?: string;
    /**
    * Global setting that controls whether vSphere HA remediates VMs on host failure. Can be one of enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_host_monitoring ComputeCluster#ha_host_monitoring}
    */
    readonly haHostMonitoring?: string;
    /**
    * Controls vSphere VM component protection for virtual machines in this cluster. This allows vSphere HA to react to failures between hosts and specific virtual machine components, such as datastores. Can be one of enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_component_protection ComputeCluster#ha_vm_component_protection}
    */
    readonly haVmComponentProtection?: string;
    /**
    * The condition used to determine whether or not VMs in a certain restart priority class are online, allowing HA to move on to restarting VMs on the next priority. Can be one of none, poweredOn, guestHbStatusGreen, or appHbStatusGreen.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_dependency_restart_condition ComputeCluster#ha_vm_dependency_restart_condition}
    */
    readonly haVmDependencyRestartCondition?: string;
    /**
    * If a heartbeat from a virtual machine is not received within this configured interval, the virtual machine is marked as failed. The value is in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_failure_interval ComputeCluster#ha_vm_failure_interval}
    */
    readonly haVmFailureInterval?: number;
    /**
    * The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset time is allotted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_maximum_failure_window ComputeCluster#ha_vm_maximum_failure_window}
    */
    readonly haVmMaximumFailureWindow?: number;
    /**
    * The maximum number of resets that HA will perform to a virtual machine when responding to a failure event.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_maximum_resets ComputeCluster#ha_vm_maximum_resets}
    */
    readonly haVmMaximumResets?: number;
    /**
    * The time, in seconds, that HA waits after powering on a virtual machine before monitoring for heartbeats.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_minimum_uptime ComputeCluster#ha_vm_minimum_uptime}
    */
    readonly haVmMinimumUptime?: number;
    /**
    * The type of virtual machine monitoring to use when HA is enabled in the cluster. Can be one of vmMonitoringDisabled, vmMonitoringOnly, or vmAndAppMonitoring.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_monitoring ComputeCluster#ha_vm_monitoring}
    */
    readonly haVmMonitoring?: string;
    /**
    * Additional delay in seconds after ready condition is met. A VM is considered ready at this point.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_restart_additional_delay ComputeCluster#ha_vm_restart_additional_delay}
    */
    readonly haVmRestartAdditionalDelay?: number;
    /**
    * The default restart priority for affected VMs when vSphere detects a host failure. Can be one of lowest, low, medium, high, or highest.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_restart_priority ComputeCluster#ha_vm_restart_priority}
    */
    readonly haVmRestartPriority?: string;
    /**
    * The maximum time, in seconds, that vSphere HA will wait for virtual machines in one priority to be ready before proceeding with the next priority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#ha_vm_restart_timeout ComputeCluster#ha_vm_restart_timeout}
    */
    readonly haVmRestartTimeout?: number;
    /**
    * The timeout for each host maintenance mode operation when removing hosts from a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#host_cluster_exit_timeout ComputeCluster#host_cluster_exit_timeout}
    */
    readonly hostClusterExitTimeout?: number;
    /**
    * Must be set if cluster enrollment is managed from host resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#host_managed ComputeCluster#host_managed}
    */
    readonly hostManaged?: boolean | cdktf.IResolvable;
    /**
    * The managed object IDs of the hosts to put in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#host_system_ids ComputeCluster#host_system_ids}
    */
    readonly hostSystemIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#id ComputeCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name for the new cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#name ComputeCluster#name}
    */
    readonly name: string;
    /**
    * The DRS behavior for proactive HA recommendations. Can be one of Automated or Manual.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#proactive_ha_automation_level ComputeCluster#proactive_ha_automation_level}
    */
    readonly proactiveHaAutomationLevel?: string;
    /**
    * Enables proactive HA, allowing for vSphere to get HA data from external providers and use DRS to perform remediation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#proactive_ha_enabled ComputeCluster#proactive_ha_enabled}
    */
    readonly proactiveHaEnabled?: boolean | cdktf.IResolvable;
    /**
    * The configured remediation for moderately degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this cannot be set to MaintenanceMode when proactive_ha_severe_remediation is set to QuarantineMode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#proactive_ha_moderate_remediation ComputeCluster#proactive_ha_moderate_remediation}
    */
    readonly proactiveHaModerateRemediation?: string;
    /**
    * The list of IDs for health update providers configured for this cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#proactive_ha_provider_ids ComputeCluster#proactive_ha_provider_ids}
    */
    readonly proactiveHaProviderIds?: string[];
    /**
    * The configured remediation for severely degraded hosts. Can be one of MaintenanceMode or QuarantineMode. Note that this cannot be set to QuarantineMode when proactive_ha_moderate_remediation is set to MaintenanceMode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#proactive_ha_severe_remediation ComputeCluster#proactive_ha_severe_remediation}
    */
    readonly proactiveHaSevereRemediation?: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#tags ComputeCluster#tags}
    */
    readonly tags?: string[];
    /**
    * Whether the vSAN compression service is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_compression_enabled ComputeCluster#vsan_compression_enabled}
    */
    readonly vsanCompressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the vSAN deduplication service is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_dedup_enabled ComputeCluster#vsan_dedup_enabled}
    */
    readonly vsanDedupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the vSAN data-in-transit encryption is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_dit_encryption_enabled ComputeCluster#vsan_dit_encryption_enabled}
    */
    readonly vsanDitEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * When vsan_dit_encryption_enabled is enabled, sets the rekey interval of data-in-transit encryption (in minutes).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_dit_rekey_interval ComputeCluster#vsan_dit_rekey_interval}
    */
    readonly vsanDitRekeyInterval?: number;
    /**
    * Whether the vSAN service is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_enabled ComputeCluster#vsan_enabled}
    */
    readonly vsanEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the vSAN network diagnostic mode is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_network_diagnostic_mode_enabled ComputeCluster#vsan_network_diagnostic_mode_enabled}
    */
    readonly vsanNetworkDiagnosticModeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the vSAN performance service is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_performance_enabled ComputeCluster#vsan_performance_enabled}
    */
    readonly vsanPerformanceEnabled?: boolean | cdktf.IResolvable;
    /**
    * The managed object IDs of the vSAN datastore to be mounted on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_remote_datastore_ids ComputeCluster#vsan_remote_datastore_ids}
    */
    readonly vsanRemoteDatastoreIds?: string[];
    /**
    * Whether the vSAN unmap service is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_unmap_enabled ComputeCluster#vsan_unmap_enabled}
    */
    readonly vsanUnmapEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether the vSAN verbose mode is enabled for the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_verbose_mode_enabled ComputeCluster#vsan_verbose_mode_enabled}
    */
    readonly vsanVerboseModeEnabled?: boolean | cdktf.IResolvable;
    /**
    * vsan_disk_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#vsan_disk_group ComputeCluster#vsan_disk_group}
    */
    readonly vsanDiskGroup?: ComputeClusterVsanDiskGroup[] | cdktf.IResolvable;
}
export interface ComputeClusterVsanDiskGroup {
    /**
    * Cache disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#cache ComputeCluster#cache}
    */
    readonly cache?: string;
    /**
    * List of storage disks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster#storage ComputeCluster#storage}
    */
    readonly storage?: string[];
}
export declare function computeClusterVsanDiskGroupToTerraform(struct?: ComputeClusterVsanDiskGroup | cdktf.IResolvable): any;
export declare class ComputeClusterVsanDiskGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeClusterVsanDiskGroup | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeClusterVsanDiskGroup | cdktf.IResolvable | undefined);
    private _cache?;
    get cache(): string;
    set cache(value: string);
    resetCache(): void;
    get cacheInput(): string | undefined;
    private _storage?;
    get storage(): string[];
    set storage(value: string[]);
    resetStorage(): void;
    get storageInput(): string[] | undefined;
}
export declare class ComputeClusterVsanDiskGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeClusterVsanDiskGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeClusterVsanDiskGroupOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster}
*/
export declare class ComputeCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_compute_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/r/compute_cluster vsphere_compute_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeClusterConfig
    */
    constructor(scope: Construct, id: string, config: ComputeClusterConfig);
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _dpmAutomationLevel?;
    get dpmAutomationLevel(): string;
    set dpmAutomationLevel(value: string);
    resetDpmAutomationLevel(): void;
    get dpmAutomationLevelInput(): string | undefined;
    private _dpmEnabled?;
    get dpmEnabled(): boolean | cdktf.IResolvable;
    set dpmEnabled(value: boolean | cdktf.IResolvable);
    resetDpmEnabled(): void;
    get dpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dpmThreshold?;
    get dpmThreshold(): number;
    set dpmThreshold(value: number);
    resetDpmThreshold(): void;
    get dpmThresholdInput(): number | undefined;
    private _drsAdvancedOptions?;
    get drsAdvancedOptions(): {
        [key: string]: string;
    };
    set drsAdvancedOptions(value: {
        [key: string]: string;
    });
    resetDrsAdvancedOptions(): void;
    get drsAdvancedOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _drsAutomationLevel?;
    get drsAutomationLevel(): string;
    set drsAutomationLevel(value: string);
    resetDrsAutomationLevel(): void;
    get drsAutomationLevelInput(): string | undefined;
    private _drsEnablePredictiveDrs?;
    get drsEnablePredictiveDrs(): boolean | cdktf.IResolvable;
    set drsEnablePredictiveDrs(value: boolean | cdktf.IResolvable);
    resetDrsEnablePredictiveDrs(): void;
    get drsEnablePredictiveDrsInput(): boolean | cdktf.IResolvable | undefined;
    private _drsEnableVmOverrides?;
    get drsEnableVmOverrides(): boolean | cdktf.IResolvable;
    set drsEnableVmOverrides(value: boolean | cdktf.IResolvable);
    resetDrsEnableVmOverrides(): void;
    get drsEnableVmOverridesInput(): boolean | cdktf.IResolvable | undefined;
    private _drsEnabled?;
    get drsEnabled(): boolean | cdktf.IResolvable;
    set drsEnabled(value: boolean | cdktf.IResolvable);
    resetDrsEnabled(): void;
    get drsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _drsMigrationThreshold?;
    get drsMigrationThreshold(): number;
    set drsMigrationThreshold(value: number);
    resetDrsMigrationThreshold(): void;
    get drsMigrationThresholdInput(): number | undefined;
    private _drsScaleDescendantsShares?;
    get drsScaleDescendantsShares(): string;
    set drsScaleDescendantsShares(value: string);
    resetDrsScaleDescendantsShares(): void;
    get drsScaleDescendantsSharesInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _forceEvacuateOnDestroy?;
    get forceEvacuateOnDestroy(): boolean | cdktf.IResolvable;
    set forceEvacuateOnDestroy(value: boolean | cdktf.IResolvable);
    resetForceEvacuateOnDestroy(): void;
    get forceEvacuateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _haAdmissionControlFailoverHostSystemIds?;
    get haAdmissionControlFailoverHostSystemIds(): string[];
    set haAdmissionControlFailoverHostSystemIds(value: string[]);
    resetHaAdmissionControlFailoverHostSystemIds(): void;
    get haAdmissionControlFailoverHostSystemIdsInput(): string[] | undefined;
    private _haAdmissionControlHostFailureTolerance?;
    get haAdmissionControlHostFailureTolerance(): number;
    set haAdmissionControlHostFailureTolerance(value: number);
    resetHaAdmissionControlHostFailureTolerance(): void;
    get haAdmissionControlHostFailureToleranceInput(): number | undefined;
    private _haAdmissionControlPerformanceTolerance?;
    get haAdmissionControlPerformanceTolerance(): number;
    set haAdmissionControlPerformanceTolerance(value: number);
    resetHaAdmissionControlPerformanceTolerance(): void;
    get haAdmissionControlPerformanceToleranceInput(): number | undefined;
    private _haAdmissionControlPolicy?;
    get haAdmissionControlPolicy(): string;
    set haAdmissionControlPolicy(value: string);
    resetHaAdmissionControlPolicy(): void;
    get haAdmissionControlPolicyInput(): string | undefined;
    private _haAdmissionControlResourcePercentageAutoCompute?;
    get haAdmissionControlResourcePercentageAutoCompute(): boolean | cdktf.IResolvable;
    set haAdmissionControlResourcePercentageAutoCompute(value: boolean | cdktf.IResolvable);
    resetHaAdmissionControlResourcePercentageAutoCompute(): void;
    get haAdmissionControlResourcePercentageAutoComputeInput(): boolean | cdktf.IResolvable | undefined;
    private _haAdmissionControlResourcePercentageCpu?;
    get haAdmissionControlResourcePercentageCpu(): number;
    set haAdmissionControlResourcePercentageCpu(value: number);
    resetHaAdmissionControlResourcePercentageCpu(): void;
    get haAdmissionControlResourcePercentageCpuInput(): number | undefined;
    private _haAdmissionControlResourcePercentageMemory?;
    get haAdmissionControlResourcePercentageMemory(): number;
    set haAdmissionControlResourcePercentageMemory(value: number);
    resetHaAdmissionControlResourcePercentageMemory(): void;
    get haAdmissionControlResourcePercentageMemoryInput(): number | undefined;
    private _haAdmissionControlSlotPolicyExplicitCpu?;
    get haAdmissionControlSlotPolicyExplicitCpu(): number;
    set haAdmissionControlSlotPolicyExplicitCpu(value: number);
    resetHaAdmissionControlSlotPolicyExplicitCpu(): void;
    get haAdmissionControlSlotPolicyExplicitCpuInput(): number | undefined;
    private _haAdmissionControlSlotPolicyExplicitMemory?;
    get haAdmissionControlSlotPolicyExplicitMemory(): number;
    set haAdmissionControlSlotPolicyExplicitMemory(value: number);
    resetHaAdmissionControlSlotPolicyExplicitMemory(): void;
    get haAdmissionControlSlotPolicyExplicitMemoryInput(): number | undefined;
    private _haAdmissionControlSlotPolicyUseExplicitSize?;
    get haAdmissionControlSlotPolicyUseExplicitSize(): boolean | cdktf.IResolvable;
    set haAdmissionControlSlotPolicyUseExplicitSize(value: boolean | cdktf.IResolvable);
    resetHaAdmissionControlSlotPolicyUseExplicitSize(): void;
    get haAdmissionControlSlotPolicyUseExplicitSizeInput(): boolean | cdktf.IResolvable | undefined;
    private _haAdvancedOptions?;
    get haAdvancedOptions(): {
        [key: string]: string;
    };
    set haAdvancedOptions(value: {
        [key: string]: string;
    });
    resetHaAdvancedOptions(): void;
    get haAdvancedOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _haDatastoreApdRecoveryAction?;
    get haDatastoreApdRecoveryAction(): string;
    set haDatastoreApdRecoveryAction(value: string);
    resetHaDatastoreApdRecoveryAction(): void;
    get haDatastoreApdRecoveryActionInput(): string | undefined;
    private _haDatastoreApdResponse?;
    get haDatastoreApdResponse(): string;
    set haDatastoreApdResponse(value: string);
    resetHaDatastoreApdResponse(): void;
    get haDatastoreApdResponseInput(): string | undefined;
    private _haDatastoreApdResponseDelay?;
    get haDatastoreApdResponseDelay(): number;
    set haDatastoreApdResponseDelay(value: number);
    resetHaDatastoreApdResponseDelay(): void;
    get haDatastoreApdResponseDelayInput(): number | undefined;
    private _haDatastorePdlResponse?;
    get haDatastorePdlResponse(): string;
    set haDatastorePdlResponse(value: string);
    resetHaDatastorePdlResponse(): void;
    get haDatastorePdlResponseInput(): string | undefined;
    private _haEnabled?;
    get haEnabled(): boolean | cdktf.IResolvable;
    set haEnabled(value: boolean | cdktf.IResolvable);
    resetHaEnabled(): void;
    get haEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _haHeartbeatDatastoreIds?;
    get haHeartbeatDatastoreIds(): string[];
    set haHeartbeatDatastoreIds(value: string[]);
    resetHaHeartbeatDatastoreIds(): void;
    get haHeartbeatDatastoreIdsInput(): string[] | undefined;
    private _haHeartbeatDatastorePolicy?;
    get haHeartbeatDatastorePolicy(): string;
    set haHeartbeatDatastorePolicy(value: string);
    resetHaHeartbeatDatastorePolicy(): void;
    get haHeartbeatDatastorePolicyInput(): string | undefined;
    private _haHostIsolationResponse?;
    get haHostIsolationResponse(): string;
    set haHostIsolationResponse(value: string);
    resetHaHostIsolationResponse(): void;
    get haHostIsolationResponseInput(): string | undefined;
    private _haHostMonitoring?;
    get haHostMonitoring(): string;
    set haHostMonitoring(value: string);
    resetHaHostMonitoring(): void;
    get haHostMonitoringInput(): string | undefined;
    private _haVmComponentProtection?;
    get haVmComponentProtection(): string;
    set haVmComponentProtection(value: string);
    resetHaVmComponentProtection(): void;
    get haVmComponentProtectionInput(): string | undefined;
    private _haVmDependencyRestartCondition?;
    get haVmDependencyRestartCondition(): string;
    set haVmDependencyRestartCondition(value: string);
    resetHaVmDependencyRestartCondition(): void;
    get haVmDependencyRestartConditionInput(): string | undefined;
    private _haVmFailureInterval?;
    get haVmFailureInterval(): number;
    set haVmFailureInterval(value: number);
    resetHaVmFailureInterval(): void;
    get haVmFailureIntervalInput(): number | undefined;
    private _haVmMaximumFailureWindow?;
    get haVmMaximumFailureWindow(): number;
    set haVmMaximumFailureWindow(value: number);
    resetHaVmMaximumFailureWindow(): void;
    get haVmMaximumFailureWindowInput(): number | undefined;
    private _haVmMaximumResets?;
    get haVmMaximumResets(): number;
    set haVmMaximumResets(value: number);
    resetHaVmMaximumResets(): void;
    get haVmMaximumResetsInput(): number | undefined;
    private _haVmMinimumUptime?;
    get haVmMinimumUptime(): number;
    set haVmMinimumUptime(value: number);
    resetHaVmMinimumUptime(): void;
    get haVmMinimumUptimeInput(): number | undefined;
    private _haVmMonitoring?;
    get haVmMonitoring(): string;
    set haVmMonitoring(value: string);
    resetHaVmMonitoring(): void;
    get haVmMonitoringInput(): string | undefined;
    private _haVmRestartAdditionalDelay?;
    get haVmRestartAdditionalDelay(): number;
    set haVmRestartAdditionalDelay(value: number);
    resetHaVmRestartAdditionalDelay(): void;
    get haVmRestartAdditionalDelayInput(): number | undefined;
    private _haVmRestartPriority?;
    get haVmRestartPriority(): string;
    set haVmRestartPriority(value: string);
    resetHaVmRestartPriority(): void;
    get haVmRestartPriorityInput(): string | undefined;
    private _haVmRestartTimeout?;
    get haVmRestartTimeout(): number;
    set haVmRestartTimeout(value: number);
    resetHaVmRestartTimeout(): void;
    get haVmRestartTimeoutInput(): number | undefined;
    private _hostClusterExitTimeout?;
    get hostClusterExitTimeout(): number;
    set hostClusterExitTimeout(value: number);
    resetHostClusterExitTimeout(): void;
    get hostClusterExitTimeoutInput(): number | undefined;
    private _hostManaged?;
    get hostManaged(): boolean | cdktf.IResolvable;
    set hostManaged(value: boolean | cdktf.IResolvable);
    resetHostManaged(): void;
    get hostManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _hostSystemIds?;
    get hostSystemIds(): string[];
    set hostSystemIds(value: string[]);
    resetHostSystemIds(): void;
    get hostSystemIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _proactiveHaAutomationLevel?;
    get proactiveHaAutomationLevel(): string;
    set proactiveHaAutomationLevel(value: string);
    resetProactiveHaAutomationLevel(): void;
    get proactiveHaAutomationLevelInput(): string | undefined;
    private _proactiveHaEnabled?;
    get proactiveHaEnabled(): boolean | cdktf.IResolvable;
    set proactiveHaEnabled(value: boolean | cdktf.IResolvable);
    resetProactiveHaEnabled(): void;
    get proactiveHaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _proactiveHaModerateRemediation?;
    get proactiveHaModerateRemediation(): string;
    set proactiveHaModerateRemediation(value: string);
    resetProactiveHaModerateRemediation(): void;
    get proactiveHaModerateRemediationInput(): string | undefined;
    private _proactiveHaProviderIds?;
    get proactiveHaProviderIds(): string[];
    set proactiveHaProviderIds(value: string[]);
    resetProactiveHaProviderIds(): void;
    get proactiveHaProviderIdsInput(): string[] | undefined;
    private _proactiveHaSevereRemediation?;
    get proactiveHaSevereRemediation(): string;
    set proactiveHaSevereRemediation(value: string);
    resetProactiveHaSevereRemediation(): void;
    get proactiveHaSevereRemediationInput(): string | undefined;
    get resourcePoolId(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _vsanCompressionEnabled?;
    get vsanCompressionEnabled(): boolean | cdktf.IResolvable;
    set vsanCompressionEnabled(value: boolean | cdktf.IResolvable);
    resetVsanCompressionEnabled(): void;
    get vsanCompressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanDedupEnabled?;
    get vsanDedupEnabled(): boolean | cdktf.IResolvable;
    set vsanDedupEnabled(value: boolean | cdktf.IResolvable);
    resetVsanDedupEnabled(): void;
    get vsanDedupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanDitEncryptionEnabled?;
    get vsanDitEncryptionEnabled(): boolean | cdktf.IResolvable;
    set vsanDitEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetVsanDitEncryptionEnabled(): void;
    get vsanDitEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanDitRekeyInterval?;
    get vsanDitRekeyInterval(): number;
    set vsanDitRekeyInterval(value: number);
    resetVsanDitRekeyInterval(): void;
    get vsanDitRekeyIntervalInput(): number | undefined;
    private _vsanEnabled?;
    get vsanEnabled(): boolean | cdktf.IResolvable;
    set vsanEnabled(value: boolean | cdktf.IResolvable);
    resetVsanEnabled(): void;
    get vsanEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanNetworkDiagnosticModeEnabled?;
    get vsanNetworkDiagnosticModeEnabled(): boolean | cdktf.IResolvable;
    set vsanNetworkDiagnosticModeEnabled(value: boolean | cdktf.IResolvable);
    resetVsanNetworkDiagnosticModeEnabled(): void;
    get vsanNetworkDiagnosticModeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanPerformanceEnabled?;
    get vsanPerformanceEnabled(): boolean | cdktf.IResolvable;
    set vsanPerformanceEnabled(value: boolean | cdktf.IResolvable);
    resetVsanPerformanceEnabled(): void;
    get vsanPerformanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanRemoteDatastoreIds?;
    get vsanRemoteDatastoreIds(): string[];
    set vsanRemoteDatastoreIds(value: string[]);
    resetVsanRemoteDatastoreIds(): void;
    get vsanRemoteDatastoreIdsInput(): string[] | undefined;
    private _vsanUnmapEnabled?;
    get vsanUnmapEnabled(): boolean | cdktf.IResolvable;
    set vsanUnmapEnabled(value: boolean | cdktf.IResolvable);
    resetVsanUnmapEnabled(): void;
    get vsanUnmapEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanVerboseModeEnabled?;
    get vsanVerboseModeEnabled(): boolean | cdktf.IResolvable;
    set vsanVerboseModeEnabled(value: boolean | cdktf.IResolvable);
    resetVsanVerboseModeEnabled(): void;
    get vsanVerboseModeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vsanDiskGroup;
    get vsanDiskGroup(): ComputeClusterVsanDiskGroupList;
    putVsanDiskGroup(value: ComputeClusterVsanDiskGroup[] | cdktf.IResolvable): void;
    resetVsanDiskGroup(): void;
    get vsanDiskGroupInput(): cdktf.IResolvable | ComputeClusterVsanDiskGroup[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
