# Developer How-to Guide

# Setup Machine

_Scripts Assumption: Bash Cli being used, for Window developers install git-bash or wsl2_

- Install Python 3.7+
- Install Docker
- _Recommended:_ Install vscode

# Build and Test

## Install Dependencies Locally

```bash
make install
```

## Install Eze CLI locally

Build and install cli locally

```bash
make cli
```

### (or) Install Eze Source CLI locally

This will directly install the eze source locally

This is better for local development, as any development changes will immediately be reflected in the eze cli

```bash
pip install -e .
```

## Run Unit Tests

```bash
make lint
make test
```

## Snapshot Test Fixtures

For those unfamiliar with snapshot testing, it's basically just a fixture framework for testing output against text blob
on the filesystem, with an easy mechanism to automatically update the blobs when the output changes

It's popular in the js react world when dealing with large html output that's being generated by layered systems.

Due to the emergent and brittle nature of cli output, Eze uses [snapshot testing](https://pypi.org/project/pytest-snapshot/) for integration testing between multiple components.


Advantages:

- fast to setup
- easy to update when things change
- excellent at testing emergent output with large inputs and readable string outputs

Disadvantages:

- brittle
- smoke test

  _aka : fails don't mean something is broken, just something somewhere has changed_
- requires a human to review snapshot changes
- poor/inefficient at testing small pure functions with small inputs and small or non-string typed outputs

### Snapshot fixture location

All files will be stored in here

```
tests/__snapshots__
```

### Update pytest snapshot tests

Out the box pytest's snapshot plugin is very easy to update, run this command to regenerate the fixtures after changes.

```bash
make test-snapshot-update
```

_ps. remember to always manually check the diff before committing updated snapshots!_

## Bump Version

Version is stored in ``eze/__init__.py``, and we bump and tag the version when merging from "develop" to "main"

We use https://semver.org/ explanation:

Given a version number MAJOR.MINOR.PATCH, increment the:

- *MAJOR* version when you make incompatible API changes,
- *MINOR* version when you add functionality in a backwards compatible manner, and
- *PATCH* version when you make backwards compatible bug fixes.

## Build Local Development Docker Image

You can create a local docker image for development purposes, this can also be used to tailor/slim* the image to only contain the tools needed for your .ezerc.toml

_Some tools, for example semgrep are upto 200mb by themselves, tailoring the image will save significant amounts of space_

```bash
make docker

# Test Eze in docker
docker run -t --rm -v LOCAL_FOLDER:/data eze-cli --version
```

## Build Release Docker Image
These steps are for building and releasing an official eze image

```bash
# release docker image to "riversafe/eze-cli"
make release-docker
```

## Testing PyPi via Test

build wheel and upload via twine

_Warning: requires a unique version each upload_

```bash
make cli
twine upload --repository testpypi dist/*
```

can test via venv

```bash
python -m venv ~/.virtualenvs/eze-pip-test
source ~/.virtualenvs/eze-pip-test/Scripts/activate
pip install --index-url https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple eze-cli
```

## Use Eze Locally via Pip
Install Eze from Pypi using pip.

```bash
# Keep in mind that Eze runs on Python 3.7 and up.
pip install eze-cli

# Test Eze running ok
eze, version X.X.X
```

Once finished, you can install any tools you want to run Eze with, and finally run Eze locally.
```bash
eze test
```

<details>
<summary>Example: Scanning a Python project using  Eze</summary>

```bash
# Install 3 tools and run Eze
pip install piprot
pip install bandit
pip install safety
eze test
```
</details>

## Release Steps

For repo maintainers

_requires pypi and dockerhub access_

- update version
  
  ```text
  eze-cli\eze\__init__.py
  ```
  
- update change log with any changes in this format
  ```text
  ab-###: <brief description>
  ```
  
- deploy to pypi
  ```bash
  make release-pypi-test
  make release-pypi
  ```

- deploy to dockerhub
  ```bash
  make release-docker
  ```

## Tips and Tricks

### venv helpers

worth creating a dedicated env for eze, so you don't pollute your globally install pip repos

create a specific env for eze

```bash
start-eze-env: python -m venv ~/.virtualenvs/eze-core
```

change to eze env

```bash
source ~/.virtualenvs/eze-core/Scripts/activate
```

stop eze env

```bash
deactivate
```

### Bigger Organisations: Tailoring Image
It's recommended for organisations with mature devops teams to download and tailor this Docker image, adding/removing the pre-installed security tools as needed to optimise size of the image, as well as making their own _.ezerc.toml_ and autoconfiguration files.

_*Aka: Some tools for example semgrep are upto 200mb by themselves, tailoring the image to remove unused tools will save significant amounts of space_

Dockerfile Source:
https://github.com/RiverSafeUK/eze-cli/Dockerfile


# Contribute Guide

See [CONTRIBUTING GUIDE](CONTRIBUTING.md)