from .translator import TranslatorSpec

class GitLab(TranslatorSpec):
    remote_regexes = [
        r'git@gitlab\.com:(?P<project_name>[\w\-]+)/(?P<repo_name>[\w\-]+)\.git',
        r'https://gitlab\.com/(?P<project_name>[\w\-]+)/(?P<repo_name>[\w\-]+)\.git',
    ]

    url_root_recipes = [
        "https://gitlab.com/{project_name}/{repo_name}/",
    ]

    url_body_recipes = [
        ("blob/{branch_name}/{path}", "is_folder == False"),
        ("tree/{branch_name}/{path}", "is_folder == True"),
        ("blob/{commit_hash}/{path}", "is_folder == False"),
        ("tree/{commit_hash}/{path}", "is_folder == True"),
    ]

    url_suffix_recipes = [
        ("#L{start_line}-L{end_line}", "is_folder == False"),
        ("#L{line}", "is_folder == False"),
        "",
    ]
