# Generated by Django 4.0.4 on 2022-05-25 14:18

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "jobId",
                    models.BigAutoField(
                        help_text="Primary identifier",
                        primary_key=True,
                        serialize=False,
                        verbose_name="job identifier",
                    ),
                ),
                (
                    "runId",
                    models.CharField(
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#runId",
                        max_length=128,
                        verbose_name="client supplied identifier",
                    ),
                ),
                (
                    "ownerId",
                    models.CharField(
                        blank=True,
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#ownerId",
                        max_length=64,
                        null=True,
                        verbose_name="owner id of the job",
                    ),
                ),
                (
                    "phase",
                    models.CharField(
                        choices=[
                            ("PENDING", "pending"),
                            ("QUEUED", "queued"),
                            ("EXECUTING", "executing"),
                            ("COMPLETED", "completed"),
                            ("ERROR", "error"),
                            ("ABORTED", "aborted"),
                            ("UNKNOWN", "unknown"),
                            ("HELD", "held"),
                            ("SUSPENDED", "suspended"),
                            ("ARCHIVED", "archived"),
                        ],
                        default="PENDING",
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#ExecutionPhase",
                        max_length=16,
                        verbose_name="execution phase",
                    ),
                ),
                (
                    "quote",
                    models.DateTimeField(
                        blank=True,
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#Quote",
                        null=True,
                        verbose_name="predicted end time",
                    ),
                ),
                (
                    "creationTime",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="DateTime when job was created",
                        verbose_name="job creation time",
                    ),
                ),
                (
                    "startTime",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="job execution start time"
                    ),
                ),
                (
                    "endTime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="job execution finished time",
                    ),
                ),
                (
                    "executionDuration",
                    models.IntegerField(
                        default=0,
                        help_text="Time limit after which the job will be aborted, 0 for no limit",
                        verbose_name="execution duration in seconds",
                    ),
                ),
                (
                    "destruction",
                    models.DateTimeField(
                        blank=True,
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#DestructionTime",
                        null=True,
                        verbose_name="job destruction time",
                    ),
                ),
                (
                    "errorSummary",
                    models.TextField(
                        blank=True,
                        help_text="See https://www.ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#Error",
                        null=True,
                        verbose_name="job error summary",
                    ),
                ),
            ],
            options={
                "verbose_name": "job",
                "verbose_name_plural": "jobs",
                "ordering": ["creationTime"],
            },
        ),
        migrations.CreateModel(
            name="Result",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        help_text="Paramater key",
                        max_length=64,
                        verbose_name="paramater key",
                    ),
                ),
                (
                    "value",
                    models.TextField(
                        help_text="Usually a reference URI to a resource",
                        verbose_name="paramater value",
                    ),
                ),
                (
                    "size",
                    models.BigIntegerField(
                        blank=True, null=True, verbose_name="resource size"
                    ),
                ),
                (
                    "mimeType",
                    models.CharField(
                        blank=True,
                        max_length=128,
                        null=True,
                        verbose_name="result mime-type",
                    ),
                ),
                (
                    "job",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="results",
                        related_query_name="result",
                        to="uws.job",
                    ),
                ),
            ],
            options={
                "verbose_name": "result",
                "verbose_name_plural": "results",
                "unique_together": {("job", "key")},
            },
        ),
        migrations.CreateModel(
            name="Parameter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        help_text="Paramater key",
                        max_length=64,
                        verbose_name="paramater key",
                    ),
                ),
                ("value", models.TextField(verbose_name="paramater value")),
                (
                    "byReference",
                    models.BooleanField(default=False, verbose_name="is a reference"),
                ),
                (
                    "isPost",
                    models.BooleanField(default=False, verbose_name="is posted"),
                ),
                (
                    "job",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="parameters",
                        related_query_name="parameter",
                        to="uws.job",
                    ),
                ),
            ],
            options={
                "verbose_name": "parameter",
                "verbose_name_plural": "parameters",
                "unique_together": {("job", "key")},
            },
        ),
    ]
