"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("aws-cdk-lib/aws-iot");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class IotToS3 extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToS3Props} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup S3 Bucket
        if (!props.existingBucketInterface) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            this.s3BucketInterface = this.s3Bucket;
        }
        else {
            this.s3BucketInterface = props.existingBucketInterface;
        }
        // Role to allow IoT to send messages to the S3 Bucket
        this.iotActionsRole = new iam.Role(this, 'iot-actions-role', {
            assumedBy: new iam.ServicePrincipal('iot.amazonaws.com')
        });
        // Setup the IAM policy for IoT Actions
        this.s3BucketInterface.grantWrite(this.iotActionsRole);
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                s3: {
                    key: props.s3Key || '${topic()}/${timestamp()}',
                    bucketName: this.s3BucketInterface.bucketName,
                    roleArn: this.iotActionsRole.roleArn
                }
            }]);
        const iotTopicProps = defaults.overrideProps(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopicRule', iotTopicProps);
        // If existing bucket has a KMS CMK, explicitly provide IoTActionsRole necessary access to write to the bucket
        if (this.s3Bucket && this.s3Bucket.encryptionKey) {
            this.s3Bucket.encryptionKey.grantEncrypt(this.iotActionsRole);
        }
    }
}
exports.IotToS3 = IotToS3;
_a = JSII_RTTI_SYMBOL_1;
IotToS3[_a] = { fqn: "@aws-solutions-constructs/aws-iot-s3.IotToS3", version: "2.30.0" };
//# sourceMappingURL=data:application/json;base64,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