# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TeamArgs', 'Team']

@pulumi.input_type
class TeamArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 ignore_externally_synced_members: Optional[pulumi.Input[bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Team resource.
        :param pulumi.Input[str] email: An email address for the team.
        :param pulumi.Input[bool] ignore_externally_synced_members: Ignores team members that have been added to team by [Team
               Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
               [grafana_team_external_group
               resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A set of email addresses corresponding to users who should be given membership
               to the team. Note: users specified here must already exist in Grafana.
        :param pulumi.Input[str] name: The display name for the Grafana team created.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if ignore_externally_synced_members is not None:
            pulumi.set(__self__, "ignore_externally_synced_members", ignore_externally_synced_members)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        An email address for the team.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="ignoreExternallySyncedMembers")
    def ignore_externally_synced_members(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignores team members that have been added to team by [Team
        Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
        [grafana_team_external_group
        resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        """
        return pulumi.get(self, "ignore_externally_synced_members")

    @ignore_externally_synced_members.setter
    def ignore_externally_synced_members(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_externally_synced_members", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of email addresses corresponding to users who should be given membership
        to the team. Note: users specified here must already exist in Grafana.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the Grafana team created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TeamState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 ignore_externally_synced_members: Optional[pulumi.Input[bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Team resources.
        :param pulumi.Input[str] email: An email address for the team.
        :param pulumi.Input[bool] ignore_externally_synced_members: Ignores team members that have been added to team by [Team
               Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
               [grafana_team_external_group
               resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A set of email addresses corresponding to users who should be given membership
               to the team. Note: users specified here must already exist in Grafana.
        :param pulumi.Input[str] name: The display name for the Grafana team created.
        :param pulumi.Input[int] team_id: The team id assigned to this team by Grafana.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if ignore_externally_synced_members is not None:
            pulumi.set(__self__, "ignore_externally_synced_members", ignore_externally_synced_members)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        An email address for the team.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="ignoreExternallySyncedMembers")
    def ignore_externally_synced_members(self) -> Optional[pulumi.Input[bool]]:
        """
        Ignores team members that have been added to team by [Team
        Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
        [grafana_team_external_group
        resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        """
        return pulumi.get(self, "ignore_externally_synced_members")

    @ignore_externally_synced_members.setter
    def ignore_externally_synced_members(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_externally_synced_members", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of email addresses corresponding to users who should be given membership
        to the team. Note: users specified here must already exist in Grafana.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the Grafana team created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[int]]:
        """
        The team id assigned to this team by Grafana.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "team_id", value)


class Team(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 ignore_externally_synced_members: Optional[pulumi.Input[bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/manage-users-and-permissions/manage-teams/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/team/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test_team = grafana.Team("test-team",
            email="teamemail@example.com",
            members=["viewer-01@example.com"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: An email address for the team.
        :param pulumi.Input[bool] ignore_externally_synced_members: Ignores team members that have been added to team by [Team
               Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
               [grafana_team_external_group
               resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A set of email addresses corresponding to users who should be given membership
               to the team. Note: users specified here must already exist in Grafana.
        :param pulumi.Input[str] name: The display name for the Grafana team created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TeamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/manage-users-and-permissions/manage-teams/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/http_api/team/)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        test_team = grafana.Team("test-team",
            email="teamemail@example.com",
            members=["viewer-01@example.com"])
        ```

        :param str resource_name: The name of the resource.
        :param TeamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 ignore_externally_synced_members: Optional[pulumi.Input[bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamArgs.__new__(TeamArgs)

            __props__.__dict__["email"] = email
            __props__.__dict__["ignore_externally_synced_members"] = ignore_externally_synced_members
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            __props__.__dict__["team_id"] = None
        super(Team, __self__).__init__(
            'grafana:index/team:Team',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            ignore_externally_synced_members: Optional[pulumi.Input[bool]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[int]] = None) -> 'Team':
        """
        Get an existing Team resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: An email address for the team.
        :param pulumi.Input[bool] ignore_externally_synced_members: Ignores team members that have been added to team by [Team
               Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
               [grafana_team_external_group
               resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A set of email addresses corresponding to users who should be given membership
               to the team. Note: users specified here must already exist in Grafana.
        :param pulumi.Input[str] name: The display name for the Grafana team created.
        :param pulumi.Input[int] team_id: The team id assigned to this team by Grafana.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamState.__new__(_TeamState)

        __props__.__dict__["email"] = email
        __props__.__dict__["ignore_externally_synced_members"] = ignore_externally_synced_members
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["team_id"] = team_id
        return Team(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        An email address for the team.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="ignoreExternallySyncedMembers")
    def ignore_externally_synced_members(self) -> pulumi.Output[Optional[bool]]:
        """
        Ignores team members that have been added to team by [Team
        Sync](https://grafana.com/docs/grafana/latest/enterprise/team-sync/). Team Sync can be provisioned using
        [grafana_team_external_group
        resource](https://registry.terraform.io/providers/grafana/grafana/latest/docs/resources/team_external_group).
        """
        return pulumi.get(self, "ignore_externally_synced_members")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of email addresses corresponding to users who should be given membership
        to the team. Note: users specified here must already exist in Grafana.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The display name for the Grafana team created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[int]:
        """
        The team id assigned to this team by Grafana.
        """
        return pulumi.get(self, "team_id")

