"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
class CloudFrontToApiGateway extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the CloudFrontToApiGateway class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        this.apiGateway = props.existingApiGatewayObj;
        [this.cloudFrontWebDistribution, this.cloudFrontFunction, this.cloudFrontLoggingBucket] =
            defaults.CloudFrontDistributionForApiGateway(this, props.existingApiGatewayObj, props.cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.cloudFrontLoggingBucketProps, props.responseHeadersPolicyProps);
    }
}
exports.CloudFrontToApiGateway = CloudFrontToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-apigateway.CloudFrontToApiGateway", version: "2.29.0" };
//# sourceMappingURL=data:application/json;base64,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