import * as route53 from '@aws-cdk/aws-route53';
import * as core from '@aws-cdk/core';
export interface PrivateAssetBucketProps {
    readonly assetBucketName?: string;
    /**
       * if you want to use an imported bucket instead
       */
    readonly assetBucketNameImport?: string;
    readonly customDomain?: CustomDomain;
    readonly userPoolId: string;
    readonly userPoolClientId: string;
    /**
     * The token use that you expect to be present in the JWT's token_use claim.
     * Usually you are verifying either Access token (common) or ID token (less common).
     * Pass null explicitly to not check the JWT's token use--if you know what you're doing
     */
    readonly tokenUse?: 'access' | 'id';
}
export interface CustomDomain {
    readonly zone: route53.IHostedZone;
    /**
       * domainName needs to be part of the hosted zone
       * e.g.: image.example.com
       */
    readonly domainName: string;
}
export declare class PrivateAssetBucket extends core.Construct {
    assetBucketName: string;
    assetBucketCloudfrontUrl: string;
    assetBucketRecordDomainName: string | undefined;
    constructor(scope: core.Construct, id: string, props: PrivateAssetBucketProps);
}
