"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cognito = require("@aws-cdk/aws-cognito");
const core = require("@aws-cdk/core");
const index_1 = require("../src/index");
class IntegTesting {
    constructor() {
        const app = new core.App();
        const stack = new core.Stack(app, 'PrivateAssetBucket-stack2', {
            env: {
                account: '981237193288',
                region: 'us-east-1',
            },
        });
        const userPool = new cognito.UserPool(stack, 'userPool', {
            removalPolicy: core.RemovalPolicy.DESTROY,
        });
        const userPoolWebClient = new cognito.UserPoolClient(stack, 'userPoolWebClient', {
            userPool: userPool,
            generateSecret: false,
            preventUserExistenceErrors: true,
            authFlows: {
                adminUserPassword: true,
                userPassword: true,
            },
            oAuth: {
                flows: {
                    authorizationCodeGrant: false,
                    implicitCodeGrant: true,
                },
            },
        });
        const privateAssetBucket = new index_1.PrivateAssetBucket(stack, 'privateAssetBucket', {
            userPoolId: userPool.userPoolId,
            userPoolClientId: userPoolWebClient.userPoolClientId,
            tokenUse: 'access',
        });
        new core.CfnOutput(stack, 'AssetBucketName', {
            value: privateAssetBucket.assetBucketName,
        });
        new core.CfnOutput(stack, 'AssetBucketCloudfrontUrl', {
            value: privateAssetBucket.assetBucketCloudfrontUrl,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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