/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.csv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.InputAnalysisProcess;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;

abstract class CsvFormatDetector
implements InputAnalysisProcess {
    private final int MAX_ROW_SAMPLES;
    private final char comment;
    private final char suggestedDelimiter;
    private final char normalizedNewLine;
    private final int whitespaceRangeStart;
    private char[] allowedDelimiters;
    private char[] delimiterPreference;

    CsvFormatDetector(int maxRowSamples, CsvParserSettings settings, int whitespaceRangeStart) {
        this.MAX_ROW_SAMPLES = maxRowSamples;
        this.whitespaceRangeStart = whitespaceRangeStart;
        this.allowedDelimiters = settings.getDelimitersForDetection();
        if (this.allowedDelimiters != null && this.allowedDelimiters.length > 0) {
            this.suggestedDelimiter = this.allowedDelimiters[0];
            this.delimiterPreference = (char[])this.allowedDelimiters.clone();
            Arrays.sort(this.allowedDelimiters);
        } else {
            String delimiter = ((CsvFormat)settings.getFormat()).getDelimiterString();
            this.suggestedDelimiter = (char)(delimiter.length() > 1 ? 44 : (int)((CsvFormat)settings.getFormat()).getDelimiter());
            this.allowedDelimiters = new char[0];
            this.delimiterPreference = this.allowedDelimiters;
        }
        this.normalizedNewLine = ((CsvFormat)settings.getFormat()).getNormalizedNewline();
        this.comment = ((CsvFormat)settings.getFormat()).getComment();
    }

    private Map<Character, Integer> calculateTotals(List<Map<Character, Integer>> symbolsPerRow) {
        HashMap<Character, Integer> out = new HashMap<Character, Integer>();
        for (Map<Character, Integer> rowStats : symbolsPerRow) {
            for (Map.Entry<Character, Integer> symbolStats : rowStats.entrySet()) {
                Character symbol = symbolStats.getKey();
                Integer count = symbolStats.getValue();
                Integer total = (Integer)out.get(symbol);
                if (total == null) {
                    total = 0;
                }
                out.put(symbol, total + count);
            }
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(char[] characters, int length) {
        char delimiter;
        Map<Character, Integer> totals;
        int singleQuoteCount;
        int doubleQuoteCount;
        HashMap<Character, Integer> escape;
        block25: {
            char c;
            char delimiterMax;
            int i2;
            HashSet<Character> allSymbols = new HashSet<Character>();
            HashMap<Character, Integer> symbols = new HashMap<Character, Integer>();
            escape = new HashMap<Character, Integer>();
            ArrayList<Map<Character, Integer>> symbolsPerRow = new ArrayList<Map<Character, Integer>>();
            doubleQuoteCount = 0;
            singleQuoteCount = 0;
            char inQuote = '\u0000';
            boolean afterNewLine = true;
            block0: for (i2 = 0; i2 < length; ++i2) {
                char ch = characters[i2];
                if (afterNewLine && ch == this.comment) {
                    while (++i2 < length) {
                        ch = characters[i2];
                        if (ch != '\r' && ch != '\n' && ch != this.normalizedNewLine) continue;
                        if (ch != '\r' || i2 + 1 >= characters.length || characters[i2 + 1] != '\n') continue block0;
                        ++i2;
                        continue block0;
                    }
                    continue;
                }
                if (ch == '\"' || ch == '\'') {
                    if (inQuote == ch) {
                        char prev;
                        char next;
                        if (ch == '\"') {
                            ++doubleQuoteCount;
                        } else {
                            ++singleQuoteCount;
                        }
                        if (i2 + 1 < length && (Character.isLetterOrDigit(next = characters[i2 + 1]) || next <= ' ' && this.whitespaceRangeStart < next && next != '\n' && next != '\r') && !Character.isLetterOrDigit(prev = characters[i2 - 1])) {
                            CsvFormatDetector.increment(escape, prev);
                        }
                        inQuote = '\u0000';
                        continue;
                    }
                    if (inQuote != '\u0000') continue;
                    char prev = '\u0000';
                    int j = i2;
                    while (prev <= ' ' && --j >= 0) {
                        prev = characters[j];
                    }
                    if (j >= 0 && Character.isLetterOrDigit(prev)) continue;
                    inQuote = ch;
                    continue;
                }
                if (inQuote != '\u0000') continue;
                afterNewLine = false;
                if (this.isSymbol(ch)) {
                    allSymbols.add(Character.valueOf(ch));
                    CsvFormatDetector.increment(symbols, ch);
                    continue;
                }
                if (ch != '\r' && ch != '\n' && ch != this.normalizedNewLine || symbols.size() <= 0) continue;
                afterNewLine = true;
                symbolsPerRow.add(symbols);
                if (symbolsPerRow.size() == this.MAX_ROW_SAMPLES) break;
                symbols = new HashMap();
            }
            if (symbols.size() > 0 && length < characters.length) {
                symbolsPerRow.add(symbols);
            }
            if (length >= characters.length && i2 >= length && symbolsPerRow.size() > 1) {
                symbolsPerRow.remove(symbolsPerRow.size() - 1);
            }
            totals = this.calculateTotals(symbolsPerRow);
            HashMap<Character, Integer> sums = new HashMap<Character, Integer>();
            HashSet<Character> toRemove = new HashSet<Character>();
            for (Map map : symbolsPerRow) {
                for (Map map2 : symbolsPerRow) {
                    for (Character symbol : allSymbols) {
                        Integer previousCount = (Integer)map.get(symbol);
                        Integer currentCount = (Integer)map2.get(symbol);
                        if (previousCount == null && currentCount == null) {
                            toRemove.add(symbol);
                        }
                        if (previousCount == null || currentCount == null) continue;
                        CsvFormatDetector.increment(sums, symbol.charValue(), Math.abs(previousCount - currentCount));
                    }
                }
            }
            sums.keySet().removeAll(toRemove);
            if (this.allowedDelimiters.length > 0) {
                void var18_29;
                HashSet<Character> toRetain = new HashSet<Character>();
                char[] cArray = this.allowedDelimiters;
                int len$ = cArray.length;
                boolean bl = false;
                while (var18_29 < len$) {
                    char c2 = cArray[var18_29];
                    toRetain.add(Character.valueOf(c2));
                    ++var18_29;
                }
                sums.keySet().retainAll(toRetain);
            }
            if ((delimiterMax = this.max(sums, totals, this.suggestedDelimiter)) != (c = this.min(sums, totals, this.suggestedDelimiter))) {
                if ((Integer)sums.get(Character.valueOf(c)) == 0 && (Integer)sums.get(Character.valueOf(delimiterMax)) != 0) {
                    delimiter = c;
                } else {
                    for (char c3 : this.allowedDelimiters) {
                        if (c3 == c) {
                            delimiter = c;
                        } else {
                            if (c3 != delimiterMax) continue;
                            delimiter = delimiterMax;
                        }
                        break block25;
                    }
                    delimiter = totals.get(Character.valueOf(c)) > totals.get(Character.valueOf(delimiterMax)) ? c : delimiterMax;
                }
            } else {
                delimiter = delimiterMax;
            }
        }
        char c = doubleQuoteCount >= singleQuoteCount ? (char)'\"' : '\'';
        escape.remove(Character.valueOf(delimiter));
        char quoteEscape = this.max(escape, totals, c);
        this.apply(delimiter, c, quoteEscape);
    }

    private static void increment(Map<Character, Integer> map, char symbol) {
        CsvFormatDetector.increment(map, symbol, 1);
    }

    private static void increment(Map<Character, Integer> map, char symbol, int incrementSize) {
        Integer count = map.get(Character.valueOf(symbol));
        if (count == null) {
            count = 0;
        }
        map.put(Character.valueOf(symbol), count + incrementSize);
    }

    private char min(Map<Character, Integer> map, Map<Character, Integer> totals, char defaultChar) {
        return this.getChar(map, totals, defaultChar, true);
    }

    private char max(Map<Character, Integer> map, Map<Character, Integer> totals, char defaultChar) {
        return this.getChar(map, totals, defaultChar, false);
    }

    private char getChar(Map<Character, Integer> map, Map<Character, Integer> totals, char defaultChar, boolean min) {
        int val = min ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (Map.Entry<Character, Integer> e : map.entrySet()) {
            int sum = e.getValue();
            if ((!min || sum > val) && (min || sum < val)) continue;
            char newChar = e.getKey().charValue();
            if (val == sum) {
                Integer currentTotal = totals.get(Character.valueOf(defaultChar));
                Integer newTotal = totals.get(Character.valueOf(newChar));
                if (currentTotal != null && newTotal != null) {
                    if (currentTotal.equals(newTotal)) {
                        int defIndex = ArgumentUtils.indexOf(this.delimiterPreference, defaultChar, 0);
                        int newIndex = ArgumentUtils.indexOf(this.delimiterPreference, newChar, 0);
                        if (defIndex == -1 || newIndex == -1) continue;
                        defaultChar = defIndex < newIndex ? defaultChar : newChar;
                        continue;
                    }
                    if ((!min || newTotal <= currentTotal) && (min || newTotal <= currentTotal)) continue;
                    defaultChar = newChar;
                    continue;
                }
                if (!this.isSymbol(newChar)) continue;
                defaultChar = newChar;
                continue;
            }
            val = sum;
            defaultChar = newChar;
        }
        return defaultChar;
    }

    private boolean isSymbol(char ch) {
        return this.isAllowedDelimiter(ch) || ch != this.comment && !Character.isLetterOrDigit(ch) && (ch == '\t' || ch >= ' ');
    }

    private boolean isAllowedDelimiter(char ch) {
        return Arrays.binarySearch(this.allowedDelimiters, ch) >= 0;
    }

    abstract void apply(char var1, char var2, char var3);
}

