"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeFunction = exports.InvocationType = exports.LogType = exports.AwsApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const assertions_1 = require("./assertions");
const common_1 = require("./common");
const providers_1 = require("./providers");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that creates a custom resource that will perform
 * a query using the AWS SDK
 */
class AwsApiCall extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.flattenResponse = 'false';
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_AwsApiCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AwsApiCall);
            }
            throw error;
        }
        this.provider = new providers_1.AssertionsProvider(this, 'SdkProvider');
        this.provider.addPolicyStatementFromSdkCall(props.service, props.api);
        this.name = `${props.service}${props.api}`;
        this.sdkCallResource = new core_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                service: props.service,
                api: props.api,
                parameters: this.provider.encode(props.parameters),
                flattenResponse: core_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.SDK_RESOURCE_TYPE_PREFIX}${this.name}`,
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.sdkCallResource.node.addDependency(this.provider);
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.sdkCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.sdkCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromCustomResource(this.sdkCallResource, 'apiCallResponse'),
        });
    }
    assertAtPath(path, expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromAwsApiCall(this, path),
        });
    }
}
exports.AwsApiCall = AwsApiCall;
_a = JSII_RTTI_SYMBOL_1;
AwsApiCall[_a] = { fqn: "@aws-cdk/integ-tests.AwsApiCall", version: "1.180.0" };
/**
 * Set to Tail to include the execution log in the response.
 * Applies to synchronously invoked functions only.
 */
var LogType;
(function (LogType) {
    /**
     * The log messages are not returned in the response
     */
    LogType["NONE"] = "None";
    /**
     * The log messages are returned in the response
     */
    LogType["TAIL"] = "Tail";
})(LogType = exports.LogType || (exports.LogType = {}));
/**
 * The type of invocation. Default is REQUEST_RESPONE
 */
var InvocationType;
(function (InvocationType) {
    /**
     * Invoke the function asynchronously.
     * Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    InvocationType["EVENT"] = "Event";
    /**
     * Invoke the function synchronously.
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    InvocationType["REQUEST_RESPONE"] = "RequestResponse";
    /**
     * Validate parameter values and verify that the user
     * or role has permission to invoke the function.
     */
    InvocationType["DRY_RUN"] = "DryRun";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
/**
 * An AWS Lambda Invoke function API call.
 * Use this istead of the generic AwsApiCall in order to
 * invoke a lambda function. This will automatically create
 * the correct permissions to invoke the function
 */
class LambdaInvokeFunction extends AwsApiCall {
    constructor(scope, id, props) {
        super(scope, id, {
            api: 'invoke',
            service: 'Lambda',
            parameters: {
                FunctionName: props.functionName,
                InvocationType: props.invocationType,
                LogType: props.logType,
                Payload: props.payload,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_LambdaInvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvokeFunction);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        // need to give the assertion lambda permission to invoke
        new core_1.CfnResource(this, 'Invoke', {
            type: 'AWS::Lambda::Permission',
            properties: {
                Action: 'lambda:InvokeFunction',
                FunctionName: props.functionName,
                Principal: this.provider.handlerRoleArn,
            },
        });
        // the api call is 'invoke', but the permission is 'invokeFunction'
        // so need to handle it specially
        this.provider.addPolicyStatementFromSdkCall('Lambda', 'invokeFunction', [stack.formatArn({
                service: 'lambda',
                resource: 'function',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: props.functionName,
            })]);
    }
}
exports.LambdaInvokeFunction = LambdaInvokeFunction;
_b = JSII_RTTI_SYMBOL_1;
LambdaInvokeFunction[_b] = { fqn: "@aws-cdk/integ-tests.LambdaInvokeFunction", version: "1.180.0" };
//# sourceMappingURL=data:application/json;base64,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