# Generated by Django 3.2.12 on 2022-04-05 00:44

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import filer.fields.image


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        ('simpel_pages', '0004_auto_20220403_2317'),
    ]

    operations = [
        migrations.CreateModel(
            name='Block',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(blank=True, null=True, verbose_name='name')),
                ('group', models.SlugField(blank=True, null=True, verbose_name='group')),
                ('position', models.IntegerField(default=0, help_text='Used for ordering block.', verbose_name='position')),
                ('object_id', models.IntegerField(blank=True, null=True, verbose_name='object')),
                ('object_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='blocks', to='contenttypes.contenttype', verbose_name='object type')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_pages.block_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Block',
                'verbose_name_plural': 'Blocks',
            },
        ),
        migrations.CreateModel(
            name='RichTextBlock',
            fields=[
                ('block_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_pages.block')),
                ('text', models.TextField()),
            ],
            options={
                'verbose_name': 'Text Block',
                'verbose_name_plural': 'Text Blocks',
            },
            bases=('simpel_pages.block',),
        ),
        migrations.CreateModel(
            name='ImageBlock',
            fields=[
                ('block_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_pages.block')),
                ('caption', models.CharField(max_length=200, verbose_name='Caption')),
                ('thumb_height', models.IntegerField(default=100, verbose_name='Thumbnail Height')),
                ('thumb_width', models.IntegerField(default=100, verbose_name='Thumbnail Width')),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'verbose_name': 'Image Block',
                'verbose_name_plural': 'Image Blocks',
            },
            bases=('simpel_pages.block',),
        ),
    ]
