# Generated by Django 3.2.12 on 2022-03-28 20:12

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

import filer.fields.image
import mptt.fields
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('simpel_themes', '0004_alter_screenshoot_template'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80, unique=True, verbose_name='Category Name')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=80, null=True, unique=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, help_text='Categories, unlike tags, can have a hierarchy. You might have a Jazz category, and under that have children categories for Bebop and Big Band. Totally optional.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_pages.category')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ['name'],
                'permissions': (('import_category', 'Can import Category'), ('export_category', 'Can export Category')),
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Last updated at')),
                ('url', models.CharField(db_index=True, max_length=100, verbose_name='URL')),
                ('title', models.CharField(max_length=200, verbose_name='title')),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, null=True, unique=True)),
                ('seo_title', models.CharField(blank=True, max_length=200, null=True, verbose_name='SEO title')),
                ('seo_description', models.TextField(blank=True, null=True, verbose_name='SEO description')),
                ('allow_comments', models.BooleanField(default=False, verbose_name='allow comments')),
                ('registration_required', models.BooleanField(default=False, help_text='If this is checked, only logged-in users will be able to view the page.', verbose_name='registration required')),
                ('data', models.JSONField(blank=True, null=True)),
                ('real_model', models.CharField(blank=True, editable=False, max_length=120, null=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('bookmarks', models.ManyToManyField(blank=True, related_name='bookmarks', to=settings.AUTH_USER_MODEL, verbose_name='Users who bookmark this page.')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='pages', to='simpel_pages.category', verbose_name='Category')),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='pages', to=settings.AUTH_USER_MODEL, verbose_name='Page Owner')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, help_text='Pages, unlike tags, can have a hierarchy. You might have a Index page, and under that have children pages for post and story. Totally optional.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='simpel_pages.page')),
                ('readers', models.ManyToManyField(blank=True, related_name='page_readers', to=settings.AUTH_USER_MODEL, verbose_name='Users who mark this page as read.')),
                ('sites', models.ManyToManyField(related_name='simpelposts', to='sites.Site', verbose_name='sites')),
            ],
            options={
                'verbose_name': 'page',
                'verbose_name_plural': 'pages',
                'ordering': ['url'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='name')),
                ('slug', models.SlugField(max_length=100, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'Tag',
                'verbose_name_plural': 'Tags',
            },
        ),
        migrations.CreateModel(
            name='TaggedPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_pages', to='simpel_pages.page')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_pages', to='simpel_pages.tag')),
            ],
            options={
                'verbose_name': 'Tagged Page',
                'verbose_name_plural': 'Tagged Pages',
            },
        ),
        migrations.AddField(
            model_name='page',
            name='tags',
            field=taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', related_name='pages', through='simpel_pages.TaggedPage', to='simpel_pages.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='page',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='pages', to='simpel_themes.modeltemplate', verbose_name='Template'),
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_pages.page')),
                ('content', models.TextField(blank=True, null=True, verbose_name='content')),
                ('summary', models.TextField(blank=True, null=True, verbose_name='summary')),
                ('thumbnail', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='simpelpages', to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'verbose_name': 'post',
                'verbose_name_plural': 'posts',
                'abstract': False,
            },
            bases=('simpel_pages.page',),
        ),
        migrations.CreateModel(
            name='PageGallery',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('caption', models.CharField(max_length=200, verbose_name='Caption')),
                ('thumb_height', models.IntegerField(default=100, verbose_name='Thumbnail Height')),
                ('thumb_width', models.IntegerField(default=100, verbose_name='Thumbnail Width')),
                ('image', filer.fields.image.FilerImageField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='simpelpages_gallery_items', to=settings.FILER_IMAGE_MODEL)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_query_name='galleries', to='simpel_pages.page', verbose_name='page')),
            ],
            options={
                'verbose_name': 'Image Gallery',
                'verbose_name_plural': 'Image Galleries',
                'ordering': ['page'],
                'index_together': {('page', 'image')},
            },
        ),
    ]
