# AUTOGENERATED! DO NOT EDIT! File to edit: 00_cli.ipynb (unless otherwise specified).

__all__ = ['papersweep_exec']

# Cell
from fastcore.all import *
import yaml
import wandb
import papermill as pm

# Cell
@call_parse
def papersweep_exec(input_nb:Param("Input notebook", str),
               sweep_config:Param("YAML file with the sweep config", str),
               entity:Param("wandb entity", str),
               project:Param("wandb project", str),
               pm_params:Param("YAML file with papermill parameters", str)=None,
               sweep_id:Param("Sweep ID. This option omits `sweep_config`", str)=None):
    with maybe_open(sweep_config, 'r') as f:
        sc = yaml.safe_load(f)
    if pm_params:
        with maybe_open(pm_params, 'r') as f:
            _pm_params = yaml.safe_load(f)
    sid = wandb.sweep(sweep=sc, entity=entity, project=project) if not sweep_id else sweep_id
    sweep_agent = wandb.agent(sid,
                              function=partial(pm.execute_notebook,
                                               input_path=input_nb,
                                               output_path='__.ipynb',
                                               parameters=_pm_params))