# EntroPy Password Generator - Issue Report

Thank you for contributing to the **EntroPy Password Generator**! Please fill out the sections below to help us understand and address your issue or suggestion. For guidelines, see our [CONTRIBUTING.md](https://github.com/gerivanc/entropy-password-generator/blob/main/CONTRIBUTING.md). For ideas or general questions, consider using [GitHub Discussions](https://github.com/gerivanc/entropy-password-generator/discussions).

---

## 📌 Issue Description
Provide a clear and detailed description of the problem or suggestion. For example:
- "Running `entropy-password-generator --mode 1` raises an `ImportError`."
- "Suggest adding support for custom character sets in the CLI."

**Description**:
[Enter your description here]

---

## 🔄 Steps to Reproduce
List the steps to reproduce the issue. For example:
1. Install the package: `pip install entropy-password-generator`.
2. Run: `entropy-password-generator --mode 1`.
3. Observe the error: `[Error message]`.

**Steps**:
1. [Step 1]
2. [Step 2]
3. [Step 3]

---

## ✅ Expected Behavior
Describe what should happen. For example:
- "The command should generate a 24-character password with lowercase and special characters, with 139.92 bits of entropy."

**Expected Behavior**:
[Enter expected behavior here]

---

## 🖥️ Environment Details
Provide details about your environment. To check versions, use:
- Python: `python3 --version`
- Project: `entropy-password-generator --version` or `pip show entropy-password-generator`

- **Operating System**: [e.g., Ubuntu 24.04, Windows 11, macOS Sonoma]
- **Python Version**: [e.g., 3.8, 3.10, 3.12]
- **Project Version**: [e.g., 0.5.7 from PyPI]
- **Installation Method**: [e.g., PyPI, Test PyPI, cloned repository]
- **Additional Context**: [e.g., dependencies, terminal output, system configurations]

---

## 📸 Screenshots or Logs
Include screenshots, terminal output, or stack traces. For errors, include the full stack trace. Example:
```bash
$ entropy-password-generator --mode 1
Traceback (most recent call last):
  File "...", line X, in <module>
    ...
ImportError: No module named 'xyz'
```

**Logs/Screenshots**:
```bash
[Insert terminal output or error message here]
```

---

## 🛠️ Possible Solutions
Share ideas for resolving the issue. For example:
- "Check for missing dependencies in `pyproject.toml`."
- "Add a validation step for CLI arguments."

**Suggestions**:
[Enter suggestions here]

---

## 🔗 Related Links
Provide links to related issues, documentation, or discussions. For example:
- [CHANGELOG.md](https://github.com/gerivanc/entropy-password-generator/blob/main/CHANGELOG.md)
- Related issue: #[Issue number]

**Links**:
[Enter links here]

---

## 💡 Additional Information
Include other details, such as:
- Frequency (e.g., always, intermittent).
- Workarounds attempted.
- Impact (e.g., blocks CLI execution, affects specific modes).

**Details**:
[Enter additional information here]

---

## 🔒 Security Note
If this issue involves a security vulnerability, please follow the instructions in [SECURITY.md](https://github.com/gerivanc/entropy-password-generator/blob/main/SECURITY.md) to report it privately instead of posting here.

---

**Upvote or comment** if this issue affects you to help us prioritize it. Thank you for helping improve the **EntroPy Password Generator**! 🚀🔑

---

#### Copyright © 2025 Gerivan Costa dos Santos
