###############################################################################
# __   _            _____    _____
# | \ | |          / ____|  / ____|
# |  \| |  _   _  | |      | (___
# | . ` | | | | | | |       \___ \
# | |\  | | |_| | | |____   ____) |
# |_| \_|  \__,_|  \_____| |_____/
#
# Fast constraint solving in Python  - https://github.com/yangeorget/nucs
#
# Copyright 2024-2025 - Yan Georget
###############################################################################
from typing import List, Optional, Tuple, Union

import pytest

from nucs.constants import PROP_CONSISTENCY, PROP_ENTAILMENT, PROP_INCONSISTENCY
from nucs.propagators.relation_propagator import compute_domains_relation
from tests.propagators.propagator_test import PropagatorTest


class TestRelation(PropagatorTest):
    @pytest.mark.parametrize(
        "domains,parameters,consistency_result,expected_domains",
        [
            ([(-5, 5), (-5, 5)], [0, 7, 1, 4, 2, -7, 3, 3], PROP_CONSISTENCY, [[1, 3], [3, 4]]),
            (
                [(0, 3), (0, 3), (1, 8)],
                [
                    0,
                    1,
                    0,
                    0,
                    2,
                    0,
                    0,
                    3,
                    0,
                    1,
                    1,
                    1,
                    1,
                    2,
                    2,
                    1,
                    3,
                    3,
                    2,
                    1,
                    2,
                    2,
                    2,
                    4,
                    2,
                    3,
                    6,
                    3,
                    1,
                    3,
                    3,
                    2,
                    6,
                    3,
                    3,
                    9,
                ],
                PROP_CONSISTENCY,
                [[1, 3], [1, 3], [1, 6]],
            ),
            ([(0, 3), (0, 3)], [4, 5], PROP_INCONSISTENCY, None),
            ([(0, 3), (0, 3)], [1, 2], PROP_ENTAILMENT, [[1, 1], [2, 2]]),
            ([0, 1, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
            ([0, 2, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
            ([0, 3, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
            ([2, 3, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
            ([1, 3, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
            ([1, 2, (0, 5)], [0, 1, 0, 0, 2, 1, 0, 3, 2, 1, 2, 3, 1, 3, 4, 2, 3, 5], PROP_ENTAILMENT, None),
        ],
    )
    def test_compute_domains(
        self,
        domains: List[Union[int, Tuple[int, int]]],
        parameters: List[int],
        consistency_result: int,
        expected_domains: Optional[List[List[int]]],
    ) -> None:
        self.assert_compute_domains(compute_domains_relation, domains, parameters, consistency_result, expected_domains)
