# Getting Started with the python wrapper for Adobe Analytics API 2.0

On this page, a quick example on how to start with the wrapper.
More details explanation are available in the [main file](./main.md) or one the [datanalyst.info website](https://www.datanalyst.info/category/python/adobe-analytics-api-2-0/)

## 1. Create an Adobe IO console account

First you should create an Adobe IO account and connect to a Product Profile.
You can also create an Adobe IO account and then go to the product Profile in Adobe Admin Console to contect to your Adobe IO account.

When you create your Adobe IO account, you need to set a certificate, keep the key nearby because you will need it.
You can follow this [tutorial](https://www.datanalyst.info/python/adobe-io-user-management/adobe-io-jwt-authentication-with-python/)

## 2. Download the library

You can directly install the library from the command line:

```cli
pip install aanalytics2
```

or

```cli
python -m pip install --upgrade git+<https://github.com/pitchmuc/adobe_analytics_api_2.0.git#egg=aanalytics2>
```

or you can copy paste the aanalytics2.py file in your Lib/ folder in your Python installation.

## 3. Setup a JSON with your information

Starting with the wrapper, you can import it and create a template for the JSON file that will store your credential to your Adobe IO account.

```python
import aanalytics2 as api2
api2.createConfigFile()
```

This will create a JSON and you will need to fill it with the information available in your adobe io account.

## 4. Import the configuration file

Once this is done, you can import the configuration file.
I would recommend to store the config file and the key in the folder that you are using, however, the element will work if you are using correct path.

```python
import aanalytics2 as api2
api2.importConfigFile('myconfig.json')
```

## 5. Get Company ID(s) & create your instance

Once all of these setup steps are completed, you can start using the methods attached to Analytics API.
The first method is the _getCompanyId_, that will return you the different company ID attached to your account.
you will extract the *globalCompanyId* and use it to create your instance and use the other methods...

```python
import aanalytics2 as api2
api2.importConfigFile('myconfig.json')
cids = api2.getCompanyId()
cid = cids[0]['globalCompanyId'] ## using the first one
mycompany = api2.Analytics(cid)
```

Starting version 0.1.1 a new class (Login) is avalabile in order to retrieve the login company.

```python
import aanalytics2 as api2
api2.importConfigFile('myconfig.json')

login = api2.Login()
cids = login.getCompanyId()

#you can also access the login return through the instance
login.COMPANY_IDS
## returns the same result that cids.
```

Form there, 2 methods can be used to create the Analytics class instance.

```python

#old method
mycompany = api2.Analytics(cid)

# new method directly in the Login class
mycompany = loggin.createAnalyticsConnection(cid)

```

## 6. Use the methods

Once you have the instance created, you can use the different methods available to them.
Don't hesitate to use the _help()_ function in order to have more details on the different possible parameters.
Example :

```python
segments = mycompany.getSegments()
```

or

```python
myreport = mycompany.getReport('myRequest.json')
```

The response that is given is a dictionary with the relevant information from your request (timeframe, segments used, etc...)\
You can access the data directly with the "data" keyword.

```python
data = myreport['data']
```
