"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Flow = exports.FlowProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const fnf_generated_1 = require("./fnf.generated");
Object.defineProperty(exports, "FlowProperty", { enumerable: true, get: function () { return fnf_generated_1.RosFlow; } });
/**
 * A ROS resource type:  `ALIYUN::FNF::Flow`
 */
class Flow extends ros.Resource {
    /**
     * Create a new `ALIYUN::FNF::Flow`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFlow = new fnf_generated_1.RosFlow(this, id, {
            description: props.description,
            requestId: props.requestId,
            definition: props.definition,
            roleArn: props.roleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFlow;
        this.attrCreatedTime = rosFlow.attrCreatedTime;
        this.attrId = rosFlow.attrId;
        this.attrLastModifiedTime = rosFlow.attrLastModifiedTime;
        this.attrName = rosFlow.attrName;
    }
}
exports.Flow = Flow;
//# sourceMappingURL=data:application/json;base64,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