from typing import Optional, Dict
from enum import Enum
from classiq import wire
from classiq_interface.generator.function_param_list import *
from classiq import api_wrapper as api_wrapper, wire as wire
from classiq.custom_function_library import CustomFunctionLibrary as CustomFunctionLibrary
from classiq.exceptions import ClassiqGenerationError as ClassiqGenerationError, ClassiqValueError as ClassiqValueError
from classiq_interface.generator import constraints, result

class Generator:
    def __init__(self, qubit_count: int, max_depth: int, **kwargs) -> None: ...
    def generate(self) -> result.GeneratedCircuit: ...
    async def generate_async(self) -> result.GeneratedCircuit: ...
    @property
    def constraints(self) -> constraints.QuantumCircuitConstraints: ...
    def include_library(self, library: CustomFunctionLibrary) -> None: ...
    def __getattribute__(self, item): ...
    def __dir__(self): ...
    def Mcx(self, params: Mcx, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Subtractor(self, params: Subtractor, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def HadamardAmpLoad(self, params: HadamardAmpLoad, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def TwoDimensionalEntangler(self, params: TwoDimensionalEntangler, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def BitwiseAnd(self, params: BitwiseAnd, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def BitwiseOr(self, params: BitwiseOr, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def LessEqual(self, params: LessEqual, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def IntegerComparator(self, params: IntegerComparator, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Equal(self, params: Equal, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def VQEAnsatz(self, params: VQEAnsatz, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def AmplitudeEstimation(self, params: AmplitudeEstimation, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def GreaterThan(self, params: GreaterThan, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def FinanceModels(self, params: FinanceModels, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Arithmetic(self, params: Arithmetic, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def QaoaAnsatz(self, params: QaoaAnsatz, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def BitwiseXor(self, params: BitwiseXor, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def CustomFunction(self, params: CustomFunction, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Adder(self, params: Adder, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def UnitaryGate(self, params: UnitaryGate, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def HardwareEfficientAnsatz(self, params: HardwareEfficientAnsatz, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def NotEqual(self, params: NotEqual, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Finance(self, params: Finance, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def GridEntangler(self, params: GridEntangler, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def FinancePayoff(self, params: FinancePayoff, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def HypercubeEntangler(self, params: HypercubeEntangler, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def Negation(self, params: Negation, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def SparseAmpLoad(self, params: SparseAmpLoad, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def LessThan(self, params: LessThan, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def GroverOperator(self, params: GroverOperator, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def StatePropagator(self, params: StatePropagator, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def ArithmeticOracle(self, params: ArithmeticOracle, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def StatePreparation(self, params: StatePreparation, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def QFT(self, params: QFT, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
    def GreaterEqual(self, params: GreaterEqual, in_wires: Optional[Dict[Enum, wire.Wire]] = None) -> Dict[Enum, wire.Wire]: ...
