"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const kms = require("aws-cdk-lib/aws-kms");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
const existingKey = new kms.Key(stack, `existingKey`, {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
});
const props = {
    iotTopicRuleProps: {
        topicRulePayload: {
            ruleDisabled: false,
            description: "process solutions constructs messages",
            sql: "SELECT * FROM 'solutions/constructs'",
            actions: []
        }
    },
    bucketProps: {
        encryption: aws_s3_1.BucketEncryption.KMS,
        encryptionKey: existingKey,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
    },
    loggingBucketProps: {
        encryption: aws_s3_1.BucketEncryption.KMS_MANAGED,
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
    }
};
new lib_1.IotToS3(stack, 'test-iot-s3-integration', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,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