# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ceg']

package_data = \
{'': ['*']}

install_requires = \
['rich>=12.5.1,<13.0.0']

entry_points = \
{'console_scripts': ['ceg = ceg.cli:ceg_cli']}

setup_kwargs = {
    'name': 'ceg',
    'version': '0.1.1',
    'description': 'A simple gist crud utility.',
    'long_description': '===\nCeg\n===\n\n\nOverview\n========\n-   `Introduction`_\n-   `Installation`_\n-   `Usage`_\n-   `Examples`_\n        - `Creating a gist`_\n        - `Modifying an existing gist`_\n        - `Listing public/secret(private) gists`_\n        - `Downloading a gist`_\n        - `Deleting a gist`_\n        - `Backing up all gists`_\n        - `Silent mode`_\n-   `Similar Projects`_\n-   `Issues`_\n-   `Contribution`_\n-   `License`_\n\nIntroduction\n------------\nA gist **<c**>reate/**<r**>ead/**<u**>pdate/**<d**>elete (crud) utility(pronounced as *Keg*).it can perform all the operations,you would want to perform on a gist.this includes:\n\n1. Creating gist(s).\n2. Modifying existing gist(s).\n3. Downloading gist(s). [1]_\n4. Listing public/secret gists for authenticated users as well as for unauthenticated users(only public).\n5. Deleting a gist. [2]_\n6. Creating a local backup of all the gists(for authenticated users).\n\nceg can also be used as a library. check out `Api documentation`_.\n\n.. [1] As of now, only files smaller than 10MB can be downloaded as allowed by GitHub API.this is planned to change once "git clone" has been implemented internally in future releases.\n.. [2] Bulk operation for deleting multiple gists for planned for next release.\n\nInstallation\n------------\nThere are multiple ways to install ceg, the simplest one being installing from PYPI_:\n::\n\n    # py instead of python3 on windows\n    python3 -m pip install ceg\n\n\nYou can also install it manually. for that, you need to have poetry_ installed and be on a system with a minimal python version being ``3.7``.after installing poetry, you can just do ``poetry build`` and pip install from ``dist/ceg*.whl`` or whatever you prefer. however please be mindful that installing poetry from pip is `not recommended`_. \n::\n\n    # you can also use install/uninstall scripts after cloning the repo, if on *nix.\n    curl -sSL https://install.python-poetry.org | python3 - \n    git clone https://github.com/justaus3r/ceg.git \n    cd ceg\n    poetry install\n    poetry build\n\nAfter installation, you can optionally set an environment variable named ``GIHTUB_SECRET_KEY`` and save your GitHub secret there. this helps to preclude you from passing your key explicitly every time you use the utility. however, if you don\'t feel comfortable storing it in an environment variable, you can use ``-sk/--secret-key`` and pass it to the utility.\n\n\nUsage\n-----\n::\n\n    usage: ceg [options] [sub-arguments]\n\n    A simple gist crud utility.\n\n    options:\n      -h, --help            show this help message and exit\n      -po GISTNAME [GISTNAME ...], --post GISTNAME [GISTNAME ...]\n                            create a gist\n      -pa GISTNAME [GISTNAME ...], --patch GISTNAME [GISTNAME ...]\n                            modify an existing gist\n      -g GISTID [GISTID ...], --get GISTID [GISTID ...]\n                            Download gist(s)\n      -d GISTID, --delete GISTID\n                            remove a gist\n      -l, --list            list public/private gists for authenticated user\n      -lo USERNAME, --list-other USERNAME\n                            list public gists for unauthenticated users\n      -bk, --backup         create a backup of all gists\n      -sk SECRETKEY, --secret-key SECRETKEY\n                            user\'s github secret key\n      -nl, --no-logging     don\'t log anything to stdout\n      -v, --version         show utility\'s semantic version\n    \n    sub-arguments:\n      --post/-po\n          --no-public/-np        switch gist visibility to private\n    \n          --description/-desc    description for the gist\n        \n      --patch/-pa\n          --gist-id/-gi          gist-id for the gist\n    \n    For more usage help, check out https://www.github.com/justaus3r/ceg/#examples\n\nExamples\n--------\nCreating a gist\n~~~~~~~~~~~~~~~\nYou can create a gist with multiple files added at the same time. but please know that if your files have a naming scheme like ``gistfile{number}``, it will be\nignored by ceg as GitHub uses this naming scheme internally. for creating a secret gist, you can just append ``--no-public/-np`` in the argument list.\n::\n    \n    $ ceg --post "file1" "file2" -desc "This is description of the gist"\n\nModifying an existing gist\n~~~~~~~~~~~~~~~~~~~~~~~~~~\nModifying a gist is just as easier as creating a gist. just pass all the modified files to ceg and the ``gist-id`` of gist you are modifying(use ``--gist-id/gi``).\nyou can also update the gist description by passing ``--description/-desc NEWDESCRIPTION``.\n::\n    \n    $ ceg --patch "file4" "file4" -desc "My dirty secrets." -gi abcdef\n\nListing public/secret(private) gists\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\nYou can list all of your gists, which will be beautified before printing to stdout. please note that if you are not authenticated(not giving GitHub secret key) then you can use ``--list-other/-lo`` but you will only be shown public gists.\n::\n\n    $ ceg -l\n      # or\n    $ ceg -lo Justaus3r\n\nDownloading a gist\n~~~~~~~~~~~~~~~~~~\nYou can download an arbitrary amount of gists in one go! just pass their ``gist-id``, sit back and let the magic happen! all of the gists will be downloaded in directories named with their respective gist-ids.\n::\n    \n    $ ceg -g gistid1 gistid2 gistid3\n\nDeleting a gist\n~~~~~~~~~~~~~~~\nYou can delete a gist by simpling passing its ``gist-id``.note that bulk operation is not supported for now.\n::\n\n    $ ceg -d gistid\n\nBacking up all gists\n~~~~~~~~~~~~~~~~~~~~\nAll user gists can be backed up, only by using a single command. only authenticated users can use this feature for now but that might change in future releases.\n::\n\n    $ ceg -bk\n\nSilent mode\n~~~~~~~~~~~\nAll operations can be performed under the silent mode, under which the logger is turned off and nothing is printed to stdout.\n::\n    \n    $ ceg -l -nl\n\nSimilar Projects\n~~~~~~~~~~~~~~~~\nIs ceg not your taste? well then you can try following similar projects:\n\n1. `defunkt/gist`_\n2. `ropensci/gistr`_ \n3. `jswank/gister`_\n\nIssues\n------\nYou can report all issues/feature requests at `GitHub bug tracker`_.\n\nContribution\n------------\nAll kinds of contributions are welcomed. though please be mindful that this project is statically typed and uses black formatting so please type-check(using ``mypy``) before a PR. I haven\'t yet added ``py.typed``, nor is the project type-checked at installation or any workflows setup to do so because I am too lazy. tho I plan to do that. also, note that\n`conventional commits`_ and `semantic versioning`_ are used for git commits/versioning.\n\nLicense\n-------\nThis project is distributed under "GNU General Public License v3.0",and can be distributed with its later versions.\n\n.. _`Api documentation`: https://github.com\n.. _PYPI: https://pypi.org\n.. _poetry: https://python-poetry.org/docs/master/#installing-with-the-official-installer\n.. _`not recommended`: https://python-poetry.org/docs/#alternative-installation-methods-not-recommended\n.. _`GitHub bug tracker`: https://github.com/justas3r/ceg/issues/\n.. _`conventional commits`: https://www.conventionalcommits.org/en/v1.0.0/\n.. _`semantic versioning`: https://semver.org/\n.. _`defunkt/gist`: https://github.com/defunkt/gist\n.. _`ropensci/gistr`: https://github.com/ropensci/gistr\n.. _`jswank/gister`: https://github.com/jswank/gister\n',
    'author': 'Justaus3r',
    'author_email': 'x-neron@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://www.github.com/justaus3r/ceg',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
