# nodetool snapshot --tag event-worker-table --table event_worker entpor_access

import click
import os
import boto3
import re
import shutil
import time
from python_cassandra_cli.aws_utils import AWSUtils

class StoreSnapshotTable(object):
    
    def __init__(self, keyspace, table_name, s3, id, key, tag, environment, schema, host, user, password, no_clear_snapshot, ssm_secret, region,secret_name):

        self.keyspace = keyspace
        self.table_name = table_name
        self.s3 = s3
        self.id = id
        self.key = key
        self.tag = tag
        self.environment = environment
        self.schema = schema
        self.host = host
        self.user = user
        self.password = password
        self.no_clear_snapshot = no_clear_snapshot
        self.ssm_secret = ssm_secret
        self.region = region
        self.secret_name = secret_name

    def store_snapshot_table(self):

        aws_utils = AWSUtils(self.id, self.key)

        client_s3 = aws_utils.s3_client()

        client_ssm = aws_utils.ssm_client(self.id, self.key, self.region)

        result_filtered_array = [];

        time_stamp = str(int(time.time()))

        main_folder = time_stamp + "_snapshots_" + self.tag + "_" + self.keyspace + "_" + self.table_name + "_" + self.environment;

        # nodetool take table snapshot
        cmd = "nodetool snapshot --tag {0} --table {1} {2}".format(self.tag, self.table_name, self.keyspace)
        os.system(cmd);

        user_dir=os.getcwd()
        # change to root of system
        os.chdir('/')

        # search snapshots
        for root,dirs,files in os.walk('.'):
            if (re.search('/snapshots/'+self.tag+"$", root)) and ("_snapshots_" + self.tag + "_" + self.keyspace not in root ):
                    result_filtered_array.append(root);
        # change dir to user directory
        os.chdir(user_dir);

        for line in result_filtered_array:
            i = result_filtered_array.index(line);
            result_record_init = result_filtered_array[i];
            result_record = re.sub('^.','', result_record_init);
            folder_path=result_record.partition("/" +  self.keyspace)[2];
            folder_copy=re.sub("/" + self.tag, '',folder_path);
            snapshotdir = main_folder + folder_copy + "/" + self.tag;
            shutil.copytree(result_record, snapshotdir);

        if self.schema:
            if self.ssm_secret:
                print('Getting secrets from SSM')
                parameter = client_ssm.get_parameter(Name=self.secret_name, WithDecryption=True)
                value_array = parameter['Parameter']['Value'].split('\n')
                result_dict={}
                for item in value_array:
                    result_dict[item.partition('=')[0]]=item.partition('=')[2]
                user=result_dict['USER']
                password=result_dict['PASSWORD']
            else:
                user=self.user
                password=self.password

            cmd_cql = "cqlsh {0} -u {1} -p {2} -e \"DESC TABLE {4}.{5};\" > {3}/{4}_{5}_{6}_schema.cql".format(
                self.host, user, password, main_folder, self.keyspace, self.table_name, self.environment)
            # print(cmd_cql);
            os.system(cmd_cql);

        for root,dirs,files in os.walk(main_folder):
            for file in files:
                client_s3.upload_file(os.path.join(root,file), self.s3, os.path.join(root,file))
                # print(os.path.join(root,file));

        shutil.rmtree(main_folder)

        if self.no_clear_snapshot:
            print("You need to clear snapshot with tag '% s' using nodetool" % self.tag)
        else:
            print("Clearing snapshot '% s' from system" % self.tag);
            cmd_nodetool = "nodetool clearsnapshot -t {0}".format(self.tag)
            # print(cmd_nodetool);
            os.system(cmd_nodetool);