# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['protoletariat', 'protoletariat.tests']

package_data = \
{'': ['*']}

install_requires = \
['astor>=0.8.1,<0.9.0', 'click>=8.0.1,<9.0.0', 'protobuf>=3.19.1,<4.0.0']

entry_points = \
{'console_scripts': ['protol = protoletariat.__main__:main']}

setup_kwargs = {
    'name': 'protoletariat',
    'version': '0.2.1',
    'description': 'Python protocol buffers for the rest of us',
    'long_description': '# Protocol Buffers for the Rest of Us\n\n## Motivation\n\n`protoletariat` has one goal: fixing the broken imports for the Python code\ngenerated by `protoc`.\n\n## Usage\n\nHere\'s an example of how to use the tool, called `protol`:\n\n1. Create a few protobuf files\n\n```protobuf\n// thing1.proto\nsyntax = "proto3";\n\nimport "thing2.proto";\n\npackage things;\n\nmessage Thing1 {\n  Thing2 thing2 = 1;\n}\n```\n\n```protobuf\n// thing2.proto\nsyntax = "proto3";\n\npackage things;\n\nmessage Thing2 {\n  string data = 1;\n}\n```\n\n2. Run `protoc` on those files\n\n```sh\n$ mkdir out\n$ protoc --python_out=out --proto_path=directory/containing/protos thing1.proto thing2.proto\n```\n\n3. Run `protol` on the generated code\n\n```sh\n$ protol --create-init --overwrite -g out --proto-path=directory/containing/protos thing1.proto thing2.proto\n```\n\nThe `out/thing1_pb2.py` file should show a diff containing at least these lines:\n\n```patch\n-import thing2_pb2 as thing2__pb2\n-\n+from . import thing2_pb2 as thing2__pb2\n```\n\n## How it works\n\nAt a high level, `protoletariat` converts absolute imports to relative imports.\n\nHowever, it doesn\'t just convert any absolute import to a relative import.\n\nThe `protol` tool will only convert imports that were generated from `.proto` files. It\ndoes this by inspecting `FileDescriptorProtos` from the protobuf files.\n\nThe core mechanism is implemented using a simplified form of pattern matching,\nthat looks at the Python AST, and if an import pattern is matched and\ncorresponding rewrite rule is fired.\n\n## Help\n\n```\n$ protol --help\nUsage: protol [OPTIONS] PROTO_FILES...\n\n  Rewrite protoc-generated imports for use by the proletariat.\n\nOptions:\n  -g, --generated-python-dir DIRECTORY\n                                  Directory containing generated Python code\n                                  [required]\n  -p, --proto-path DIRECTORY      Protobuf file search path(s). Accepts\n                                  multiple values.  [required]\n  --overwrite / --no-overwrite    Overwrite all generated Python files with\n                                  modified imports\n  --create-init / --dont-create-init\n                                  Create an __init__.py file under the\n                                  `generated-python-dir` directory\n  --help                          Show this message and exit.\n```\n',
    'author': 'Phillip Cloud',
    'author_email': '417981+cpcloud@users.noreply.github.com',
    'maintainer': 'Phillip Cloud',
    'maintainer_email': '417981+cpcloud@users.noreply.github.com',
    'url': 'https://github.com/cpcloud/protoletariat',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
