"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    Autogenerated on: 2022-07-13 11:13:18
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyopencga.rest_clients._parent_rest_clients import _ParentRestClient


class Variant(_ParentRestClient):
    """
    This class contains methods for the 'Analysis - Variant' webservices
    Client version: 2.2.4-SNAPSHOT [a5b6f4334f26b4e2e2d8b2843830c3b8f1b5b6e8]
    PATH: /{apiVersion}/analysis/variant
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Variant, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def aggregation_stats(self, **options):
        """
        Calculate and fetch aggregation stats.
        PATH: /{apiVersion}/analysis/variant/aggregationStats

        :param str saved_filter: Use a saved filter at User level.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str type: List of types, accepted values are SNV, MNV, INDEL,
            SV, COPY_NUMBER, COPY_NUMBER_LOSS, COPY_NUMBER_GAIN, INSERTION,
            DELETION, DUPLICATION, TANDEM_DUPLICATION, BREAKEND, e.g.
            SNV,INDEL.
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str cohort: Select variants with calculated stats for the
            selected cohorts.
        :param str cohort_stats_ref: Reference Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_alt: Alternate Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_maf: Minor Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_mgf: Minor Genotype Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_pass: Filter PASS frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str missing_alleles: Number of missing alleles:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str missing_genotypes: Number of missing genotypes:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str score: Filter by variant score:
            [{study:}]{score}[<|>|<=|>=]{number}.
        :param bool annotation_exists: Return only annotated variants.
        :param str gene: List of genes, most gene IDs are accepted (HGNC,
            Ensembl gene, ...). This is an alias to 'xref' parameter.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578. Accepts
            aliases 'loss_of_function' and 'protein_altering'.
        :param str xref: List of any external reference, these can be genes,
            proteins or variants. Accepted IDs include HGNC, Ensembl genes,
            dbSNP, ClinVar, HPO, Cosmic, ...
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str protein_substitution: Protein substitution scores include
            SIFT and PolyPhen. You can query using the score
            {protein_score}[<|>|<=|>=]{number} or the description
            {protein_score}[~=|=]{description} e.g. polyphen>0.1,sift=tolerant.
        :param str conservation: Filter by conservation score:
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str population_frequency_alt: Alternate Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_ref: Reference Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_maf: Population minor allele
            frequency: {study}:{population}[<|>|<=|>=]{number}. e.g.
            1kG_phase3:ALL<0.01.
        :param str transcript_flag: List of transcript flags. e.g. canonical,
            CCDS, basic, LRG, MANE Select, MANE Plus Clinical, EGLH_HaemOnc,
            TSO500.
        :param str gene_trait_id: List of gene trait association id. e.g.
            'umls:C0007222' , 'OMIM:269600'.
        :param str go: List of GO (Gene Ontology) terms. e.g. 'GO:0002020'.
        :param str expression: List of tissues of interest. e.g. 'lung'.
        :param str protein_keyword: List of Uniprot protein variant annotation
            keywords.
        :param str drug: List of drug names.
        :param str functional_score: Functional score:
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str clinical: Clinical source: clinvar, cosmic.
        :param str clinical_significance: Clinical significance: benign,
            likely_benign, likely_pathogenic, pathogenic.
        :param bool clinical_confirmed_status: Clinical confirmed status.
        :param str custom_annotation: Custom annotation:
            {key}[<|>|<=|>=]{number} or {key}[~=|=]{text}.
        :param str trait: List of traits, based on ClinVar, HPO, COSMIC, i.e.:
            IDs, histologies, descriptions,...
        :param str field: List of facet fields separated by semicolons, e.g.:
            studies;type. For nested faceted fields use >>, e.g.:
            chromosome>>type;percentile(gerp).
        """

        return self._get(category='analysis', resource='aggregationStats', subcategory='variant', **options)

    def metadata_annotation(self, **options):
        """
        Read variant annotations metadata from any saved versions.
        PATH: /{apiVersion}/analysis/variant/annotation/metadata

        :param str annotation_id: Annotation identifier.
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        """

        return self._get(category='analysis', resource='metadata', subcategory='variant/annotation', **options)

    def query_annotation(self, **options):
        """
        Query variant annotations from any saved versions.
        PATH: /{apiVersion}/analysis/variant/annotation/query

        :param str id: List of IDs, these can be rs IDs (dbSNP) or variants in
            the format chrom:start:ref:alt, e.g. rs116600158,19:7177679:C:T.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str annotation_id: Annotation identifier.
        """

        return self._get(category='analysis', resource='query', subcategory='variant/annotation', **options)

    def run_circos(self, data=None, **options):
        """
        Generate a Circos plot for a given sample.
        PATH: /{apiVersion}/analysis/variant/circos/run

        :param dict data: Circos analysis params to customize the plot. These
            parameters include the title,  the plot density (i.e., the number
            of points to display), the general query and the list of tracks.
            Currently, the supported track types are: COPY-NUMBER, INDEL,
            REARRANGEMENT and SNV. In addition, each track can contain a
            specific query. (REQUIRED)
        :param str study: study.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/circos', data=data, **options)

    def delete_cohort_stats(self, **options):
        """
        Delete cohort variant stats from a cohort.
        PATH: /{apiVersion}/analysis/variant/cohort/stats/delete

        :param str study: study.
        :param str cohort: Cohort ID or UUID.
        """

        return self._delete(category='analysis', resource='delete', subcategory='variant/cohort/stats', **options)

    def info_cohort_stats(self, cohort, **options):
        """
        Read cohort variant stats from list of cohorts.
        PATH: /{apiVersion}/analysis/variant/cohort/stats/info

        :param str cohort: Comma separated list of cohort IDs or UUIDs up to a
            maximum of 100. (REQUIRED)
        :param str study: study.
        """

        options['cohort'] = cohort
        return self._get(category='analysis', resource='info', subcategory='variant/cohort/stats', **options)

    def run_cohort_stats(self, data=None, **options):
        """
        Compute cohort variant stats for the selected list of samples.
        PATH: /{apiVersion}/analysis/variant/cohort/stats/run

        :param dict data: Cohort variant stats params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/cohort/stats', data=data, **options)

    def run_export(self, data=None, **options):
        """
        Filter and export variants from the variant storage to a file.
        PATH: /{apiVersion}/analysis/variant/export/run

        :param dict data: Variant export params. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/export', data=data, **options)

    def genotypes_family(self, mode_of_inheritance, **options):
        """
        Calculate the possible genotypes for the members of a family.
        PATH: /{apiVersion}/analysis/variant/family/genotypes

        :param str mode_of_inheritance: Mode of inheritance. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str family: Family id.
        :param str clinical_analysis: Clinical analysis id.
        :param str penetrance: Penetrance.
        :param str disorder: Disorder id.
        """

        options['modeOfInheritance'] = mode_of_inheritance
        return self._get(category='analysis', resource='genotypes', subcategory='variant/family', **options)

    def run_family_qc(self, data=None, **options):
        """
        Run quality control (QC) for a given family. It computes the
            relatedness scores among the family members.
        PATH: /{apiVersion}/analysis/variant/family/qc/run

        :param dict data: Family QC analysis params. Family ID. Relatedness
            method, by default 'PLINK/IBD'. Minor  allele frequence (MAF) is
            used to filter variants before computing relatedness, e.g.:
            1kg_phase3:CEU>0.35 or cohort:ALL>0.05. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/family/qc', data=data, **options)

    def delete_file(self, **options):
        """
         [DEPRECATED] Use operation/variant/delete.
        PATH: /{apiVersion}/analysis/variant/file/delete

        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str file: Files to remove.
        :param bool resume: Resume a previously failed indexation.
        """

        return self._delete(category='analysis', resource='delete', subcategory='variant/file', **options)

    def run_gatk(self, data=None, **options):
        """
        GATK is a Genome Analysis Toolkit for variant discovery in
            high-throughput sequencing data. Supported Gatk commands:
            HaplotypeCaller.
        PATH: /{apiVersion}/analysis/variant/gatk/run

        :param dict data: Gatk parameters. Supported Gatk commands:
            HaplotypeCaller. (REQUIRED)
        :param str study: study.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/gatk', data=data, **options)

    def run_genome_plot(self, data=None, **options):
        """
        Generate a genome plot for a given sample.
        PATH: /{apiVersion}/analysis/variant/genomePlot/run

        :param dict data: Genome plot analysis params to customize the plot.
            The configuration file includes the title,  the plot density (i.e.,
            the number of points to display), the general query and the list of
            tracks. Currently, the supported track types are: COPY-NUMBER,
            INDEL, REARRANGEMENT and SNV. In addition, each track can contain a
            specific query. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/genomePlot', data=data, **options)

    def run_gwas(self, data=None, **options):
        """
        Run a Genome Wide Association Study between two cohorts.
        PATH: /{apiVersion}/analysis/variant/gwas/run

        :param dict data: Gwas analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/gwas', data=data, **options)

    def run_index(self, data=None, **options):
        """
         [DEPRECATED] Use operation/variant/index.
        PATH: /{apiVersion}/analysis/variant/index/run

        :param dict data: Variant index params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_description: Job description.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/index', data=data, **options)

    def run_individual_qc(self, data=None, **options):
        """
        Run quality control (QC) for a given individual. It includes inferred
            sex and  mendelian errors (UDP).
        PATH: /{apiVersion}/analysis/variant/individual/qc/run

        :param dict data: Individual QC analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/individual/qc', data=data, **options)

    def run_inferred_sex(self, data=None, **options):
        """
        Infer sex from chromosome mean coverages.
        PATH: /{apiVersion}/analysis/variant/inferredSex/run

        :param dict data: Inferred sex analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/inferredSex', data=data, **options)

    def query_knockout_gene(self, **options):
        """
        Fetch values from KnockoutAnalysis result, by genes.
        PATH: /{apiVersion}/analysis/variant/knockout/gene/query

        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str study: study.
        :param str job: Job ID or UUID.
        """

        return self._get(category='analysis', resource='query', subcategory='variant/knockout/gene', **options)

    def query_knockout_individual(self, **options):
        """
        Fetch values from KnockoutAnalysis result, by individuals.
        PATH: /{apiVersion}/analysis/variant/knockout/individual/query

        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str study: study.
        :param str job: Job ID or UUID.
        """

        return self._get(category='analysis', resource='query', subcategory='variant/knockout/individual', **options)

    def run_knockout(self, data=None, **options):
        """
        Obtains the list of knocked out genes for each sample.
        PATH: /{apiVersion}/analysis/variant/knockout/run

        :param dict data: Gene knockout analysis params. (REQUIRED)
        :param str study: study.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/knockout', data=data, **options)

    def run_mendelian_error(self, data=None, **options):
        """
        Run mendelian error analysis to infer uniparental disomy regions.
        PATH: /{apiVersion}/analysis/variant/mendelianError/run

        :param dict data: Mendelian error analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/mendelianError', data=data, **options)

    def metadata(self, **options):
        """
        .
        PATH: /{apiVersion}/analysis/variant/metadata

        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str file: Filter variants from the files specified. This will
            set includeFile parameter when not provided.
        :param str sample: Filter variants by sample genotype. This will
            automatically set 'includeSample' parameter when not provided. This
            filter accepts multiple 3 forms: 1) List of samples: Samples that
            contain the main variant. Accepts AND (;) and OR (,) operators. 
            e.g. HG0097,HG0098 . 2) List of samples with genotypes:
            {sample}:{gt1},{gt2}. Accepts AND (;) and OR (,) operators.  e.g.
            HG0097:0/0;HG0098:0/1,1/1 . Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT, HET_MISS and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT . 3) Sample with segregation
            mode: {sample}:{segregation}. Only one sample accepted.Accepted
            segregation modes: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ]. Value is case insensitive.
            e.g. HG0097:DeNovo Sample must have parents defined and indexed. .
        :param str include_study: List of studies to include in the result.
            Accepts 'all' and 'none'.
        :param str include_file: List of files to be returned. Accepts 'all'
            and 'none'. If undefined, automatically includes files used for
            filtering. If none, no file is included.
        :param str include_sample: List of samples to be included in the
            result. Accepts 'all' and 'none'. If undefined, automatically
            includes samples used for filtering. If none, no sample is
            included.
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        """

        return self._get(category='analysis', resource='metadata', subcategory='variant', **options)

    def query_mutational_signature(self, **options):
        """
        Run mutational signature analysis for a given sample. Use context
            index.
        PATH: /{apiVersion}/analysis/variant/mutationalSignature/query

        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str sample: Sample name.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578. Accepts
            aliases 'loss_of_function' and 'protein_altering'.
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str file_data: Filter by file data (i.e. FILTER, QUAL and INFO
            columns from VCF file). [{file}:]{key}{op}{value}[,;]* . If no file
            is specified, will use all files from 'file' filter. e.g. AN>200 or
            file_1.vcf:AN>200;file_2.vcf:AN<10 . Many fields can be combined.
            e.g. file_1.vcf:AN>200;DB=true;file_2.vcf:AN<10,FILTER=PASS,LowDP.
        :param str filter: Specify the FILTER for any of the files. If 'file'
            filter is provided, will match the file and the filter. e.g.:
            PASS,LowGQX.
        :param str qual: Specify the QUAL for any of the files. If 'file'
            filter is provided, will match the file and the qual. e.g.: >123.4.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str gene: List of genes, most gene IDs are accepted (HGNC,
            Ensembl gene, ...). This is an alias to 'xref' parameter.
        :param str panel: Filter by genes from the given disease panel.
        :param str panel_mode_of_inheritance: Filter genes from specific
            panels that match certain mode of inheritance. Accepted values : [
            autosomalDominant, autosomalRecessive, XLinkedDominant,
            XLinkedRecessive, YLinked, mitochondrial, deNovo, mendelianError,
            compoundHeterozygous ].
        :param str panel_confidence: Filter genes from specific panels that
            match certain confidence. Accepted values : [ high, medium, low,
            rejected ].
        :param str panel_feature_type: Filter elements from specific panels by
            type. Accepted values : [ gene, region, str, variant ].
        :param str panel_role_in_cancer: Filter genes from specific panels
            that match certain role in cancer. Accepted values : [ both,
            oncogene, tumorSuppressorGene, fusion ].
        :param bool panel_intersection: Intersect panel genes and regions with
            given genes and regions from que input query. This will prevent
            returning variants from regions out of the panel.
        :param bool fitting: Compute the relative proportions of the different
            mutational signatures demonstrated by the tumour.
        """

        return self._get(category='analysis', resource='query', subcategory='variant/mutationalSignature', **options)

    def run_mutational_signature(self, data=None, **options):
        """
        Run mutational signature analysis for a given sample.
        PATH: /{apiVersion}/analysis/variant/mutationalSignature/run

        :param dict data: Mutational signature analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/mutationalSignature', data=data, **options)

    def run_plink(self, data=None, **options):
        """
        Plink is a whole genome association analysis toolset, designed to
            perform a range of basic, large-scale analyses.
        PATH: /{apiVersion}/analysis/variant/plink/run

        :param dict data: Plink params. (REQUIRED)
        :param str study: study.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/plink', data=data, **options)

    def query(self, **options):
        """
        Filter and fetch variants from indexed VCF files in the variant
            storage.
        PATH: /{apiVersion}/analysis/variant/query

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param bool sort: Sort the results.
        :param bool summary: Fast fetch of main variant parameters.
        :param bool approximate_count: Get an approximate count, instead of an
            exact total count. Reduces execution time.
        :param int approximate_count_sampling_size: Sampling size to get the
            approximate count. Larger values increase accuracy but also
            increase execution time.
        :param str saved_filter: Use a saved filter at User level.
        :param str id: List of IDs, these can be rs IDs (dbSNP) or variants in
            the format chrom:start:ref:alt, e.g. rs116600158,19:7177679:C:T.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str type: List of types, accepted values are SNV, MNV, INDEL,
            SV, COPY_NUMBER, COPY_NUMBER_LOSS, COPY_NUMBER_GAIN, INSERTION,
            DELETION, DUPLICATION, TANDEM_DUPLICATION, BREAKEND, e.g.
            SNV,INDEL.
        :param str reference: Reference allele.
        :param str alternate: Main alternate allele.
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str file: Filter variants from the files specified. This will
            set includeFile parameter when not provided.
        :param str filter: Specify the FILTER for any of the files. If 'file'
            filter is provided, will match the file and the filter. e.g.:
            PASS,LowGQX.
        :param str qual: Specify the QUAL for any of the files. If 'file'
            filter is provided, will match the file and the qual. e.g.: >123.4.
        :param str file_data: Filter by file data (i.e. FILTER, QUAL and INFO
            columns from VCF file). [{file}:]{key}{op}{value}[,;]* . If no file
            is specified, will use all files from 'file' filter. e.g. AN>200 or
            file_1.vcf:AN>200;file_2.vcf:AN<10 . Many fields can be combined.
            e.g. file_1.vcf:AN>200;DB=true;file_2.vcf:AN<10,FILTER=PASS,LowDP.
        :param str sample: Filter variants by sample genotype. This will
            automatically set 'includeSample' parameter when not provided. This
            filter accepts multiple 3 forms: 1) List of samples: Samples that
            contain the main variant. Accepts AND (;) and OR (,) operators. 
            e.g. HG0097,HG0098 . 2) List of samples with genotypes:
            {sample}:{gt1},{gt2}. Accepts AND (;) and OR (,) operators.  e.g.
            HG0097:0/0;HG0098:0/1,1/1 . Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT, HET_MISS and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT . 3) Sample with segregation
            mode: {sample}:{segregation}. Only one sample accepted.Accepted
            segregation modes: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ]. Value is case insensitive.
            e.g. HG0097:DeNovo Sample must have parents defined and indexed. .
        :param str genotype: Samples with a specific genotype:
            {samp_1}:{gt_1}(,{gt_n})*(;{samp_n}:{gt_1}(,{gt_n})*)* e.g.
            HG0097:0/0;HG0098:0/1,1/1. Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT, HET_MISS and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT. This will automatically set
            'includeSample' parameter when not provided.
        :param str sample_data: Filter by any SampleData field from samples.
            [{sample}:]{key}{op}{value}[,;]* . If no sample is specified, will
            use all samples from 'sample' or 'genotype' filter. e.g. DP>200 or
            HG0097:DP>200,HG0098:DP<10 . Many FORMAT fields can be combined.
            e.g. HG0097:DP>200;GT=1/1,0/1,HG0098:DP<10.
        :param str sample_annotation: Selects some samples using metadata
            information from Catalog. e.g.
            age>20;phenotype=hpo:123,hpo:456;name=smith.
        :param bool sample_metadata: Return the samples metadata group by
            study. Sample names will appear in the same order as their
            corresponding genotypes.
        :param str unknown_genotype: Returned genotype for unknown genotypes.
            Common values: [0/0, 0|0, ./.].
        :param int sample_limit: Limit the number of samples to be included in
            the result.
        :param int sample_skip: Skip some samples from the result. Useful for
            sample pagination.
        :param str cohort: Select variants with calculated stats for the
            selected cohorts.
        :param str cohort_stats_ref: Reference Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_alt: Alternate Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_maf: Minor Allele Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_mgf: Minor Genotype Frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cohort_stats_pass: Filter PASS frequency:
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str missing_alleles: Number of missing alleles:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str missing_genotypes: Number of missing genotypes:
            [{study:}]{cohort}[<|>|<=|>=]{number}.
        :param str score: Filter by variant score:
            [{study:}]{score}[<|>|<=|>=]{number}.
        :param str family: Filter variants where any of the samples from the
            given family contains the variant (HET or HOM_ALT).
        :param str family_disorder: Specify the disorder to use for the family
            segregation.
        :param str family_segregation: Filter by segregation mode from a given
            family. Accepted values: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ].
        :param str family_members: Sub set of the members of a given family.
        :param str family_proband: Specify the proband child to use for the
            family segregation.
        :param str include_study: List of studies to include in the result.
            Accepts 'all' and 'none'.
        :param str include_file: List of files to be returned. Accepts 'all'
            and 'none'. If undefined, automatically includes files used for
            filtering. If none, no file is included.
        :param str include_sample: List of samples to be included in the
            result. Accepts 'all' and 'none'. If undefined, automatically
            includes samples used for filtering. If none, no sample is
            included.
        :param str include_sample_data: List of Sample Data keys (i.e. FORMAT
            column from VCF file) from Sample Data to include in the output.
            e.g: DP,AD. Accepts 'all' and 'none'.
        :param str include_genotype: Include genotypes, apart of other formats
            defined with includeFormat.
        :param str include_sample_id: Include sampleId on each result.
        :param bool annotation_exists: Return only annotated variants.
        :param str gene: List of genes, most gene IDs are accepted (HGNC,
            Ensembl gene, ...). This is an alias to 'xref' parameter.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578. Accepts
            aliases 'loss_of_function' and 'protein_altering'.
        :param str xref: List of any external reference, these can be genes,
            proteins or variants. Accepted IDs include HGNC, Ensembl genes,
            dbSNP, ClinVar, HPO, Cosmic, ...
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str protein_substitution: Protein substitution scores include
            SIFT and PolyPhen. You can query using the score
            {protein_score}[<|>|<=|>=]{number} or the description
            {protein_score}[~=|=]{description} e.g. polyphen>0.1,sift=tolerant.
        :param str conservation: Filter by conservation score:
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str population_frequency_alt: Alternate Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_ref: Reference Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str population_frequency_maf: Population minor allele
            frequency: {study}:{population}[<|>|<=|>=]{number}. e.g.
            1kG_phase3:ALL<0.01.
        :param str transcript_flag: List of transcript flags. e.g. canonical,
            CCDS, basic, LRG, MANE Select, MANE Plus Clinical, EGLH_HaemOnc,
            TSO500.
        :param str gene_trait_id: List of gene trait association id. e.g.
            'umls:C0007222' , 'OMIM:269600'.
        :param str go: List of GO (Gene Ontology) terms. e.g. 'GO:0002020'.
        :param str expression: List of tissues of interest. e.g. 'lung'.
        :param str protein_keyword: List of Uniprot protein variant annotation
            keywords.
        :param str drug: List of drug names.
        :param str functional_score: Functional score:
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str clinical: Clinical source: clinvar, cosmic.
        :param str clinical_significance: Clinical significance: benign,
            likely_benign, likely_pathogenic, pathogenic.
        :param bool clinical_confirmed_status: Clinical confirmed status.
        :param str custom_annotation: Custom annotation:
            {key}[<|>|<=|>=]{number} or {key}[~=|=]{text}.
        :param str panel: Filter by genes from the given disease panel.
        :param str panel_mode_of_inheritance: Filter genes from specific
            panels that match certain mode of inheritance. Accepted values : [
            autosomalDominant, autosomalRecessive, XLinkedDominant,
            XLinkedRecessive, YLinked, mitochondrial, deNovo, mendelianError,
            compoundHeterozygous ].
        :param str panel_confidence: Filter genes from specific panels that
            match certain confidence. Accepted values : [ high, medium, low,
            rejected ].
        :param str panel_role_in_cancer: Filter genes from specific panels
            that match certain role in cancer. Accepted values : [ both,
            oncogene, tumorSuppressorGene, fusion ].
        :param str panel_feature_type: Filter elements from specific panels by
            type. Accepted values : [ gene, region, str, variant ].
        :param bool panel_intersection: Intersect panel genes and regions with
            given genes and regions from que input query. This will prevent
            returning variants from regions out of the panel.
        :param str trait: List of traits, based on ClinVar, HPO, COSMIC, i.e.:
            IDs, histologies, descriptions,...
        """

        return self._get(category='analysis', resource='query', subcategory='variant', **options)

    def run_relatedness(self, data=None, **options):
        """
        Compute a score to quantify relatedness between samples.
        PATH: /{apiVersion}/analysis/variant/relatedness/run

        :param dict data: Relatedness analysis params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/relatedness', data=data, **options)

    def run_rvtests(self, data=None, **options):
        """
        Rvtests is a flexible software package for genetic association
            studies. Supported RvTests commands: rvtest, vcf2kinship.
        PATH: /{apiVersion}/analysis/variant/rvtests/run

        :param dict data: RvTests parameters. Supported RvTests commands:
            rvtest, vcf2kinship. (REQUIRED)
        :param str study: study.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/rvtests', data=data, **options)

    def aggregation_stats_sample(self, **options):
        """
        Calculate and fetch sample aggregation stats.
        PATH: /{apiVersion}/analysis/variant/sample/aggregationStats

        :param str saved_filter: Use a saved filter at User level.
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str type: List of types, accepted values are SNV, MNV, INDEL,
            SV, COPY_NUMBER, COPY_NUMBER_LOSS, COPY_NUMBER_GAIN, INSERTION,
            DELETION, DUPLICATION, TANDEM_DUPLICATION, BREAKEND, e.g.
            SNV,INDEL.
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Filter variants from the given studies, these can be
            either the numeric ID or the alias with the format
            user@project:study.
        :param str file: Filter variants from the files specified. This will
            set includeFile parameter when not provided.
        :param str filter: Specify the FILTER for any of the files. If 'file'
            filter is provided, will match the file and the filter. e.g.:
            PASS,LowGQX.
        :param str sample: Filter variants by sample genotype. This will
            automatically set 'includeSample' parameter when not provided. This
            filter accepts multiple 3 forms: 1) List of samples: Samples that
            contain the main variant. Accepts AND (;) and OR (,) operators. 
            e.g. HG0097,HG0098 . 2) List of samples with genotypes:
            {sample}:{gt1},{gt2}. Accepts AND (;) and OR (,) operators.  e.g.
            HG0097:0/0;HG0098:0/1,1/1 . Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT, HET_MISS and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT . 3) Sample with segregation
            mode: {sample}:{segregation}. Only one sample accepted.Accepted
            segregation modes: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ]. Value is case insensitive.
            e.g. HG0097:DeNovo Sample must have parents defined and indexed. .
        :param str genotype: Samples with a specific genotype:
            {samp_1}:{gt_1}(,{gt_n})*(;{samp_n}:{gt_1}(,{gt_n})*)* e.g.
            HG0097:0/0;HG0098:0/1,1/1. Unphased genotypes (e.g. 0/1, 1/1) will
            also include phased genotypes (e.g. 0|1, 1|0, 1|1), but not vice
            versa. When filtering by multi-allelic genotypes, any secondary
            allele will match, regardless of its position e.g. 1/2 will match
            with genotypes 1/2, 1/3, 1/4, .... Genotype aliases accepted:
            HOM_REF, HOM_ALT, HET, HET_REF, HET_ALT, HET_MISS and MISS  e.g.
            HG0097:HOM_REF;HG0098:HET_REF,HOM_ALT. This will automatically set
            'includeSample' parameter when not provided.
        :param str sample_annotation: Selects some samples using metadata
            information from Catalog. e.g.
            age>20;phenotype=hpo:123,hpo:456;name=smith.
        :param str family: Filter variants where any of the samples from the
            given family contains the variant (HET or HOM_ALT).
        :param str family_disorder: Specify the disorder to use for the family
            segregation.
        :param str family_segregation: Filter by segregation mode from a given
            family. Accepted values: [ autosomalDominant, autosomalRecessive,
            XLinkedDominant, XLinkedRecessive, YLinked, mitochondrial, deNovo,
            mendelianError, compoundHeterozygous ].
        :param str family_members: Sub set of the members of a given family.
        :param str family_proband: Specify the proband child to use for the
            family segregation.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578. Accepts
            aliases 'loss_of_function' and 'protein_altering'.
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str population_frequency_alt: Alternate Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str clinical: Clinical source: clinvar, cosmic.
        :param str clinical_significance: Clinical significance: benign,
            likely_benign, likely_pathogenic, pathogenic.
        :param bool clinical_confirmed_status: Clinical confirmed status.
        :param str field: List of facet fields separated by semicolons, e.g.:
            studies;type. For nested faceted fields use >>, e.g.:
            chromosome>>type . Accepted values: chromosome, type, genotype,
            consequenceType, biotype, clinicalSignificance, dp, qual, filter.
        """

        return self._get(category='analysis', resource='aggregationStats', subcategory='variant/sample', **options)

    def run_sample_eligibility(self, data=None, **options):
        """
        Filter samples by a complex query involving metadata and variants
            data.
        PATH: /{apiVersion}/analysis/variant/sample/eligibility/run

        :param dict data: . (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/sample/eligibility', data=data, **options)

    def run_sample_qc(self, data=None, **options):
        """
        Run quality control (QC) for a given sample. It includes variant
            stats, and if the sample is somatic, mutational signature and
            genome plot are calculated.
        PATH: /{apiVersion}/analysis/variant/sample/qc/run

        :param dict data: Sample QC analysis params. Mutational signature and
            genome plot are calculated for somatic samples only. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/sample/qc', data=data, **options)

    def query_sample(self, **options):
        """
        Get sample data of a given variant.
        PATH: /{apiVersion}/analysis/variant/sample/query

        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str variant: Variant.
        :param str study: Study where all the samples belong to.
        :param str genotype: Genotypes that the sample must have to be
            selected.
        """

        return self._get(category='analysis', resource='query', subcategory='variant/sample', **options)

    def run_sample(self, data=None, **options):
        """
        Get samples given a set of variants.
        PATH: /{apiVersion}/analysis/variant/sample/run

        :param dict data: Sample variant filter params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/sample', data=data, **options)

    def query_sample_stats(self, sample, **options):
        """
        Obtain sample variant stats from a sample.
        PATH: /{apiVersion}/analysis/variant/sample/stats/query

        :param str sample: Sample ID. (REQUIRED)
        :param str region: List of regions, these can be just a single
            chromosome name or regions in the format chr:start-end, e.g.:
            2,3:100000-200000.
        :param str type: List of types, accepted values are SNV, MNV, INDEL,
            SV, COPY_NUMBER, COPY_NUMBER_LOSS, COPY_NUMBER_GAIN, INSERTION,
            DELETION, DUPLICATION, TANDEM_DUPLICATION, BREAKEND, e.g.
            SNV,INDEL.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str file: Filter variants from the files specified. This will
            set includeFile parameter when not provided.
        :param str filter: Specify the FILTER for any of the files. If 'file'
            filter is provided, will match the file and the filter. e.g.:
            PASS,LowGQX.
        :param str sample_data: Filter by any SampleData field from samples.
            [{sample}:]{key}{op}{value}[,;]* . If no sample is specified, will
            use all samples from 'sample' or 'genotype' filter. e.g. DP>200 or
            HG0097:DP>200,HG0098:DP<10 . Many FORMAT fields can be combined.
            e.g. HG0097:DP>200;GT=1/1,0/1,HG0098:DP<10.
        :param str ct: List of SO consequence types, e.g.
            missense_variant,stop_lost or SO:0001583,SO:0001578. Accepts
            aliases 'loss_of_function' and 'protein_altering'.
        :param str biotype: List of biotypes, e.g. protein_coding.
        :param str transcript_flag: List of transcript flags. e.g. canonical,
            CCDS, basic, LRG, MANE Select, MANE Plus Clinical, EGLH_HaemOnc,
            TSO500.
        :param str population_frequency_alt: Alternate Population Frequency:
            {study}:{population}[<|>|<=|>=]{number}. e.g. 1kG_phase3:ALL<0.01.
        :param str clinical: Clinical source: clinvar, cosmic.
        :param str clinical_significance: Clinical significance: benign,
            likely_benign, likely_pathogenic, pathogenic.
        :param bool clinical_confirmed_status: Clinical confirmed status.
        :param bool filter_transcript: Do filter transcripts when obtaining
            transcript counts.
        """

        options['sample'] = sample
        return self._get(category='analysis', resource='query', subcategory='variant/sample/stats', **options)

    def run_sample_stats(self, data=None, **options):
        """
        Compute sample variant stats for the selected list of samples.
        PATH: /{apiVersion}/analysis/variant/sample/stats/run

        :param dict data: Sample variant stats params. Use index=true and
            indexId='' to store the result in catalog sample QC. indexId=ALL
            requires an empty query. Use sample=all to compute sample stats of
            all samples in the variant storage. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/sample/stats', data=data, **options)

    def run_stats_export(self, data=None, **options):
        """
        Export calculated variant stats and frequencies.
        PATH: /{apiVersion}/analysis/variant/stats/export/run

        :param dict data: Variant stats export params. (REQUIRED)
        :param str project: Project [user@]project where project can be either
            the ID or the alias.
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/stats/export', data=data, **options)

    def run_stats(self, data=None, **options):
        """
        Compute variant stats for any cohort and any set of variants.
        PATH: /{apiVersion}/analysis/variant/stats/run

        :param dict data: Variant stats params. (REQUIRED)
        :param str study: Study [[user@]project:]study where study and project
            can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        """

        return self._post(category='analysis', resource='run', subcategory='variant/stats', data=data, **options)

