# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 7
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_8_2_0.models.node_drives_node_drive_firmware import NodeDrivesNodeDriveFirmware  # noqa: F401,E501


class NodeDrivesNodeDrive(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bay_group': 'str',
        'baynum': 'int',
        'blocks': 'int',
        'chassis': 'int',
        'devname': 'str',
        'firmware': 'NodeDrivesNodeDriveFirmware',
        'format_progress': 'int',
        'handle': 'int',
        'interface_type': 'str',
        'lnum': 'int',
        'locnstr': 'str',
        'logical_block_length': 'int',
        'media_type': 'str',
        'model': 'str',
        'pending_actions': 'list[str]',
        'physical_block_length': 'int',
        'present': 'bool',
        'purpose': 'str',
        'purpose_description': 'str',
        'serial': 'str',
        'ui_state': 'str',
        'wwn': 'str',
        'x_loc': 'int',
        'y_loc': 'int'
    }

    attribute_map = {
        'bay_group': 'bay_group',
        'baynum': 'baynum',
        'blocks': 'blocks',
        'chassis': 'chassis',
        'devname': 'devname',
        'firmware': 'firmware',
        'format_progress': 'format_progress',
        'handle': 'handle',
        'interface_type': 'interface_type',
        'lnum': 'lnum',
        'locnstr': 'locnstr',
        'logical_block_length': 'logical_block_length',
        'media_type': 'media_type',
        'model': 'model',
        'pending_actions': 'pending_actions',
        'physical_block_length': 'physical_block_length',
        'present': 'present',
        'purpose': 'purpose',
        'purpose_description': 'purpose_description',
        'serial': 'serial',
        'ui_state': 'ui_state',
        'wwn': 'wwn',
        'x_loc': 'x_loc',
        'y_loc': 'y_loc'
    }

    def __init__(self, bay_group=None, baynum=None, blocks=None, chassis=None, devname=None, firmware=None, format_progress=None, handle=None, interface_type=None, lnum=None, locnstr=None, logical_block_length=None, media_type=None, model=None, pending_actions=None, physical_block_length=None, present=None, purpose=None, purpose_description=None, serial=None, ui_state=None, wwn=None, x_loc=None, y_loc=None):  # noqa: E501
        """NodeDrivesNodeDrive - a model defined in Swagger"""  # noqa: E501

        self._bay_group = None
        self._baynum = None
        self._blocks = None
        self._chassis = None
        self._devname = None
        self._firmware = None
        self._format_progress = None
        self._handle = None
        self._interface_type = None
        self._lnum = None
        self._locnstr = None
        self._logical_block_length = None
        self._media_type = None
        self._model = None
        self._pending_actions = None
        self._physical_block_length = None
        self._present = None
        self._purpose = None
        self._purpose_description = None
        self._serial = None
        self._ui_state = None
        self._wwn = None
        self._x_loc = None
        self._y_loc = None
        self.discriminator = None

        if bay_group is not None:
            self.bay_group = bay_group
        if baynum is not None:
            self.baynum = baynum
        if blocks is not None:
            self.blocks = blocks
        if chassis is not None:
            self.chassis = chassis
        if devname is not None:
            self.devname = devname
        if firmware is not None:
            self.firmware = firmware
        if format_progress is not None:
            self.format_progress = format_progress
        if handle is not None:
            self.handle = handle
        if interface_type is not None:
            self.interface_type = interface_type
        if lnum is not None:
            self.lnum = lnum
        if locnstr is not None:
            self.locnstr = locnstr
        if logical_block_length is not None:
            self.logical_block_length = logical_block_length
        if media_type is not None:
            self.media_type = media_type
        if model is not None:
            self.model = model
        if pending_actions is not None:
            self.pending_actions = pending_actions
        if physical_block_length is not None:
            self.physical_block_length = physical_block_length
        if present is not None:
            self.present = present
        if purpose is not None:
            self.purpose = purpose
        if purpose_description is not None:
            self.purpose_description = purpose_description
        if serial is not None:
            self.serial = serial
        if ui_state is not None:
            self.ui_state = ui_state
        if wwn is not None:
            self.wwn = wwn
        if x_loc is not None:
            self.x_loc = x_loc
        if y_loc is not None:
            self.y_loc = y_loc

    @property
    def bay_group(self):
        """Gets the bay_group of this NodeDrivesNodeDrive.  # noqa: E501

        The name of the bay group this drive belongs to.  # noqa: E501

        :return: The bay_group of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._bay_group

    @bay_group.setter
    def bay_group(self, bay_group):
        """Sets the bay_group of this NodeDrivesNodeDrive.

        The name of the bay group this drive belongs to.  # noqa: E501

        :param bay_group: The bay_group of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if bay_group is not None and len(bay_group) > 2147483647:
            raise ValueError("Invalid value for `bay_group`, length must be less than or equal to `2147483647`")  # noqa: E501
        if bay_group is not None and len(bay_group) < 0:
            raise ValueError("Invalid value for `bay_group`, length must be greater than or equal to `0`")  # noqa: E501

        self._bay_group = bay_group

    @property
    def baynum(self):
        """Gets the baynum of this NodeDrivesNodeDrive.  # noqa: E501

        Numerical representation of this drive's bay.  # noqa: E501

        :return: The baynum of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._baynum

    @baynum.setter
    def baynum(self, baynum):
        """Sets the baynum of this NodeDrivesNodeDrive.

        Numerical representation of this drive's bay.  # noqa: E501

        :param baynum: The baynum of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if baynum is not None and baynum > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `baynum`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if baynum is not None and baynum < 0:  # noqa: E501
            raise ValueError("Invalid value for `baynum`, must be a value greater than or equal to `0`")  # noqa: E501

        self._baynum = baynum

    @property
    def blocks(self):
        """Gets the blocks of this NodeDrivesNodeDrive.  # noqa: E501

        Number of blocks on this drive.  # noqa: E501

        :return: The blocks of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._blocks

    @blocks.setter
    def blocks(self, blocks):
        """Sets the blocks of this NodeDrivesNodeDrive.

        Number of blocks on this drive.  # noqa: E501

        :param blocks: The blocks of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if blocks is not None and blocks > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `blocks`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if blocks is not None and blocks < 0:  # noqa: E501
            raise ValueError("Invalid value for `blocks`, must be a value greater than or equal to `0`")  # noqa: E501

        self._blocks = blocks

    @property
    def chassis(self):
        """Gets the chassis of this NodeDrivesNodeDrive.  # noqa: E501

        The chassis number which contains this drive.  # noqa: E501

        :return: The chassis of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._chassis

    @chassis.setter
    def chassis(self, chassis):
        """Sets the chassis of this NodeDrivesNodeDrive.

        The chassis number which contains this drive.  # noqa: E501

        :param chassis: The chassis of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if chassis is not None and chassis > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `chassis`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if chassis is not None and chassis < 0:  # noqa: E501
            raise ValueError("Invalid value for `chassis`, must be a value greater than or equal to `0`")  # noqa: E501

        self._chassis = chassis

    @property
    def devname(self):
        """Gets the devname of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's device name.  # noqa: E501

        :return: The devname of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._devname

    @devname.setter
    def devname(self, devname):
        """Sets the devname of this NodeDrivesNodeDrive.

        This drive's device name.  # noqa: E501

        :param devname: The devname of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if devname is not None and len(devname) > 255:
            raise ValueError("Invalid value for `devname`, length must be less than or equal to `255`")  # noqa: E501
        if devname is not None and len(devname) < 0:
            raise ValueError("Invalid value for `devname`, length must be greater than or equal to `0`")  # noqa: E501

        self._devname = devname

    @property
    def firmware(self):
        """Gets the firmware of this NodeDrivesNodeDrive.  # noqa: E501

        Drive firmware information.  # noqa: E501

        :return: The firmware of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: NodeDrivesNodeDriveFirmware
        """
        return self._firmware

    @firmware.setter
    def firmware(self, firmware):
        """Sets the firmware of this NodeDrivesNodeDrive.

        Drive firmware information.  # noqa: E501

        :param firmware: The firmware of this NodeDrivesNodeDrive.  # noqa: E501
        :type: NodeDrivesNodeDriveFirmware
        """

        self._firmware = firmware

    @property
    def format_progress(self):
        """Gets the format_progress of this NodeDrivesNodeDrive.  # noqa: E501

        Drive format progress percentage.  # noqa: E501

        :return: The format_progress of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._format_progress

    @format_progress.setter
    def format_progress(self, format_progress):
        """Sets the format_progress of this NodeDrivesNodeDrive.

        Drive format progress percentage.  # noqa: E501

        :param format_progress: The format_progress of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if format_progress is not None and format_progress > 100:  # noqa: E501
            raise ValueError("Invalid value for `format_progress`, must be a value less than or equal to `100`")  # noqa: E501
        if format_progress is not None and format_progress < 0:  # noqa: E501
            raise ValueError("Invalid value for `format_progress`, must be a value greater than or equal to `0`")  # noqa: E501

        self._format_progress = format_progress

    @property
    def handle(self):
        """Gets the handle of this NodeDrivesNodeDrive.  # noqa: E501

        Drive_d's handle representation for this driveIf we fail to retrieve the handle for this drive from drive_d: -1  # noqa: E501

        :return: The handle of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._handle

    @handle.setter
    def handle(self, handle):
        """Sets the handle of this NodeDrivesNodeDrive.

        Drive_d's handle representation for this driveIf we fail to retrieve the handle for this drive from drive_d: -1  # noqa: E501

        :param handle: The handle of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if handle is not None and handle > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `handle`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if handle is not None and handle < -1:  # noqa: E501
            raise ValueError("Invalid value for `handle`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._handle = handle

    @property
    def interface_type(self):
        """Gets the interface_type of this NodeDrivesNodeDrive.  # noqa: E501

        String representation of this drive's interface type.  # noqa: E501

        :return: The interface_type of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._interface_type

    @interface_type.setter
    def interface_type(self, interface_type):
        """Sets the interface_type of this NodeDrivesNodeDrive.

        String representation of this drive's interface type.  # noqa: E501

        :param interface_type: The interface_type of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if interface_type is not None and len(interface_type) > 255:
            raise ValueError("Invalid value for `interface_type`, length must be less than or equal to `255`")  # noqa: E501
        if interface_type is not None and len(interface_type) < 0:
            raise ValueError("Invalid value for `interface_type`, length must be greater than or equal to `0`")  # noqa: E501

        self._interface_type = interface_type

    @property
    def lnum(self):
        """Gets the lnum of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's logical drive number in IFS.  # noqa: E501

        :return: The lnum of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._lnum

    @lnum.setter
    def lnum(self, lnum):
        """Sets the lnum of this NodeDrivesNodeDrive.

        This drive's logical drive number in IFS.  # noqa: E501

        :param lnum: The lnum of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if lnum is not None and lnum > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `lnum`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if lnum is not None and lnum < 0:  # noqa: E501
            raise ValueError("Invalid value for `lnum`, must be a value greater than or equal to `0`")  # noqa: E501

        self._lnum = lnum

    @property
    def locnstr(self):
        """Gets the locnstr of this NodeDrivesNodeDrive.  # noqa: E501

        String representation of this drive's physical location.  # noqa: E501

        :return: The locnstr of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._locnstr

    @locnstr.setter
    def locnstr(self, locnstr):
        """Sets the locnstr of this NodeDrivesNodeDrive.

        String representation of this drive's physical location.  # noqa: E501

        :param locnstr: The locnstr of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if locnstr is not None and len(locnstr) > 255:
            raise ValueError("Invalid value for `locnstr`, length must be less than or equal to `255`")  # noqa: E501
        if locnstr is not None and len(locnstr) < 0:
            raise ValueError("Invalid value for `locnstr`, length must be greater than or equal to `0`")  # noqa: E501

        self._locnstr = locnstr

    @property
    def logical_block_length(self):
        """Gets the logical_block_length of this NodeDrivesNodeDrive.  # noqa: E501

        Size of a logical block on this drive.  # noqa: E501

        :return: The logical_block_length of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._logical_block_length

    @logical_block_length.setter
    def logical_block_length(self, logical_block_length):
        """Sets the logical_block_length of this NodeDrivesNodeDrive.

        Size of a logical block on this drive.  # noqa: E501

        :param logical_block_length: The logical_block_length of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if logical_block_length is not None and logical_block_length > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `logical_block_length`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if logical_block_length is not None and logical_block_length < 0:  # noqa: E501
            raise ValueError("Invalid value for `logical_block_length`, must be a value greater than or equal to `0`")  # noqa: E501

        self._logical_block_length = logical_block_length

    @property
    def media_type(self):
        """Gets the media_type of this NodeDrivesNodeDrive.  # noqa: E501

        String representation of this drive's media type.  # noqa: E501

        :return: The media_type of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """Sets the media_type of this NodeDrivesNodeDrive.

        String representation of this drive's media type.  # noqa: E501

        :param media_type: The media_type of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if media_type is not None and len(media_type) > 255:
            raise ValueError("Invalid value for `media_type`, length must be less than or equal to `255`")  # noqa: E501
        if media_type is not None and len(media_type) < 0:
            raise ValueError("Invalid value for `media_type`, length must be greater than or equal to `0`")  # noqa: E501

        self._media_type = media_type

    @property
    def model(self):
        """Gets the model of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's manufacturer and model.  # noqa: E501

        :return: The model of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this NodeDrivesNodeDrive.

        This drive's manufacturer and model.  # noqa: E501

        :param model: The model of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if model is not None and len(model) > 255:
            raise ValueError("Invalid value for `model`, length must be less than or equal to `255`")  # noqa: E501
        if model is not None and len(model) < 0:
            raise ValueError("Invalid value for `model`, length must be greater than or equal to `0`")  # noqa: E501

        self._model = model

    @property
    def pending_actions(self):
        """Gets the pending_actions of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's current outstanding actions. For example, \"add\" or \"firmware_update\".  # noqa: E501

        :return: The pending_actions of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: list[str]
        """
        return self._pending_actions

    @pending_actions.setter
    def pending_actions(self, pending_actions):
        """Sets the pending_actions of this NodeDrivesNodeDrive.

        This drive's current outstanding actions. For example, \"add\" or \"firmware_update\".  # noqa: E501

        :param pending_actions: The pending_actions of this NodeDrivesNodeDrive.  # noqa: E501
        :type: list[str]
        """

        self._pending_actions = pending_actions

    @property
    def physical_block_length(self):
        """Gets the physical_block_length of this NodeDrivesNodeDrive.  # noqa: E501

        Size of a physical block on this drive.  # noqa: E501

        :return: The physical_block_length of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._physical_block_length

    @physical_block_length.setter
    def physical_block_length(self, physical_block_length):
        """Sets the physical_block_length of this NodeDrivesNodeDrive.

        Size of a physical block on this drive.  # noqa: E501

        :param physical_block_length: The physical_block_length of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if physical_block_length is not None and physical_block_length > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `physical_block_length`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if physical_block_length is not None and physical_block_length < 0:  # noqa: E501
            raise ValueError("Invalid value for `physical_block_length`, must be a value greater than or equal to `0`")  # noqa: E501

        self._physical_block_length = physical_block_length

    @property
    def present(self):
        """Gets the present of this NodeDrivesNodeDrive.  # noqa: E501

        Indicates whether this drive is physically present in the node.  # noqa: E501

        :return: The present of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: bool
        """
        return self._present

    @present.setter
    def present(self, present):
        """Sets the present of this NodeDrivesNodeDrive.

        Indicates whether this drive is physically present in the node.  # noqa: E501

        :param present: The present of this NodeDrivesNodeDrive.  # noqa: E501
        :type: bool
        """

        self._present = present

    @property
    def purpose(self):
        """Gets the purpose of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's purpose in the DRV state machine.  # noqa: E501

        :return: The purpose of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """Sets the purpose of this NodeDrivesNodeDrive.

        This drive's purpose in the DRV state machine.  # noqa: E501

        :param purpose: The purpose of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if purpose is not None and len(purpose) > 255:
            raise ValueError("Invalid value for `purpose`, length must be less than or equal to `255`")  # noqa: E501
        if purpose is not None and len(purpose) < 0:
            raise ValueError("Invalid value for `purpose`, length must be greater than or equal to `0`")  # noqa: E501

        self._purpose = purpose

    @property
    def purpose_description(self):
        """Gets the purpose_description of this NodeDrivesNodeDrive.  # noqa: E501

        Description of this drive's purpose.  # noqa: E501

        :return: The purpose_description of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._purpose_description

    @purpose_description.setter
    def purpose_description(self, purpose_description):
        """Sets the purpose_description of this NodeDrivesNodeDrive.

        Description of this drive's purpose.  # noqa: E501

        :param purpose_description: The purpose_description of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if purpose_description is not None and len(purpose_description) > 255:
            raise ValueError("Invalid value for `purpose_description`, length must be less than or equal to `255`")  # noqa: E501
        if purpose_description is not None and len(purpose_description) < 0:
            raise ValueError("Invalid value for `purpose_description`, length must be greater than or equal to `0`")  # noqa: E501

        self._purpose_description = purpose_description

    @property
    def serial(self):
        """Gets the serial of this NodeDrivesNodeDrive.  # noqa: E501

        Serial number for this drive.  # noqa: E501

        :return: The serial of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._serial

    @serial.setter
    def serial(self, serial):
        """Sets the serial of this NodeDrivesNodeDrive.

        Serial number for this drive.  # noqa: E501

        :param serial: The serial of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if serial is not None and len(serial) > 255:
            raise ValueError("Invalid value for `serial`, length must be less than or equal to `255`")  # noqa: E501
        if serial is not None and len(serial) < 0:
            raise ValueError("Invalid value for `serial`, length must be greater than or equal to `0`")  # noqa: E501

        self._serial = serial

    @property
    def ui_state(self):
        """Gets the ui_state of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's state as presented to the UI.  # noqa: E501

        :return: The ui_state of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._ui_state

    @ui_state.setter
    def ui_state(self, ui_state):
        """Sets the ui_state of this NodeDrivesNodeDrive.

        This drive's state as presented to the UI.  # noqa: E501

        :param ui_state: The ui_state of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if ui_state is not None and len(ui_state) > 255:
            raise ValueError("Invalid value for `ui_state`, length must be less than or equal to `255`")  # noqa: E501
        if ui_state is not None and len(ui_state) < 0:
            raise ValueError("Invalid value for `ui_state`, length must be greater than or equal to `0`")  # noqa: E501

        self._ui_state = ui_state

    @property
    def wwn(self):
        """Gets the wwn of this NodeDrivesNodeDrive.  # noqa: E501

        The drive's 'worldwide name' from its NAA identifiers.  # noqa: E501

        :return: The wwn of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: str
        """
        return self._wwn

    @wwn.setter
    def wwn(self, wwn):
        """Sets the wwn of this NodeDrivesNodeDrive.

        The drive's 'worldwide name' from its NAA identifiers.  # noqa: E501

        :param wwn: The wwn of this NodeDrivesNodeDrive.  # noqa: E501
        :type: str
        """
        if wwn is not None and len(wwn) > 255:
            raise ValueError("Invalid value for `wwn`, length must be less than or equal to `255`")  # noqa: E501
        if wwn is not None and len(wwn) < 0:
            raise ValueError("Invalid value for `wwn`, length must be greater than or equal to `0`")  # noqa: E501

        self._wwn = wwn

    @property
    def x_loc(self):
        """Gets the x_loc of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's x-axis grid location.  # noqa: E501

        :return: The x_loc of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._x_loc

    @x_loc.setter
    def x_loc(self, x_loc):
        """Sets the x_loc of this NodeDrivesNodeDrive.

        This drive's x-axis grid location.  # noqa: E501

        :param x_loc: The x_loc of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if x_loc is not None and x_loc > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `x_loc`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if x_loc is not None and x_loc < 0:  # noqa: E501
            raise ValueError("Invalid value for `x_loc`, must be a value greater than or equal to `0`")  # noqa: E501

        self._x_loc = x_loc

    @property
    def y_loc(self):
        """Gets the y_loc of this NodeDrivesNodeDrive.  # noqa: E501

        This drive's y-axis grid location.  # noqa: E501

        :return: The y_loc of this NodeDrivesNodeDrive.  # noqa: E501
        :rtype: int
        """
        return self._y_loc

    @y_loc.setter
    def y_loc(self, y_loc):
        """Sets the y_loc of this NodeDrivesNodeDrive.

        This drive's y-axis grid location.  # noqa: E501

        :param y_loc: The y_loc of this NodeDrivesNodeDrive.  # noqa: E501
        :type: int
        """
        if y_loc is not None and y_loc > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `y_loc`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if y_loc is not None and y_loc < 0:  # noqa: E501
            raise ValueError("Invalid value for `y_loc`, must be a value greater than or equal to `0`")  # noqa: E501

        self._y_loc = y_loc

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NodeDrivesNodeDrive):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
